/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMD5Util;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.CallBackEventType;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CallBackUtil {
    private static final Log LOGGER = LogFactory.getLog(CallBackUtil.class);
    private static final String callBackEntityNumber = "hrcs_esigncallbackflow";
    private static final HRBaseServiceHelper eSignCallBackFlowService = new HRBaseServiceHelper("hrcs_esigncallbackflow");
    public static final String CALL_BACK_KEY = "callbackkey";
    public static final String CALL_BACK_KEY_DETAIL = "callbackkeydetail";
    private static final String REL_DATA_ID = "reldataid";
    private static final String CALL_BACK_MSG = "callbackmsg";
    private static final String CALL_BACK_STATUS = "callbackstatus";
    private static final String CALL_BACK_RESULT = "callbackresult";
    private static final String FAIL_MSG = "failmsg";
    public static final String CALL_BACK_STATUS_Y = "1";
    public static final String CALL_BACK_RESULT_Y = "1";
    public static final String CALL_BACK_RESULT_N = "0";

    public static void insert(String callBackKey, String callBackKeyDetail, Long relDataId) {
        DynamicObject dyn = eSignCallBackFlowService.generateEmptyEntryDynamicObject(callBackEntityNumber);
        dyn.set(CALL_BACK_KEY, (Object)callBackKey);
        dyn.set(CALL_BACK_KEY_DETAIL, (Object)callBackKeyDetail);
        dyn.set(REL_DATA_ID, (Object)relDataId);
        eSignCallBackFlowService.saveOne(dyn);
    }

    private static void update(String callBackKey, String callBackMsg, String callBackStatus, String callBackResult, String failMsg) {
        DynamicObject dyn = CallBackUtil.getDynByCallBackKey(callBackKey);
        if (ObjectUtils.isEmpty((Object)dyn)) {
            LOGGER.warn("not query data,no updates callBackKey={}", (Object)callBackKey);
            return;
        }
        dyn.set(CALL_BACK_MSG, (Object)callBackMsg);
        dyn.set(CALL_BACK_STATUS, (Object)callBackStatus);
        dyn.set(CALL_BACK_RESULT, (Object)callBackResult);
        dyn.set(FAIL_MSG, (Object)failMsg);
        eSignCallBackFlowService.updateOne(dyn);
    }

    public static DynamicObject getDynByCallBackKey(String callBackKey) {
        return eSignCallBackFlowService.loadDynamicObject(new QFilter[]{new QFilter(CALL_BACK_KEY, "=", (Object)callBackKey)});
    }

    public static void updateInvokeFail(CallBackEventType callBackEventType, Map<String, String> paramMap, String failMsg) {
        Function<Map<String, String>, String> callBackKeyFunction = callBackEventType.getCallBackKeyFunction();
        if (ObjectUtils.isEmpty(callBackKeyFunction)) {
            LOGGER.warn("callBackEventType:[{}] callBackKeyFunction is null", (Object)callBackEventType.getX_FASC_Event());
            return;
        }
        String callBackKey = callBackKeyFunction.apply(paramMap);
        String callBackMsg = SerializationUtils.toJsonString(paramMap);
        if (StringUtils.isBlank((CharSequence)callBackKey)) {
            LOGGER.warn("callBackEventType:[{}] callBackKey is null, callBackMsg:[{}]", (Object)callBackEventType.getX_FASC_Event(), (Object)callBackMsg);
            return;
        }
        CallBackUtil.update(callBackKey, callBackMsg, "1", CALL_BACK_RESULT_N, failMsg);
    }

    public static void updateInvokeSucess(CallBackEventType callBackEventType, Map<String, String> paramMap) {
        Function<Map<String, String>, String> callBackKeyFunction = callBackEventType.getCallBackKeyFunction();
        if (ObjectUtils.isEmpty(callBackKeyFunction)) {
            LOGGER.warn("callBackEventType:[{}] callBackKeyFunction is null", (Object)callBackEventType.getX_FASC_Event());
            return;
        }
        String callBackKey = callBackKeyFunction.apply(paramMap);
        String callBackMsg = SerializationUtils.toJsonString(paramMap);
        if (StringUtils.isBlank((CharSequence)callBackKey)) {
            LOGGER.warn("callBackEventType:[{}] callBackKey is null, callBackMsg:[{}]", (Object)callBackEventType.getX_FASC_Event(), (Object)callBackMsg);
            return;
        }
        CallBackUtil.update(callBackKey, callBackMsg, "1", "1", "");
    }

    public static Long queryRelDataIdByCallBackKey(String callBackKey) {
        DynamicObject dyn = eSignCallBackFlowService.queryOriginalOne(REL_DATA_ID, new QFilter(CALL_BACK_KEY, "=", (Object)callBackKey));
        return dyn.getLong(REL_DATA_ID);
    }

    public static String getSealCreateCallBackKey(Long verifyId, String createSerialNo) {
        return HRMD5Util.getMD5String((String)(createSerialNo + "&" + verifyId));
    }

    public static String getSealCreateCallBackKey(JSONObject reqParam) {
        String createSerialNo = reqParam.getString("createSerialNo");
        if (createSerialNo == null) {
            createSerialNo = "";
        }
        Long verifyId = reqParam.getLong("verifyId");
        return CallBackUtil.getSealCreateCallBackKey(verifyId, createSerialNo);
    }

    @Deprecated
    public static String getSealAuthorizeFreeSignCallBackKey(String openCorpId, String sealId, String businessId, Date startTime, Date endTime) {
        return HRMD5Util.getMD5String((String)ESignCOSealMgrUtil.buildFreeSignInfoKey(openCorpId, sealId, businessId, startTime, endTime));
    }

    @Deprecated
    public static String getSealAuthorizeFreeSignCallBackKey(JSONObject reqParam) {
        Long expiresTime = Long.valueOf(reqParam.getString("expiresTime"));
        Date endTime = HRDateTimeUtils.convertDate((Long)expiresTime);
        Date startTime = HRDateTimeUtils.convertBefore365DayDate((Long)expiresTime);
        return CallBackUtil.getSealAuthorizeFreeSignCallBackKey(reqParam.getString("openCorpId"), String.valueOf(reqParam.getLong("sealId")), reqParam.getString("businessId"), startTime, endTime);
    }

    public static String getSealAuthorizeFreeSignCallBackKey2(String openCorpId, String sealId, String businessId) {
        return HRMD5Util.getMD5String((String)ESignCOSealMgrUtil.buildFreeSignInfoKey(openCorpId, sealId, businessId));
    }

    public static String getSealAuthorizeFreeSignCallBackKey2(JSONObject reqParam) {
        return CallBackUtil.getSealAuthorizeFreeSignCallBackKey2(reqParam.getString("openCorpId"), String.valueOf(reqParam.getLong("sealId")), reqParam.getString("businessId"));
    }

    public static void updateCorAuthStatus(String pkValue, String openCorpId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_esigncoauth");
        DynamicObject dynamicObject = baseServiceHelper.queryOne((Object)Long.valueOf(pkValue));
        dynamicObject.set("authstatus", (Object)"1");
        dynamicObject.set("thirdcompanyid", (Object)openCorpId);
        baseServiceHelper.updateOne(dynamicObject);
    }

    public static DynamicObject[] getSignFlow(String signTaskId, String actorId) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_signflow");
        QFilter qFilter = new QFilter("entryentity.value", "=", (Object)signTaskId);
        qFilter.and(new QFilter("entryentity.value", "=", (Object)signTaskId));
        QFilter actorQfilter = new QFilter("entryentityorg.signorg", "=", (Object)actorId);
        actorQfilter.or(new QFilter("entryentityperson.naturalid", "=", (Object)actorId));
        actorQfilter.or(new QFilter("entryentityperson.candidateid", "=", (Object)actorId));
        qFilter.and(actorQfilter);
        return baseServiceHelper.query(new QFilter[]{qFilter});
    }

    public static JSONObject getReqParamJsonObject(Map<String, String> paramMap) {
        String bizContent = paramMap.get("bizContent");
        return JSON.parseObject((String)bizContent);
    }
}

