/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.hismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hrcs.bussiness.servicehelper.hismodel.HisEntityDependentServiceHelper;
import kd.hr.hrcs.common.constants.hismodel.HisEntityDependentConstants;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityConditionVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityRelVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityVO;
import kd.hr.hrcs.common.model.hismodel.HisEntityDependentVO;

public class HisEntityDependentService
implements HisEntityDependentConstants {
    public List<HisEntityDependentVO> loadData(Long id) {
        List<HisEntityDependentVO> hisEntityDependentVOList;
        if (id != null && id != 0L) {
            DynamicObject[] entities = HisEntityDependentServiceHelper.getEntities(id);
            DynamicObject[] entityRel = HisEntityDependentServiceHelper.getEntityRel(id);
            hisEntityDependentVOList = this.buildHisEntityDependentVOList(entities, entityRel);
        } else {
            hisEntityDependentVOList = Collections.emptyList();
        }
        return hisEntityDependentVOList;
    }

    public List<HisEntityDependentVO> buildHisEntityDependentVOList(DynamicObject[] entities, DynamicObject[] entityRel) {
        ArrayList hisEntityDependentVOList = Lists.newArrayListWithExpectedSize((int)16);
        HashMap groupEntityMap = Maps.newHashMapWithExpectedSize((int)entities.length);
        for (DynamicObject entity : entities) {
            String key2 = entity.getLong("ed.id") + "#" + entity.getString("row");
            List entityList = groupEntityMap.getOrDefault(key2, Lists.newArrayListWithExpectedSize((int)entities.length));
            entityList.add(entity);
            groupEntityMap.put(key2, entityList);
        }
        HashMap relMapWithRight = Maps.newHashMapWithExpectedSize((int)entityRel.length);
        for (DynamicObject rel : entityRel) {
            relMapWithRight.put(rel.getLong("edjoinentity.id"), rel);
        }
        groupEntityMap.forEach((key, value) -> {
            HisEntityDependentVO hisEntityDependentVO = new HisEntityDependentVO();
            hisEntityDependentVO.setRow(key.substring(key.indexOf("#") + 1));
            ArrayList hisEDEntityVOList = Lists.newArrayListWithExpectedSize((int)value.size());
            value.sort(Comparator.comparingInt(x -> x.getInt("index")));
            this.addHisEDEntityVO(hisEDEntityVOList, relMapWithRight, (List<DynamicObject>)value);
            hisEntityDependentVO.setEdEntityList((List)hisEDEntityVOList);
            DynamicObject ed = ((DynamicObject)value.get(0)).getDynamicObject("ed");
            hisEntityDependentVO.setEdId(ed.getLong("id") + "");
            hisEntityDependentVO.setEdName(ed.getString("name"));
            hisEntityDependentVOList.add(hisEntityDependentVO);
        });
        hisEntityDependentVOList.sort(Comparator.comparingInt(x -> Integer.parseInt(x.getRow())));
        return hisEntityDependentVOList;
    }

    private void addHisEDEntityVO(List<HisEDEntityVO> hisEDEntityVOList, Map<Long, DynamicObject> relMap, List<DynamicObject> edEntityList) {
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)edEntityList.size());
        for (DynamicObject entity : edEntityList) {
            entityMap.put(entity.getLong("id"), entity);
        }
        for (DynamicObject rightEntity : edEntityList) {
            long rightEntityId = rightEntity.getLong("id");
            HisEDEntityVO hisEDEntityVO = new HisEDEntityVO();
            String edId = String.valueOf(rightEntity.getLong("ed.id"));
            hisEDEntityVO.setEdId(edId);
            String rightEntityIdStr = String.valueOf(rightEntityId);
            hisEDEntityVO.setEdEntityId(rightEntityIdStr);
            hisEDEntityVO.setEntity(rightEntity.getString("entity.id"));
            hisEDEntityVO.setEntityNum(rightEntity.getString("entity.id"));
            hisEDEntityVO.setEntityName(rightEntity.getString("entity.name"));
            hisEDEntityVO.setRow(rightEntity.getString("row"));
            DynamicObject rel = relMap.get(rightEntityId);
            hisEDEntityVOList.add(hisEDEntityVO);
            if (rel == null) continue;
            long leftEntityId = rel.getLong("edentity.id");
            DynamicObject leftEntity = (DynamicObject)entityMap.get(leftEntityId);
            HisEDEntityRelVO hisEDEntityRelVO = new HisEDEntityRelVO();
            hisEDEntityRelVO.setEdEntityId(String.valueOf(leftEntity.getLong("id")));
            hisEDEntityRelVO.setLeftEntityNum(leftEntity.getString("entity.id"));
            hisEDEntityRelVO.setLeftEntityName(leftEntity.getString("entity.name"));
            hisEDEntityRelVO.setEdJoinEntityId(rightEntityIdStr);
            hisEDEntityRelVO.setRightEntityNum(rightEntity.getString("entity.id"));
            hisEDEntityRelVO.setRightEntityName(rightEntity.getString("entity.name"));
            hisEDEntityRelVO.setRelId(String.valueOf(rel.getLong("id")));
            hisEDEntityRelVO.setRow(hisEDEntityVO.getRow());
            hisEDEntityRelVO.setEdId(edId);
            DynamicObjectCollection conditions = rel.getDynamicObjectCollection("entryentity");
            ArrayList hisEDEntityConditionVOList = Lists.newArrayListWithExpectedSize((int)conditions.size());
            conditions.forEach(condition -> {
                HisEDEntityConditionVO hisEDEntityConditionVO = new HisEDEntityConditionVO();
                hisEDEntityConditionVO.setConditionId(String.valueOf(condition.getLong("id")));
                hisEDEntityConditionVO.setLeftProp(condition.getString("leftprop"));
                hisEDEntityConditionVO.setCompareType(condition.getString("comparetype"));
                hisEDEntityConditionVO.setRightProp(condition.getString("rightprop"));
                hisEDEntityConditionVOList.add(hisEDEntityConditionVO);
            });
            hisEDEntityRelVO.setConditionList((List)hisEDEntityConditionVOList);
            hisEDEntityVO.setEdEntityRel(hisEDEntityRelVO);
        }
    }
}

