/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.label.LabelResultEntry;
import kd.hr.hbp.common.model.label.LabelResultInfo;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskProcessService;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.service.label.LabelFunctionTargetExecutor;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.service.label.LabelTaskProcessService;
import kd.hr.hrcs.bussiness.service.label.LabelTaskStorageService;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class ComplexLabelTaskProcessService
implements ILabelTaskProcessService {
    private static final Log logger = LogFactory.getLog(ComplexLabelTaskProcessService.class);
    protected final Long policyId;
    protected final String taskNumber;
    private String mainEntityNumber;
    protected DynamicObject labelPolicy;
    protected DynamicObject labelObject;
    protected DynamicObject label;
    private ILabelTaskProcessService labelTaskProcessService;
    private LabelDataService labelDataService;
    private final Map<Long, String> rulePlugins = new HashMap<Long, String>(16);
    private final Map<Long, String> labelValuePlugins = new HashMap<Long, String>(16);
    private final Map<Long, String> labelValueFunctions = new HashMap<Long, String>(16);
    private final Map<Long, DynamicObject> labelValueDynamicObject = new HashMap<Long, DynamicObject>(16);
    private final Map<String, String> appCloudMap = new HashMap<String, String>(16);
    private final Map<String, String> appIsvMap = new HashMap<String, String>(16);
    private final Map<Long, String> lableInputNumberMapping = new LinkedHashMap<Long, String>(16);
    private final Map<String, DynamicObject> paramsMap = new LinkedHashMap<String, DynamicObject>(16);
    private final Map<String, List<ValueMapItem>> comboMap = new LinkedHashMap<String, List<ValueMapItem>>(16);
    private static final HRBaseServiceHelper BIZAPP_SERVICE_HELPER = new HRBaseServiceHelper("bos_devportal_bizapp");
    private static final String[] selects = new String[]{"labelObjectId", "createTime", "lastUpdateTime", "isDeleted", "id", "labels.labelValueId", "labels.labelValueName", "labels.labelBizValue", "labels.from", "labels.creatorId", "labels.createTime"};
    private boolean needCheckService = false;
    private boolean checkServiceFlag = false;
    private String preTaskNumber;
    private LabelTaskStorageService labelTaskStorageService = null;

    public ComplexLabelTaskProcessService(Long policyId, String taskNumber) {
        logger.info("ComplexLabelTaskProcessService init. policyId:{},taskNumber:{}", (Object)policyId, (Object)taskNumber);
        this.policyId = policyId;
        this.taskNumber = taskNumber;
        this.init();
        this.initAppCloud();
    }

    private void init() {
        this.labelPolicy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        if (this.labelPolicy != null) {
            this.preTaskNumber = this.labelPolicy.getString("lasttasknumber");
            if (HRStringUtils.isNotEmpty((String)this.preTaskNumber)) {
                this.labelTaskStorageService = new LabelTaskStorageService(this.policyId, this.preTaskNumber);
            }
            this.label = this.labelPolicy.getDynamicObject("label");
            DynamicObject[] labelObjects = LabelObjectServiceHelper.getLabelObjectsByFilter(new QFilter("id", "=", (Object)this.labelPolicy.getLong("labelobject.id")));
            if (labelObjects != null && labelObjects.length > 0) {
                this.labelObject = labelObjects[0];
            }
            if ("1".equals(this.labelPolicy.getString("configtype"))) {
                this.labelTaskProcessService = new LabelTaskProcessService(this.policyId, this.taskNumber);
            } else if ("2".equals(this.labelPolicy.getString("configtype"))) {
                this.initRulePlugin();
                this.initLabelValueFunc();
                this.labelDataService = new LabelDataService(this.labelObject.getLong("id"), true);
                this.needCheckService = true;
            }
            this.initLabelPlugin();
        }
        DynamicObject mainEntity = LabelPolicyServiceHelper.getEntryByObjectId(this.labelObject.getLong("id"));
        this.mainEntityNumber = mainEntity.getString("entitynumber");
    }

    private void initLabelPlugin() {
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        if ("20".equals(this.label.getString("type"))) {
            DynamicObject[] labelValueDyns = labelServiceHelper.getRulesByLabelAndLabelObject(this.label.getLong("id"), this.labelObject.getLong("id"));
            if (labelValueDyns != null) {
                for (DynamicObject labelValueDynRow : labelValueDyns) {
                    if (labelValueDynRow.getDynamicObject("labelvalue") == null) continue;
                    if ("2".equals(this.label.getString("configtype"))) {
                        this.needCheckService = true;
                        this.labelValuePlugins.put(labelValueDynRow.getDynamicObject("labelvalue").getLong("id"), labelValueDynRow.getString("service"));
                    }
                    this.labelValueDynamicObject.put(labelValueDynRow.getDynamicObject("labelvalue").getLong("id"), labelValueDynRow.getDynamicObject("labelvalue"));
                }
            }
        } else if ("2".equals(this.labelPolicy.getString("configtype"))) {
            DynamicObject[] labelValueDyns;
            for (DynamicObject labelValueDyn : labelValueDyns = labelServiceHelper.getLabelValueCollection(this.label.getLong("id"))) {
                this.labelValueDynamicObject.put(labelValueDyn.getLong("id"), labelValueDyn);
            }
            this.needCheckService = true;
        }
    }

    private void initRulePlugin() {
        DynamicObjectCollection ruleEntry = this.labelPolicy.getDynamicObjectCollection("entryentity");
        if (ruleEntry != null && ruleEntry.size() > 0) {
            for (DynamicObject ruleDynRow : ruleEntry) {
                if (ruleDynRow.getDynamicObject("labelvalue") == null) continue;
                this.rulePlugins.put(ruleDynRow.getDynamicObject("labelvalue").getLong("id"), ruleDynRow.getString("service"));
            }
        }
    }

    private void initLabelValueFunc() {
        if ("20".equals(this.label.getString("type")) && "1".equals(this.label.getString("configtype"))) {
            DynamicObjectCollection paramDynCol;
            DynamicObject[] labelValueDyns;
            LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
            for (DynamicObject labelValueDynRow : labelValueDyns = labelServiceHelper.getRulesByLabelAndLabelObject(this.label.getLong("id"), this.labelObject.getLong("id"))) {
                if (labelValueDynRow.getDynamicObject("labelvalue") == null || labelValueDynRow.getDynamicObject("brmtarget") == null) continue;
                this.labelValueFunctions.put(labelValueDynRow.getDynamicObject("labelvalue").getLong("id"), labelValueDynRow.getDynamicObject("brmtarget").getString("conditions"));
            }
            DynamicObject brmRuleScene = LblStrategyServiceHelper.getRuleScene(this.labelPolicy.getLong("label.id"), this.labelPolicy.getLong("labelobject.id"));
            if (brmRuleScene != null && (paramDynCol = brmRuleScene.getDynamicObjectCollection("brmscene.sceneinputparams")) != null && paramDynCol.size() > 0) {
                DynamicObject[] dynFields;
                for (DynamicObject dynamicObject : paramDynCol) {
                    if (!dynamicObject.getString("inputnumber").startsWith("pl")) continue;
                    Long tempInputNumber = Long.parseLong(dynamicObject.getString("inputnumber").replace("pl", ""));
                    this.lableInputNumberMapping.put(tempInputNumber, dynamicObject.getString("inputnumber"));
                }
                for (DynamicObject field : dynFields = this.getFields(this.lableInputNumberMapping.keySet())) {
                    if (!this.lableInputNumberMapping.containsKey(field.getLong("id"))) continue;
                    this.paramsMap.put(this.lableInputNumberMapping.get(field.getLong("id")), field);
                }
            }
        }
    }

    private DynamicObject[] getFields(Set<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        return serviceHelper.query("id,fieldname,entitynumber,valuetype,labelobjectid,fieldalias,fieldpath,complextype,controltype", new QFilter[]{new QFilter("id", "in", ids)});
    }

    private void initAppCloud() {
        ArrayList appList = new ArrayList(16);
        this.rulePlugins.values().forEach(serviceName -> {
            String[] servicePath;
            if (serviceName != null && !"".equals(serviceName) && (servicePath = serviceName.split("\\.")).length == 2) {
                appList.add(servicePath[0]);
            }
        });
        this.labelValuePlugins.values().forEach(serviceName -> {
            String[] servicePath;
            if (serviceName != null && !"".equals(serviceName) && (servicePath = serviceName.split("\\.")).length == 2) {
                appList.add(servicePath[0]);
            }
        });
        if (appList.size() > 0) {
            DynamicObject[] appDyns;
            for (DynamicObject dyn : appDyns = BIZAPP_SERVICE_HELPER.query("number,isv,bizcloud.id,bizcloud.number", new QFilter[]{new QFilter("number", "in", appList)})) {
                this.appCloudMap.put(dyn.getString("number"), dyn.getDynamicObject("bizcloud").getString("number").toLowerCase(Locale.ROOT));
                this.appIsvMap.put(dyn.getString("number"), dyn.getString("isv"));
            }
        }
    }

    @Override
    public LabelResultInfo getRuleResult(List<Map<String, Object>> paramsList, Map<String, Object> lruCacheMap) {
        return null;
    }

    private void checkService(Map<Long, List<Map<String, Object>>> paramMap) {
        if (this.needCheckService && !this.checkServiceFlag && paramMap != null && paramMap.size() > 0) {
            ArrayList<Long> pkList = new ArrayList<Long>(10);
            pkList.add(paramMap.keySet().iterator().next());
            ArrayList<Long> rulesErrorLabelValues = new ArrayList<Long>(10);
            ArrayList<Long> rulesNotFoundLabelValues = new ArrayList<Long>(10);
            for (Map.Entry<Long, String> rules : this.rulePlugins.entrySet()) {
                String[] servicePath;
                String serviceName = rules.getValue();
                if (serviceName == null || "".equals(serviceName) || (servicePath = serviceName.split("\\.")).length != 2) continue;
                try {
                    List list;
                    if (this.isKingdee(servicePath[0])) {
                        list = (List)HRMServiceHelper.invokeBizService((String)this.appCloudMap.get(servicePath[0]), (String)servicePath[0], (String)servicePath[1], (String)"findMatchPks", (Object[])new Object[]{this.mainEntityNumber, this.labelObject, this.labelValueDynamicObject.get(rules.getKey()), pkList});
                        continue;
                    }
                    list = (List)HRMServiceHelper.invokeService((String)this.appCloudMap.get(servicePath[0]), (String)servicePath[0], (String)servicePath[1], (String)"findMatchPks", (Object[])new Object[]{this.mainEntityNumber, this.labelObject, this.labelValueDynamicObject.get(rules.getKey()), pkList});
                }
                catch (Exception exp) {
                    String errorMsg;
                    logger.error(exp.getMessage());
                    logger.error((Throwable)exp);
                    String string = errorMsg = exp.getMessage() == null ? "" : exp.getMessage();
                    if (errorMsg.indexOf("findMatchPks") > -1) {
                        rulesErrorLabelValues.add(rules.getKey());
                        continue;
                    }
                    if (errorMsg.indexOf("ServiceFactory not find") > -1 || errorMsg.indexOf(servicePath[1]) > -1) {
                        rulesNotFoundLabelValues.add(rules.getKey());
                        continue;
                    }
                    rulesErrorLabelValues.add(rules.getKey());
                }
            }
            if (rulesNotFoundLabelValues.size() > 0 || rulesErrorLabelValues.size() > 0) {
                throw new KDBizException(this.getErrorMsg(rulesErrorLabelValues, rulesNotFoundLabelValues));
            }
        }
    }

    private String getErrorMsg(List<Long> rulesErrorLabelValues, List<Long> rulesNotFoundLabelValues) {
        if (rulesNotFoundLabelValues.size() > 0 && rulesErrorLabelValues.size() > 0) {
            return String.format(ResManager.loadKDString((String)"%1s\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u4e0d\u5b58\u5728\u3002\u8fd0\u884c%2s\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u5931\u8d25\u3002", (String)"ComplexLabelTaskProcessService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getNames(rulesNotFoundLabelValues), this.getNames(rulesErrorLabelValues));
        }
        if (rulesNotFoundLabelValues.size() > 0) {
            return String.format(ResManager.loadKDString((String)"%s\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"ComplexLabelTaskProcessService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getNames(rulesNotFoundLabelValues));
        }
        if (rulesErrorLabelValues.size() > 0) {
            return String.format(ResManager.loadKDString((String)"%s\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u8fd0\u884c\u5931\u8d25\u3002", (String)"ComplexLabelTaskProcessService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getNames(rulesErrorLabelValues));
        }
        return null;
    }

    private String getNames(List<Long> labelValues) {
        StringBuilder result = new StringBuilder();
        for (Long ruleValueId : labelValues) {
            if (result.length() > 0) {
                result.append(ResManager.loadKDString((String)"\u3001", (String)"ComplexLabelTaskProcessService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            result.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"ComplexLabelTaskProcessService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.labelValueDynamicObject.get(ruleValueId).getString("value")));
        }
        return result.toString();
    }

    @Override
    public List<LabelResultInfo> getRuleResultList(Map<Long, List<Map<String, Object>>> paramMap, Map<String, List<PolicyResult>> lruCacheMap) {
        this.checkService(paramMap);
        List<Object> resultInfoList = new ArrayList(10);
        if ("1".equals(this.labelPolicy.getString("configtype"))) {
            resultInfoList = this.labelTaskProcessService.getRuleResultList(paramMap, lruCacheMap);
            if ("20".equals(this.label.getString("type")) && "2".equals(this.label.getString("configtype"))) {
                HashMap<Long, LabelResultInfo> labelResultMap = new HashMap<Long, LabelResultInfo>(16);
                HashMap labelValueMatchMap = new HashMap(16);
                for (Map.Entry<Long, String> entry : this.labelValuePlugins.entrySet()) {
                    if (labelValueMatchMap.containsKey(entry.getKey())) continue;
                    ArrayList matchList = new ArrayList(10);
                    labelValueMatchMap.put(entry.getKey(), matchList);
                }
                for (LabelResultInfo labelResultInfo : resultInfoList) {
                    labelResultMap.put(Long.parseLong(String.valueOf(labelResultInfo.getId())), labelResultInfo);
                    for (Object labelResultEntry : labelResultInfo.getLabelResult()) {
                        if (!labelValueMatchMap.containsKey(labelResultEntry.getLabelValueId())) continue;
                        ((List)labelValueMatchMap.get(labelResultEntry.getLabelValueId())).add(Long.parseLong(String.valueOf(labelResultInfo.getId())));
                    }
                }
                for (Map.Entry<Long, String> entry : labelValueMatchMap.entrySet()) {
                    Map<Long, List<String>> labelValues = this.getLabelValues((List)((Object)entry.getValue()), paramMap, this.labelValueDynamicObject.get(entry.getKey()));
                    for (Map.Entry entry2 : labelValues.entrySet()) {
                        if (!labelResultMap.containsKey(entry2.getKey())) continue;
                        for (LabelResultEntry labelResultEntry : ((LabelResultInfo)labelResultMap.get(entry2.getKey())).getLabelResult()) {
                            if (labelResultEntry.getLabelValueId().longValue() != entry.getKey().longValue()) continue;
                            if (entry2.getValue() != null && ((List)entry2.getValue()).size() > 0) {
                                labelResultEntry.setLabelBizValue((String)((List)entry2.getValue()).get(0));
                                continue;
                            }
                            labelResultEntry.setLabelBizValue("");
                        }
                    }
                }
                resultInfoList = labelResultMap.values().stream().collect(Collectors.toList());
            }
        } else if ("2".equals(this.labelPolicy.getString("configtype")) && this.labelObject != null) {
            HashMap<Long, LabelResultInfo> labelResultMap = new HashMap<Long, LabelResultInfo>(16);
            List<Long> pkList = paramMap.keySet().stream().collect(Collectors.toList());
            if (this.rulePlugins != null) {
                for (Map.Entry<Long, String> entry : this.rulePlugins.entrySet()) {
                    List<Long> matchList = this.findMatchPksByService(pkList, entry.getValue(), this.labelValueDynamicObject.get(entry.getKey()));
                    Map<Long, List<String>> labelValues = null;
                    if ("20".equals(this.label.getString("type"))) {
                        labelValues = this.getLabelValues(matchList, paramMap, this.labelValueDynamicObject.get(entry.getKey()));
                    }
                    this.setLabelResult(labelResultMap, matchList, labelValues, this.labelValueDynamicObject.get(entry.getKey()));
                }
                resultInfoList = labelResultMap.values().stream().collect(Collectors.toList());
            }
            this.setDisplayFields(resultInfoList);
        }
        this.refreshTimes(resultInfoList);
        return resultInfoList;
    }

    private void refreshTimes(List<LabelResultInfo> resultInfoList) {
        if (resultInfoList == null || resultInfoList.size() == 0) {
            return;
        }
        if (HRStringUtils.isEmpty((String)this.preTaskNumber) || this.labelTaskStorageService == null) {
            return;
        }
        List pkIds = resultInfoList.stream().map(resultInfo -> String.valueOf(resultInfo.getId())).collect(Collectors.toList());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", pkIds));
        List<Map<String, Object>> preResultInfoList = this.labelTaskStorageService.getResultList(selects, qFilters, 0, pkIds.size());
        HashMap<Object, Map<String, Object>> resultMap = new HashMap<Object, Map<String, Object>>(16);
        for (Map<String, Object> row : preResultInfoList) {
            resultMap.put(row.get("id"), row);
        }
        for (LabelResultInfo labelResultInfo : resultInfoList) {
            if (!resultMap.containsKey(String.valueOf(labelResultInfo.getId()))) continue;
            this.updateLabelResultInfo(labelResultInfo, (Map)resultMap.get(String.valueOf(labelResultInfo.getId())));
        }
    }

    private void updateLabelResultInfo(LabelResultInfo labelResultInfo, Map<String, Object> row) {
        if (row == null) {
            return;
        }
        if (row.containsKey("createTime") && HRStringUtils.isNotEmpty((String)String.valueOf(row.get("createTime")))) {
            try {
                labelResultInfo.setCreateTime(HRDateTimeUtils.parseDate((String)String.valueOf(row.get("createTime"))));
            }
            catch (ParseException e) {
                logger.error("createTime parse error. " + row.get("createTime"));
            }
        }
        HashMap<String, Map> oldValueMap = new HashMap<String, Map>(16);
        ArrayList labelMapList = (ArrayList)row.get("labels");
        for (Map labelValueMap : labelMapList) {
            oldValueMap.put(String.valueOf(labelValueMap.get("labelValueId")) + labelValueMap.get("labelValueName") + labelValueMap.get("labelBizValue"), labelValueMap);
        }
        boolean valueChangeFlag = oldValueMap.size() != labelResultInfo.getLabelResult().size();
        for (LabelResultEntry entry : labelResultInfo.getLabelResult()) {
            String key = entry.getLabelValueId() + entry.getLabelValueName() + entry.getLabelBizValue();
            if (oldValueMap.containsKey(key)) {
                Map preValueMap = (Map)oldValueMap.get(key);
                if (!preValueMap.containsKey("createTime")) continue;
                try {
                    entry.setCreateTime(HRDateTimeUtils.parseDate((String)String.valueOf(preValueMap.get("createTime"))));
                }
                catch (ParseException e) {
                    logger.error("createTime parse error. " + row.get("createTime"));
                }
                continue;
            }
            valueChangeFlag = true;
        }
        if (!valueChangeFlag && row.containsKey("lastUpdateTime") && HRStringUtils.isNotEmpty((String)String.valueOf(row.get("lastUpdateTime")))) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                df.setTimeZone(TimeZone.getTimeZone(ZoneId.ofOffset("GMT", ZoneOffset.ofHours(0))));
                labelResultInfo.setLastUpdateTime(df.parse(String.valueOf(row.get("lastUpdateTime"))));
            }
            catch (Exception e) {
                logger.error("lastUpdateTime parse error. " + row.get("lastUpdateTime"));
            }
        } else {
            labelResultInfo.setLastUpdateTime(new Date());
        }
    }

    private void setDisplayFields(List<LabelResultInfo> resultList) {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        List idList = resultList.stream().map(labelResultInfo -> labelResultInfo.getId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", idList);
        List<Map<String, Object>> entryDataList = this.labelDataService.getEntryDataList(qFilter);
        if (entryDataList == null || entryDataList.size() == 0) {
            return;
        }
        Map<String, Map> entryDataGroup = entryDataList.stream().collect(Collectors.toMap(ed -> String.valueOf(ed.get("id")), ed -> ed));
        for (LabelResultInfo labelResultInfo2 : resultList) {
            if (!entryDataGroup.containsKey(String.valueOf(labelResultInfo2.getId()))) continue;
            Map item = entryDataGroup.get(String.valueOf(labelResultInfo2.getId()));
            item.entrySet().forEach(entry -> labelResultInfo2.putDisplayField(((String)entry.getKey()).replaceAll("_dm6h7z_", "@"), entry.getValue()));
        }
    }

    private void setLabelResult(Map<Long, LabelResultInfo> labelResultMap, List<Long> matchList, Map<Long, List<String>> labelValues, DynamicObject labelValueDyn) {
        for (Long pk : matchList) {
            if (!labelResultMap.containsKey(pk)) {
                LabelResultInfo resultInfo = this.createLabelResultInfo(pk);
                labelResultMap.put(pk, resultInfo);
            }
            if ("20".equals(this.label.getString("type")) && labelValues.containsKey(pk) && labelValues.get(pk).size() > 0) {
                for (String bizLabelValue : labelValues.get(pk)) {
                    LabelResultEntry labelResultEntry = new LabelResultEntry(Long.valueOf(this.label.getLong("id")), Long.valueOf(labelValueDyn.getLong("id")), labelValueDyn.getString("value"), bizLabelValue);
                    labelResultEntry.setCreateTime(new Date());
                    labelResultEntry.setCreatorId(Long.valueOf(1L));
                    labelResultMap.get(pk).getLabelResult().add(labelResultEntry);
                }
                continue;
            }
            LabelResultEntry labelResultEntry = new LabelResultEntry(Long.valueOf(this.label.getLong("id")), Long.valueOf(labelValueDyn.getLong("id")), labelValueDyn.getString("value"), null);
            labelResultEntry.setCreateTime(new Date());
            labelResultEntry.setCreatorId(Long.valueOf(1L));
            labelResultMap.get(pk).getLabelResult().add(labelResultEntry);
        }
    }

    private LabelResultInfo createLabelResultInfo(Long id) {
        LabelResultInfo resultInfo = new LabelResultInfo();
        resultInfo.setId((Object)id);
        resultInfo.setCreateTime(new Date());
        resultInfo.setLabelObjectId(Long.valueOf(this.labelObject.getLong("id")));
        resultInfo.setPolicyId(this.policyId);
        return resultInfo;
    }

    private boolean isKingdee(String appId) {
        return "kingdee".equals(this.appIsvMap.get(appId));
    }

    private List<Long> findMatchPksByService(List<Long> pkList, String serviceName, DynamicObject labelValueDyn) {
        String[] servicePath;
        ArrayList<Long> result = new ArrayList<Long>(10);
        if (serviceName != null && !"".equals(serviceName) && (servicePath = serviceName.split("\\.")).length == 2) {
            try {
                if (this.isKingdee(servicePath[0])) {
                    List rpcResult = (List)HRMServiceHelper.invokeBizService((String)this.appCloudMap.get(servicePath[0]), (String)servicePath[0], (String)servicePath[1], (String)"findMatchPks", (Object[])new Object[]{this.mainEntityNumber, this.labelObject, labelValueDyn, pkList});
                    if (rpcResult != null) {
                        rpcResult.forEach(pk -> result.add(Long.parseLong(String.valueOf(pk))));
                    }
                } else {
                    List rpcResult = (List)HRMServiceHelper.invokeService((String)this.appCloudMap.get(servicePath[0]), (String)servicePath[0], (String)servicePath[1], (String)"findMatchPks", (Object[])new Object[]{this.mainEntityNumber, this.labelObject, labelValueDyn, pkList});
                    if (rpcResult != null) {
                        rpcResult.forEach(pk -> result.add(Long.parseLong(String.valueOf(pk))));
                    }
                }
            }
            catch (Exception exp) {
                String errorMsg;
                logger.error(exp.getMessage());
                logger.error((Throwable)exp);
                String string = errorMsg = exp.getMessage() == null ? "" : exp.getMessage();
                if (errorMsg.indexOf("findMatchPks") > -1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u8fd0\u884c\u5931\u8d25\u3002", (String)"ComplexLabelTaskProcessService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), labelValueDyn.getString("value")));
                }
                if (errorMsg.indexOf("ServiceFactory not find") > -1 || errorMsg.indexOf(servicePath[1]) > -1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"ComplexLabelTaskProcessService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), labelValueDyn.getString("value")));
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6253\u6807\u89c4\u5219\u670d\u52a1\u7c7b\u8fd0\u884c\u5931\u8d25\u3002", (String)"ComplexLabelTaskProcessService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), labelValueDyn.getString("value")));
            }
        }
        return result;
    }

    private Map<Long, List<String>> getLabelValuesByService(List<Long> pkList, DynamicObject labelValueDyn, String serviceName) {
        String[] servicePath;
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(16);
        if (serviceName != null && !"".equals(serviceName) && (servicePath = serviceName.split("\\.")).length == 2) {
            try {
                if (this.isKingdee(servicePath[0])) {
                    Map rpcResult = (Map)HRMServiceHelper.invokeBizService((String)this.appCloudMap.get(servicePath[0]), (String)servicePath[0], (String)servicePath[1], (String)"getLabelValues", (Object[])new Object[]{this.mainEntityNumber, this.labelObject, labelValueDyn, pkList});
                    if (rpcResult != null) {
                        rpcResult.forEach((pk, value) -> {
                            ArrayList<String> values = new ArrayList<String>(16);
                            values.add((String)value);
                            result.put(Long.parseLong(String.valueOf(pk)), values);
                        });
                    }
                } else {
                    Map rpcResult = (Map)HRMServiceHelper.invokeService((String)this.appCloudMap.get(servicePath[0]), (String)servicePath[0], (String)servicePath[1], (String)"getLabelValues", (Object[])new Object[]{this.mainEntityNumber, this.labelObject, labelValueDyn, pkList});
                    if (rpcResult != null) {
                        rpcResult.forEach((pk, value) -> {
                            ArrayList<String> values = new ArrayList<String>(16);
                            values.add((String)value);
                            result.put(Long.parseLong(String.valueOf(pk)), values);
                        });
                    }
                }
            }
            catch (Exception exp) {
                String errorMsg;
                logger.error(exp.getMessage());
                logger.error((Throwable)exp);
                String string = errorMsg = exp.getMessage() == null ? "" : exp.getMessage();
                if (errorMsg.indexOf("getLabelValues") > -1) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1s\u201d\u6807\u7b7e\u4e2d\u7684\u201c%2s\u201d\u6807\u7b7e\u503c\u89c4\u5219\u670d\u52a1\u7c7b\u8fd0\u884c\u5931\u8d25\u3002", (String)"ComplexLabelTaskProcessService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.label.getString("name"), labelValueDyn.getString("value"));
                    throw new KDBizException(errorMsg);
                }
                if (errorMsg.indexOf("ServiceFactory not find") > -1 || errorMsg.indexOf(servicePath[1]) > -1) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1s\u201d\u6807\u7b7e\u4e2d\u7684\u201c%2s\u201d\u6807\u7b7e\u503c\u89c4\u5219\u670d\u52a1\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"ComplexLabelTaskProcessService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.label.getString("name"), labelValueDyn.getString("value"));
                    throw new KDBizException(errorMsg);
                }
                errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1s\u201d\u6807\u7b7e\u4e2d\u7684\u201c%2s\u201d\u6807\u7b7e\u503c\u89c4\u5219\u670d\u52a1\u7c7b\u8fd0\u884c\u5931\u8d25\u3002", (String)"ComplexLabelTaskProcessService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.label.getString("name"), labelValueDyn.getString("value"));
                throw new KDBizException(errorMsg);
            }
        }
        return result;
    }

    private Map<Long, List<String>> getLabelValuesByFunc(List<Long> pkList, Map<Long, List<Map<String, Object>>> paramMap, DynamicObject labelValueDyn) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(16);
        for (Long pkId : pkList) {
            if (!paramMap.containsKey(pkId)) continue;
            ArrayList labels = new ArrayList(16);
            result.put(pkId, labels);
            for (Map<String, Object> row : paramMap.get(pkId)) {
                try {
                    Object funcResult = LabelFunctionTargetExecutor.executeFunction(this.labelValueFunctions.get(labelValueDyn.getLong("id")), this.getLabelFuncParams(row));
                    if (((List)result.get(pkId)).contains(String.valueOf(funcResult))) continue;
                    ((List)result.get(pkId)).add(String.valueOf(funcResult));
                }
                catch (Exception exp) {
                    logger.error("execute function error.");
                    logger.error((Throwable)exp);
                }
            }
        }
        return result;
    }

    private Map<String, Object> getLabelFuncParams(Map<String, Object> row) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>(this.paramsMap.size());
        for (Map.Entry<String, DynamicObject> param : this.paramsMap.entrySet()) {
            DynamicObject dynField = param.getValue();
            if (AnalyseObjectUtil.isBaseDataType((String)dynField.getString("complextype")) && (dynField.getString("fieldalias").endsWith(".id") || dynField.getString("fieldalias").endsWith(".name") || dynField.getString("fieldalias").endsWith(".number"))) {
                if (!param.getKey().startsWith("pl")) continue;
                inputParams.put(param.getKey(), row.get(dynField.getString("fieldalias")));
                continue;
            }
            if (FieldControlType.COMBO.getValue().equals(dynField.getString("controltype"))) {
                if (!param.getKey().startsWith("pl")) continue;
                inputParams.put(param.getKey(), this.getComboName(dynField.getString("entitynumber"), dynField.getString("fieldpath"), dynField.getString("fieldalias"), row.get(dynField.getString("fieldalias"))));
                continue;
            }
            if (FieldControlType.MUL_COMBO.getValue().equals(dynField.getString("controltype"))) {
                if (!"string".equals(dynField.getString("valuetype")) && row.get(dynField.getString("fieldalias")) instanceof String && ("".equals(row.get(dynField.getString("fieldalias"))) || "null".equalsIgnoreCase((String)row.get(dynField.getString("fieldalias"))))) {
                    inputParams.put(param.getKey(), null);
                    continue;
                }
                String tempValue = String.valueOf(row.get(dynField.getString("fieldalias")));
                if (tempValue.startsWith(",")) {
                    tempValue = tempValue.substring(1);
                }
                if (tempValue.endsWith(",")) {
                    tempValue = tempValue.substring(0, tempValue.length() - 1);
                }
                inputParams.put(param.getKey(), tempValue);
                continue;
            }
            if (!"string".equals(dynField.getString("valuetype")) && row.get(dynField.getString("fieldalias")) instanceof String && ("".equals(row.get(dynField.getString("fieldalias"))) || "null".equalsIgnoreCase((String)row.get(dynField.getString("fieldalias"))))) {
                inputParams.put(param.getKey(), null);
                continue;
            }
            inputParams.put(param.getKey(), row.get(dynField.getString("fieldalias")));
        }
        return inputParams;
    }

    private String getComboName(String entityNumber, String fieldPath, String fieldAlias, Object key) {
        if (key == null) {
            return null;
        }
        if (!this.comboMap.containsKey(fieldAlias)) {
            DynamicProperty dynamicProperty = LabelService.getFieldDynamicProperty(entityNumber, fieldPath);
            if (dynamicProperty instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)dynamicProperty;
                List itemList = comboProp.getComboItems();
                this.comboMap.put(fieldAlias, itemList);
                return this.getComboName(key, this.comboMap.get(fieldAlias));
            }
            return String.valueOf(key);
        }
        return this.getComboName(key, this.comboMap.get(fieldAlias));
    }

    private String getComboName(Object key, List<ValueMapItem> itemList) {
        for (ValueMapItem item : itemList) {
            if (!key.equals(item.getValue())) continue;
            return item.getName().getLocaleValue();
        }
        return key == null ? null : String.valueOf(key);
    }

    private Map<Long, List<String>> getLabelValues(List<Long> pkList, Map<Long, List<Map<String, Object>>> paramMap, DynamicObject labelValueDyn) {
        HashMap<Long, List<String>> resultMap = new HashMap<Long, List<String>>(16);
        if (pkList == null || pkList.size() == 0) {
            return resultMap;
        }
        if ("2".equals(this.label.getString("configtype"))) {
            return this.getLabelValuesByService(pkList, labelValueDyn, this.labelValuePlugins.get(labelValueDyn.getLong("id")));
        }
        if ("1".equals(this.label.getString("configtype"))) {
            return this.getLabelValuesByFunc(pkList, paramMap, labelValueDyn);
        }
        return resultMap;
    }

    @Override
    public void finish() {
        Date nowDate = new Date();
        LabelPolicyServiceHelper.updatePolicyTask(this.policyId, this.taskNumber, "2", null);
        HRBaseServiceHelper labelPolicyHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        DynamicObject tempLabelPolicy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        tempLabelPolicy.set("lasttasknumber", (Object)this.taskNumber);
        tempLabelPolicy.set("lasttasktime", (Object)nowDate);
        tempLabelPolicy.set("modifytime", (Object)nowDate);
        labelPolicyHelper.updateOne(tempLabelPolicy);
    }
}

