/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.util.GenFieldUtil;
import kd.hr.hrcs.common.constants.label.LabelConstants;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;
import kd.hr.hrcs.common.model.label.LabelDataMulFieldParam;
import kd.hr.hrcs.common.model.label.LabelExcelMulFieldBo;
import kd.hr.hrcs.common.model.label.LabelExcelMulFieldRowBo;

@ExcludeFromJacocoGeneratedReport
public class LabelDataService
implements LabelConstants,
LblStrategyConstants {
    private Map<String, Object> controlData;
    DynamicObjectCollection entry;
    private String entityNumber;
    private String fieldNumber;
    private String displayName;
    private String fieldName;
    private String mainEntityAlias;
    private Map<String, String> oneToNEntityMap;
    private Map<String, Map<String, String>> comboFieldNameMap;
    private Map<String, Set<String>> entryKeyMap;
    private Map<String, Set<String>> relEntityKeyMap;

    public Map<String, Set<String>> getEntryKeyMap() {
        return this.entryKeyMap;
    }

    public void setEntryKeyMap(Map<String, Set<String>> entryKeyMap) {
        this.entryKeyMap = entryKeyMap;
    }

    public Map<String, Set<String>> getRelEntityKeyMap() {
        return this.relEntityKeyMap;
    }

    public void setRelEntityKeyMap(Map<String, Set<String>> relEntityKeyMap) {
        this.relEntityKeyMap = relEntityKeyMap;
    }

    public String getMainEntityAlias() {
        return this.mainEntityAlias;
    }

    public void setMainEntityAlias(String mainEntityAlias) {
        this.mainEntityAlias = mainEntityAlias;
    }

    public Map<String, String> getOneToNEntityMap() {
        return this.oneToNEntityMap;
    }

    public void setOneToNEntityMap(Map<String, String> oneToNEntityMap) {
        this.oneToNEntityMap = oneToNEntityMap;
    }

    public Map<String, Map<String, String>> getComboFieldNameMap() {
        return this.comboFieldNameMap;
    }

    public void setComboFieldNameMap(Map<String, Map<String, String>> comboFieldNameMap) {
        this.comboFieldNameMap = comboFieldNameMap;
    }

    public Map<String, Object> getControlData() {
        return this.controlData;
    }

    public void setControlData(Map<String, Object> controlData) {
        this.controlData = controlData;
    }

    public DynamicObjectCollection getEntry() {
        return this.entry;
    }

    public void setEntry(DynamicObjectCollection entry) {
        this.entry = entry;
    }

    public LabelDataService() {
    }

    public LabelDataService(long lblObjId, boolean isDisplay) {
        this.loadParam(lblObjId, isDisplay);
    }

    private void loadParam(long lblObjId, boolean isDisplay) {
        LabelService service = new LabelService();
        this.controlData = service.getEntityAndFieldData(lblObjId);
        List joinEntityCommonBoList = (List)this.controlData.get("entityNodes");
        this.oneToNEntityMap = Maps.newHashMapWithExpectedSize((int)joinEntityCommonBoList.size());
        for (JoinEntityCommonBo joinEntityCommonBo : joinEntityCommonBoList) {
            EntityRelationCommonBo entityRelation;
            if (HRStringUtils.equals((String)"main", (String)joinEntityCommonBo.getType())) {
                this.mainEntityAlias = joinEntityCommonBo.getEntityAlias();
            }
            if ((entityRelation = joinEntityCommonBo.getEntityRelation()) == null || !"2".equals(entityRelation.getRelationType())) continue;
            this.oneToNEntityMap.put(joinEntityCommonBo.getEntityAlias(), entityRelation.getDisplayName().getLocaleValue());
        }
        DynamicObject lblObjConfig = LabelObjectServiceHelper.getLblObjConfig(lblObjId);
        if (isDisplay) {
            this.entry = lblObjConfig.getDynamicObjectCollection("displayentryentity");
            this.entityNumber = "displayentitynumberalias";
            this.fieldNumber = "displayfieldnumber";
            this.displayName = "displaydisplayname";
            this.fieldName = "displayfieldname";
        } else {
            this.entry = lblObjConfig.getDynamicObjectCollection("manualentryentity");
            this.entityNumber = "manualentitynumberalias";
            this.fieldNumber = "manualfieldnumber";
            this.displayName = "manualdisplayname";
            this.fieldName = "manualfieldname";
        }
        List fieldTreeNodeList = (List)this.controlData.get("fieldTreeNode");
        HashMap fieldTreeNodeMap = Maps.newHashMapWithExpectedSize((int)80000);
        LabelDataService.addFieldTreeNodeMap(fieldTreeNodeList, fieldTreeNodeMap);
        this.comboFieldNameMap = Maps.newHashMapWithExpectedSize((int)this.entry.size());
        for (DynamicObject dynamicObject : this.entry) {
            String entityAlias = dynamicObject.getString(this.entityNumber);
            String fieldNum = dynamicObject.getString(this.fieldNumber);
            String key = HRStringUtils.equals((String)entityAlias, (String)this.mainEntityAlias) ? fieldNum : entityAlias + "." + fieldNum;
            FieldTreeNode fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(key);
            if (fieldTreeNode == null) continue;
            DynamicProperty property = GenFieldUtil.getBindEntityProperty(entityAlias + "." + fieldNum);
            if (fieldTreeNode.getEntryField().booleanValue()) {
                this.addComboName(property, key, this.comboFieldNameMap);
                continue;
            }
            if (!this.oneToNEntityMap.containsKey(entityAlias)) continue;
            this.addComboName(property, key, this.comboFieldNameMap);
        }
        for (Map.Entry entry : fieldTreeNodeMap.entrySet()) {
            FieldTreeNode value = (FieldTreeNode)entry.getValue();
            if (value.getEntryField().booleanValue()) {
                value.setEntryNumber(value.getEntryNumber().replace("@", "_dm6h7z_"));
                continue;
            }
            if (!value.getEntry().booleanValue()) continue;
            String replace = value.getNumber().replace("@", "_dm6h7z_");
            value.setNumber(replace);
        }
        this.sort(this.entry);
    }

    public EntryAp generateEntryAp(Map<String, Map<String, Object>> fieldKeyPropMap) {
        EntryAp entryAp = new EntryAp();
        entryAp.setId("entryentity");
        entryAp.setKey(entryAp.getId());
        entryAp.setSplitPage(true);
        entryAp.setPageRow(20);
        entryAp.setPageType("1");
        entryAp.setShowSeq(true);
        entryAp.setShowSelChexkbox(true);
        entryAp.setHeight(new LocaleString("100%"));
        entryAp.setOrderAndFilter(3);
        EntryEntity entryEntity = new EntryEntity();
        entryEntity.setKey(entryAp.getKey());
        entryEntity.setId(entryAp.getId());
        entryEntity.setName(new LocaleString(entryAp.getKey()));
        entryEntity.setDefaultRows(0);
        entryAp.setEntry(entryEntity);
        List<FieldAp> fieldApList = this.getFieldApList(fieldKeyPropMap);
        for (FieldAp fieldAp : fieldApList) {
            entryAp.getItems().add(fieldAp);
        }
        FieldAp fieldAp0 = new FieldAp();
        fieldAp0.setId("id");
        fieldAp0.setKey(fieldAp0.getId());
        fieldAp0.setHidden(true);
        TextField field0 = new TextField();
        field0.setKey(fieldAp0.getId());
        field0.setId(fieldAp0.getId());
        fieldAp0.setField((Field)field0);
        entryAp.getItems().add(fieldAp0);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId("seq");
        fieldAp.setKey(fieldAp.getId());
        IntegerField field = new IntegerField();
        field.setKey(fieldAp.getId());
        field.setId(fieldAp.getId());
        fieldAp.setField((Field)field);
        entryAp.getItems().add(fieldAp);
        return entryAp;
    }

    public EntryProp registerDynamicProps(FormShowParameter formShowParameter) {
        EntryProp entryPropNew = new EntryProp();
        entryPropNew.setName("entryentity");
        entryPropNew.setDbIgnore(true);
        entryPropNew.setDefaultRows(0);
        EntryType itemType = new EntryType();
        itemType.setName(entryPropNew.getName());
        itemType.setExtendName(entryPropNew.getName());
        entryPropNew.setItemType((IDataEntityType)itemType);
        DynamicObjectType dynamicCollectionItemPropertyType = entryPropNew.getDynamicCollectionItemPropertyType();
        String fieldPropTypeStr = (String)formShowParameter.getCustomParam("fieldPropType");
        Map fieldPropTypeMap = (Map)SerializationUtils.fromJsonString((String)fieldPropTypeStr, Map.class);
        for (Map.Entry entry : fieldPropTypeMap.entrySet()) {
            Map propMap = (Map)entry.getValue();
            String type = (String)propMap.get("propType");
            String key = (String)entry.getKey();
            List<DynamicProperty> fieldPropertyList = GenFieldUtil.getFieldPropertyList(key, type, null, false);
            if (fieldPropertyList.isEmpty()) {
                if (key.startsWith("labelperson")) {
                    BasedataProp basedataProp = new BasedataProp();
                    basedataProp.setName(key);
                    basedataProp.setDbIgnore(true);
                    basedataProp.setBaseEntityId("bos_user");
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                    basedataProp.setComplexType((IDataEntityType)dataEntityType);
                    DynamicSimpleProperty refIdProp = basedataProp.createRefIDProp();
                    refIdProp.setName("bos_user");
                    basedataProp.setRefIdProp((IDataEntityProperty)refIdProp);
                    basedataProp.setRefIdPropName("bos_user");
                    fieldPropertyList.add((DynamicProperty)basedataProp);
                } else if (key.startsWith("labeltime")) {
                    DateTimeProp dateTimeProp = new DateTimeProp();
                    dateTimeProp.setName(key);
                    dateTimeProp.setDbIgnore(true);
                    fieldPropertyList.add((DynamicProperty)dateTimeProp);
                }
            }
            for (DynamicProperty property : fieldPropertyList) {
                dynamicCollectionItemPropertyType.addProperty(property);
            }
        }
        TextProp longProp = new TextProp();
        longProp.setName("id");
        longProp.setDbIgnore(true);
        dynamicCollectionItemPropertyType.addProperty((DynamicProperty)longProp);
        IntegerProp integerProp = new IntegerProp();
        integerProp.setName("seq");
        integerProp.setDbIgnore(true);
        dynamicCollectionItemPropertyType.addProperty((DynamicProperty)integerProp);
        return entryPropNew;
    }

    public Map<String, Map<String, Object>> getFieldKeyPropMap() {
        List fieldTreeNodeList = (List)this.controlData.get("fieldTreeNode");
        HashMap fieldTreeNodeMap = Maps.newHashMapWithExpectedSize((int)80000);
        LabelDataService.addFieldTreeNodeMap(fieldTreeNodeList, fieldTreeNodeMap);
        HashSet entryKeySet = Sets.newHashSetWithExpectedSize((int)fieldTreeNodeMap.size());
        HashSet relEntityKeySet = Sets.newHashSetWithExpectedSize((int)fieldTreeNodeMap.size());
        LinkedHashMap fieldKeyPropMap = Maps.newLinkedHashMapWithExpectedSize((int)this.entry.size());
        for (DynamicObject dynamicObject : this.entry) {
            String entityNumber = dynamicObject.getString(this.entityNumber);
            String fieldNumber = dynamicObject.getString(this.fieldNumber);
            if (!HRStringUtils.isEmpty((String)entityNumber)) {
                HashMap proMap;
                LocaleString displayName;
                FieldTreeNode fieldTreeNode;
                if (HRStringUtils.equals((String)this.mainEntityAlias, (String)entityNumber)) {
                    fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(fieldNumber);
                    if (fieldTreeNode.getEntryField().booleanValue()) {
                        if (!entryKeySet.add(fieldTreeNode.getEntryNumber())) continue;
                        displayName = ((FieldTreeNode)fieldTreeNodeMap.get(fieldTreeNode.getEntryNumber())).getName();
                        proMap = Maps.newHashMapWithExpectedSize((int)2);
                        proMap.put("propType", "text");
                        proMap.put("propName", displayName.getLocaleValue());
                        fieldKeyPropMap.put(fieldTreeNode.getEntryNumber(), proMap);
                        continue;
                    }
                    DynamicProperty property = GenFieldUtil.getBindEntityProperty(entityNumber + "." + fieldNumber);
                    String displayName2 = dynamicObject.getString(this.displayName);
                    if (HRStringUtils.isEmpty((String)displayName2)) {
                        displayName2 = dynamicObject.getString(this.fieldName);
                    }
                    HashMap proMap2 = Maps.newHashMapWithExpectedSize((int)2);
                    this.setPropType(property, proMap2);
                    proMap2.put("propName", displayName2);
                    String newFieldNum = fieldNumber.replace(".", "_dm6h7z_");
                    fieldKeyPropMap.put(newFieldNum, proMap2);
                    continue;
                }
                fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(entityNumber + "." + fieldNumber);
                if (fieldTreeNode.getEntryField().booleanValue()) {
                    if (!entryKeySet.add(fieldTreeNode.getEntryNumber())) continue;
                    displayName = ((FieldTreeNode)fieldTreeNodeMap.get(fieldTreeNode.getEntryNumber())).getName();
                    proMap = Maps.newHashMapWithExpectedSize((int)2);
                    proMap.put("propType", "text");
                    proMap.put("propName", displayName.getLocaleValue());
                    fieldKeyPropMap.put(fieldTreeNode.getEntryNumber(), proMap);
                    continue;
                }
                String entityName = this.oneToNEntityMap.get(entityNumber);
                if (!HRStringUtils.isEmpty((String)entityName)) {
                    if (!relEntityKeySet.add(entityNumber)) continue;
                    proMap = Maps.newHashMapWithExpectedSize((int)2);
                    proMap.put("propType", "text");
                    proMap.put("propName", entityName);
                    fieldKeyPropMap.put(entityNumber, proMap);
                    continue;
                }
                DynamicProperty property = GenFieldUtil.getBindEntityProperty(entityNumber + "." + fieldNumber);
                fieldNumber = entityNumber + "." + fieldNumber;
                String displayName3 = dynamicObject.getString(this.displayName);
                if (HRStringUtils.isEmpty((String)displayName3)) {
                    displayName3 = dynamicObject.getString(this.fieldName);
                }
                HashMap proMap3 = Maps.newHashMapWithExpectedSize((int)2);
                this.setPropType(property, proMap3);
                proMap3.put("propName", displayName3);
                String newFieldNum = fieldNumber.replace(".", "_dm6h7z_");
                fieldKeyPropMap.put(newFieldNum, proMap3);
                continue;
            }
            if (!"LabelPerson".equals(fieldNumber) && !"LabelTime".equals(fieldNumber)) continue;
            HashMap proMap = Maps.newHashMapWithExpectedSize((int)2);
            proMap.put("propType", fieldNumber);
            String name = dynamicObject.getString(this.fieldName);
            proMap.put("propName", name);
            fieldKeyPropMap.put(fieldNumber.toLowerCase(Locale.ROOT), proMap);
        }
        return fieldKeyPropMap;
    }

    public void generateEntryAndRelField() {
        List fieldTreeNodeList = (List)this.controlData.get("fieldTreeNode");
        HashMap fieldTreeNodeMap = Maps.newHashMapWithExpectedSize((int)80000);
        LabelDataService.addFieldTreeNodeMap(fieldTreeNodeList, fieldTreeNodeMap);
        this.entryKeyMap = Maps.newHashMapWithExpectedSize((int)fieldTreeNodeMap.size());
        this.relEntityKeyMap = Maps.newHashMapWithExpectedSize((int)fieldTreeNodeMap.size());
        for (DynamicObject dynamicObject : this.entry) {
            Set entryFieldKeySet;
            FieldTreeNode fieldTreeNode;
            String entityNumber = dynamicObject.getString(this.entityNumber);
            String fieldNumber = dynamicObject.getString(this.fieldNumber);
            if (HRStringUtils.isEmpty((String)entityNumber)) continue;
            if (HRStringUtils.equals((String)this.mainEntityAlias, (String)entityNumber)) {
                fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(fieldNumber);
                if (!fieldTreeNode.getEntryField().booleanValue()) continue;
                entryFieldKeySet = this.entryKeyMap.computeIfAbsent(fieldTreeNode.getEntryNumber(), k -> Sets.newHashSetWithExpectedSize((int)this.entry.size()));
                entryFieldKeySet.add(fieldTreeNode.getFieldAlias());
                continue;
            }
            fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(entityNumber + "." + fieldNumber);
            if (fieldTreeNode.getEntryField().booleanValue()) {
                entryFieldKeySet = this.entryKeyMap.computeIfAbsent(fieldTreeNode.getEntryNumber(), k -> Sets.newHashSetWithExpectedSize((int)this.entry.size()));
                entryFieldKeySet.add(fieldTreeNode.getFieldAlias());
                continue;
            }
            String entityName = this.oneToNEntityMap.get(entityNumber);
            if (HRStringUtils.isEmpty((String)entityName)) continue;
            Set relFieldKeySet = this.relEntityKeyMap.computeIfAbsent(entityNumber, k -> Sets.newHashSetWithExpectedSize((int)this.entry.size()));
            relFieldKeySet.add(fieldTreeNode.getFieldAlias());
        }
    }

    public List<FieldAp> getFieldApList(Map<String, Map<String, Object>> fieldKeyPropMap) {
        ArrayList fieldApList = Lists.newArrayListWithExpectedSize((int)fieldKeyPropMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : fieldKeyPropMap.entrySet()) {
            String fieldKey = entry.getKey();
            Map<String, Object> propMap = entry.getValue();
            String propType = (String)propMap.get("propType");
            String name = (String)propMap.get("propName");
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId(fieldKey);
            entryFieldAp.setKey(fieldKey);
            entryFieldAp.setName(new LocaleString(name));
            if ("labelperson".equals(fieldKey.toLowerCase(Locale.ROOT))) {
                BasedataField basedataField = new BasedataField();
                basedataField.setKey(entryFieldAp.getKey());
                basedataField.setId(entryFieldAp.getId());
                basedataField.setBaseEntityId("bos_user");
                basedataField.setViewDetail(false);
                entryFieldAp.setField((Field)basedataField);
                fieldApList.add(entryFieldAp);
                continue;
            }
            if ("labeltime".equals(fieldKey.toLowerCase(Locale.ROOT))) {
                DateTimeField dateTimeField = new DateTimeField();
                dateTimeField.setKey(entryFieldAp.getKey());
                dateTimeField.setId(entryFieldAp.getId());
                entryFieldAp.setField((Field)dateTimeField);
                fieldApList.add(entryFieldAp);
                continue;
            }
            List<DynamicProperty> propList = GenFieldUtil.getFieldPropertyList(fieldKey, propType, null, false);
            for (DynamicProperty property : propList) {
                FieldAp fieldAp = this.getFieldAp(property, fieldKey, propMap);
                fieldAp.setName(new LocaleString(name));
                fieldApList.add(fieldAp);
            }
        }
        return fieldApList;
    }

    public HRComplexObjContext getIdContext(QFilter qFilter) {
        List joinEntityCommonBoList = (List)this.controlData.get("entityNodes");
        JoinEntityCommonBo mainEntity = joinEntityCommonBoList.stream().filter(je -> HRStringUtils.equals((String)"main", (String)je.getType())).findFirst().orElse(null);
        HashSet otherEntityAliasSet = Sets.newHashSetWithExpectedSize((int)joinEntityCommonBoList.size());
        for (JoinEntityCommonBo joinEntityCommonBo : joinEntityCommonBoList) {
            if (!HRStringUtils.equals((String)"main", (String)joinEntityCommonBo.getType())) {
                otherEntityAliasSet.add(joinEntityCommonBo.getEntityAlias());
                continue;
            }
            mainEntity = joinEntityCommonBo;
        }
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)16);
        if (qFilter != null) {
            boolean isTopOther = false;
            for (Object otherEntity : otherEntityAliasSet) {
                if (!qFilter.getProperty().contains((String)otherEntity + ".")) continue;
                isTopOther = true;
                break;
            }
            if (!isTopOther) {
                qFilterList.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
            }
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                boolean isOther = false;
                for (String otherEntity : otherEntityAliasSet) {
                    if (!nest.getFilter().getProperty().contains(otherEntity)) continue;
                    isOther = true;
                    break;
                }
                if (isOther) continue;
                qFilterList.add(nest.getFilter());
            }
        }
        ArrayList queryFieldCommonBoList = Lists.newArrayListWithExpectedSize((int)1);
        QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
        queryFieldCommonBo.setFieldAlias("id");
        assert (mainEntity != null);
        queryFieldCommonBo.setEntityNumber(mainEntity.getEntityAlias());
        queryFieldCommonBo.setValueType(DataTypeEnum.LONG.getDataTypeKey());
        queryFieldCommonBo.setComplexType(FieldComplexType.NORMAL.getValue());
        queryFieldCommonBoList.add(queryFieldCommonBo);
        LabelService labelService = new LabelService();
        return labelService.getContext(Lists.newArrayList((Object[])new JoinEntityCommonBo[]{mainEntity}), queryFieldCommonBoList, qFilterList);
    }

    public HRComplexObjContext getIdCountContext(QFilter qFilter) {
        List joinEntityCommonBoList = (List)this.controlData.get("entityNodes");
        HashMap fieldTreeNodeMap = Maps.newHashMapWithExpectedSize((int)80000);
        List fieldTreeNodeList = (List)this.controlData.get("fieldTreeNode");
        LabelDataService.addFieldTreeNodeMap(fieldTreeNodeList, fieldTreeNodeMap);
        List<QueryFieldCommonBo> queryFieldCommonBoList = this.buildQueryFieldByDisplayResults(this.entry, fieldTreeNodeMap, this.mainEntityAlias);
        if (!fieldTreeNodeMap.containsKey("id")) {
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            queryFieldCommonBo.setFieldAlias("id");
            queryFieldCommonBo.setFieldPath("id");
            queryFieldCommonBo.setEntityNumber(this.mainEntityAlias);
            queryFieldCommonBo.setValueType(DataTypeEnum.LONG.getDataTypeKey());
            queryFieldCommonBo.setComplexType(FieldComplexType.NORMAL.getValue());
            queryFieldCommonBoList.add(queryFieldCommonBo);
        }
        List<JoinEntityCommonBo> filterEntityList = this.filterEntity(joinEntityCommonBoList, queryFieldCommonBoList, qFilter);
        LabelService labelService = new LabelService();
        return labelService.getContext(filterEntityList, queryFieldCommonBoList, qFilter == null ? null : Lists.newArrayList((Object[])new QFilter[]{qFilter}));
    }

    public List<Map<String, Object>> getEntryDataList(QFilter qFilter) {
        List joinEntityCommonBoList = (List)this.controlData.get("entityNodes");
        List fieldTreeNodeList = (List)this.controlData.get("fieldTreeNode");
        HashMap fieldTreeNodeMap = Maps.newHashMapWithExpectedSize((int)80000);
        LabelDataService.addFieldTreeNodeMap(fieldTreeNodeList, fieldTreeNodeMap);
        LinkedHashSet mainFieldSet = Sets.newLinkedHashSetWithExpectedSize((int)fieldTreeNodeMap.size());
        LinkedHashSet entryKeySet = Sets.newLinkedHashSetWithExpectedSize((int)fieldTreeNodeMap.size());
        LinkedHashSet relEntryKeySet = Sets.newLinkedHashSetWithExpectedSize((int)fieldTreeNodeMap.size());
        LinkedHashSet relEntityKeySet = Sets.newLinkedHashSetWithExpectedSize((int)fieldTreeNodeMap.size());
        HashMap mainEntryFieldMap = Maps.newHashMapWithExpectedSize((int)fieldTreeNodeMap.size());
        HashMap relFieldMap = Maps.newHashMapWithExpectedSize((int)fieldTreeNodeMap.size());
        HashMap relEntryFieldMap = Maps.newHashMapWithExpectedSize((int)fieldTreeNodeMap.size());
        for (DynamicObject row : this.entry) {
            FieldTreeNode fieldTreeNode;
            String entityNumber = row.getString(this.entityNumber);
            String fieldNumber = row.getString(this.fieldNumber);
            if (HRStringUtils.isEmpty((String)entityNumber)) continue;
            if (HRStringUtils.equals((String)this.mainEntityAlias, (String)entityNumber)) {
                fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(fieldNumber);
                if (fieldTreeNode.getEntryField().booleanValue()) {
                    entryKeySet.add(fieldTreeNode.getEntryNumber());
                    Set mainEntryFieldSet = mainEntryFieldMap.getOrDefault(fieldTreeNode.getEntryNumber(), Sets.newLinkedHashSetWithExpectedSize((int)this.entry.size()));
                    mainEntryFieldSet.add(fieldTreeNode.getFieldAlias());
                    mainEntryFieldMap.put(fieldTreeNode.getEntryNumber(), mainEntryFieldSet);
                    continue;
                }
                mainFieldSet.add(fieldTreeNode.getFieldAlias());
                continue;
            }
            fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(entityNumber + "." + fieldNumber);
            if (fieldTreeNode.getEntryField().booleanValue()) {
                relEntryKeySet.add(fieldTreeNode.getEntryNumber());
                Set relEntryFieldSet = relEntryFieldMap.getOrDefault(fieldTreeNode.getEntryNumber(), Sets.newLinkedHashSetWithExpectedSize((int)this.entry.size()));
                relEntryFieldSet.add(fieldTreeNode.getFieldAlias());
                relEntryFieldMap.put(fieldTreeNode.getEntryNumber(), relEntryFieldSet);
                continue;
            }
            String entityName = this.oneToNEntityMap.get(entityNumber);
            if (!HRStringUtils.isEmpty((String)entityName)) {
                if (!fieldTreeNode.getField().booleanValue()) continue;
                relEntityKeySet.add(entityNumber);
                Set relFieldSet = relFieldMap.getOrDefault(entityNumber, Sets.newLinkedHashSetWithExpectedSize((int)this.entry.size()));
                relFieldSet.add(fieldTreeNode.getFieldAlias());
                relFieldMap.put(entityNumber, relFieldSet);
                continue;
            }
            mainFieldSet.add(fieldTreeNode.getFieldAlias());
        }
        List<QueryFieldCommonBo> queryFieldCommonBoList = this.buildQueryFieldByDisplayResults(this.entry, fieldTreeNodeMap, this.mainEntityAlias);
        Map<String, String> idKeyMap = this.addId(fieldTreeNodeMap, queryFieldCommonBoList, this.mainEntityAlias);
        List<JoinEntityCommonBo> filterEntityList = this.filterEntity(joinEntityCommonBoList, queryFieldCommonBoList, qFilter);
        LabelService labelService = new LabelService();
        HRComplexObjContext complexObjContext = labelService.getContext(filterEntityList, queryFieldCommonBoList, qFilter == null ? null : Lists.newArrayList((Object[])new QFilter[]{qFilter}));
        complexObjContext.setAlgoXDetailOptimize(false);
        ReportQueryService reportQueryService = labelService.getReportQueryService(complexObjContext);
        List dataList = reportQueryService.queryMap();
        ArrayList entryDataList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        LinkedHashMap mulFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)dataList.size());
        InteServiceImpl service = new InteServiceImpl();
        String dateFormat = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        int rowNum = 0;
        for (Map map : dataList) {
            String dataId = map.get("id").toString();
            Integer lastRowNum = (Integer)idMap.get(dataId);
            if (lastRowNum == null) {
                idMap.put(dataId, rowNum);
                LinkedHashMap data = Maps.newLinkedHashMapWithExpectedSize((int)map.size());
                data.put("id", dataId);
                this.handleMainField(data, mainFieldSet, map);
                LabelDataMulFieldParam labelDataMulFieldParam = new LabelDataMulFieldParam((Map)mulFieldMap, rowNum, map, dateFormat, (Map)relFieldMap, (Map)mainEntryFieldMap, idKeyMap, (Map)relEntryFieldMap, (Set)relEntityKeySet, (Map)fieldTreeNodeMap, (Set)entryKeySet, (Set)relEntryKeySet);
                this.handleMulFieldMap(labelDataMulFieldParam, true);
                this.handleRelEntityField(labelDataMulFieldParam);
                this.handleMulFieldMap(labelDataMulFieldParam, false);
                entryDataList.add(data);
                ++rowNum;
                continue;
            }
            LabelDataMulFieldParam labelDataMulFieldParam = new LabelDataMulFieldParam((Map)mulFieldMap, lastRowNum.intValue(), map, dateFormat, (Map)relFieldMap, (Map)mainEntryFieldMap, idKeyMap, (Map)relEntryFieldMap, (Set)relEntityKeySet, (Map)fieldTreeNodeMap, (Set)entryKeySet, (Set)relEntryKeySet);
            this.handleMulFieldMap(labelDataMulFieldParam, true);
            this.handleRelEntityField(labelDataMulFieldParam);
            this.handleMulFieldMap(labelDataMulFieldParam, false);
        }
        for (Map.Entry entry : mulFieldMap.entrySet()) {
            Integer mulFieldRowNum = (Integer)entry.getKey();
            Map data = (Map)entryDataList.get(mulFieldRowNum);
            Map colContextMap = (Map)entry.getValue();
            for (Map.Entry colContextEntry : colContextMap.entrySet()) {
                String key = (String)colContextEntry.getKey();
                StringBuilder textBuilder = new StringBuilder();
                Map rowBoMap = ((LabelExcelMulFieldBo)colContextEntry.getValue()).getRowBoMap();
                for (Map.Entry rowEntry : rowBoMap.entrySet()) {
                    for (LabelExcelMulFieldRowBo labelExcelMulFieldRowBo : (List)rowEntry.getValue()) {
                        textBuilder.append(labelExcelMulFieldRowBo.getContextBuilder().toString()).append("\n");
                    }
                }
                data.put(key, textBuilder.toString());
            }
        }
        return entryDataList;
    }

    public List<QueryFieldCommonBo> buildQueryFieldByDisplayResults(DynamicObjectCollection displayEntry, Map<String, FieldTreeNode> fieldTreeNodeMap, String mainEntityAlias) {
        ArrayList queryFieldCommonBoList = Lists.newArrayListWithExpectedSize((int)displayEntry.size());
        for (DynamicObject dynamicObject : displayEntry) {
            String entityNumber = dynamicObject.getString(this.entityNumber);
            if (HRStringUtils.isEmpty((String)entityNumber)) continue;
            String fieldNumber = dynamicObject.getString(this.fieldNumber);
            if (!HRStringUtils.equals((String)mainEntityAlias, (String)entityNumber)) {
                fieldNumber = entityNumber + "." + fieldNumber;
            }
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            queryFieldCommonBo.setFieldAlias(fieldNumber);
            queryFieldCommonBo.setEntityNumber(entityNumber);
            FieldTreeNode fieldTreeNode = fieldTreeNodeMap.get(fieldNumber);
            queryFieldCommonBo.setFieldPath(fieldTreeNode.getFieldPath());
            queryFieldCommonBo.setValueType(fieldTreeNode.getValueType());
            queryFieldCommonBo.setComplexType(fieldTreeNode.getComplexType());
            queryFieldCommonBoList.add(queryFieldCommonBo);
        }
        return queryFieldCommonBoList;
    }

    public void handleMulFieldMap(LabelDataMulFieldParam param, boolean isMainEntity) {
        Set entryKeySet;
        Map entryFieldMap;
        Map dataMap = param.getDataMap();
        String dateFormat = param.getDateFormat();
        Map idKeyMap = param.getIdKeyMap();
        Map mulFieldMap = param.getMulFieldMap();
        int rowNum = param.getRowNum();
        if (isMainEntity) {
            entryFieldMap = param.getMainEntryFieldMap();
            entryKeySet = param.getEntryKeySet();
        } else {
            entryFieldMap = param.getRelEntryFieldMap();
            entryKeySet = param.getRelEntryKeySet();
        }
        Map fieldTreeNodeMap = param.getFieldTreeNodeMap();
        Map colContextMap = mulFieldMap.getOrDefault(rowNum, Maps.newLinkedHashMapWithExpectedSize((int)dataMap.size()));
        this.handleMulFieldMap(dataMap, dateFormat, idKeyMap, entryKeySet, entryFieldMap, fieldTreeNodeMap, colContextMap);
    }

    private void handleMulFieldMap(Map<String, Object> dataMap, String dateFormat, Map<String, String> idKeyMap, Set<String> entryKeySet, Map<String, Set<String>> entryFieldMap, Map<String, FieldTreeNode> fieldTreeNodeMap, Map<String, LabelExcelMulFieldBo> colContextMap) {
        for (String entryKey : entryKeySet) {
            Map rowBoMap;
            HashSet dataKeySet = Sets.newHashSetWithExpectedSize((int)entryFieldMap.size());
            String relEntityFieldStr = "\u25cf";
            Set<String> entryFieldSet = entryFieldMap.get(entryKey);
            StringBuilder stringBuilder = new StringBuilder(relEntityFieldStr);
            for (String entryField : entryFieldSet) {
                String comboName;
                dataKeySet.add(entryField);
                FieldTreeNode fieldTreeNode = fieldTreeNodeMap.get(entryField);
                String valueStr = LabelDataService.formatData(dataMap.get(entryField), dateFormat);
                Map<String, String> comboMap = this.comboFieldNameMap.get(entryField);
                if (comboMap != null && !HRStringUtils.isEmpty((String)(comboName = comboMap.get(valueStr)))) {
                    valueStr = comboName;
                }
                stringBuilder.append(fieldTreeNode.getName().getLocaleValue()).append(":").append(valueStr).append(";");
            }
            String idKey = idKeyMap.get(entryFieldSet.toArray(new String[0])[0]);
            Object id = dataMap.get(idKey);
            LabelExcelMulFieldBo labelExcelMulFieldBo = colContextMap.get(entryKey);
            if (labelExcelMulFieldBo == null) {
                rowBoMap = Maps.newHashMapWithExpectedSize((int)dataMap.size());
                LabelExcelMulFieldRowBo labelExcelMulFieldRowBo = new LabelExcelMulFieldRowBo(id, entryKey, (Set)dataKeySet, stringBuilder);
                rowBoMap.put(id, Lists.newArrayList((Object[])new LabelExcelMulFieldRowBo[]{labelExcelMulFieldRowBo}));
                labelExcelMulFieldBo = new LabelExcelMulFieldBo(rowBoMap);
            } else {
                rowBoMap = labelExcelMulFieldBo.getRowBoMap();
                List excelMulFieldRowBoList = (List)rowBoMap.get(id);
                if (CollectionUtils.isEmpty((Collection)excelMulFieldRowBoList)) {
                    LabelExcelMulFieldRowBo labelExcelMulFieldRowBo = new LabelExcelMulFieldRowBo(id, entryKey, (Set)dataKeySet, stringBuilder);
                    rowBoMap.put(id, Lists.newArrayList((Object[])new LabelExcelMulFieldRowBo[]{labelExcelMulFieldRowBo}));
                }
            }
            colContextMap.put(entryKey, labelExcelMulFieldBo);
        }
    }

    public void handleRelEntityField(LabelDataMulFieldParam param) {
        Map dataMap = param.getDataMap();
        String dateFormat = param.getDateFormat();
        Map idKeyMap = param.getIdKeyMap();
        Map mulFieldMap = param.getMulFieldMap();
        int rowNum = param.getRowNum();
        Map relFieldMap = param.getRelFieldMap();
        Set relEntityKeySet = param.getRelEntityKeySet();
        Map fieldTreeNodeMap = param.getFieldTreeNodeMap();
        Map colContextMap = mulFieldMap.getOrDefault(rowNum, Maps.newLinkedHashMapWithExpectedSize((int)dataMap.size()));
        for (String relEntityKey : relEntityKeySet) {
            Map rowBoMap;
            LabelExcelMulFieldBo labelExcelMulFieldBo;
            HashSet dataKeySet = Sets.newHashSetWithExpectedSize((int)relFieldMap.size());
            Object id = null;
            String relEntityFieldStr = "\u25cf";
            Set relFieldSet = (Set)relFieldMap.get(relEntityKey);
            if (!CollectionUtils.isEmpty((Collection)relFieldSet)) {
                String idKey = (String)idKeyMap.get(relFieldSet.toArray(new String[0])[0]);
                id = dataMap.get(idKey);
                StringBuilder stringBuilder = new StringBuilder(relEntityFieldStr);
                for (String relField : relFieldSet) {
                    String comboName;
                    dataKeySet.add(relField);
                    FieldTreeNode fieldTreeNode = (FieldTreeNode)fieldTreeNodeMap.get(relField);
                    String valueStr = LabelDataService.formatData(dataMap.get(relField), dateFormat);
                    Map<String, String> comboMap = this.comboFieldNameMap.get(relField);
                    if (comboMap != null && !HRStringUtils.isEmpty((String)(comboName = comboMap.get(valueStr)))) {
                        valueStr = comboName;
                    }
                    stringBuilder.append(fieldTreeNode.getName().getLocaleValue()).append(":").append(valueStr).append(";");
                }
                relEntityFieldStr = stringBuilder.toString();
            }
            if ((labelExcelMulFieldBo = (LabelExcelMulFieldBo)colContextMap.get(relEntityKey)) == null) {
                rowBoMap = Maps.newHashMapWithExpectedSize((int)dataMap.size());
                if (!CollectionUtils.isEmpty((Collection)relFieldSet)) {
                    LabelExcelMulFieldRowBo labelExcelMulFieldRowBo = new LabelExcelMulFieldRowBo(null, null, (Set)dataKeySet, new StringBuilder(relEntityFieldStr));
                    rowBoMap.put(id, Lists.newArrayList((Object[])new LabelExcelMulFieldRowBo[]{labelExcelMulFieldRowBo}));
                }
                labelExcelMulFieldBo = new LabelExcelMulFieldBo(rowBoMap);
            } else {
                List excelMulFieldRowBoList;
                rowBoMap = labelExcelMulFieldBo.getRowBoMap();
                if (!CollectionUtils.isEmpty((Collection)relFieldSet) && CollectionUtils.isEmpty((Collection)(excelMulFieldRowBoList = (List)rowBoMap.get(id)))) {
                    LabelExcelMulFieldRowBo labelExcelMulFieldRowBo = new LabelExcelMulFieldRowBo(null, null, (Set)dataKeySet, new StringBuilder(relEntityFieldStr));
                    rowBoMap.put(id, Collections.singletonList(labelExcelMulFieldRowBo));
                }
            }
            colContextMap.put(relEntityKey, labelExcelMulFieldBo);
        }
        mulFieldMap.put(rowNum, colContextMap);
    }

    public Map<String, String> addId(Map<String, FieldTreeNode> fieldTreeNodeMap, List<QueryFieldCommonBo> queryFieldCommonBoList, String mainEntityAlias) {
        queryFieldCommonBoList.add(this.buildIdBo("id", mainEntityAlias));
        HashSet idKeySet = Sets.newHashSetWithExpectedSize((int)queryFieldCommonBoList.size());
        HashMap idKeyMap = Maps.newHashMapWithExpectedSize((int)queryFieldCommonBoList.size());
        Set fieldAliasSet = queryFieldCommonBoList.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
        for (Map.Entry<String, FieldTreeNode> entry : fieldTreeNodeMap.entrySet()) {
            String alias;
            FieldTreeNode fieldTreeNode = entry.getValue();
            if (fieldTreeNode.getEntryField().booleanValue() && fieldAliasSet.contains(fieldTreeNode.getFieldAlias())) {
                alias = fieldTreeNode.getEntryNumber().startsWith(mainEntityAlias + "_dm6h7z_") ? fieldTreeNode.getEntryNumber().replace(mainEntityAlias + "_dm6h7z_", "") + ".id" : fieldTreeNode.getEntryNumber().replace("_dm6h7z_", ".") + ".id";
                if (idKeySet.add(alias)) {
                    queryFieldCommonBoList.add(this.buildIdBo(alias, fieldTreeNode.getEntityNumber()));
                }
                idKeyMap.put(fieldTreeNode.getFieldAlias(), alias);
                continue;
            }
            if (HRStringUtils.equals((String)mainEntityAlias, (String)fieldTreeNode.getEntityNumber()) || !fieldTreeNode.getField().booleanValue() || !fieldAliasSet.contains(fieldTreeNode.getFieldAlias())) continue;
            alias = fieldTreeNode.getEntityNumber() + ".id";
            if (idKeySet.add(alias)) {
                queryFieldCommonBoList.add(this.buildIdBo(alias, fieldTreeNode.getEntityNumber()));
            }
            idKeyMap.put(fieldTreeNode.getFieldAlias(), alias);
        }
        return idKeyMap;
    }

    private QueryFieldCommonBo buildIdBo(String fieldAlias, String entityNumber) {
        QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
        queryFieldCommonBo.setFieldAlias(fieldAlias);
        queryFieldCommonBo.setFieldPath(queryFieldCommonBo.getFieldAlias());
        queryFieldCommonBo.setEntityNumber(entityNumber);
        queryFieldCommonBo.setValueType(DataTypeEnum.LONG.getDataTypeKey());
        queryFieldCommonBo.setComplexType(FieldComplexType.NORMAL.getValue());
        return queryFieldCommonBo;
    }

    public static void addFieldTreeNodeMap(List<FieldTreeNode> fieldTreeNodeList, Map<String, FieldTreeNode> fieldTreeNodeMap) {
        for (FieldTreeNode treeNode : fieldTreeNodeList) {
            if (treeNode.getField().booleanValue()) {
                fieldTreeNodeMap.put(treeNode.getFieldAlias(), treeNode);
            } else if (treeNode.getEntry().booleanValue()) {
                fieldTreeNodeMap.put(treeNode.getNumber(), treeNode);
            }
            List children = treeNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            LabelDataService.addFieldTreeNodeMap(children, fieldTreeNodeMap);
        }
    }

    private void sort(DynamicObjectCollection entry) {
        entry.sort((x1, x2) -> {
            String fieldNumber1 = x1.getString(this.fieldNumber);
            String fieldNumber2 = x2.getString(this.fieldNumber);
            if (fieldNumber1.equals("LabelPerson")) {
                if (fieldNumber2.equals("LabelTime")) {
                    return -1;
                }
                return 1;
            }
            if (fieldNumber1.equals("LabelTime")) {
                return 1;
            }
            if (fieldNumber2.equals("LabelPerson") || fieldNumber2.equals("LabelTime")) {
                return -1;
            }
            return 0;
        });
    }

    private void handleMainField(Map<String, Object> data, Set<String> mainFieldSet, Map<String, Object> dataMap) {
        for (String mainField : mainFieldSet) {
            Object value = dataMap.get(mainField);
            mainField = mainField.replace(".", "_dm6h7z_");
            data.put(mainField, value);
        }
    }

    public static String formatData(Object value, String dateFormat) {
        String valueStr = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value instanceof Date ? HRDateTimeUtils.format((Date)((Date)value), (String)dateFormat) : (value == null ? "" : value.toString()));
        return valueStr;
    }

    private FieldAp getFieldAp(DynamicProperty property, String id, Map<String, Object> propMap) {
        id = id.replace(".", "_dm6h7z_");
        EntryFieldAp fieldAp = new EntryFieldAp();
        if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            TextAreaField textAreaField = new TextAreaField();
            textAreaField.setKey(id);
            textAreaField.setId(id);
            fieldAp.setField((Field)textAreaField);
        } else if (property instanceof ComboProp) {
            MulComboField mulComboField = new MulComboField();
            mulComboField.setKey(id);
            mulComboField.setId(id);
            List items = (List)propMap.get("propItems");
            if (items != null) {
                ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)items.size());
                items.forEach(valueMapItem -> {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setValue((String)valueMapItem.get("propItemsValue"));
                    Map captionMap = (Map)valueMapItem.get("propItemsCaption");
                    LocaleString localeString = new LocaleString();
                    captionMap.forEach((key, value) -> {
                        String cfr_ignored_0 = (String)localeString.put(key, (Object)((String)value));
                    });
                    comboItem.setCaption(localeString);
                    comboItemList.add(comboItem);
                });
                mulComboField.setItems((List)comboItemList);
            }
            fieldAp.setField((Field)mulComboField);
        } else if (property instanceof DateTimeProp) {
            DateTimeField dateTimeField = new DateTimeField();
            dateTimeField.setKey(id);
            dateTimeField.setId(id);
            fieldAp.setField((Field)dateTimeField);
        } else if (property instanceof IntegerProp) {
            IntegerField integerField = new IntegerField();
            integerField.setKey(id);
            integerField.setId(id);
            fieldAp.setField((Field)integerField);
        } else if (property instanceof DecimalProp) {
            DecimalField decimalField = new DecimalField();
            decimalField.setKey(id);
            decimalField.setId(id);
            fieldAp.setField((Field)decimalField);
        } else if (property instanceof TextProp) {
            TextAreaField textAreaField = new TextAreaField();
            textAreaField.setKey(id);
            textAreaField.setId(id);
            fieldAp.setField((Field)textAreaField);
        }
        fieldAp.setId(id);
        fieldAp.setKey(fieldAp.getId());
        return fieldAp;
    }

    private void setPropType(DynamicProperty property, Map<String, Object> proMap) {
        String type = null;
        if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            type = "text";
        } else if (property instanceof ComboProp || property instanceof BooleanProp) {
            ArrayList comboList = Lists.newArrayListWithExpectedSize((int)2);
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                List valueMapItems = comboProp.getComboItems();
                valueMapItems.forEach(valueMapItem -> {
                    HashMap item = Maps.newHashMapWithExpectedSize((int)2);
                    item.put("propItemsValue", valueMapItem.getValue());
                    item.put("propItemsCaption", valueMapItem.getName());
                    comboList.add(item);
                });
            } else {
                HashMap item = Maps.newHashMapWithExpectedSize((int)2);
                item.put("propItemsValue", Boolean.TRUE.toString());
                item.put("propItemsCaption", new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"LabelObjectListPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
                HashMap item2 = Maps.newHashMapWithExpectedSize((int)2);
                item2.put("propItemsValue", Boolean.FALSE.toString());
                item2.put("propItemsCaption", new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"LabelObjectListPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
                comboList.add(item);
                comboList.add(item2);
            }
            proMap.put("propItems", comboList);
            type = "mulcombofield";
        } else if (property instanceof DateTimeProp) {
            type = "daterangefield";
        } else if (property instanceof IntegerProp) {
            type = "integer";
        } else if (property instanceof DecimalProp) {
            type = "decimal";
        } else if (property instanceof TextProp) {
            type = "text";
        }
        proMap.put("propType", type);
    }

    private List<JoinEntityCommonBo> filterEntity(List<JoinEntityCommonBo> joinEntityCommonBoList, List<QueryFieldCommonBo> queryFieldCommonBoList, QFilter qFilter) {
        Set fieldAliasSet = queryFieldCommonBoList.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
        HashSet qFilterPropertySet = Sets.newHashSetWithExpectedSize((int)joinEntityCommonBoList.size());
        if (qFilter != null) {
            qFilterPropertySet.add(qFilter.getProperty());
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                qFilterPropertySet.add(nest.getFilter().getProperty());
            }
        }
        ArrayList filterEntityBoList = Lists.newArrayListWithExpectedSize((int)joinEntityCommonBoList.size());
        block1: for (JoinEntityCommonBo joinEntityCommonBo : joinEntityCommonBoList) {
            if (HRStringUtils.equals((String)"main", (String)joinEntityCommonBo.getType())) {
                filterEntityBoList.add(joinEntityCommonBo);
                continue;
            }
            boolean isFieldContains = false;
            for (String fieldAlias : fieldAliasSet) {
                if (!fieldAlias.contains(joinEntityCommonBo.getEntityAlias() + ".")) continue;
                filterEntityBoList.add(joinEntityCommonBo);
                isFieldContains = true;
                break;
            }
            if (isFieldContains) continue;
            for (String qFilterProperty : qFilterPropertySet) {
                if (!qFilterProperty.contains(joinEntityCommonBo.getEntityAlias() + ".")) continue;
                filterEntityBoList.add(joinEntityCommonBo);
                continue block1;
            }
        }
        return filterEntityBoList;
    }

    private void addComboName(DynamicProperty property, String key, Map<String, Map<String, String>> comboFieldNameMap) {
        if (property instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)property;
            List valueMapItems = comboProp.getComboItems();
            HashMap comboMap = Maps.newHashMapWithExpectedSize((int)valueMapItems.size());
            valueMapItems.forEach(valueMapItem -> comboMap.put(valueMapItem.getValue(), valueMapItem.getName().getLocaleValue()));
            comboFieldNameMap.put(key, comboMap);
        } else if (property instanceof BooleanProp) {
            HashMap comboMap = Maps.newHashMapWithExpectedSize((int)2);
            comboMap.put(Boolean.TRUE.toString(), ResManager.loadKDString((String)"\u662f", (String)"LabelObjectListPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            comboMap.put(Boolean.FALSE.toString(), ResManager.loadKDString((String)"\u5426", (String)"LabelObjectListPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            comboFieldNameMap.put(key, comboMap);
        }
    }
}

