/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;

@ExcludeFromJacocoGeneratedReport
public class LabelFunctionTargetExecutor {
    private static final Log LOGGER = LogFactory.getLog(LabelFunctionTargetExecutor.class);

    private LabelFunctionTargetExecutor() {
    }

    public static Object executeFunction(String expression, Map<String, Object> inputParams) throws Exception {
        if (inputParams != null && inputParams.size() > 0) {
            expression = LabelFunctionTargetExecutor.fillVariable(expression, inputParams);
        }
        return LabelFunctionTargetExecutor.execute(expression);
    }

    public static Object execute(String expression) throws Exception {
        return HRFunctionHelper.executeFunction((String)expression, null);
    }

    private static String fillVariable(String expression, Map<String, Object> inputParams) {
        Set<String> variables = LabelFunctionTargetExecutor.getExprVariables(expression);
        for (String var : variables) {
            String strValue;
            Object value = null;
            if (inputParams.containsKey(var)) {
                value = inputParams.get(var);
            }
            if (value instanceof String) {
                strValue = "\"" + value + "\"";
            } else if (value instanceof Date) {
                strValue = HRDateTimeUtils.formatDate((Date)((Date)value));
                strValue = "\"" + strValue + "\"";
            } else if (value instanceof OrmLocaleValue) {
                OrmLocaleValue ormValue = (OrmLocaleValue)value;
                strValue = "\"" + ormValue.getLocaleValue() + "\"";
            } else {
                strValue = String.valueOf(value);
            }
            if (value == null) {
                LOGGER.error("parse_function_target_error: expression: '{}' lacks parameter value '{}' error.", (Object)expression, (Object)var);
                return "";
            }
            expression = expression.replaceAll("\\$" + var + "\\$", strValue);
        }
        return expression;
    }

    private static String fillVariableForPreExecute(String expression, Map<String, Object> inputParams) {
        Set<String> variables = LabelFunctionTargetExecutor.getExprVariables(expression);
        for (String var : variables) {
            Object value = inputParams.get(var);
            if (value != null) {
                expression = expression.replaceAll("\\$" + var + "\\$", String.valueOf(value));
                continue;
            }
            LOGGER.error("parse_function_target_error: expression: '{}' lacks parameter value '{}' error.", (Object)expression, (Object)var);
            return "";
        }
        return expression;
    }

    private static Set<String> getExprVariables(String expression) {
        HashSet<String> varSet = new HashSet<String>();
        StringBuilder varSb = new StringBuilder();
        boolean flag = false;
        for (int i = 0; i < expression.length(); ++i) {
            char ex = expression.charAt(i);
            if (ex != '$' && flag) {
                varSb.append(ex);
            }
            if (ex == '$') {
                boolean bl = flag = !flag;
            }
            if (flag || varSb.length() <= 0) continue;
            varSet.add(varSb.toString());
            varSb = new StringBuilder();
        }
        return varSet;
    }
}

