/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class LabelObjectServiceHelper {
    public static DynamicObject[] getLabelObjectsByFilter(QFilter listQFilters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelobject");
        return serviceHelper.query("name,number,type,publishstatus,description,parent,enable,creator,createtime", new QFilter[]{listQFilters}, "createtime DESC");
    }

    public static DynamicObject getLblObjConfig(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjconfig");
        return serviceHelper.loadDynamicObject(new QFilter("labelobjectid.id", "=", (Object)lblObjId));
    }

    public static DynamicObject[] getLblObjConfigs(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjconfig");
        return serviceHelper.query("id,status,enable", new QFilter[]{new QFilter("labelobjectid.id", "in", lblObjIdList)});
    }

    public static boolean isLblObjConfigRef(Long lblObjId, String entityAlias) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjconfig");
        DynamicObject dy = serviceHelper.queryOne("id,conditionentryentity.ruleentitynumberalias,manualentryentity.manualentitynumberalias,displayentryentity.displayentitynumberalias", new QFilter("labelobjectid.id", "=", (Object)lblObjId));
        if (dy == null) {
            return false;
        }
        DynamicObjectCollection ruleColl = dy.getDynamicObjectCollection("conditionentryentity");
        DynamicObjectCollection manualColl = dy.getDynamicObjectCollection("manualentryentity");
        DynamicObjectCollection displayColl = dy.getDynamicObjectCollection("displayentryentity");
        boolean ruleRef = ruleColl.stream().anyMatch(ruleDy -> ruleDy.getString("ruleentitynumberalias").equals(entityAlias));
        boolean manualRef = manualColl.stream().anyMatch(manualDy -> manualDy.getString("manualentitynumberalias").equals(entityAlias));
        boolean displayRef = displayColl.stream().anyMatch(displayDy -> displayDy.getString("displayentitynumberalias").equals(entityAlias));
        return ruleRef || manualRef || displayRef;
    }

    public static DynamicObject[] getFilters(Long lblStrategyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategyfilter");
        return serviceHelper.query("id,lblstrategy,value,fieldkey,hasfilter", new QFilter[]{new QFilter("lblstrategy.id", "=", (Object)lblStrategyId)});
    }

    public static DynamicProperty getProperty(String entityNum, String fieldName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
        Map allFields = dataEntityType.getAllFields();
        return (DynamicProperty)allFields.get(fieldName);
    }

    public static DynamicObject[] getLblObjectByLabel(Long lblId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelobjectrel");
        return serviceHelper.query("id,label,labelobject", new QFilter[]{new QFilter("label", "=", (Object)lblId)});
    }

    public static boolean getLblStrategy(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.isExists(new QFilter[]{new QFilter("labelobject.id", "in", lblObjIdList)});
    }

    public static boolean isEnableLblStrategy4LblObj(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.isExists(new QFilter[]{new QFilter("labelobject.id", "in", lblObjIdList), new QFilter("enable", "in", (Object)"1")});
    }

    public static boolean isEnableLblStrategy4Lbl(List<Long> lblIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.isExists(new QFilter[]{new QFilter("label.id", "in", lblIdList), new QFilter("enable", "in", (Object)"1")});
    }

    public static void disableLblStrategy4LblObj(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        DynamicObject[] dys = serviceHelper.query("enable", new QFilter[]{new QFilter("labelobject.id", "in", lblObjIdList), new QFilter("enable", "in", (Object)"1")});
        Arrays.stream(dys).forEach(dy -> dy.set("enable", (Object)"0"));
        serviceHelper.save(dys);
    }

    public static void disableLblStrategy4Lbl(List<Long> lblIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        DynamicObject[] dys = serviceHelper.query("enable", new QFilter[]{new QFilter("label.id", "in", lblIdList), new QFilter("enable", "in", (Object)"1")});
        Arrays.stream(dys).forEach(dy -> dy.set("enable", (Object)"0"));
        serviceHelper.save(dys);
    }

    public static boolean isLblRel(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelobjectrel");
        return serviceHelper.isExists(new QFilter[]{new QFilter("labelobject.id", "in", lblObjIdList)});
    }

    public static DynamicObject[] getJoinEntities(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        return serviceHelper.query("id,index,entitynumber,entityalias,type,labelobject,ismainbo", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }

    public static DynamicObject[] getJoinEntitiesOrder(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        return serviceHelper.query("id,index,entitynumber,entityalias,type,labelobject,ismainbo", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId)}, "index asc");
    }

    public static DynamicObject[] getJoinEntities(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        return serviceHelper.query("id,index,entitynumber,entityalias,type,labelobject,ismainbo", new QFilter[]{new QFilter("labelobject.id", "in", lblObjIdList)});
    }

    public static DynamicObject[] getEntityRelation(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblentityrelation");
        return serviceHelper.query("id,entityid,jointype,joinentityid,labelobject,relationtype,displayname,joinconditions,joinconditions.leftprop,joinconditions.comparetype,joinconditions.rightprop,joinconditions.rightproptype,joinconditions.rightpropval,joinconditions.logictype", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }

    public static DynamicObject[] getEntityRelations(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblentityrelation");
        return serviceHelper.query("id,entityid,jointype,joinentityid,labelobject,joinconditions,joinconditions.leftprop,joinconditions.comparetype,joinconditions.rightprop,joinconditions.rightproptype,joinconditions.rightpropval,joinconditions.logictype", new QFilter[]{new QFilter("labelobject.id", "in", lblObjIdList)});
    }

    public static DynamicObject[] getAllFields(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        return serviceHelper.query("id,fieldname,entitynumber,valuetype,labelobjectid,fieldalias,fieldpath,complextype,controltype,fieldtypeid.id,fieldtypeid.name,selectedfield", new QFilter[]{new QFilter("labelobjectid.id", "=", (Object)lblObjId)}, "fieldtypeid.id desc");
    }

    public static DynamicObject[] getFields(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        return serviceHelper.query("id,fieldname,entitynumber,valuetype,labelobjectid,fieldalias,fieldpath,complextype,controltype,fieldtypeid.id,fieldtypeid.name,selectedfield", new QFilter[]{new QFilter("labelobjectid.id", "=", (Object)lblObjId), new QFilter("selectedfield", "=", (Object)"1")}, "fieldtypeid.id desc");
    }

    public static DynamicObject[] getFields(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        return serviceHelper.query("id,fieldname,entitynumber,valuetype,labelobjectid,fieldalias,fieldpath,complextype,controltype", new QFilter[]{new QFilter("labelobjectid.id", "in", lblObjIdList), new QFilter("selectedfield", "=", (Object)"1")});
    }

    public static DynamicObject[] getFieldTypes(List<Long> lblObjIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        return serviceHelper.query("id,enable,status", new QFilter[]{new QFilter("labelobjectid.id", "in", lblObjIdList)});
    }

    public static boolean getLblScene(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelscene");
        return serviceHelper.isExists(new QFilter[]{new QFilter("lblobjectids.fbasedataid.id", "=", (Object)lblObjId)});
    }

    public static DynamicObject[] getMainEntities(String mainEntityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "=", (Object)mainEntityNumber), new QFilter("type", "=", (Object)"main")};
        return serviceHelper.query("id,index,entitynumber,entityalias,type,labelobject,labelobject.id,labelobject.name,labelobject.number,ismainbo", filters);
    }
}

