/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.ext.hr.filter.control.HRFilter;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.container.Tab;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.labelandreport.ComplexObjTransferUtil;
import kd.hr.hrcs.bussiness.service.label.ConvertFieldService;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;
import kd.hr.hrcs.bussiness.service.label.ObjectFieldServiceHelper;
import kd.hr.hrcs.common.model.label.LabelJoinEntityCommonBo;

@ExcludeFromJacocoGeneratedReport
public class LabelService {
    private static final Log LOGGER = LogFactory.getLog(LabelService.class);
    private final FieldDefineService fieldDefineService = new FieldDefineService();
    public static final String TAB_PAGE_AP = "tabpageap";
    public static final String TAB_PAGE_AP1 = "tabpageap1";
    public static final String TAB_PAGE_AP2 = "tabpageap2";

    public static String doStepAction(Tab tab, boolean isForward) {
        String currentTab = tab.getCurrentTab();
        String nextTab = isForward ? (TAB_PAGE_AP.equals(currentTab) ? TAB_PAGE_AP1 : TAB_PAGE_AP2) : (TAB_PAGE_AP2.equals(currentTab) ? TAB_PAGE_AP1 : TAB_PAGE_AP);
        tab.activeTab(nextTab);
        return nextTab;
    }

    public boolean validateDuplicate(Long lblId, Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.isExists(new QFilter[]{new QFilter("label.id", "=", (Object)lblId), new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }

    public static DynamicProperty getFieldDynamicProperty(String entityNumber, String fieldPath) {
        int index2;
        int index = fieldPath.indexOf(".");
        if (index == -1) {
            return LabelObjectServiceHelper.getProperty(entityNumber, fieldPath);
        }
        int entityNumIndex = fieldPath.indexOf(entityNumber);
        if (entityNumIndex != -1) {
            fieldPath = fieldPath.substring(entityNumIndex + 1);
        }
        if ((index2 = fieldPath.indexOf(".")) != -1) {
            DynamicProperty fieldDynamicProperty = LabelObjectServiceHelper.getProperty(entityNumber, fieldPath.substring(0, index2));
            fieldPath = fieldPath.substring(index2 + 1);
            if (fieldDynamicProperty instanceof BasedataProp) {
                entityNumber = ((BasedataProp)fieldDynamicProperty).getBaseEntityId();
                int index3 = fieldPath.indexOf(".");
                if (index3 == -1 && ("id".equals(fieldPath) || "number".equals(fieldPath) || "name".equals(fieldPath))) {
                    return fieldDynamicProperty;
                }
            }
        }
        return LabelService.getFieldDynamicProperty(entityNumber, fieldPath);
    }

    public List<Object> getBaseDataIds(String[] ids, String entityNumber) {
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)10);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String name = dataEntityType.getPrimaryKey().getPropertyType().getName();
        if ("java.lang.Long".equals(name) || "long".equals(name)) {
            for (String baseDataId : ids) {
                idList.add(Long.parseLong(baseDataId));
            }
        } else {
            idList.addAll(Arrays.asList(ids));
        }
        return idList;
    }

    public void saveEntityAndField(Long lblObjId, List<LabelJoinEntityCommonBo> joinEntityCommonBoList, List<QueryFieldCommonBo> queryFieldCommonBoList) {
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        HRBaseServiceHelper relationHelper = new HRBaseServiceHelper("hrcs_lblentityrelation");
        List entityIdList = joinEntityCommonBoList.stream().filter(joinEntityCommonBo -> !HRStringUtils.isEmpty((String)joinEntityCommonBo.getId())).map(joinEntityCommonBo -> Long.parseLong(joinEntityCommonBo.getId())).collect(Collectors.toList());
        DynamicObject[] entityData = LabelObjectServiceHelper.getJoinEntities(lblObjId);
        Map<Long, DynamicObject> entityDataMap = Arrays.stream(entityData).collect(Collectors.toMap(data -> data.getLong("id"), data -> data));
        ArrayList deleteEntityIdList = Lists.newArrayListWithExpectedSize((int)entityDataMap.size());
        entityDataMap.forEach((key, value) -> {
            if (!entityIdList.contains(key)) {
                deleteEntityIdList.add(key);
            }
        });
        List fieldAliasList = queryFieldCommonBoList.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toList());
        DynamicObject[] fieldData = LabelObjectServiceHelper.getAllFields(lblObjId);
        Map<String, DynamicObject> fieldDataMap = Arrays.stream(fieldData).collect(Collectors.toMap(data -> data.getString("fieldalias"), data -> data));
        ArrayList deleteFieldIdList = Lists.newArrayListWithExpectedSize((int)entityDataMap.size());
        fieldDataMap.forEach((key, value) -> {
            if (!fieldAliasList.contains(key)) {
                deleteFieldIdList.add(value.getLong("id"));
            }
        });
        DynamicObject[] relData = LabelObjectServiceHelper.getEntityRelation(lblObjId);
        Map<Long, DynamicObject> relDataMap = Arrays.stream(relData).collect(Collectors.toMap(data -> data.getLong("id"), data -> data));
        DynamicObjectCollection updateJoinDynCol = new DynamicObjectCollection();
        DynamicObjectCollection updateRelationDynCol = new DynamicObjectCollection();
        ArrayList filedList = Lists.newArrayListWithExpectedSize((int)queryFieldCommonBoList.size());
        ArrayList updateIdList = Lists.newArrayListWithExpectedSize((int)relDataMap.size());
        HashMap entityIdMap = Maps.newHashMapWithExpectedSize((int)joinEntityCommonBoList.size());
        int emptyCount = 0;
        for (LabelJoinEntityCommonBo entityCommonBo : joinEntityCommonBoList) {
            if (!HRStringUtils.isEmpty((String)entityCommonBo.getId())) continue;
            ++emptyCount;
        }
        DynamicObjectCollection joinDynCol = new DynamicObjectCollection();
        DynamicObjectCollection relationDynCol = new DynamicObjectCollection();
        long[] ids = ORM.create().genLongIds("hrcs_lbljoinentity", emptyCount);
        emptyCount = 0;
        for (LabelJoinEntityCommonBo entityCommonBo : joinEntityCommonBoList) {
            DynamicObject relDyn;
            long id;
            DynamicObject joinDyn;
            DynamicObject dynamicObject = joinDyn = HRStringUtils.isEmpty((String)entityCommonBo.getId()) ? null : entityDataMap.get(Long.parseLong(entityCommonBo.getId()));
            if (joinDyn == null) {
                joinDyn = joinEntityHelper.generateEmptyDynamicObject();
                id = ids[emptyCount];
                joinDyn.set("id", (Object)id);
                joinDynCol.add((Object)joinDyn);
                ++emptyCount;
            } else {
                id = joinDyn.getLong("id");
                updateJoinDynCol.add((Object)joinDyn);
            }
            entityIdMap.put(entityCommonBo.getEntityAlias(), id);
            this.setEntityValueByBo(lblObjId, joinDyn, entityCommonBo);
            EntityRelationCommonBo entityRelation = entityCommonBo.getEntityRelation();
            if (entityRelation == null) continue;
            String relIdStr = entityRelation.getId();
            if (!HRStringUtils.isEmpty((String)relIdStr)) {
                long relId = Long.parseLong(relIdStr);
                relDyn = relDataMap.get(relId);
                updateRelationDynCol.add((Object)relDyn);
                updateIdList.add(relId);
            } else {
                relDyn = relationHelper.generateEmptyDynamicObject();
                relationDynCol.add((Object)relDyn);
            }
            Long entityId = (Long)entityIdMap.get(entityRelation.getEntityAlias());
            Long joinEntityId = (Long)entityIdMap.get(entityRelation.getJoinEntityAlias());
            this.setRelValueByBo(relDyn, lblObjId, entityId, joinEntityId, entityRelation);
        }
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        queryFieldCommonBoList.forEach(queryFieldCommonBo -> {
            if (!HRStringUtils.isEmpty((String)queryFieldCommonBo.getFieldAlias())) {
                DynamicObject field = (DynamicObject)fieldDataMap.get(queryFieldCommonBo.getFieldAlias());
                if (field == null) {
                    field = fieldHelper.generateEmptyDynamicObject();
                }
                field.set("entitynumber", (Object)queryFieldCommonBo.getEntityNumber());
                field.set("fieldname", (Object)queryFieldCommonBo.getFieldName());
                field.set("valuetype", (Object)queryFieldCommonBo.getValueType());
                field.set("fieldalias", (Object)queryFieldCommonBo.getFieldAlias());
                field.set("fieldpath", (Object)queryFieldCommonBo.getFieldPath());
                field.set("complextype", (Object)queryFieldCommonBo.getComplexType());
                field.set("controltype", (Object)queryFieldCommonBo.getControlType());
                field.set("selectedfield", (Object)(null == queryFieldCommonBo.getSelectedField() || queryFieldCommonBo.getSelectedField() != false ? 1 : 0));
                field.set("labelobjectid", (Object)lblObjId);
                filedList.add(field);
            }
        });
        joinEntityHelper.save(joinDynCol);
        relationHelper.save(relationDynCol);
        ObjectFieldServiceHelper.saveBatchFields(filedList);
        joinEntityHelper.save(updateJoinDynCol);
        relationHelper.save(updateRelationDynCol);
        Set<Long> oldRelIdSet = relDataMap.keySet();
        oldRelIdSet.removeAll(updateIdList);
        relationHelper.delete(oldRelIdSet.toArray());
        joinEntityHelper.delete(deleteEntityIdList.toArray());
        fieldHelper.delete(deleteFieldIdList.toArray());
    }

    public void saveMainLblObjRel(Long lblObjId, LabelJoinEntityCommonBo entityCommonBo, EntityRelationCommonBo relationCommonBo) {
        long entityId;
        HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
        HRBaseServiceHelper relationHelper = new HRBaseServiceHelper("hrcs_lblentityrelation");
        DynamicObject[] entityData = LabelObjectServiceHelper.getJoinEntities(lblObjId);
        DynamicObject[] relData = LabelObjectServiceHelper.getEntityRelation(lblObjId);
        DynamicObject mainLblObjEntity = null;
        Long mainEntityId = null;
        for (DynamicObject entityDatum : entityData) {
            if (Objects.equals(entityCommonBo.getEntityAlias(), entityDatum.getString("entityalias"))) {
                mainLblObjEntity = entityDatum;
            }
            if (!"main".equals(entityDatum.getString("type"))) continue;
            mainEntityId = entityDatum.getLong("id");
        }
        if (mainLblObjEntity == null) {
            mainLblObjEntity = joinEntityHelper.generateEmptyDynamicObject();
            entityId = ORM.create().genLongId("hrcs_lbljoinentity");
            mainLblObjEntity.set("id", (Object)entityId);
            this.setEntityValueByBo(lblObjId, mainLblObjEntity, entityCommonBo);
            joinEntityHelper.saveOne(mainLblObjEntity);
        } else {
            entityId = mainLblObjEntity.getLong("id");
        }
        DynamicObject mainLblObjRel = null;
        for (DynamicObject relDatum : relData) {
            if (!Objects.equals(relationCommonBo.getEntityId(), relDatum.getString("entityid"))) continue;
            mainLblObjRel = relDatum;
            break;
        }
        if (mainLblObjRel == null) {
            mainLblObjRel = relationHelper.generateEmptyDynamicObject();
        }
        this.setRelValueByBo(mainLblObjRel, lblObjId, entityId, mainEntityId, relationCommonBo);
        relationHelper.saveOne(mainLblObjRel);
    }

    public Map<String, Object> getControlData(Long lblObjId) {
        ArrayList selectedFieldKeys;
        List fieldTreeNodeList;
        List<Object> queryFieldCommonBoList;
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        List<JoinEntityCommonBo> joinEntityCommonBoList = this.getJoinEntityCommonBoList(lblObjId);
        if (!joinEntityCommonBoList.isEmpty()) {
            Optional<JoinEntityCommonBo> first = joinEntityCommonBoList.stream().filter(je -> "main".equals(je.getType())).findFirst();
            first.ifPresent(joinEntityCommonBo -> map.put("mainBo", joinEntityCommonBo));
            queryFieldCommonBoList = this.getAllQueryFieldCommonBoList(lblObjId);
            Map<String, QueryFieldCommonBo> queryFieldCommonBoMap = queryFieldCommonBoList.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, queryFieldCommonBo -> queryFieldCommonBo));
            Set<String> refByReportFieldAliasList = LblStrategyServiceHelper.getLabelRefParam(lblObjId);
            fieldTreeNodeList = this.fieldDefineService.getEntityAllFields(joinEntityCommonBoList, queryFieldCommonBoList, refByReportFieldAliasList);
            selectedFieldKeys = Lists.newArrayListWithExpectedSize((int)fieldTreeNodeList.size());
            this.handleFieldTreeNode(selectedFieldKeys, fieldTreeNodeList, queryFieldCommonBoMap);
        } else {
            fieldTreeNodeList = Collections.emptyList();
            selectedFieldKeys = Collections.emptyList();
            queryFieldCommonBoList = Collections.emptyList();
        }
        List dataSourceTree = this.fieldDefineService.getDataSourceTree();
        map.put("entityNodes", joinEntityCommonBoList);
        map.put("clouds", dataSourceTree);
        map.put("entities", this.fieldDefineService.getAllEntities(dataSourceTree));
        map.put("fieldTreeNode", fieldTreeNodeList);
        map.put("selectedFieldKeys", selectedFieldKeys);
        map.put("method", "init");
        map.put("isReport", false);
        map.put("queryFieldCommonBoList", queryFieldCommonBoList);
        return map;
    }

    public Map<String, Object> getEntityAndFieldData(Long lblObjId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        List<JoinEntityCommonBo> joinEntityCommonBoList = this.getJoinEntityCommonBoList(lblObjId);
        List fieldTreeNodeList = !joinEntityCommonBoList.isEmpty() ? this.fieldDefineService.getEntityAllFields(joinEntityCommonBoList, null) : Collections.emptyList();
        map.put("entityNodes", joinEntityCommonBoList);
        map.put("fieldTreeNode", fieldTreeNodeList);
        return map;
    }

    public List<JoinEntityCommonBo> getJoinEntityCommonBoList(Long lblObjId) {
        ArrayList joinEntityCommonBoList;
        if (lblObjId != null && 0L != lblObjId) {
            DynamicObject[] joinEntities = LabelObjectServiceHelper.getJoinEntities(lblObjId);
            DynamicObject[] entityRelations = LabelObjectServiceHelper.getEntityRelation(lblObjId);
            HashMap groupMap = Maps.newHashMapWithExpectedSize((int)entityRelations.length);
            for (DynamicObject entityRelation : entityRelations) {
                groupMap.put(entityRelation.getString("joinentityid.entityalias"), entityRelation);
            }
            joinEntityCommonBoList = Lists.newArrayListWithExpectedSize((int)joinEntities.length);
            for (DynamicObject joinEntity : joinEntities) {
                String entityIdStr = String.valueOf(joinEntity.getLong("id"));
                String entityNumber = joinEntity.getString("entitynumber");
                String entityAlias = joinEntity.getString("entityalias");
                JoinEntityCommonBo joinEntityCommonBo = this.buildEntityBo(joinEntity);
                DynamicObject rel = (DynamicObject)groupMap.get(entityAlias);
                if (rel != null) {
                    EntityRelationCommonBo entityRelationCommonBo = new EntityRelationCommonBo();
                    entityRelationCommonBo.setEntityAlias(rel.getString("entityid.entityalias"));
                    entityRelationCommonBo.setEntityId(String.valueOf(rel.getLong("entityid.id")));
                    entityRelationCommonBo.setEntityNumber(rel.getString("entityid.entitynumber"));
                    entityRelationCommonBo.setId(String.valueOf(rel.getLong("id")));
                    entityRelationCommonBo.setJoinEntityAlias(entityAlias);
                    entityRelationCommonBo.setJoinEntityId(entityIdStr);
                    entityRelationCommonBo.setJoinEntityNumber(entityNumber);
                    entityRelationCommonBo.setJoinType(rel.getString("jointype"));
                    entityRelationCommonBo.setRelationType(rel.getString("relationtype"));
                    OrmLocaleValue displayName = (OrmLocaleValue)rel.getLocaleString("displayname");
                    entityRelationCommonBo.setDisplayName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)displayName));
                    DynamicObjectCollection joinConditions = rel.getDynamicObjectCollection("joinconditions");
                    ArrayList joinConditionBoList = Lists.newArrayListWithExpectedSize((int)joinConditions.size());
                    for (DynamicObject joinCondition : joinConditions) {
                        JoinConditionBo joinConditionBo = new JoinConditionBo();
                        joinConditionBo.setId(String.valueOf(joinCondition.getLong("id")));
                        joinConditionBo.setCompareType(joinCondition.getString("comparetype"));
                        joinConditionBo.setLeftProp(joinCondition.getString("leftprop"));
                        joinConditionBo.setLogicType(joinCondition.getString("logictype"));
                        joinConditionBo.setRightProp(joinCondition.getString("rightprop"));
                        joinConditionBo.setRightPropType(joinCondition.getString("rightproptype"));
                        joinConditionBo.setRightPropVal(joinCondition.getString("rightpropval"));
                        joinConditionBoList.add(joinConditionBo);
                    }
                    entityRelationCommonBo.setConditions((List)joinConditionBoList);
                    joinEntityCommonBo.setEntityRelation(entityRelationCommonBo);
                }
                joinEntityCommonBoList.add(joinEntityCommonBo);
            }
            joinEntityCommonBoList.sort(Comparator.comparing(JoinEntityCommonBo::getIndex));
        } else {
            joinEntityCommonBoList = Collections.emptyList();
        }
        return joinEntityCommonBoList;
    }

    public List<QueryFieldCommonBo> convertToBo(String fieldTreeNodeStr) {
        List fieldTreeNodeList = JSON.parseArray((String)fieldTreeNodeStr, FieldTreeNode.class);
        List<QueryFieldCommonBo> queryFieldCommonBoList = ConvertFieldService.convertToBO(fieldTreeNodeList);
        AnalyseObjectUtil.setFieldControlType(queryFieldCommonBoList);
        return queryFieldCommonBoList;
    }

    public void setBaseDataNum(List<QueryFieldCommonBo> queryFieldCommonBoList) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (QueryFieldCommonBo queryFieldCommonBo : queryFieldCommonBoList) {
            if (!AnalyseObjectUtil.isBaseDataType((String)queryFieldCommonBo.getComplexType())) continue;
            queryFieldCommonBo.setBaseDataNum(AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)queryFieldCommonBo.getEntityNumber(), (String)queryFieldCommonBo.getFieldAlias(), (MainEntityTypeUtil)mainEntityTypeUtil));
        }
    }

    public List<QueryFieldCommonBo> getAllQueryFieldCommonBoList(Long lblObjId) {
        DynamicObject[] fields = LabelObjectServiceHelper.getAllFields(lblObjId);
        return this.getQueryFieldCommonBoList(fields);
    }

    public List<QueryFieldCommonBo> getQueryFieldCommonBoList(Long lblObjId) {
        DynamicObject[] fields = LabelObjectServiceHelper.getFields(lblObjId);
        return this.getQueryFieldCommonBoList(fields);
    }

    public List<QueryFieldCommonBo> getQueryFieldCommonBoList(DynamicObject[] fields) {
        ArrayList queryFieldCommonBoList = Lists.newArrayListWithCapacity((int)fields.length);
        for (DynamicObject field : fields) {
            String entityNumber = field.getString("entitynumber");
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            OrmLocaleValue fieldName = (OrmLocaleValue)field.getLocaleString("fieldname");
            queryFieldCommonBo.setFieldName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)fieldName));
            queryFieldCommonBo.setEntityName(MetadataServiceHelper.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue());
            queryFieldCommonBo.setFieldPath(field.getString("fieldpath"));
            queryFieldCommonBo.setEntityNumber(entityNumber);
            queryFieldCommonBo.setComplexType(field.getString("complextype"));
            queryFieldCommonBo.setFieldAlias(field.getString("fieldalias"));
            queryFieldCommonBo.setValueType(field.getString("valuetype"));
            queryFieldCommonBo.setId(String.valueOf(field.getLong("id")));
            queryFieldCommonBo.setControlType(field.getString("controltype"));
            queryFieldCommonBo.setSelectedField(Boolean.valueOf(field.getBoolean("selectedfield")));
            queryFieldCommonBoList.add(queryFieldCommonBo);
        }
        return queryFieldCommonBoList;
    }

    private String getFilterFieldParamId(DynamicObject field) {
        String result = "";
        if (field != null && field.getString("entitynumber") != null && field.getString("fieldalias") != null && field.getString("fieldpath") != null) {
            if (field.getString("fieldalias").startsWith(field.getString("entitynumber")) || field.getString("fieldpath").startsWith(field.getString("entitynumber"))) {
                String[] splits = field.getString("fieldalias").split("\\.");
                result = splits[0] + "." + field.getString("fieldpath");
            } else {
                result = field.getString("entitynumber") + "." + field.getString("entitynumber") + "." + field.getString("fieldalias");
            }
        }
        return result;
    }

    public List<Map<String, String>> getDisplayList(List<Map<String, String>> paramList, Long lblObjId) {
        ArrayList<Map<String, String>> displayList = new ArrayList<Map<String, String>>(10);
        DynamicObject[] fields = LabelObjectServiceHelper.getFields(lblObjId);
        HashMap<String, String> fieldTypeMap = new HashMap<String, String>(16);
        LinkedHashMap<String, JSONArray> groupMap = new LinkedHashMap<String, JSONArray>(16);
        for (DynamicObject field : fields) {
            fieldTypeMap.put(this.getFilterFieldParamId(field), field.getString("fieldtypeid.name"));
            if (groupMap.containsKey(field.getString("fieldtypeid.name"))) continue;
            groupMap.put(field.getString("fieldtypeid.name"), new JSONArray());
        }
        for (Map map : paramList) {
            if (!HRStringUtils.isNotEmpty((String)((String)map.get("children")))) continue;
            JSONArray jsonArray = JSONArray.parseArray((String)((String)map.get("children")));
            for (int idx = 0; idx < jsonArray.size(); ++idx) {
                String paramId = jsonArray.getJSONObject(idx).getString("id");
                if (fieldTypeMap.get(paramId) == null || groupMap.get(fieldTypeMap.get(paramId)) == null) continue;
                ((JSONArray)groupMap.get(fieldTypeMap.get(paramId))).add((Object)jsonArray.getJSONObject(idx));
            }
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            HashMap groupItem = new HashMap();
            groupItem.put("text", entry.getKey());
            groupItem.put("children", ((JSONArray)entry.getValue()).toJSONString());
            displayList.add(groupItem);
        }
        return displayList;
    }

    public Map<String, Object> getDragEntityResult(JoinEntityCommonBo entityBO, JoinEntityCommonBo relEntityBO) {
        String entityAlias = entityBO.getEntityAlias();
        String type = entityBO.getType();
        String entityNumber = entityBO.getEntityNumber();
        FieldTreeNode entityFiledBo = this.fieldDefineService.getEntityFiledBo(entityNumber, entityAlias, "main".equals(type), null);
        if (relEntityBO != null) {
            EntityRelationCommonBo entityRelationCommonBo = new EntityRelationCommonBo();
            entityRelationCommonBo.setEntityNumber(relEntityBO.getEntityNumber());
            entityRelationCommonBo.setEntityAlias(relEntityBO.getEntityAlias());
            entityRelationCommonBo.setJoinEntityNumber(entityNumber);
            entityRelationCommonBo.setJoinEntityAlias(entityAlias);
            entityRelationCommonBo.setJoinType("none");
            entityBO.setEntityRelation(entityRelationCommonBo);
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        resultMap.put("fieldTreeNode", entityFiledBo);
        resultMap.put("entityNode", entityBO);
        resultMap.put("method", "addEntity");
        return resultMap;
    }

    public boolean validateRef(Long lblObjId) {
        boolean lblRelies = LabelObjectServiceHelper.isLblRel(Lists.newArrayList((Object[])new Long[]{lblObjId}));
        boolean lblStrategies = LabelObjectServiceHelper.getLblStrategy(Lists.newArrayList((Object[])new Long[]{lblObjId}));
        boolean lblScene = LabelObjectServiceHelper.getLblScene(lblObjId);
        return !lblRelies && !lblStrategies && !lblScene;
    }

    public boolean validateConfigRef(Long lblObjId) {
        DynamicObject lblObjConfig = LabelObjectServiceHelper.getLblObjConfig(lblObjId);
        return lblObjConfig == null;
    }

    public void fillFilterParam(List<Map<String, String>> paramList, HRFilter hrFilter, String condition) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)4);
        data.put("param", paramList);
        data.put("value", RuleUtil.getNewestConditionValue((String)condition));
        data.put("onlyUpdateWeb", "true");
        hrFilter.updateControlData((Map)data);
    }

    public Map<String, Object> convertToRuleCondition(Map<String, String> hrFilterConditionMap, DynamicObject[] fields) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)hrFilterConditionMap.size());
        HashMap convertedConditionMap = Maps.newHashMapWithExpectedSize((int)hrFilterConditionMap.size());
        HashSet selectedFieldSet = Sets.newHashSetWithExpectedSize((int)hrFilterConditionMap.size());
        hrFilterConditionMap.forEach((key, value) -> {
            Map conditionMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            List conditionList = (List)conditionMap.get("conditionList");
            conditionList.forEach(paramMap -> {
                String param = (String)paramMap.get("param");
                String id = "";
                for (DynamicObject field : fields) {
                    String fieldPath = field.getString("fieldpath");
                    String entityNumber = field.getString("entitynumber");
                    String fieldAlias = field.getString("fieldalias");
                    String complexType = field.getString("complextype");
                    String compareParam = fieldPath.startsWith(entityNumber) ? fieldAlias.split("\\.")[0] + "." + fieldPath : entityNumber + "." + entityNumber + "." + fieldPath;
                    if (!Objects.equals(param, compareParam)) continue;
                    if (AnalyseObjectUtil.isBaseDataType((String)complexType) && (fieldPath.endsWith(".number") || fieldPath.endsWith(".name"))) {
                        DynamicProperty fieldDynamicProperty = LabelService.getFieldDynamicProperty(entityNumber, fieldPath);
                        String baseDataNum = ((BasedataProp)fieldDynamicProperty).getBaseEntityId();
                        id = "p" + field.getLong("id") + '.' + baseDataNum + '.' + "id";
                    } else {
                        id = "p" + field.getLong("id");
                    }
                    if ("enum".equals(paramMap.get("paramType"))) {
                        paramMap.put("paramType", "string");
                    }
                    selectedFieldSet.add(field.getLong("id"));
                    break;
                }
                paramMap.put("param", id);
            });
            convertedConditionMap.put(key, SerializationUtils.toJsonString((Object)conditionMap));
        });
        resultMap.put("condition", convertedConditionMap);
        resultMap.put("conditionField", selectedFieldSet);
        return resultMap;
    }

    public List<Map<String, Object>> getFrequencyData() {
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)10);
        HashMap onceMap = Maps.newHashMapWithExpectedSize((int)16);
        onceMap.put("label", ResManager.loadKDString((String)"\u4ec5\u4e00\u6b21", (String)"LabelService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        onceMap.put("value", "0");
        dataList.add(onceMap);
        HashMap dayMap = Maps.newHashMapWithExpectedSize((int)16);
        dayMap.put("label", ResManager.loadKDString((String)"\u6bcf\u5929", (String)"LabelService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        dayMap.put("value", "1");
        dataList.add(dayMap);
        HashMap weekMap = Maps.newHashMapWithExpectedSize((int)16);
        weekMap.put("label", ResManager.loadKDString((String)"\u6bcf\u5468", (String)"LabelService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekMap.put("value", "2");
        ArrayList weekChildrenList = Lists.newArrayListWithExpectedSize((int)10);
        HashMap weekChildrenMap0 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap0.put("label", ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"LabelService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap0.put("value", "2_0");
        weekChildrenList.add(weekChildrenMap0);
        HashMap weekChildrenMap1 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap1.put("label", ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"LabelService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap1.put("value", "2_1");
        weekChildrenList.add(weekChildrenMap1);
        HashMap weekChildrenMap2 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap2.put("label", ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"LabelService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap2.put("value", "2_2");
        weekChildrenList.add(weekChildrenMap2);
        HashMap weekChildrenMap3 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap3.put("label", ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"LabelService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap3.put("value", "2_3");
        weekChildrenList.add(weekChildrenMap3);
        HashMap weekChildrenMap4 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap4.put("label", ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"LabelService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap4.put("value", "2_4");
        weekChildrenList.add(weekChildrenMap4);
        HashMap weekChildrenMap5 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap5.put("label", ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"LabelService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap5.put("value", "2_5");
        weekChildrenList.add(weekChildrenMap5);
        HashMap weekChildrenMap6 = Maps.newHashMapWithExpectedSize((int)16);
        weekChildrenMap6.put("label", ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"LabelService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        weekChildrenMap6.put("value", "2_6");
        weekChildrenList.add(weekChildrenMap6);
        weekMap.put("children", weekChildrenList);
        dataList.add(weekMap);
        HashMap monthMap = Maps.newHashMapWithExpectedSize((int)16);
        monthMap.put("label", ResManager.loadKDString((String)"\u6bcf\u6708", (String)"LabelService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        monthMap.put("value", "3");
        ArrayList monthChildrenList = Lists.newArrayListWithExpectedSize((int)10);
        for (int i = 1; i <= 31; ++i) {
            HashMap monthChildrenMap = Maps.newHashMapWithExpectedSize((int)16);
            monthChildrenMap.put("label", ResManager.loadKDString((String)"%s\u65e5", (String)"LabelService_10", (String)"hrmp-hrcs-business", (Object[])new Object[]{i}));
            monthChildrenMap.put("value", "3_" + i);
            monthChildrenList.add(monthChildrenMap);
        }
        monthMap.put("children", monthChildrenList);
        dataList.add(monthMap);
        return dataList;
    }

    public Map<String, Object> buildBrmSceneParamMap(DynamicObject field, boolean isLabel) {
        String idStr;
        long id = field.getLong("id");
        String name = field.getString("fieldname");
        if (isLabel) {
            idStr = "pl" + id;
        } else {
            idStr = "p" + id;
            name = name + "1";
        }
        HashMap inputParamMap = Maps.newHashMapWithExpectedSize((int)16);
        inputParamMap.put("inputnumber", idStr);
        String type = ConvertFieldService.convertType(field, isLabel);
        if (ParamTypeEnum.DATE.getValue().equals(type)) {
            inputParamMap.put("inputdateformat", "yyyy-MM-dd");
        } else if (ParamTypeEnum.BASEDATA.getValue().equals(type)) {
            DynamicProperty fieldDynamicProperty = LabelService.getFieldDynamicProperty(field.getString("entitynumber"), field.getString("fieldpath"));
            inputParamMap.put("inputobject", ((BasedataProp)fieldDynamicProperty).getBaseEntityId());
        } else if (ParamTypeEnum.ENUM.getValue().equals(type)) {
            ComboProp property = (ComboProp)LabelService.getFieldDynamicProperty(field.getString("entitynumber"), field.getString("fieldpath"));
            List comboItems = property.getComboItems();
            ArrayList comboList = Lists.newArrayListWithExpectedSize((int)comboItems.size());
            for (ValueMapItem comboItem : comboItems) {
                HashMap comboMap = Maps.newHashMapWithExpectedSize((int)16);
                comboMap.put("name", comboItem.getName());
                comboMap.put("value", comboItem.getValue());
                comboList.add(comboMap);
            }
            inputParamMap.put("inputcombo", SerializationUtils.toJsonString((Object)comboList));
            if (property instanceof MulComboProp) {
                inputParamMap.put("inputmultiple", "1");
            }
            type = "enum";
        }
        inputParamMap.put("inputparamstype", type);
        inputParamMap.put("inputname", name);
        inputParamMap.put("modifystatus", "new");
        return inputParamMap;
    }

    public JoinEntityCommonBo buildEntityBo(DynamicObject joinEntity) {
        String entityIdStr = String.valueOf(joinEntity.getLong("id"));
        String entityNumber = joinEntity.getString("entitynumber");
        String entityAlias = joinEntity.getString("entityalias");
        String type = joinEntity.getString("type");
        LabelJoinEntityCommonBo joinEntityCommonBo = new LabelJoinEntityCommonBo();
        joinEntityCommonBo.setId(entityIdStr);
        joinEntityCommonBo.setEntityNumber(entityNumber);
        joinEntityCommonBo.setEntityAlias(entityAlias);
        joinEntityCommonBo.setIndex(Integer.valueOf(joinEntity.getInt("index")));
        joinEntityCommonBo.setType(type);
        String suffix = entityAlias.contains("\u03b4") ? entityAlias.substring(entityAlias.indexOf("\u03b4") + 1) : "";
        joinEntityCommonBo.setDisplayName(MetadataServiceHelper.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue() + suffix);
        joinEntityCommonBo.setMainBo(Boolean.valueOf(joinEntity.getBoolean("ismainbo")));
        return joinEntityCommonBo;
    }

    public List<String> validateCondition(String condition) {
        RuleValidateInfo info;
        Map map;
        List conditionList;
        if (HRStringUtils.isNotEmpty((String)condition) && !CollectionUtils.isEmpty((Collection)(conditionList = (List)(map = (Map)SerializationUtils.fromJsonString((String)condition, Map.class)).get("conditionList"))) && !(info = RuleValidateUtil.validCondition((String)condition, (boolean)false)).isSuccess()) {
            return info.getMsgList();
        }
        return Collections.emptyList();
    }

    public ReportQueryService getReportQueryService(HRComplexObjContext hrComplexObjContext) {
        return new ReportQueryService(hrComplexObjContext);
    }

    public HRComplexObjContext getContext(List<JoinEntityCommonBo> joinEntityCommonBoList, List<QueryFieldCommonBo> queryFieldCommonBoList, List<QFilter> qFilterList) {
        List entityRelationCommonBoList = joinEntityCommonBoList.stream().filter(joinEntityCommonBo -> joinEntityCommonBo.getEntityRelation() != null).map(JoinEntityCommonBo::getEntityRelation).collect(Collectors.toList());
        return ComplexObjTransferUtil.transferToComplexObjContext(joinEntityCommonBoList, queryFieldCommonBoList, entityRelationCommonBoList, qFilterList);
    }

    public QFilter getLabelObjectDataFilter(DynamicObject lblObj) {
        String condition = lblObj.getString("condition");
        if (HRStringUtils.isEmpty((String)condition)) {
            return null;
        }
        long lblObjId = lblObj.getLong("id");
        List<JoinEntityCommonBo> joinEntityCommonBoList = this.getJoinEntityCommonBoList(lblObjId);
        List entityAllFields = this.fieldDefineService.getEntityAllFields(joinEntityCommonBoList, null);
        ArrayList queryFieldCommonBoList = Lists.newArrayListWithExpectedSize((int)entityAllFields.size());
        ConvertFieldService.convertToBO(queryFieldCommonBoList, entityAllFields);
        return HRFilterUtil.condition2QFilter4HRReport((String)condition, (String)SerializationUtils.toJsonString((Object)queryFieldCommonBoList));
    }

    private void handleFieldTreeNode(List<String> selectFieldKeyList, List<FieldTreeNode> fieldTreeNode, Map<String, QueryFieldCommonBo> queryFieldCommonBoMap) {
        for (FieldTreeNode treeNode : fieldTreeNode) {
            QueryFieldCommonBo queryFieldCommonBo;
            List children = treeNode.getChildren();
            if (treeNode.getSelected().booleanValue()) {
                selectFieldKeyList.add(treeNode.getFieldAlias());
            }
            if ((queryFieldCommonBo = queryFieldCommonBoMap.get(treeNode.getFieldAlias())) != null) {
                queryFieldCommonBo.setControlType(treeNode.getControlType());
            }
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            this.handleFieldTreeNode(selectFieldKeyList, children, queryFieldCommonBoMap);
        }
    }

    private void setEntityValueByBo(Long lblObjId, DynamicObject joinDyn, LabelJoinEntityCommonBo entityCommonBo) {
        joinDyn.set("entitynumber", (Object)entityCommonBo.getEntityNumber());
        joinDyn.set("entityalias", (Object)entityCommonBo.getEntityAlias());
        joinDyn.set("type", (Object)entityCommonBo.getType());
        joinDyn.set("index", (Object)entityCommonBo.getIndex());
        joinDyn.set("labelobject", (Object)lblObjId);
        joinDyn.set("ismainbo", (Object)entityCommonBo.getMainBo());
    }

    private void setRelValueByBo(DynamicObject relDyn, Long lblObjId, Long entityId, Long joinEntityId, EntityRelationCommonBo entityRelation) {
        relDyn.set("entityid", (Object)entityId);
        relDyn.set("jointype", (Object)entityRelation.getJoinType());
        relDyn.set("joinentityid", (Object)joinEntityId);
        relDyn.set("labelobject", (Object)lblObjId);
        relDyn.set("relationtype", (Object)entityRelation.getRelationType());
        relDyn.set("displayname", (Object)(entityRelation.getDisplayName() == null ? new LocaleString() : entityRelation.getDisplayName()));
        List conditions = entityRelation.getConditions();
        DynamicObjectCollection joinConditions = relDyn.getDynamicObjectCollection("joinconditions");
        joinConditions.clear();
        conditions.forEach(condition -> {
            DynamicObject joinCondition = joinConditions.addNew();
            joinCondition.set("leftprop", (Object)condition.getLeftProp());
            joinCondition.set("comparetype", (Object)condition.getCompareType());
            joinCondition.set("rightprop", (Object)condition.getRightProp());
            joinCondition.set("rightproptype", (Object)condition.getRightPropType());
            joinCondition.set("rightpropval", (Object)condition.getRightPropVal());
            joinCondition.set("logictype", (Object)condition.getLogicType());
        });
    }
}

