/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.service.labelandreport.HRFilterUtil;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.ConvertFieldService;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskQueryService;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;
import kd.hr.hrcs.bussiness.util.GenFieldUtil;

@ExcludeFromJacocoGeneratedReport
public class LabelTaskQueryService
implements ILabelTaskQueryService {
    private Long policyId;
    private String taskNumber;
    private Long objectId;
    private String mainEntityNumber;
    private String mainEntityAlias;
    private HRComplexObjContext context;
    private static final Log logger = LogFactory.getLog(LabelTaskQueryService.class);
    private static final LabelService labelService = new LabelService();
    private QFilter[] idFilters;
    private List<QFilter> paramsListQfliter;
    private Set<String> filterEntityNumber = new HashSet<String>(16);

    public LabelTaskQueryService(Long policyId, String taskNumber) {
        this.policyId = policyId;
        this.taskNumber = taskNumber;
        this.objectId = this.getObject();
        Map<String, String> mainEntityInfo = this.getMainEntityInfo(this.objectId);
        this.mainEntityNumber = mainEntityInfo.get("number");
        this.mainEntityAlias = mainEntityInfo.get("alias");
        this.paramsListQfliter = this.initFilterList();
        this.context = this.getContext(this.mainEntityNumber, this.mainEntityAlias, this.objectId, policyId);
        this.idFilters = this.getFilterList4Id(this.mainEntityNumber).toArray(new QFilter[0]);
    }

    @Override
    public int getBizIdCount() {
        DynamicObject policyDy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        Long objectId = policyDy.getLong("labelobject.id");
        DynamicObject mainEntity = LabelPolicyServiceHelper.getEntryByObjectId(objectId);
        String mainEntityNumber = mainEntity.getString("entitynumber");
        QFilter[] qFilters = this.idFilters;
        ORM orm = ORM.create();
        return orm.count("LabelTaskQueryService." + mainEntityNumber, mainEntityNumber, qFilters);
    }

    @Override
    public List<Map<String, Object>> getBizIds(int start, int limit) {
        ArrayList<Map<String, Object>> idList = new ArrayList<Map<String, Object>>();
        QFilter[] qFilters = this.idFilters;
        DynamicObject[] ids = LabelTaskQueryService.load(this.mainEntityNumber, "id", qFilters, "id desc", start, limit, Boolean.FALSE);
        if (ids == null || ids.length == 0) {
            return idList;
        }
        Arrays.stream(ids).forEach(id -> {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put("id", id.getString("id"));
            idList.add(idMap);
        });
        return idList;
    }

    private void addFilterEntityNumber(String objectFilterCondition, String conditionFieldAlias) {
        DynamicObject[] entityRelations;
        for (DynamicObject entityRelation : entityRelations = LabelPolicyServiceHelper.getEntityRelation(this.objectId)) {
            String entityAlias = entityRelation.getString("joinentityid.entityalias");
            if ((objectFilterCondition == null || !objectFilterCondition.contains(entityAlias)) && (conditionFieldAlias == null || !conditionFieldAlias.contains(entityAlias))) continue;
            this.filterEntityNumber.add(entityAlias);
        }
    }

    private List<QFilter> initFilterList() {
        DynamicObject[] dataFilters;
        DynamicObject policyDy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        Long objectId = policyDy.getLong("labelobject.id");
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        DynamicObject objectDy = labelServiceHelper.loadObject(objectId);
        String objectFilterCondition = objectDy.getString("condition");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!HRStringUtils.isEmpty((String)objectFilterCondition)) {
            LabelService labelService = new LabelService();
            List<JoinEntityCommonBo> joinEntityCommonBoList = labelService.getJoinEntityCommonBoList(objectId);
            FieldDefineService fieldDefineService = new FieldDefineService();
            List fieldTreeNodeList = fieldDefineService.getEntityAllFields(joinEntityCommonBoList, null);
            ArrayList queryFieldCommonBoList = Lists.newArrayListWithExpectedSize((int)64);
            ConvertFieldService.convertToBO(queryFieldCommonBoList, fieldTreeNodeList);
            QFilter objectFilter = HRFilterUtil.condition2QFilter4HRReport((String)objectFilterCondition, (String)SerializationUtils.toJsonString((Object)queryFieldCommonBoList));
            logger.info("labelTask-objectFilter:{}", (Object)objectFilter);
            if (objectFilter != null) {
                filterList.add(objectFilter);
            }
        }
        String conditionFieldAlias = null;
        this.addFilterEntityNumber(objectFilterCondition, conditionFieldAlias);
        for (DynamicObject filterDyn : dataFilters = LabelObjectServiceHelper.getFilters(this.policyId)) {
            QFilter rangeFilter;
            String[] split;
            QFilter textFilter;
            if (!"false".equals(filterDyn.getString("hasfilter"))) continue;
            String value = filterDyn.getString("value");
            conditionFieldAlias = filterDyn.getString("fieldkey");
            DynamicProperty dynProperty = GenFieldUtil.getBindEntityProperty(conditionFieldAlias);
            if (HRStringUtils.isEmpty((String)value)) continue;
            if (dynProperty instanceof TextProp) {
                textFilter = new QFilter(conditionFieldAlias, "like", (Object)value);
                filterList.add(textFilter);
            } else if (dynProperty instanceof ComboProp) {
                split = value.split(",");
                rangeFilter = new QFilter(conditionFieldAlias, "in", Arrays.asList(split));
                filterList.add(rangeFilter);
            } else if (dynProperty instanceof BasedataProp) {
                split = value.split(",");
                List selectIdList = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                QFilter rangeFilter2 = new QFilter(conditionFieldAlias, "in", selectIdList);
                filterList.add(rangeFilter2);
            } else if (dynProperty instanceof DateTimeProp) {
                String[] rangeTime = value.split(",");
                if (rangeTime.length > 0) {
                    try {
                        QFilter beginFilter = new QFilter(conditionFieldAlias, ">=", (Object)HRDateTimeUtils.parseDate((String)rangeTime[0]));
                        filterList.add(beginFilter);
                    }
                    catch (ParseException e) {
                        logger.error("labelTask-DateTimeProp-beginFilter:{}", (Object)value);
                    }
                }
                if (rangeTime.length > 1) {
                    try {
                        QFilter endFilter = new QFilter(conditionFieldAlias, "<=", (Object)HRDateTimeUtils.parseDate((String)rangeTime[1]));
                        filterList.add(endFilter);
                    }
                    catch (ParseException e) {
                        logger.error("labelTask-DateTimeProp-endFilter:{}", (Object)value);
                    }
                }
            } else if (dynProperty instanceof DecimalProp) {
                textFilter = new QFilter(conditionFieldAlias, "=", (Object)new BigDecimal(value));
                filterList.add(textFilter);
            } else if (dynProperty instanceof BooleanProp) {
                split = value.split(",");
                rangeFilter = new QFilter(conditionFieldAlias, "in", Arrays.asList(split));
                filterList.add(rangeFilter);
            }
            this.addFilterEntityNumber(objectFilterCondition, conditionFieldAlias);
        }
        filterList.add(new QFilter("id", "in", (Object)0));
        return filterList;
    }

    private List<QFilter> getFilterList4Id(String mainEntityNumber) {
        DynamicObject[] dataFilters;
        DynamicObject policyDy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        Long objectId = policyDy.getLong("labelobject.id");
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        DynamicObject objectDy = labelServiceHelper.loadObject(objectId);
        String objectFilterCondition = objectDy.getString("condition");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        List<QueryFieldCommonBo> queryFieldCommonBoList = labelService.getQueryFieldCommonBoList(objectId);
        if (queryFieldCommonBoList == null || queryFieldCommonBoList.isEmpty()) {
            return new ArrayList<QFilter>();
        }
        logger.info("labelTask-mainEntityNumber:{}", (Object)mainEntityNumber);
        List mainEntityQueryFieldList = queryFieldCommonBoList.stream().filter(queryFieldCommonBo -> mainEntityNumber.equals(queryFieldCommonBo.getEntityNumber())).collect(Collectors.toList());
        logger.info("labelTask-mainEntityQueryFieldList:{}", mainEntityQueryFieldList);
        String queryFieldBoJson = SerializationUtils.toJsonString(mainEntityQueryFieldList);
        logger.info("labelTask-queryFieldBoJson:{}", (Object)queryFieldBoJson);
        if (!HRStringUtils.isEmpty((String)objectFilterCondition)) {
            RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)objectFilterCondition, RuleConditionInfo.class);
            logger.info("labelTask-objectFilterCondition:{}", (Object)objectFilterCondition);
            RuleConditionInfo ruleConditionInfoRebuild = new RuleConditionInfo();
            try {
                ruleConditionInfoRebuild = this.rebuildCondition(ruleConditionInfo, mainEntityNumber);
                logger.info("labelTask-ruleConditionInfoRebuild:{}", (Object)SerializationUtils.toJsonString((Object)ruleConditionInfoRebuild));
                QFilter objectFilter = HRFilterUtil.condition2QFilter4HRReport((String)SerializationUtils.toJsonString((Object)ruleConditionInfoRebuild), (String)queryFieldBoJson);
                logger.info("labelTask-objectFilter:{}", (Object)objectFilter);
                filterList.add(objectFilter);
            }
            catch (Exception e) {
                logger.error("labelTask-e", (Throwable)e);
            }
        }
        String conditionFieldAlias = null;
        for (DynamicObject filterDyn : dataFilters = LabelObjectServiceHelper.getFilters(this.policyId)) {
            QFilter rangeFilter;
            String[] split;
            QFilter textFilter;
            if (!"false".equals(filterDyn.getString("hasfilter"))) continue;
            String value = filterDyn.getString("value");
            conditionFieldAlias = filterDyn.getString("fieldkey");
            DynamicProperty dynProperty = GenFieldUtil.getBindEntityProperty(conditionFieldAlias);
            if (conditionFieldAlias == null || !conditionFieldAlias.startsWith(mainEntityNumber) || HRStringUtils.isEmpty((String)value)) continue;
            if (dynProperty instanceof TextProp) {
                textFilter = new QFilter(conditionFieldAlias, "like", (Object)value);
                filterList.add(textFilter);
            } else if (dynProperty instanceof ComboProp) {
                split = value.split(",");
                rangeFilter = new QFilter(conditionFieldAlias, "in", Arrays.asList(split));
                filterList.add(rangeFilter);
            } else if (dynProperty instanceof BasedataProp) {
                split = value.split(",");
                List selectIdList = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
                QFilter rangeFilter2 = new QFilter(conditionFieldAlias, "in", selectIdList);
                filterList.add(rangeFilter2);
            } else if (dynProperty instanceof DateTimeProp) {
                String[] rangeTime = value.split(",");
                if (rangeTime.length > 0) {
                    try {
                        QFilter beginFilter = new QFilter(conditionFieldAlias, ">=", (Object)HRDateTimeUtils.parseDate((String)rangeTime[0]));
                        filterList.add(beginFilter);
                    }
                    catch (ParseException e) {
                        logger.error("labelTask-DateTimeProp-beginFilter:{}", (Object)value);
                    }
                }
                if (rangeTime.length > 1) {
                    try {
                        QFilter endFilter = new QFilter(conditionFieldAlias, "<=", (Object)HRDateTimeUtils.parseDate((String)rangeTime[1]));
                        filterList.add(endFilter);
                    }
                    catch (ParseException e) {
                        logger.error("labelTask-DateTimeProp-endFilter:{}", (Object)value);
                    }
                }
            } else if (dynProperty instanceof DecimalProp) {
                textFilter = new QFilter(conditionFieldAlias, "=", (Object)new BigDecimal(value));
                filterList.add(textFilter);
            } else if (dynProperty instanceof BooleanProp) {
                split = value.split(",");
                rangeFilter = new QFilter(conditionFieldAlias, "in", Arrays.asList(split));
                filterList.add(rangeFilter);
            }
            this.addFilterEntityNumber(objectFilterCondition, conditionFieldAlias);
        }
        return filterList;
    }

    private RuleConditionInfo rebuildCondition(RuleConditionInfo ruleConditionInfo, String mainEntityNumber) {
        RuleConditionInfo ruleConditionInfoNew = new RuleConditionInfo();
        if (ruleConditionInfo == null || "2".equals(ruleConditionInfo.getConditionExpressType())) {
            return ruleConditionInfoNew;
        }
        if (ruleConditionInfo.getConditionList() == null || ruleConditionInfo.getConditionList().isEmpty()) {
            return ruleConditionInfo;
        }
        ArrayList<ConditionInfo> conditionInfoListNew = new ArrayList<ConditionInfo>(10);
        for (ConditionInfo conditionInfo : ruleConditionInfo.getConditionList()) {
            String[] paramArr = conditionInfo.getParam().split("\\.");
            Set paramSet = Arrays.stream(paramArr).collect(Collectors.toSet());
            if (!paramArr[0].equals(mainEntityNumber)) continue;
            conditionInfoListNew.add(conditionInfo);
        }
        if (conditionInfoListNew.isEmpty()) {
            return ruleConditionInfoNew;
        }
        ruleConditionInfoNew.setConditionList(conditionInfoListNew);
        List newNameList = conditionInfoListNew.stream().map(ConditionInfo::getName).collect(Collectors.toList());
        if (ruleConditionInfo.getConditionExpressList() == null || ruleConditionInfo.getConditionExpressList().isEmpty()) {
            return ruleConditionInfoNew;
        }
        ArrayList<ConditionExpressInfo> conditionExpressInfoListNew = new ArrayList<ConditionExpressInfo>(10);
        for (ConditionExpressInfo conditionExpressInfo : ruleConditionInfo.getConditionExpressList()) {
            if (!newNameList.contains(conditionExpressInfo.getName())) continue;
            conditionExpressInfoListNew.add(conditionExpressInfo);
        }
        ruleConditionInfoNew.setConditionExpressList(conditionExpressInfoListNew);
        ruleConditionInfoNew.setConditionExpressType(ruleConditionInfo.getConditionExpressType());
        StringBuilder conditionExpressStrNew = new StringBuilder();
        if (!conditionExpressInfoListNew.isEmpty()) {
            for (int idx = 0; idx < conditionExpressInfoListNew.size(); ++idx) {
                ConditionExpressInfo con = (ConditionExpressInfo)conditionExpressInfoListNew.get(idx);
                conditionExpressStrNew.append(con.getName()).append(' ');
                if (con.getLogical() == null || con.getLogical().length() == 0 || "null".equals(con.getLogical()) || idx == conditionExpressInfoListNew.size() - 1) continue;
                conditionExpressStrNew.append(con.getLogical()).append(' ');
            }
        }
        ruleConditionInfoNew.setConditionExpressStr(conditionExpressStrNew.toString());
        return ruleConditionInfoNew;
    }

    @Override
    public List<Map<String, Object>> getLabelObjectFieldParams(Long pkId) {
        return this.getLabel(Collections.singletonList(pkId));
    }

    @Override
    public List<Map<String, Object>> getLabelObjectFieldParams(List<Long> pkIds) {
        return this.getLabel(pkIds);
    }

    public List<Map<String, Object>> getLabel(List<Long> pkIds) {
        List qFilters = this.context.getQfilterList();
        qFilters.remove(qFilters.size() - 1);
        qFilters.removeAll(Collections.singleton(null));
        qFilters.add(new QFilter("id", "in", pkIds));
        this.context.setQfilterList(qFilters);
        return this.getData(this.context);
    }

    private Long getObject() {
        DynamicObject policyDy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        if (policyDy == null) {
            return 0L;
        }
        return policyDy.getLong("labelobject.id");
    }

    private Map<String, String> getMainEntityInfo(Long objectId) {
        DynamicObject mainEntity = LabelPolicyServiceHelper.getEntryByObjectId(objectId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", mainEntity.getString("entitynumber"));
        map.put("alias", mainEntity.getString("entityalias"));
        return map;
    }

    private HRComplexObjContext getContext(String mainEntityNumber, String mainEntityAlias, Long objectId, Long policyId) {
        DynamicObject[] entityRelations;
        DynamicObject[] paramDyList;
        HRComplexObjContext context = new HRComplexObjContext();
        StringBuilder fieldAliasString = new StringBuilder();
        context.setEntityNumber(mainEntityNumber);
        context.setEntityTable(HREntityHelper.getTableName((String)mainEntityNumber));
        ArrayList queryFieldsInfoList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject param : paramDyList = LabelPolicyServiceHelper.listParamByPolicyId(policyId)) {
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(param.getString("param.fieldpath"), "1", param.getString("param.fieldalias"));
            fieldInfo.setDataType(DataTypeEnum.of((String)param.getString("param.valuetype")));
            queryFieldsInfoList.add(fieldInfo);
            fieldAliasString.append(param.getString("param.fieldalias")).append(";");
            DynamicObject dynField = param.getDynamicObject("param");
            if (!AnalyseObjectUtil.isBaseDataType((String)dynField.getString("complextype")) || !dynField.getString("fieldalias").endsWith(".name") && !dynField.getString("fieldalias").endsWith(".number")) continue;
            String tempFieldAlias = param.getDynamicObject("param").getString("fieldalias");
            String tempFieldIdAlias = tempFieldAlias.substring(0, tempFieldAlias.lastIndexOf(".") + 1) + "id";
            String tempFieldPath = param.getDynamicObject("param").getString("fieldpath");
            String tempFieldIdPath = tempFieldPath.substring(0, tempFieldPath.lastIndexOf(".") + 1) + "id";
            if (fieldAliasString.indexOf(tempFieldIdAlias) > -1) continue;
            HRComplexObjFieldInfo fieldIdInfo = new HRComplexObjFieldInfo(tempFieldIdPath, "1", tempFieldIdAlias);
            fieldIdInfo.setDataType(DataTypeEnum.LONG);
            queryFieldsInfoList.add(fieldIdInfo);
            fieldAliasString.append(tempFieldIdAlias).append(";");
        }
        queryFieldsInfoList.add(this.extAddId());
        logger.info("label->context,policyId:{},queryFieldsInfoList:{}", (Object)policyId, (Object)queryFieldsInfoList);
        context.setComplexObjFieldInfoList((List)queryFieldsInfoList);
        ArrayList joinRelationList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject entityRelation : entityRelations = LabelPolicyServiceHelper.getEntityRelation(objectId)) {
            if ("main".equalsIgnoreCase(entityRelation.getString("joinentityid.type")) || fieldAliasString.indexOf(entityRelation.getString("joinentityid.entityalias")) < 0 && !this.filterEntityNumber.contains(entityRelation.getString("joinentityid.entityalias"))) continue;
            HRComplexObjJoinRelation relationInfo = new HRComplexObjJoinRelation(mainEntityNumber, mainEntityAlias, entityRelation.getString("joinentityid.entitynumber"), entityRelation.getString("joinentityid.entityalias"), entityRelation.getString("jointype"));
            DynamicObjectCollection joinConditions = entityRelation.getDynamicObjectCollection("joinconditions");
            ArrayList joinConditionBoList = Lists.newArrayListWithExpectedSize((int)joinConditions.size());
            for (DynamicObject joinCondition : joinConditions) {
                HRComplexObjConditionRow condition;
                if ("field".equals(joinCondition.getString("rightproptype"))) {
                    condition = new HRComplexObjConditionRow(joinCondition.getString("leftprop"), joinCondition.getString("rightprop"));
                    condition.setRightFieldItem(true);
                } else {
                    condition = new HRComplexObjConditionRow(joinCondition.getString("leftprop"), joinCondition.getString("rightpropval"));
                    condition.setRightFieldItem(false);
                }
                condition.setCompareOp(joinCondition.getString("comparetype"));
                condition.setLogicOp(joinCondition.getString("logictype"));
                joinConditionBoList.add(condition);
            }
            relationInfo.setCondition((List)joinConditionBoList);
            joinRelationList.add(relationInfo);
        }
        context.setJoinRelationList((List)joinRelationList);
        context.setQfilterList(this.paramsListQfliter);
        logger.info("label->context,policyId:{},context.setEntityNumber:{},context.setJoinRelationList:{},context.setComplexObjFieldInfoList:{},context.setQfilterList:{}", new Object[]{policyId, context.getEntityNumber(), context.getJoinRelationList(), context.getComplexObjFieldInfoList(), context.getQfilterList()});
        return context;
    }

    private HRComplexObjFieldInfo extAddId() {
        HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo("id", "1", "id");
        fieldInfo.setDataType(DataTypeEnum.LONG);
        return fieldInfo;
    }

    private List<Map<String, Object>> getData(HRComplexObjContext context) {
        ReportQueryService reportQueryService;
        try {
            reportQueryService = new ReportQueryService(context);
        }
        catch (Exception e) {
            logger.error("label->context new ReportQueryService(context) error", (Throwable)e);
            logger.error("label->context new ReportQueryService(context) error context", (Object)context);
            return new ArrayList<Map<String, Object>>();
        }
        List dataList = reportQueryService.queryMap();
        logger.info("label->context dataList :{}", (Object)dataList);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        dataList.forEach(data -> {
            HashMap previewDataMap = Maps.newHashMapWithExpectedSize((int)data.size());
            for (Map.Entry entry : data.entrySet()) {
                Object value = entry.getValue();
                previewDataMap.put(entry.getKey(), value == null ? "" : value);
            }
            resultList.add(previewDataMap);
        });
        logger.info("label->context resultList :{}", (Object)resultList);
        return resultList;
    }

    public static DynamicObject[] loadData(DynamicObjectType type, List<Object> idList, DataSet ds, Boolean loadReferenceData) {
        Throwable throwable = null;
        try {
            ds.forEach(row -> idList.add(row.get(0)));
        }
        catch (Throwable exp) {
            throwable = exp;
            throw exp;
        }
        finally {
            if (ds != null) {
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable var35) {
                        throwable.addSuppressed(var35);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return BusinessDataReader.load((Object[])idList.toArray(), (DynamicObjectType)type, (Boolean)loadReferenceData);
    }

    public static DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBy, int pageIndex, int pageSize, Boolean loadReferenceData) {
        if (pageIndex >= 0 && pageSize > 0) {
            DynamicObjectType type = LabelTaskQueryService.getSubEntityType(entityName, selectProperties);
            ArrayList<Object> idList = new ArrayList<Object>();
            DataSet ds = ORM.create().queryDataSet("LabelTaskQueryService.load", entityName, "id", filters, orderBy, pageIndex, pageSize, (Distinctable)WithEntityEntryDistinctable.get());
            return LabelTaskQueryService.loadData(type, idList, ds, loadReferenceData);
        }
        return new DynamicObject[0];
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    protected <R> R query(String sql, ResultSetHandler<R> resultHandler, Object ... params) {
        return (R)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)sql, (Object[])params, resultHandler);
    }
}

