/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.label.LabelResultInfo;
import kd.hr.hrcs.bussiness.service.label.ComplexLabelTaskProcessService;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskProcessService;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskQueryService;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskService;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskStorageService;
import kd.hr.hrcs.bussiness.service.label.LabelPublishService;
import kd.hr.hrcs.bussiness.service.label.LabelTaskQueryService;
import kd.hr.hrcs.bussiness.service.label.LabelTaskStorageService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;
import kd.hr.hrcs.bussiness.util.LruPolicyCacheMap;

public class LabelTaskService
implements ILabelTaskService {
    private static final Log logger = LogFactory.getLog(LabelTaskService.class);
    private static final int PAGESIZE_ID = 200000;
    public static final String TASK_STATUS_INIT = "0";
    public static final String TASK_STATUS_DOING = "1";
    public static final String TASK_STATUS_SUCCESS = "2";
    public static final String TASK_STATUS_FAIL = "3";
    public static final String TASK_STATUS_CANCEL = "4";
    private static final int SPLIT_MIN_COUNT = 2;
    private static final int SPLIT_MAX_COUNT = 5;
    private static final int THREAD_PROCESS_COUNT = 10000;
    private static final String POLICY_TASK_ENTRY = "hrcs_labelpolicytask";
    private static final HRBaseServiceHelper policyTaskServiceHelper = new HRBaseServiceHelper("hrcs_labelpolicytask");
    private Long policyId;
    private String taskNumber;
    private ILabelTaskQueryService taskQueryService;
    private ILabelTaskStorageService taskStorageService;
    private ILabelTaskProcessService taskProcessService;
    private DLock lock;
    private static final ExecutorService executorServiceCustom = ThreadPools.newCachedExecutorService((String)"hrcs-label-Thread", (int)20, (int)50);

    public LabelTaskService(Long policyId, String taskNumber) {
        this.policyId = policyId;
        this.taskNumber = taskNumber;
        this.init();
    }

    private void init() {
        this.lock = DLock.create((String)("lbl_" + this.policyId), (String)"label process lock");
        this.taskQueryService = new LabelTaskQueryService(this.policyId, this.taskNumber);
        this.taskStorageService = new LabelTaskStorageService(this.policyId, this.taskNumber);
        this.taskProcessService = new ComplexLabelTaskProcessService(this.policyId, this.taskNumber);
        this.clearHisEs();
    }

    private void clearHisEs() {
        DynamicObject[] hisTasks;
        DynamicObject labelPolicy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        QFilter[] filters = new QFilter[3];
        ArrayList<String> taskNumbers = new ArrayList<String>();
        taskNumbers.add(this.taskNumber);
        taskNumbers.add(labelPolicy.getString("lasttasknumber"));
        filters[0] = new QFilter("labelpolicy.id", "=", (Object)this.policyId);
        filters[1] = new QFilter("esstatus", "!=", (Object)1);
        filters[2] = new QFilter("number", "not in", taskNumbers);
        for (DynamicObject dynamicObject : hisTasks = LabelPolicyServiceHelper.listNeedClearEsPolicyTask(filters)) {
            this.taskStorageService.deleteIndex("hrcs_label_" + this.policyId + "_" + dynamicObject.getString("number"));
            this.taskStorageService.deleteIndex("hrcs_label_id_" + this.policyId + "_" + dynamicObject.getString("number"));
            LabelPolicyServiceHelper.updateEsStatusPolicyTask(dynamicObject);
        }
    }

    private int getTaskSplitCount(int totalCount) {
        int tempCount = totalCount / 10000;
        if (tempCount > 5) {
            return 5;
        }
        if (tempCount < 2) {
            return 2;
        }
        return tempCount;
    }

    private DynamicObject getLabelPolicyTask() {
        QFilter qFilter = new QFilter("labelpolicy", "=", (Object)this.policyId);
        QFilter taskNumberFilter = new QFilter("number", "=", (Object)this.taskNumber);
        return policyTaskServiceHelper.queryOne("labelpolicy,creator,createtime,modifier,modifytime,taskstatus,taskmessage", new QFilter[]{qFilter, taskNumberFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean exeFlag = false;
        try {
            DynamicObject labelPolicyTask = this.getLabelPolicyTask();
            if (labelPolicyTask == null || !TASK_STATUS_INIT.equals(labelPolicyTask.get("taskstatus"))) {
                logger.info("executeLabelPolicyTask taskstatus is not 0, task end. policyId:{},taskNumber:{}", (Object)this.policyId, (Object)this.taskNumber);
                return;
            }
            if (this.getPolicyProcessFlag()) {
                exeFlag = true;
            } else {
                logger.info("executeLabelPolicyTask tryLock fail.policyId:{},taskNumber:{}", (Object)this.policyId, (Object)this.taskNumber);
            }
            if (exeFlag) {
                logger.info("executeLabelPolicyTask Begin,taskNumber:{}", (Object)this.taskNumber);
                LabelPolicyServiceHelper.updatePolicyTask(this.policyId, this.taskNumber, TASK_STATUS_DOING, null);
                int idCount = this.taskQueryService.getBizIdCount();
                logger.info("executeLabelPolicyTask getIdcount ,idCount:{}", (Object)idCount);
                LabelPolicyServiceHelper.updatePolicyTaskTotalQuantity(this.policyId, this.taskNumber, idCount);
                int taskSplitCount = this.getTaskSplitCount(idCount);
                this.taskStorageService.createLabelIndex(true);
                RequestContext requestContext = RequestContext.get();
                for (int start = 0; start < idCount; start += 200000) {
                    List<Map<String, Object>> idList = this.taskQueryService.getBizIds(start, 200000);
                    this.taskStorageService.saveIdList(idList, TASK_STATUS_INIT, taskSplitCount);
                    LabelPolicyServiceHelper.addPolicyTaskQuantity(this.policyId, this.taskNumber, 0, 0);
                }
                logger.info("executeLabelPolicyTask saveId2ES ");
                ArrayList<CompletableFuture<Long>> futureList = new ArrayList<CompletableFuture<Long>>(taskSplitCount);
                for (int splitNo = 0; splitNo < taskSplitCount; ++splitNo) {
                    futureList.add(this.intSplitTask(splitNo, requestContext));
                }
                logger.info("executeLabelPolicyTask task trigger ,splitCount:{}", (Object)taskSplitCount);
                boolean succussFlag = true;
                long resultCount = 0L;
                for (int splitNo = 0; splitNo < taskSplitCount; ++splitNo) {
                    long curResultCount = (Long)((CompletableFuture)futureList.get(splitNo)).get();
                    if (curResultCount > -1L) {
                        resultCount += curResultCount;
                        continue;
                    }
                    succussFlag = false;
                    break;
                }
                logger.info("executeLabelPolicyTask splitTask finished! ");
                if (succussFlag) {
                    this.taskProcessService.finish();
                    DynamicObject labelPolicy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
                    LabelPublishService.publishPolicyFinishMsg(this.policyId, this.taskNumber, resultCount, labelPolicy.getLong("labelobject.id"), labelPolicy.getLong("label.id"));
                }
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            logger.error("executeLabelPolicyTask error ,{}", (Object)exp.getMessage());
            String errorMsg = "";
            if (exp != null && (errorMsg = errorMsg + exp.getMessage()).length() > 1500) {
                errorMsg = errorMsg.substring(0, 1500);
            }
            LabelPolicyServiceHelper.updatePolicyTask(this.policyId, this.taskNumber, TASK_STATUS_FAIL, errorMsg);
            this.taskStorageService.deleteIndex(this.taskStorageService.getLabelIndexName());
        }
        finally {
            if (exeFlag) {
                this.taskStorageService.deleteIndex(this.taskStorageService.getLabelIdIndexName());
                this.releasePolicyProcessFlag();
            }
        }
    }

    private CompletableFuture<Long> intSplitTask(int splitNo, RequestContext requestContext) {
        int currentSplitNo = splitNo;
        LabelTaskQueryService curQuery = new LabelTaskQueryService(this.policyId, this.taskNumber);
        return CompletableFuture.supplyAsync(() -> this.executeSplitTask(currentSplitNo, curQuery, requestContext), executorServiceCustom);
    }

    private Map<Long, List<Map<String, Object>>> getGroupMapById(List<Map<String, Object>> paramsList) {
        HashMap<Long, List<Map<String, Object>>> resultMap = new HashMap<Long, List<Map<String, Object>>>(16);
        for (Map<String, Object> params : paramsList) {
            ArrayList<Map<String, Object>> curParams = (ArrayList<Map<String, Object>>)resultMap.get(params.get("id"));
            if (curParams == null) {
                curParams = new ArrayList<Map<String, Object>>();
                resultMap.put(Long.parseLong(String.valueOf(params.get("id"))), curParams);
            }
            if (curParams.size() >= 500) continue;
            curParams.add(params);
        }
        return resultMap;
    }

    private Long executeSplitTask(Integer splitNo, ILabelTaskQueryService taskQueryService, RequestContext requestContext) {
        RequestContext.copyAndSet((RequestContext)requestContext);
        long resultCount = 0L;
        long exeCount = 0L;
        int queryIdCnt = 1000;
        int curCnt = 0;
        ArrayList<Long> pkIds = new ArrayList<Long>(10);
        LruPolicyCacheMap lruCacheMap = new LruPolicyCacheMap(200);
        List<Map<String, Object>> idList = this.taskStorageService.getProcessDataList(splitNo, 2000);
        while (idList != null && idList.size() > 0) {
            logger.info("executeLabelPolicyTask splitTask loop begin,splitNo:{}", (Object)splitNo);
            ArrayList<LabelResultInfo> resultList = new ArrayList<LabelResultInfo>(idList.size());
            for (Map<String, Object> idMap : idList) {
                pkIds.add(Long.parseLong(String.valueOf(idMap.get("id"))));
                if (++curCnt % queryIdCnt != 0 && curCnt != idList.size()) continue;
                logger.info("executeLabelPolicyTask splitTask loop getLabelObjectFieldParams-begin,splitNo:{}", (Object)splitNo);
                List<Map<String, Object>> paramsList = taskQueryService.getLabelObjectFieldParams(pkIds);
                logger.info("executeLabelPolicyTask splitTask loop getLabelObjectFieldParams-end,splitNo:{}", (Object)splitNo);
                Map<Long, List<Map<String, Object>>> mapParams = this.getGroupMapById(paramsList);
                logger.info("executeLabelPolicyTask splitTask loop getRuleResultList-begin,splitNo:{}", (Object)splitNo);
                resultList.addAll(this.taskProcessService.getRuleResultList(mapParams, lruCacheMap));
                logger.info("executeLabelPolicyTask splitTask loop getRuleResultList-end,splitNo:{}", (Object)splitNo);
                pkIds.clear();
            }
            resultCount += (long)resultList.size();
            this.taskStorageService.saveIdList(idList, TASK_STATUS_DOING);
            this.taskStorageService.batchSaveLabelResult(resultList, "RULE");
            LabelPolicyServiceHelper.addPolicyTaskQuantity(this.policyId, this.taskNumber, idList.size(), resultList.size());
            logger.info("executeLabelPolicyTask splitTask loop continue,splitNo-exeCount:{}", (Object)(splitNo + "-" + (exeCount += (long)idList.size())));
            idList = this.taskStorageService.getProcessDataList(splitNo, 2000);
            curCnt = 0;
        }
        logger.info("executeLabelPolicyTask splitTask finished,splitNo\uff1a{} ", (Object)splitNo);
        return resultCount;
    }

    private boolean getPolicyProcessFlag() {
        return this.lock.tryLock();
    }

    private void releasePolicyProcessFlag() {
        this.lock.unlock();
    }
}

