/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class LblStrategyServiceHelper {
    public static void deleteFilter(Long strategyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategyfilter");
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("lblstrategy.id", "=", (Object)strategyId)});
    }

    public static void delete(Object[] pks) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        serviceHelper.delete(pks);
    }

    public static DynamicObject[] getLabelPolicyRules(Long strategyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelpolicyrule");
        return serviceHelper.query("id,labelpolicy,label,labelvalue,conditions,brmrule", new QFilter[]{new QFilter("labelpolicy.id", "=", (Object)strategyId)});
    }

    public static DynamicObject[] getLabelPolicies(Long lblObjId, List<Long> lblIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.query("id,label.id,labelobject,number", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId), new QFilter("label.id", "in", lblIds)});
    }

    public static DynamicObject getLabelPolicy(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.queryOne("id,label,labelobject", new QFilter("id", "=", (Object)id));
    }

    public static DynamicObject[] getLabelObjects() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelobject");
        return serviceHelper.query("id,number,name", new QFilter[]{new QFilter("publishstatus", "=", (Object)"1")}, "createtime desc");
    }

    public static DynamicObject[] getLabelObjects(String name) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelobject");
        QFilter qFilter = new QFilter("name", "like", (Object)('%' + name + '%'));
        return serviceHelper.query("id,number,name", new QFilter[]{qFilter, new QFilter("publishstatus", "=", (Object)"1")}, "createtime desc");
    }

    public static DynamicObject getRuleScene(Long lblId, Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelobjectrel");
        return serviceHelper.queryOne("id,label,labelobject,brmscene,brmscene.sceneinputparams.inputnumber", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId), new QFilter("label.id", "=", (Object)lblId)});
    }

    public static DynamicObject[] getLabelValues(Long lblId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelvalue");
        return serviceHelper.query("id,label,value,description", new QFilter[]{new QFilter("label.id", "=", (Object)lblId)});
    }

    public static DynamicObject getRulePolicy(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("brm_policy_edit");
        return serviceHelper.queryOne("name", new QFilter("id", "=", (Object)id));
    }

    public static DynamicObject[] getLblValueRule(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelvaluerule");
        return serviceHelper.query("id,labelvalue,labelobject,brmtarget,brmtarget.name", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }

    public static DynamicObject[] getLabelValues(List<Long> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelvalue");
        return serviceHelper.query("id,label,value,description", new QFilter[]{new QFilter("id", "in", idList)});
    }

    public static DynamicObject getRuleScene(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("brm_scene");
        return serviceHelper.queryOne("id,sceneinputparams,sceneinputparams.inputnumber", new QFilter("id", "=", (Object)id));
    }

    public static Object[] saveLabelParams(DynamicObjectCollection dynamicObjectCollection) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelparam");
        return serviceHelper.save(dynamicObjectCollection);
    }

    public static void deleteLabelParamsByStrategy(Long lblId, Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelparam");
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("label.id", "=", (Object)lblId), new QFilter("labelobject.id", "=", (Object)lblObjId), new QFilter("source", "=", (Object)"20")});
    }

    public static DynamicObject[] getLabelParams(Long lblId, Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelparam");
        return serviceHelper.query("id,param,brmiputparam,source,brmiputparam.number", new QFilter[]{new QFilter("label.id", "=", (Object)lblId), new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }

    public static Set<String> getLabelRefParam(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelparam");
        DynamicObject[] dys = serviceHelper.query("param.fieldalias", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId)});
        if (null != dys && dys.length > 0) {
            return Arrays.stream(dys).map(dy -> dy.getString("param.fieldalias")).collect(Collectors.toSet());
        }
        return null;
    }

    public static DynamicObject[] getLabelRef(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelparam");
        return serviceHelper.query("label.id,label.name,source,param.entitynumber,param.fieldname,param.fieldalias", new QFilter[]{new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }

    public static DynamicObject[] getLabelRef(QFilter[] qFilters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelparam");
        return serviceHelper.query("label.id,label.name,source,param.entitynumber,param.fieldname,param.fieldalias", qFilters);
    }

    public static DynamicObject[] getBrmRules(Long policyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("brm_ruledesign");
        return serviceHelper.query("policy,number", new QFilter[]{new QFilter("policy", "=", (Object)policyId)});
    }

    public static DynamicObject[] getExpireStrategy() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        Date date = new Date();
        QFilter qFilter = new QFilter("enddate", "<", (Object)date);
        return serviceHelper.query("id,lasttasknumber", new QFilter[]{qFilter});
    }

    public static DynamicObject[] getBizApps(Set<String> appNumSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        return serviceHelper.query("id,number", new QFilter[]{new QFilter("number", "in", appNumSet)});
    }

    public static DynamicObject[] getManualLabelPolicy(Long lblObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        return serviceHelper.query("number", new QFilter[]{new QFilter("worktype", "=", (Object)"1"), new QFilter("labelobject.id", "=", (Object)lblObjId)});
    }
}

