/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label.excel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.excel.LabelImportService;
import kd.hr.hrcs.bussiness.service.label.excel.LabelTemplateExcelWriter;

public class LabelImportFailedSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(LabelImportFailedSheetHandler.class);
    private ImportLogger importLogger;
    private Long lblObjId;
    private Long lblId;
    private boolean isAll;
    private Map<String, String> urlMap;
    private final LabelImportService labelImportService = new LabelImportService();
    private final List<Map<Integer, String>> dataList = Lists.newArrayListWithExpectedSize((int)10000);
    private Map<Integer, List<ImportLogger.ImportLog>> newLogCache;

    public LabelImportFailedSheetHandler(ImportLogger importLogger, boolean isAll, Map<String, String> urlMap, Long lblObjId, Long lblId) {
        this.setInterrupt(false);
        this.isAll = isAll;
        this.urlMap = urlMap;
        this.lblId = lblId;
        this.lblObjId = lblObjId;
        this.importLogger = importLogger;
        this.newLogCache = Maps.newHashMapWithExpectedSize((int)importLogger.getLogCache().size());
    }

    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        String sheetName = parsedRow.getSheetName();
        if (!HRStringUtils.equals((String)sheetName, (String)this.labelImportService.getSheet())) {
            return;
        }
        int rowNum = parsedRow.getRowNum();
        if (rowNum > 1) {
            if (parsedRow.getData().size() == 0) {
                return;
            }
            this.addData(parsedRow);
        }
    }

    private void addData(SheetHandler.ParsedRow row) {
        Map data = row.getData();
        HashMap newDataMap = Maps.newHashMapWithExpectedSize((int)data.size());
        if (!this.isAll) {
            int rowNum;
            Map logCache = this.importLogger.getLogCache();
            List importLogs = (List)logCache.get(rowNum = row.getRowNum());
            if (!CollectionUtils.isEmpty((Collection)importLogs)) {
                for (Map.Entry entry : data.entrySet()) {
                    newDataMap.put((Integer)entry.getKey() + 1, entry.getValue());
                }
                this.newLogCache.put(this.dataList.size() + 2, importLogs);
                this.dataList.add(newDataMap);
            }
        } else {
            for (Map.Entry entry : data.entrySet()) {
                newDataMap.put((Integer)entry.getKey() + 1, entry.getValue());
            }
            this.dataList.add(newDataMap);
        }
    }

    public void endDocument() {
        this.setInterrupt(false);
        if (this.labelImportService.getSheet().equals(this.getSheetName())) {
            this.setInterrupt(true);
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("label", this.lblId.toString());
            map.put("labelobject", this.lblObjId.toString());
            LabelTemplateExcelWriter labelTemplateExcelWriter = new LabelTemplateExcelWriter(map);
            labelTemplateExcelWriter.addDecSheet(ResManager.loadKDString((String)"\u5bfc\u5165\u8bf4\u660e", (String)"LabelTemplateExportTask_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            labelTemplateExcelWriter.addDataSheetByFail(this.getSheetName(), this.dataList, this.isAll ? this.importLogger.getLogCache() : this.newLogCache);
            try {
                if (this.isAll) {
                    String url = labelTemplateExcelWriter.writeFile(ResManager.loadKDString((String)"\u5168\u91cf\u62a5\u544a", (String)"LabelImportFailedSheetHandler_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    this.urlMap.put("allErrFileUrl", url);
                } else {
                    String url = labelTemplateExcelWriter.writeFile(ResManager.loadKDString((String)"\u9519\u8bef\u62a5\u544a", (String)"LabelImportFailedSheetHandler_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    this.urlMap.put("errFileUrl", url);
                }
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PermImportFailedSheetHandler_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])), new Object[0]);
            }
        }
    }
}

