/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;
import kd.hr.hrcs.common.utils.ImportFileUtil;
import org.xml.sax.SAXException;

public class LabelImportService {
    private static final Log LOGGER = LogFactory.getLog(LabelImportService.class);
    private IFormView view;
    private Long lblObjId;
    private Long lblId;
    private int totalCount;
    private int succeedCount;
    private final String sheet = ResManager.loadKDString((String)"\u6253\u6807\u6570\u636e", (String)"LabelImportService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    private final LabelService labelService = new LabelService();
    private LabelDataService labelDataService;
    private Set<String> valueSet;
    private static final Pattern PATTERN = Pattern.compile("^[0-9]*[1-9][0-9]*$");

    public String getSheet() {
        return this.sheet;
    }

    public Long getLblObjId() {
        return this.lblObjId;
    }

    public void setLblObjId(Long lblObjId) {
        this.lblObjId = lblObjId;
    }

    public int getSucceedCount() {
        return this.succeedCount;
    }

    public void setSucceedCount(int succeedCount) {
        this.succeedCount = succeedCount;
    }

    public Long getLblId() {
        return this.lblId;
    }

    public void setLblId(Long lblId) {
        this.lblId = lblId;
    }

    public LabelImportService(IFormView view, Long lblObjId, Long lblId) {
        this.view = view;
        this.lblObjId = lblObjId;
        this.lblId = lblId;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public LabelImportService() {
    }

    public String dealSheetName(String sheetName) {
        if (sheetName.length() > 32) {
            return sheetName.substring(0, 31);
        }
        return sheetName;
    }

    public void feedbackProgress(boolean complete, String allErrUrl, String errUrl) {
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get("Cached_Import_Logger");
        JSONObject map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        int progress = complete ? 100 : 25;
        map.put("progress", (Object)progress);
        map.put("errFileUrl", (Object)errUrl);
        map.put("allErrFileUrl", (Object)allErrUrl);
        map.put("complete", (Object)complete);
        if (complete) {
            map.put("userEndTime", (Object)String.valueOf(System.currentTimeMillis()));
            map.put("total", (Object)this.totalCount);
            map.put("succeed", (Object)this.succeedCount);
            map.put("failed", (Object)(this.totalCount - this.succeedCount));
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put("Cached_Import_Logger", cachedLogStr);
        cache.saveChanges();
    }

    public void addData2Cache(List<JSONObject> dataList) {
        if (!CollectionUtils.isEmpty(dataList)) {
            IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
            String cachedLogStr = cache.get("Cached_Import_Logger");
            JSONObject map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
            map.put("importFinish", dataList);
            cachedLogStr = JSON.toJSONString((Object)map);
            cache.put("Cached_Import_Logger", cachedLogStr);
            cache.saveChanges();
        }
    }

    public boolean checkTemplate(String localPath) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(new File(ImportFileUtil.checkUrl((String)"tempfile", (String)localPath)));){
            final String errMsg = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u6821\u9a8c\u5f02\u5e38\u3002", (String)"LabelImportService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            new ExcelReader().read((InputStream)inputStream, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (!this.getSheetNames().contains(LabelImportService.this.sheet)) {
                        throw new KDBizException(errMsg);
                    }
                    if (!LabelImportService.this.sheet.equals(this.getSheetName())) {
                        return;
                    }
                    if (row.getData().size() == 0) {
                        return;
                    }
                    if (row.getRowNum() == 0) {
                        Map dataMap = row.getData();
                        String idKey = (String)dataMap.get(0);
                        String labelValueKey = (String)dataMap.get(1);
                        if (!"id".equals(idKey)) {
                            throw new KDBizException(errMsg);
                        }
                        if (!"value".equals(labelValueKey)) {
                            throw new KDBizException(errMsg);
                        }
                    }
                }

                public void endDocument() throws SAXException {
                    super.endDocument();
                    this.setInterrupt(false);
                    if (LabelImportService.this.sheet.equals(this.getSheetName()) || !this.getSheetNames().contains(LabelImportService.this.sheet)) {
                        this.setInterrupt(true);
                    }
                }
            });
        }
        return true;
    }

    public void validate(List<ImportBillData> rowDataList, ImportLogger importLogger, Map<String, List<String>> labelData) {
        ImportLogger.ImportLog importLog;
        Map logCache = importLogger.getLogCache();
        if (this.valueSet == null) {
            DynamicObject[] labelValues = LblStrategyServiceHelper.getLabelValues(this.lblId);
            this.valueSet = Arrays.stream(labelValues).map(lv -> lv.getString("value")).collect(Collectors.toSet());
        }
        HashSet excelIdSet = Sets.newHashSetWithExpectedSize((int)rowDataList.size());
        for (ImportBillData importBillData : rowDataList) {
            JSONObject data = importBillData.getData();
            String id = data.getString("id");
            if (HRStringUtils.isEmpty((String)id)) continue;
            excelIdSet.add(id);
        }
        Set<String> bizIdSet = this.getBizIdSet(this.lblObjId, excelIdSet);
        HashMap idCountMap = Maps.newHashMapWithExpectedSize((int)rowDataList.size());
        for (ImportBillData importBillData : rowDataList) {
            JSONObject data = importBillData.getData();
            String id = data.getString("id");
            ArrayList importLogList = Lists.newArrayListWithExpectedSize((int)8);
            if (HRStringUtils.isEmpty((String)id)) {
                importLog = new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636eID\u3002", (String)"LabelImportService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                importLogList.add(importLog);
            }
            if (!bizIdSet.contains(id)) {
                importLog = new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8be5\u884c\u5728\u7cfb\u7edf\u4e2d\u672a\u5339\u914d\u5230\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636eID\u3002", (String)"LabelImportService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                importLogList.add(importLog);
            }
            Set rowNumSet = (Set)idCountMap.get(id);
            Integer rowNum = data.getInteger("rowNum");
            if (rowNumSet != null) {
                rowNumSet.add(rowNum);
            } else {
                rowNumSet = Sets.newHashSet((Object[])new Integer[]{rowNum});
            }
            idCountMap.put(id, rowNumSet);
            String value = data.getString("value");
            if (!HRStringUtils.isEmpty((String)value)) {
                String errMsg;
                String[] split = value.split(",");
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder dbBuilder = new StringBuilder();
                boolean isDup = false;
                for (String valueStr : split) {
                    List<String> labelValueSet;
                    if (HRStringUtils.isEmpty((String)valueStr)) continue;
                    if (!this.valueSet.contains(valueStr)) {
                        stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d\u3001", (String)"LabelImportService_5", (String)"hrmp-hrcs-business", (Object[])new Object[]{valueStr}));
                    }
                    if (!isDup && value.indexOf(valueStr) != value.lastIndexOf(valueStr)) {
                        String dupMsg = ResManager.loadKDString((String)"\u6807\u7b7e\u503c\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"LabelImportService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                        ImportLogger.ImportLog importLog2 = new ImportLogger.ImportLog(dupMsg);
                        importLogList.add(importLog2);
                        isDup = true;
                    }
                    if ((labelValueSet = labelData.get(id)) == null || !labelValueSet.contains(valueStr)) continue;
                    dbBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d\u3001", (String)"LabelImportService_5", (String)"hrmp-hrcs-business", (Object[])new Object[]{valueStr}));
                }
                if (stringBuilder.length() > 0) {
                    errMsg = ResManager.loadKDString((String)"\u6807\u7b7e\u503c%s\u4e0d\u5b58\u5728\u3002", (String)"LabelImportService_4", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.substring(0, stringBuilder.length() - 1)});
                    ImportLogger.ImportLog importLog3 = new ImportLogger.ImportLog(errMsg);
                    importLogList.add(importLog3);
                }
                if (dbBuilder.length() > 0) {
                    errMsg = ResManager.loadKDString((String)"\u8be5\u884c\u6570\u636e\u5df2\u6253%s\u6807\u7b7e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6253\u6807\u3002", (String)"LabelImportService_8", (String)"hrmp-hrcs-business", (Object[])new Object[]{dbBuilder.substring(0, dbBuilder.length() - 1)});
                    ImportLogger.ImportLog importLog4 = new ImportLogger.ImportLog(errMsg);
                    importLogList.add(importLog4);
                }
            }
            if (importLogList.size() <= 0) continue;
            logCache.put(rowNum, importLogList);
        }
        String errMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636eID\uff0cExcel\u4e2d\u5b58\u5728\u4e0e\u8be5\u884c\u6570\u636eID\u76f8\u540c\u7684\u6570\u636e\u3002", (String)"LabelImportService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (Map.Entry entry : idCountMap.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            for (Integer rowNum : (Set)entry.getValue()) {
                importLog = new ImportLogger.ImportLog(errMsg);
                List importLogList = (List)logCache.get(rowNum);
                if (importLogList == null) {
                    importLogList = Lists.newArrayListWithExpectedSize((int)8);
                }
                importLogList.add(importLog);
                logCache.put(rowNum, importLogList);
            }
        }
    }

    private Set<String> getBizIdSet(Long lblObjId, Set<String> excelIdSet) {
        if (this.labelDataService == null) {
            this.labelDataService = new LabelDataService(lblObjId, false);
        }
        HashSet idParseSet = Sets.newHashSetWithExpectedSize((int)excelIdSet.size());
        for (String excelId : excelIdSet) {
            if (!PATTERN.matcher(excelId).find() || excelId.length() > 20) continue;
            try {
                idParseSet.add(Long.parseLong(excelId));
            }
            catch (Exception exception) {
                LOGGER.error("LabelImportService-parseError:{}", (Object)exception.getMessage());
            }
        }
        QFilter qFilter = new QFilter("id", "in", (Object)idParseSet);
        HRComplexObjContext idCountContext = this.labelDataService.getIdCountContext(qFilter);
        ReportQueryService reportQueryService = new ReportQueryService(idCountContext);
        List dataList = reportQueryService.queryMap();
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)dataList.size());
        for (Map dataMap : dataList) {
            idSet.add(dataMap.get("id").toString());
        }
        return idSet;
    }
}

