/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label.excel;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.excel.LabelImportService;

public class LabelImportSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(LabelImportSheetHandler.class);
    private final ImportContext importContext;
    private String url;
    private final LinkedBlockingQueue<ImportBillData> dataQueue;
    private Map<Integer, String> nameRow;
    private SheetHandler.ParsedRow currentRow;
    private final LabelImportService labelImportService = new LabelImportService();
    private String errCellValue = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private String errCellValue2 = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private boolean hasError;

    public LabelImportSheetHandler(ImportContext importContext, String url) {
        this.importContext = importContext;
        this.url = url;
        this.dataQueue = importContext.getDataQueue(url);
    }

    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        this.currentRow = parsedRow;
        String sheetName = parsedRow.getSheetName();
        if (!HRStringUtils.equals((String)sheetName, (String)this.labelImportService.getSheet())) {
            return;
        }
        int rowNum = parsedRow.getRowNum();
        if (rowNum > 1) {
            if (parsedRow.getData().size() == 0) {
                return;
            }
            this.addData(parsedRow, sheetName);
        } else if (rowNum == 0) {
            this.nameRow = parsedRow.getData();
        }
    }

    private void addData(SheetHandler.ParsedRow row, String sheetKey) {
        JSONObject rowObj = new JSONObject();
        rowObj.put("column", (Object)this.getColumnMap());
        rowObj.putAll((Map)this.fieldMapping(this.currentRow.getData()));
        rowObj.put("rowNum", (Object)row.getRowNum());
        rowObj.put("sheetKey", (Object)sheetKey);
        this.addBillData(new ImportBillData(rowObj, row.getRowNum(), row.getRowNum(), null));
    }

    private JSONObject getColumnMap() {
        JSONObject rowObj = new JSONObject();
        this.nameRow.forEach((key, value) -> rowObj.put(value, key));
        return rowObj;
    }

    private JSONObject fieldMapping(Map<Integer, String> data) {
        JSONObject rowObj = new JSONObject();
        data.forEach((key, value) -> {
            String val = this.nameRow.get(key);
            if (HRStringUtils.isEmpty((String)val)) {
                rowObj.put(key + "", value);
            } else {
                rowObj.put(this.nameRow.get(key), value);
            }
        });
        return rowObj;
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"PermImportSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        catch (InterruptedException exp) {
            LOG.error("resolve thread error\u3002", (Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"PermImportSheetHandler_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void endDocument() {
        this.setInterrupt(false);
        if (this.labelImportService.getSheet().equals(this.getSheetName())) {
            this.setInterrupt(true);
            this.importContext.setResolveComplete(this.url);
            this.importContext.feedbackProgress(5, null, null);
        }
    }
}

