/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import org.apache.commons.lang3.StringUtils;

public class EsStrageBaseHelper {
    private static final Log logger = LogFactory.getLog(EsStrageBaseHelper.class);
    public static String IDS_SEPARATOR = "-";

    public static QueryEntity getQueryEntity(String entityName) {
        String queryFormId = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)queryFormId)) {
            return null;
        }
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
        return (QueryEntity)entityMeta.getRootEntity();
    }

    public static IDataEntityProperty findProperty(MainEntityType relationEntityType, String propertyName) {
        DynamicProperty dataEntityProperty = null;
        String[] nameKeys = propertyName.split("\\.");
        for (int i = 0; i < nameKeys.length && null == (dataEntityProperty = relationEntityType.getProperty(nameKeys[i])); ++i) {
        }
        return dataEntityProperty;
    }

    public static void parseSelectField(QueryEntity queryEntity, Set<String> mainPropertys, Set<String> nestPropertys, boolean isMapping) {
        for (QuerySelectField selectField : queryEntity.getSelectFields()) {
            String fieldName = selectField.getAlias();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            boolean mainFlags = false;
            String entityName = QFilterUtilHR.getSubEntityName((String)fieldName, (QueryEntity)queryEntity);
            if (entityName == null) {
                entityName = queryEntity.getEntityName();
                mainFlags = true;
            }
            MainEntityType relationEntityType = null;
            try {
                relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            }
            catch (Exception ex) {
                throw new KDBizException("Read entity meta data from cache error! entity name: " + entityName);
            }
            fieldName = EsStrageBaseHelper.transferBaseData(relationEntityType, fieldName, isMapping);
            if (mainFlags) {
                mainPropertys.add(fieldName);
                continue;
            }
            if (!fieldName.contains(entityName)) {
                fieldName = entityName + "." + fieldName;
            }
            nestPropertys.add(fieldName);
        }
        mainPropertys.add("id");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            String fieldName = EsStrageBaseHelper.transferBaseData(mainEntityType, joinEntity.getFKProperty(), isMapping);
            mainPropertys.add(fieldName);
            nestPropertys.add(joinEntity.getEntityName() + ".id");
        }
    }

    public static List<String> filterPropertys(Set<String> nestPropertys, String entityName) {
        ArrayList joinSelectListNew = Lists.newArrayListWithCapacity((int)16);
        List joinSelectList = nestPropertys.stream().filter(property -> property.contains(entityName)).collect(Collectors.toList());
        if (null == joinSelectList || joinSelectList.size() <= 0) {
            return joinSelectListNew;
        }
        for (String joinSelect : joinSelectList) {
            joinSelectListNew.add(joinSelect.replace(entityName + ".", ""));
        }
        return joinSelectListNew;
    }

    public static String transferBaseData(MainEntityType entityType, String property, boolean isMapping) {
        IDataEntityProperty joinProperty = EsStrageBaseHelper.findProperty(entityType, property);
        if (joinProperty instanceof IComplexProperty) {
            property = joinProperty.getName() + (isMapping ? ".id" : "_id");
        }
        return property;
    }

    public static EsDataType convertPropertyType(IDataEntityProperty srcProp) {
        return EsStrageBaseHelper.convertPropertyType(srcProp, null);
    }

    public static EsDataType convertPropertyType(IDataEntityProperty srcProp, String realProp) {
        EsDataType dataType = EsDataType.getTypeOf((String)srcProp.getPropertyType().getSimpleName());
        if (null != dataType) {
            return dataType;
        }
        if (srcProp instanceof DateProp || srcProp instanceof DateTimeProp) {
            dataType = EsDataType.DATE;
        } else if (srcProp instanceof BigDecimal) {
            dataType = EsDataType.FLOAT;
        } else if (srcProp instanceof FieldProp || srcProp instanceof ComboProp) {
            dataType = EsDataType.TEXT;
        } else {
            if (srcProp instanceof BasedataProp) {
                if (StringUtils.isNotEmpty((CharSequence)realProp)) {
                    String baseEntityId = ((BasedataProp)srcProp).getBaseEntityId();
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                    IDataEntityProperty property = EsStrageBaseHelper.findProperty(dataEntityType, realProp);
                    if (property == null) {
                        return EsStrageBaseHelper.convertPropertyType(EsStrageBaseHelper.findProperty(dataEntityType, "id"));
                    }
                    return EsStrageBaseHelper.convertPropertyType(property);
                }
                return EsDataType.LONG;
            }
            throw new KDException(BosEsErrorCode.esException, new Object[]{"the DataType (" + srcProp.getPropertyType().getSimpleName() + ") does not support."});
        }
        return dataType;
    }

    public static EsStorage init() {
        return EsStorageFactory.getStorage((String)"hr");
    }
}

