/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity.impl;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hrcs.bussiness.service.multientity.IJobAndPlanService;

public abstract class AbstractJobAndPlanService
implements IJobAndPlanService {
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final String jobNumberPrifix = "hrcs_ej_";
    private static final String planNumberPrifix = "hrcs_ep_";

    protected abstract String getTaskClassName();

    protected abstract String getNamePreFix();

    @Override
    public void fixedTimeRelease(Map<String, Object> jobParam, Date fixedTime) {
        String name = (String)jobParam.get("name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570\u9519\u8bef\uff0cname\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"IJobAndPlanService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String jobNumber = jobNumberPrifix + name;
        String planNumber = planNumberPrifix + name;
        this.deleteJobAndPlan(planNumber);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        String jobId = UUID.randomUUID().toString();
        jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(this.getTaskClassName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(this.getNamePreFix() + "job_" + name);
        jobInfo.setId(jobId);
        jobInfo.setNumber(jobNumber);
        jobInfo.setEnable(true);
        jobInfo.setParams(jobParam);
        ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(planNumber);
        planInfo.setName(this.getNamePreFix() + "plan_" + name);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(new Date());
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(fixedTime);
        endTime.add(5, 1);
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        String cronExpression = this.changeDateToCronExpression(fixedTime);
        planInfo.setCronExpression(cronExpression);
        ScheduleServiceHelper.createPlan((PlanInfo)planInfo);
    }

    @Override
    public void deleteJobAndPlanByQueryEntityName(String name) {
        String planNumber = planNumberPrifix + name;
        this.deleteJobAndPlan(planNumber);
    }

    public void deleteJobAndPlan(String planNumber) {
        Map<String, List<String>> map = this.getJobAndPlanIds(planNumber);
        if (map == null) {
            return;
        }
        List<String> listJobId = map.get("jobId");
        List<String> listScheduleId = map.get("scheduleId");
        ScheduleServiceHelper scheduleServiceHelper = new ScheduleServiceHelper();
        if (!CollectionUtils.isEmpty(listJobId)) {
            for (String jobId : listJobId) {
                ScheduleServiceHelper.deleteJob((String)jobId);
            }
        }
        if (!CollectionUtils.isEmpty(listScheduleId)) {
            for (String scheduleId : listScheduleId) {
                ScheduleServiceHelper.deletePlan((String)scheduleId);
            }
        }
    }

    private Map<String, List<String>> getJobAndPlanIds(String planNumber) {
        String sql = "SELECT FID,FJOBID FROM T_SCH_SCHEDULE WHERE fnumber = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)planNumber)};
        final HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        final ArrayList listJobId = new ArrayList();
        final ArrayList listScheduleId = new ArrayList();
        map.put("jobId", listJobId);
        map.put("scheduleId", listScheduleId);
        DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, List<String>>>(){

            public Map<String, List<String>> handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    listScheduleId.add(rs.getString("FID"));
                    listJobId.add(rs.getString("FJOBID"));
                }
                return map;
            }
        });
        return map;
    }

    private String changeDateToCronExpression(Date date) {
        if (date == null) {
            return null;
        }
        String dateFormat = "ss mm HH dd MM ?";
        return this.formatDateByPattern(date, dateFormat);
    }

    private String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }
}

