/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hrcs.bussiness.service.perm.RoleModifyNotifyService;

public class HRPermCacheMgr {
    private static Log LOGGER = LogFactory.getLog(HRPermCacheMgr.class);
    private static final String BS_HR_PERM_REGION = "HR_PERMISSION";
    private static DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("HR_PERMISSION", new DistributeCacheHAPolicy(true, true));
    public static final int defExpireTime = 28800;
    public static final String NULL_DATA_INDB_TAG = "NULL_DATA_INDB_TAG";
    private static final String BS_HR_PERM = "BS_HR_PERM_";
    private static final String IGNORE_PERM_ENTITY = "BS_HR_PERM_IGNORE_PERM_ENTITY";
    private static final String USER_ROLE = "BS_HR_PERM_USER_ROLE";
    public static final String DATA_RULE = "BS_HR_PERM_DATA_RULE";
    private static final String ENTITY_FUNC = "BS_HR_PERM_ENTITY_FUNC";
    private static final String ROLE_DIM_PROP_RELAT = "BS_HR_PERM_ROLE_DIM_PROP_RELAT";
    private static final String DIM_VALUE_TYPE = "BS_HR_PERM_DIM_VALUE_TYPE";
    private static final String ROLE_DIM_VALUE = "BS_HR_PERM_ROLE_DIM_VALUE";
    private static final String USER_DIM_VALUE = "BS_HR_PERM_USER_DIM_VALUE";
    public static final String BD_DATA_RULE = "BS_HR_PERM_BD_DATA_RULE";
    private static final String FIELD_PERM = "BS_HR_PERM_FIELD_PERM";
    private static final String IGNORE_ORG_PERM_ENTITY = "BS_HR_PERM_IGNORE_ORG_PERM_ENTITY";
    private static String[] checkCacheTypePreArr = new String[]{"BS_HR_PERM_IGNORE_PERM_ENTITY", "BS_HR_PERM_USER_ROLE", "BS_HR_PERM_DATA_RULE", "BS_HR_PERM_ENTITY_FUNC", "BS_HR_PERM_ROLE_DIM_PROP_RELAT", "BS_HR_PERM_DIM_VALUE_TYPE", "BS_HR_PERM_ROLE_DIM_VALUE", "BS_HR_PERM_USER_DIM_VALUE", "BS_HR_PERM_BD_DATA_RULE", "BS_HR_PERM_FIELD_PERM", "BS_HR_PERM_IGNORE_ORG_PERM_ENTITY"};
    private static final String NO_CTRL_PERM_ENTITYS = "BS_HR_PERM_NO_CTRL_PERM_ENTITYS";

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"HRPermCacheMgr_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static String getType4IgnorePermEntity() {
        return HRPermCacheMgr.getTypeByPrefix(IGNORE_PERM_ENTITY);
    }

    public static String getType4UserRole() {
        return HRPermCacheMgr.getTypeByPrefix(USER_ROLE);
    }

    public static String getType4DataRule() {
        return HRPermCacheMgr.getTypeByPrefix(DATA_RULE);
    }

    public static String getType4EntityFunc() {
        return HRPermCacheMgr.getTypeByPrefix(ENTITY_FUNC);
    }

    public static String getType4RoleDimPropRelat() {
        return HRPermCacheMgr.getTypeByPrefix(ROLE_DIM_PROP_RELAT);
    }

    public static String getType4RoleDimValueType() {
        return HRPermCacheMgr.getTypeByPrefix(DIM_VALUE_TYPE);
    }

    public static String getType4RoleDimValue() {
        return HRPermCacheMgr.getTypeByPrefix(ROLE_DIM_VALUE);
    }

    public static String getType4UserDimValue() {
        return HRPermCacheMgr.getTypeByPrefix(USER_DIM_VALUE);
    }

    public static String getType4BdDataRule() {
        return HRPermCacheMgr.getTypeByPrefix(BD_DATA_RULE);
    }

    public static String getType4FieldPerm() {
        return HRPermCacheMgr.getTypeByPrefix(FIELD_PERM);
    }

    public static String getType4OrgPermIgnore() {
        return HRPermCacheMgr.getTypeByPrefix(IGNORE_ORG_PERM_ENTITY);
    }

    public static String getTypeByPrefix(String typePre) {
        return typePre + "_" + HRPermCacheMgr.getAcctId();
    }

    public static String getType4NoCtrlPermEntitys() {
        return HRPermCacheMgr.getTypeByPrefix(NO_CTRL_PERM_ENTITYS);
    }

    public static void clearAllManageCache() {
        HRPermCacheMgr.clearCache(HRPermCacheMgr.getType4NoCtrlPermEntitys());
    }

    public static void clearCache(String type) {
        try {
            CACHE.removeType(type);
        }
        catch (Exception ex) {
            LOGGER.error("clearCache error.", (Throwable)ex);
        }
    }

    public static void clearCache(String type, String key) {
        try {
            CACHE.remove(type, key);
        }
        catch (Exception ex) {
            LOGGER.error("clearCache error.", (Throwable)ex);
        }
    }

    public static void clearCache(String type, String[] arrkeys) {
        try {
            CACHE.remove(type, arrkeys);
        }
        catch (Exception ex) {
            LOGGER.error("clearCache error.", (Throwable)ex);
        }
    }

    public static String getCache(String type, String key) {
        try {
            return (String)CACHE.get(type, key);
        }
        catch (Exception ex) {
            LOGGER.error("getCache error.", (Throwable)ex);
            return null;
        }
    }

    public static void putCache(String type, String key, String value) {
        try {
            CACHE.put(type, key, value, 28800);
        }
        catch (Exception ex) {
            LOGGER.error("putCache error.", (Throwable)ex);
        }
    }

    public static void putCacheToday(String type, String key, String value) {
        try {
            int expireTime = HRPermCacheMgr.secsToTomorrow();
            if (expireTime > 28800) {
                expireTime = 28800;
            }
            CACHE.put(type, key, value, expireTime);
        }
        catch (Exception ex) {
            LOGGER.error("putCache error.", (Throwable)ex);
        }
    }

    public static void putCache(String type, String key, String value, int pExpireTime) {
        try {
            CACHE.put(type, key, value, pExpireTime);
        }
        catch (Exception ex) {
            LOGGER.error("putCache error.", (Throwable)ex);
        }
    }

    public static void putCacheNullTag(String type, String key) {
        try {
            CACHE.put(type, key, (Object)NULL_DATA_INDB_TAG);
        }
        catch (Exception ex) {
            LOGGER.error("putCacheNullTag error.", (Throwable)ex);
        }
    }

    public static void putCacheNullTagToday(String type, String key) {
        try {
            int expireTime = HRPermCacheMgr.secsToTomorrow();
            if (expireTime > 28800) {
                expireTime = 28800;
            }
            CACHE.put(type, key, NULL_DATA_INDB_TAG, expireTime);
        }
        catch (Exception ex) {
            LOGGER.error("putCacheNullTag error.", (Throwable)ex);
        }
    }

    public static boolean isNullTag(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.equals(NULL_DATA_INDB_TAG);
    }

    public static void clearCache(String[] arrKeys) {
        try {
            CACHE.remove(arrKeys);
        }
        catch (Exception ex) {
            LOGGER.error("clearCache error.", (Throwable)ex);
        }
    }

    public static void clearDataEntityCache(String pEntityNum) {
        try {
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)pEntityNum));
            cacheManager.removeByDt();
        }
        catch (Exception ex) {
            LOGGER.error("clearDataEntityCache error.", (Throwable)ex);
        }
    }

    public static void clearAllCache() {
        HRPermCacheMgr.clearAllHrCache();
        PermissionServiceHelper.clearAllCache();
    }

    public static void clearAllCacheAsync() {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr#clearAllCacheAsync", () -> HRPermCacheMgr.clearAllCache());
    }

    public static void clearAllCacheAndNotifyAsync(List<Long> permFileIds) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr#clearAllCacheAndNotifyAsync#byPermFileIds", () -> {
            HRPermCacheMgr.clearAllCache();
            RoleModifyNotifyService.clearShowFormCacheByPermFileIdList(permFileIds);
        });
    }

    public static void clearAllCacheAndNotifyAsync(Long permFileId) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr#clearAllCacheAndNotifyAsync#byPermFileId", () -> {
            HRPermCacheMgr.clearAllCache();
            RoleModifyNotifyService.clearShowFormCacheByPermFileId(permFileId);
        });
    }

    public static void clearAllCacheAndNotifyAsync(String roleId) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr#clearAllCacheAndNotifyAsync#byRoleId", () -> {
            HRPermCacheMgr.clearAllCache();
            RoleModifyNotifyService.clearShowFormCacheByRoleId(roleId);
        });
    }

    public static void clearAllCacheAndNotifyAsync(Set<String> roleIds) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr#clearAllCacheAndNotifyAsync#byRoleIds", () -> {
            HRPermCacheMgr.clearAllCache();
            RoleModifyNotifyService.clearShowFormCacheByRoleId(roleIds);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllHrCache() {
        StringBuilder info = new StringBuilder();
        try {
            info.append("[clearAllHrCache]has cleaned redis type = ");
            ArrayList delKey = Lists.newArrayListWithExpectedSize((int)16);
            for (int idx = 0; idx < checkCacheTypePreArr.length; ++idx) {
                String cleanType = HRPermCacheMgr.getTypeByPrefix(checkCacheTypePreArr[idx]);
                delKey.add(cleanType);
                info.append(idx + 1).append(".[").append(cleanType).append("] \r\n");
            }
            HRPermCacheMgr.clearCache(delKey.toArray(new String[0]));
            info.append("has cleaned DataEntityCache.entityNum = ");
            String[] dataEntityCacheArr = new String[]{"hrcs_orgpermconfig"};
            for (int idx = 0; idx < dataEntityCacheArr.length; ++idx) {
                HRPermCacheMgr.clearDataEntityCache(dataEntityCacheArr[idx]);
                info.append(idx + 1).append(".[").append(dataEntityCacheArr[idx]).append("] \r\n");
            }
        }
        catch (Exception ex) {
            LOGGER.error("[clearAllCache] error\uff1a{} ", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            LOGGER.info(info.toString());
        }
    }

    public static int secsToTomorrow() {
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        tomorrow.set(11, 0);
        tomorrow.set(12, 0);
        tomorrow.set(13, 0);
        Calendar now = Calendar.getInstance();
        return (int)(tomorrow.getTime().getTime() - now.getTime().getTime()) / 1000;
    }
}

