/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.PermissionControlType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;

public class RoleManageService {
    private static final Log LOGGER = LogFactory.getLog(RoleManageService.class);

    public static Set<String> getNoCtrlPermEntitysFromCache() {
        String cacheKey;
        long start = System.currentTimeMillis();
        String cacheType = HRPermCacheMgr.getType4NoCtrlPermEntitys();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = "ALL_NO_CTRL_PERM_ENTITYS");
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Set<String> noCtrlPermEntitys = RoleManageService.queryNoCtrlPermEntitysHr();
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(noCtrlPermEntitys));
            LOGGER.info("RoleManageService.getNoCtrlPermEntitysFromCache not_cache, query time:{} ms.noCtrlPermEntity size:{}", (Object)(System.currentTimeMillis() - start), (Object)noCtrlPermEntitys.size());
            return noCtrlPermEntitys;
        }
        Set noCtrlPermEntitys = (Set)SerializationUtils.fromJsonString((String)cacheVal, Set.class);
        LOGGER.info("RoleManageService.getNoCtrlPermEntitysFromCache have_cache, time:{} ms.noCtrlPermEntity size:{}", (Object)(System.currentTimeMillis() - start), (Object)noCtrlPermEntitys.size());
        return noCtrlPermEntitys;
    }

    public static Set<String> queryNoCtrlPermEntitys() {
        HashSet noCtrlPermEntitys = Sets.newHashSetWithExpectedSize((int)16);
        String sql = "select FNUMBER, FDATA from T_META_ENTITY where FKEY = 'CtrlType' AND FTYPE = '24' ";
        String algoKey = "RoleManageService.queryEntityIsCtrlPermBatch";
        long startTime = System.currentTimeMillis();
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fdata = row.getString("FDATA");
                PermissionControlType pct = (PermissionControlType)SerializationUtils.fromJsonString((String)fdata, PermissionControlType.class);
                if (pct.isControlFunction()) continue;
                noCtrlPermEntitys.add(row.getString("FNUMBER"));
            }
        }
        LOGGER.info("RoleManageService queryNoCtrlPermEntitys end,cost_mills:{} ms", (Object)(System.currentTimeMillis() - startTime));
        return noCtrlPermEntitys;
    }

    public static Set<String> queryNoCtrlPermEntitysHr() {
        HashSet noCtrlPermEntitys = Sets.newHashSetWithExpectedSize((int)16);
        long startTime = System.currentTimeMillis();
        String hrCloudStrIds = HRCloudServiceHelper.getAllHRCloudIdInStr();
        String sql = "select en.FNUMBER, en.FDATA from T_META_ENTITY en left join t_meta_entitydesign e on en.fnumber=e.fnumber\n    left join t_meta_bizapp a on e.fbizappid = a.fid\nwhere a.fbizcloudid in (" + hrCloudStrIds + ")\nand en.FKEY = 'CtrlType' AND en.FTYPE = '24' ";
        String algoKey = "RoleManageService.queryEntityIsCtrlPermBatch";
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fdata = row.getString("FDATA");
                PermissionControlType pct = (PermissionControlType)SerializationUtils.fromJsonString((String)fdata, PermissionControlType.class);
                if (pct.isControlFunction()) continue;
                noCtrlPermEntitys.add(row.getString("FNUMBER"));
            }
        }
        LOGGER.info("RoleManageService queryNoCtrlPermEntitys end2,cost_mills:{} ms", (Object)(System.currentTimeMillis() - startTime));
        return noCtrlPermEntitys;
    }
}

