/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRRoleFunctionPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;

public class RoleMemberService {
    private static final Log LOGGER = LogFactory.getLog(RoleMemberService.class);
    private static Map<String, String> appNameMapCach = Maps.newHashMapWithExpectedSize((int)16);
    private static Map<String, Map<String, String>> cloudNameIdMapCach = Maps.newHashMapWithExpectedSize((int)16);
    private static final String ENT_NUM = "ent_num";
    private static final String ENTITY_DESIGN_DS = "entityDesignDS";
    private static String HRCS_USER_FIELD = "hrcs_userfield";
    private static Map<String, String> entityNumNameMap = Maps.newHashMapWithExpectedSize((int)16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCloudNode(IFormView view, TreeNode rootNode, Boolean alerdysetcheckbox, String treeType) {
        ArrayList treeNodeInfos = Lists.newArrayListWithCapacity((int)16);
        PermPageCacheUtil permPageCacheUtil = RoleMemberService.getPermPageCacheUtil(view);
        String currenHrBuca = (String)view.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        Map<String, RoleDataPermModel> dataPermMap = permPageCacheUtil.getDataPermMap();
        LOGGER.info("addCloudNode-----dataPermMap----" + dataPermMap);
        if (HRStringUtils.equals((String)"1", (String)treeType)) {
            RoleMemberService.setDataRuleTreeAppEntityNumCach(view, dataPermMap);
        } else {
            RoleMemberService.setFieldPermTreeAppEntityNumCach(permPageCacheUtil, view, dataPermMap);
        }
        Map<String, Map<String, String>> allAppHrBuCaMap = permPageCacheUtil.getAllAppHrBuCaMap();
        Boolean showRelate = (Boolean)view.getModel().getValue("showrelate");
        Map<String, List<String>> assignedAppEntity = showRelate != false ? RoleMemberService.getAssignedAppEntityForCache(permPageCacheUtil) : permPageCacheUtil.getAssignedAppEntity();
        HashSet entityNewSet = Sets.newHashSetWithExpectedSize((int)16);
        assignedAppEntity.forEach((appid, entitynums) -> entityNewSet.addAll(entitynums));
        DataSet entityDesignDs = null;
        try {
            String algoKeyPrefix = "kd.hr.hrcs.bussiness.service.perm.RoleMemberService.addCloudNode.";
            if (CollectionUtils.isEmpty(entityNumNameMap)) {
                entityDesignDs = RoleMemberService.getEntityDesignDs(algoKeyPrefix);
                entityNumNameMap = RoleMemberService.getEntityMap(entityDesignDs);
            }
            HashMap entityBuCaFuncMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap businessAppMap = Maps.newHashMapWithExpectedSize((int)16);
            Map<String, Long> entitySpecFuncMap = HRRoleFunctionPermHelper.getAllEntitySpecFunc();
            assignedAppEntity.forEach((appid, entitynumlist) -> {
                if (CollectionUtils.isEmpty((Collection)entitynumlist)) {
                    return;
                }
                entitynumlist.forEach(entitynum -> {
                    String appName;
                    if (HRStringUtils.isEmpty((String)entitynum)) {
                        return;
                    }
                    Set appInfoSet = (Set)businessAppMap.get(entitynum);
                    if (CollectionUtils.isEmpty((Collection)appInfoSet)) {
                        appInfoSet = Sets.newHashSetWithExpectedSize((int)16);
                    }
                    if (HRStringUtils.isEmpty((String)(appName = appNameMapCach.get(appid)))) {
                        DynamicObject appNameDy = RoleServiceHelper.getAppName(appid);
                        appName = appNameDy.getString("name");
                        appNameMapCach.put((String)appid, appName);
                    }
                    appInfoSet.add(appid + "#" + appName + "#app");
                    businessAppMap.put(entitynum, appInfoSet);
                    RoleMemberService.getBuCaFunc(appid, entitynum, allAppHrBuCaMap, entityBuCaFuncMap, entitySpecFuncMap, entityNumNameMap);
                });
            });
            HashMap cloudInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            entityBuCaFuncMap.forEach((entityNumber, finalBuCaFuncId) -> {
                String[] entityNumberArr = entityNumber.split("#");
                String[] finalBuCaFuncIdArr = finalBuCaFuncId.split("#");
                if (HRStringUtils.equals((String)"1", (String)treeType)) {
                    if (currenHrBuca.equals(finalBuCaFuncIdArr[0])) {
                        RoleMemberService.getTreeMap(businessAppMap, cloudInfoMap, entityNumber, entityNumberArr);
                    }
                } else {
                    RoleMemberService.getTreeMap(businessAppMap, cloudInfoMap, entityNumber, entityNumberArr);
                }
            });
            cloudInfoMap.forEach((cloudInfo, appMaps) -> {
                String appEntityNumStr = view.getPageCache().get("appEntityNumSet");
                Set appEntityNumCach = Sets.newHashSetWithExpectedSize((int)16);
                if (HRStringUtils.isNotEmpty((String)appEntityNumStr)) {
                    appEntityNumCach = (Set)SerializationUtils.fromJsonString((String)appEntityNumStr, Set.class);
                }
                HashSet entityNumCach = Sets.newHashSetWithExpectedSize((int)16);
                appEntityNumCach.forEach(appEntityNum -> {
                    if (HRStringUtils.equals((String)"1", (String)treeType)) {
                        String[] appEntityNumArr = appEntityNum.split("#");
                        entityNumCach.add(appEntityNumArr[1]);
                    } else {
                        entityNumCach.add(appEntityNum);
                    }
                });
                String[] cloudInfoArr = cloudInfo.split("#");
                String cloudId = cloudInfoArr[0] + "#cloud";
                TreeNode cloudNode = new TreeNode(rootNode.getId(), cloudId, cloudInfoArr[1], (Object)Boolean.TRUE);
                rootNode.addChild(cloudNode);
                String[] cloudTreeNodeInfo = new String[]{cloudInfoArr[1], cloudId, rootNode.getId()};
                treeNodeInfos.add(cloudTreeNodeInfo);
                appMaps.forEach((appidName, entitySet) -> {
                    String[] appArr = appidName.split("#");
                    String appId = cloudInfoArr[0] + "#" + appArr[0] + "#app";
                    TreeNode appNode = new TreeNode(cloudId, appId, appArr[1], (Object)Boolean.TRUE);
                    cloudNode.addChild(appNode);
                    String[] appTreeNodeInfo = new String[]{appArr[1], appId, cloudId};
                    treeNodeInfos.add(appTreeNodeInfo);
                    entitySet.forEach(entityNumName -> {
                        String[] entityArr = entityNumName.split("#");
                        if (alerdysetcheckbox.booleanValue() && !entityNumCach.contains(entityArr[0])) {
                            return;
                        }
                        String entityId = cloudInfoArr[0] + "#" + appArr[0] + "#" + entityArr[0] + "#entity";
                        TreeNode formNode = new TreeNode(appId, entityId, entityArr[1], (Object)Boolean.FALSE);
                        String[] entityTreeNodeInfo = new String[]{entityArr[1], entityId, appId};
                        treeNodeInfos.add(entityTreeNodeInfo);
                        appNode.addChild(formNode);
                    });
                });
            });
            view.getPageCache().put("treeNodeInfos", SerializationUtils.toJsonString((Object)treeNodeInfos));
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{entityDesignDs});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{entityDesignDs});
    }

    private static void setFieldPermTreeAppEntityNumCach(PermPageCacheUtil permPageCacheUtil, IFormView view, Map<String, RoleDataPermModel> dataPermMap) {
        Map<String, UserRoleFieldPermInfo> fieldPermData = permPageCacheUtil.getFieldPermData();
        HashSet appEntityNumSet = Sets.newHashSetWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(fieldPermData)) {
            fieldPermData.forEach((key, value) -> {
                List<FieldPermModel> fieldPermModelList = value.getFieldPermModelList();
                fieldPermModelList.forEach(fieldPermModel -> appEntityNumSet.add(fieldPermModel.getEntityNum()));
            });
            view.getPageCache().put("appEntityNumSet", SerializationUtils.toJsonString((Object)appEntityNumSet));
        }
    }

    private static void setDataRuleTreeAppEntityNumCach(IFormView view, Map<String, RoleDataPermModel> dataPermMap) {
        String currenHrBuca = (String)view.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        RoleDataPermModel roleDataPermModel = dataPermMap.get(currenHrBuca);
        Set<Object> appEntityNumSet = Sets.newHashSetWithExpectedSize((int)16);
        if (Objects.nonNull(roleDataPermModel)) {
            Map appEntity2DataRules = roleDataPermModel.getAppEntity2DataRules();
            appEntityNumSet = appEntity2DataRules.keySet();
            view.getPageCache().put("appEntityNumSet", SerializationUtils.toJsonString((Object)appEntityNumSet));
        }
    }

    private static void getTreeMap(Map<String, Set<String>> businessAppMap, Map<String, Map<String, Set<String>>> cloudInfoMap, String entityNumber, String[] entityNumberArr) {
        Set<String> appIdNames = businessAppMap.get(entityNumberArr[0]);
        appIdNames.forEach(appIdName -> {
            Set businessSet;
            String cloudidNameKey;
            Map appMap;
            String[] appIdNameArr = appIdName.split("#");
            HashMap bizCloudByAppIDMap = cloudNameIdMapCach.get(appIdNameArr[0]);
            if (CollectionUtils.isEmpty(bizCloudByAppIDMap)) {
                bizCloudByAppIDMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObject bizCloudByAppID = BizCloudServiceHelp.getBizCloudByAppID((String)appIdNameArr[0]);
                bizCloudByAppIDMap.put("id", bizCloudByAppID.getString("id"));
                bizCloudByAppIDMap.put("name", bizCloudByAppID.getString("name"));
                cloudNameIdMapCach.put(appIdNameArr[0], bizCloudByAppIDMap);
            }
            if (CollectionUtils.isEmpty((Map)(appMap = (Map)cloudInfoMap.get(cloudidNameKey = (String)bizCloudByAppIDMap.get("id") + "#" + (String)bizCloudByAppIDMap.get("name") + "#cloud")))) {
                appMap = Maps.newHashMapWithExpectedSize((int)16);
            }
            if (CollectionUtils.isEmpty((Collection)(businessSet = (Set)appMap.get(appIdName)))) {
                businessSet = Sets.newHashSetWithExpectedSize((int)16);
            }
            businessSet.add(entityNumber + "#entity");
            appMap.put(appIdName, businessSet);
            cloudInfoMap.put(cloudidNameKey, appMap);
        });
    }

    private static PermPageCacheUtil getPermPageCacheUtil(IFormView view) {
        String mainPageId = (String)view.getFormShowParameter().getCustomParam("mainPageId");
        PageCache pageCache = new PageCache(mainPageId, false);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil((IPageCache)pageCache);
        return permPageCacheUtil;
    }

    private static void getBuCaFunc(String appKey, String entityNumber, Map<String, Map<String, String>> allAppHrBuCaMap, Map<String, String> entityBuCaFuncMap, Map<String, Long> entitySpecFuncMap, Map<String, String> entityNumNameMap) {
        String entityName = entityNumNameMap.get(entityNumber);
        if (HRStringUtils.isEmpty((String)entityName)) {
            return;
        }
        String finalBuCaFuncId = "";
        Long aLong = entitySpecFuncMap.get(entityNumber);
        if (Objects.nonNull(aLong)) {
            finalBuCaFuncId = aLong.toString();
        }
        if (HRStringUtils.isEmpty((String)finalBuCaFuncId)) {
            finalBuCaFuncId = RoleMemberService.getHrBuCaFuncIdByApp(allAppHrBuCaMap, appKey, finalBuCaFuncId);
        }
        entityBuCaFuncMap.put(entityNumber + "#" + entityNumNameMap.getOrDefault(entityNumber, ""), finalBuCaFuncId);
    }

    private static String getHrBuCaFuncIdByApp(Map<String, Map<String, String>> allAppHrBuCaMap, String appKey, String finalBuCaFuncId) {
        String hrBuCaId;
        Map<String, String> buCaFuncMap = allAppHrBuCaMap.get(appKey);
        boolean find = false;
        if (!CollectionUtils.isEmpty(buCaFuncMap) && HRStringUtils.isNotEmpty((String)(hrBuCaId = buCaFuncMap.get("buCaFuncId")))) {
            finalBuCaFuncId = hrBuCaId + "#" + buCaFuncMap.get("name");
            find = true;
        }
        if (!find) {
            finalBuCaFuncId = "11";
        }
        return finalBuCaFuncId;
    }

    private static Map<String, String> getEntityMap(DataSet entityDesignDS) {
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)16);
        while (entityDesignDS.hasNext()) {
            Row row = entityDesignDS.next();
            entityMap.put(row.getString(ENT_NUM), row.getString("name"));
        }
        return entityMap;
    }

    private static DataSet getEntityDesignDs(String algoKeyPrefix) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entityinfo");
        return helper.queryDataSet(algoKeyPrefix + ENTITY_DESIGN_DS, "dentityid ent_id, id ent_num, name");
    }

    private static Map<String, List<String>> getAssignedAppEntityForCache(PermPageCacheUtil permPageCacheUtil) {
        List<Map<String, String>> funcPermDataList = permPageCacheUtil.getFuncPermDataList();
        HashMap<String, List<String>> assignedAppEntity = new HashMap<String, List<String>>(16);
        for (Map<String, String> map : funcPermDataList) {
            String appId = map.get("appId");
            String entityNumber = map.get("entityNumber");
            List list = assignedAppEntity.computeIfAbsent(appId, k -> Lists.newArrayListWithCapacity((int)16));
            list.remove(entityNumber);
            list.add(entityNumber);
        }
        return assignedAppEntity;
    }

    public static Map<String, UserRoleFieldPermInfo> getUserFieldPermInfoFromDatabase(String appIdStr, String entityNumStr, Long userRoleRelateId) {
        DynamicObject[] userFieldDys;
        HashMap userRoleFieldPermInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper roleFieldHelper = new HRBaseServiceHelper(HRCS_USER_FIELD);
        QFilter qFilter = new QFilter("userrolerealt", "=", (Object)userRoleRelateId);
        if (HRStringUtils.isNotEmpty((String)entityNumStr) && HRStringUtils.isNotEmpty((String)appIdStr)) {
            qFilter.and(new QFilter("entitytype", "=", (Object)entityNumStr)).and(new QFilter("app", "=", (Object)appIdStr));
        }
        if (Objects.isNull(userFieldDys = roleFieldHelper.query("id, app,entitytype, entryentity, entryentity.fieldname, entryentity.isbanread, entryentity.isbanwrite", new QFilter[]{qFilter}))) {
            return userRoleFieldPermInfoMap;
        }
        for (DynamicObject userFieldDy : userFieldDys) {
            String appId = userFieldDy.getString("app.id");
            String entityNum = userFieldDy.getString("entitytype_id");
            String key = appId + "@" + entityNum;
            UserRoleFieldPermInfo userRoleFieldPermInfo = new UserRoleFieldPermInfo();
            userRoleFieldPermInfo.setId(userFieldDy.getLong("id"));
            Map<String, String> fieldMap = RoleServiceHelper.getEntityFieldMap(entityNum);
            List<FieldPermModel> fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
            DynamicObjectCollection userFieldEntry = userFieldDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject userFieldRow : userFieldEntry) {
                FieldPermModel fieldPermModel = new FieldPermModel();
                fieldPermModel.setRoleFieldId(userRoleRelateId);
                fieldPermModel.setEntryId(userFieldRow.get("id"));
                String fieldName = userFieldRow.getString("fieldname");
                fieldPermModel.setFiledNum(fieldName);
                fieldPermModel.setEntityNum(entityNum);
                fieldPermModel.setFiledName(fieldMap.get(fieldName));
                fieldPermModel.setIsBanRead(userFieldRow.getString("isbanread"));
                fieldPermModel.setIsBanWrite(userFieldRow.getString("isbanwrite"));
                fieldPermModelList.add(fieldPermModel);
            }
            userRoleFieldPermInfoMap.put(key, userRoleFieldPermInfo);
        }
        return userRoleFieldPermInfoMap;
    }
}

