/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.PermFilesServiceHelper;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;

public class RoleModifyNotifyService {
    private static final Log LOGGER = LogFactory.getLog(RoleModifyNotifyService.class);

    public static void clearShowFormCacheByRoleId(String roleId) {
        LOGGER.info("RoleModifyNotifyService clearShowFormCacheByRoleId roleId:{}", (Object)roleId);
        if (HRStringUtils.isEmpty((String)roleId)) {
            return;
        }
        List influencedUser = PermissionServiceHelper.getUsersByRoleID((String)roleId);
        RoleModifyNotifyService.clearShowFormCacheByUserList(influencedUser);
    }

    public static void clearShowFormCacheByRoleId(Set<String> roleIds) {
        LOGGER.info("RoleModifyNotifyService clearShowFormCacheByRoleId roleIds:{}", roleIds);
        if (Objects.isNull(roleIds) || roleIds.isEmpty()) {
            return;
        }
        List<Long> influencedUser = roleIds.stream().map(PermissionServiceHelper::getUsersByRoleID).flatMap(Collection::stream).collect(Collectors.toList());
        RoleModifyNotifyService.clearShowFormCacheByUserList(influencedUser);
    }

    public static void clearShowFormCacheByUserId(Long userId) {
        LOGGER.info("RoleModifyNotifyService clearShowFormCacheByUserId userId:{}", (Object)userId);
        if (userId == null || userId == 0L) {
            return;
        }
        ArrayList influencedUser = Lists.newArrayListWithExpectedSize((int)1);
        influencedUser.add(userId);
        RoleModifyNotifyService.clearShowFormCacheByUserList(influencedUser);
    }

    public static void clearShowFormCacheByPermFileId(Long permFileId) {
        LOGGER.info("RoleModifyNotifyService clearShowFormCacheByPermFileId permFileId:{}", (Object)permFileId);
        Long userId = PermFilesServiceHelper.getUserIdByPermFile(permFileId);
        RoleModifyNotifyService.clearShowFormCacheByUserId(userId);
    }

    public static void clearShowFormCacheByPermFileIdList(List<Long> permFileIds) {
        LOGGER.info("RoleModifyNotifyService clearShowFormCacheByPermFileIdList permFileIds:{}", permFileIds);
        List<Long> userIds = PermFilesServiceHelper.getUserIdListByPermFile(permFileIds);
        RoleModifyNotifyService.clearShowFormCacheByUserList(userIds);
    }

    public static void clearShowFormCacheByUserList(List<Long> influencedUser) {
        LOGGER.info("RoleModifyNotifyService clearShowFormCacheByUserList influencedUser:{}", influencedUser);
        boolean notify = PermCheckUtil.getSysParamAuthorityChangeNotice();
        if (notify) {
            FormConfigFactory.cancelShowFormRights(influencedUser);
            FormConfigFactory.cancelShowFormDataRights(influencedUser);
        } else {
            LOGGER.info("The authority change notice switch has been disabled.");
        }
    }
}

