/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimDataCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.common.constants.MethodSource;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;

@ExcludeFromJacocoGeneratedReport
public class MultiBdCheckService {
    public static Set<String> getMulBdPropKeysByHasSetDataRule(long userId, String appId, String entityNumber, Map<String, Object> customParam) {
        Set<String> multiBdProps = MultiBdCheckService.getEntityMultiBdProps(entityNumber);
        if (CollectionUtils.isEmpty(multiBdProps)) {
            return multiBdProps;
        }
        HashSet dimMultiBdProps = Sets.newHashSetWithExpectedSize((int)multiBdProps.size());
        multiBdProps.forEach(prop -> dimMultiBdProps.add(prop));
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNumber, null);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            return Sets.newHashSetWithExpectedSize((int)16);
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, entityNumber, funcId, null);
        PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, MethodSource.METHOD_F7.getCode());
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            String roleId = userRoleInfo.getRoleId();
            List<RoleRuleInfo> rolePropDims = roleDimPropRelat.get(roleId);
            if (CollectionUtils.isEmpty(rolePropDims)) {
                dimMultiBdProps.clear();
                break;
            }
            Set props = rolePropDims.stream().map(rolePropDim -> MultiBdCheckService.splitBdPrefix(rolePropDim.getPropkey())).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(props)) {
                dimMultiBdProps.clear();
                break;
            }
            dimMultiBdProps.retainAll(props);
            if (!CollectionUtils.isEmpty((Collection)dimMultiBdProps)) continue;
            break;
        }
        HashSet dataRuleMultiBdProps = Sets.newHashSetWithExpectedSize((int)multiBdProps.size());
        multiBdProps.forEach(prop -> dataRuleMultiBdProps.add(prop));
        Set<Long> relatIds = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Map<String, Set<String>> roleBdPropMap = MultiBdCheckService.queryRoleBdDataRuleProp(roleIds, entityNumber);
        Map<Long, Set<String>> userBdPropMap = MultiBdCheckService.queryUserBdDataRuleProp(relatIds, entityNumber);
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            Set<Object> props = Sets.newHashSetWithExpectedSize((int)multiBdProps.size());
            if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
                roleBdPropMap.getOrDefault(userRoleInfo.getRoleId(), Sets.newHashSetWithExpectedSize((int)0));
                Set<String> userProps = userBdPropMap.getOrDefault(userRoleInfo.getRelatId(), Sets.newHashSetWithExpectedSize((int)0));
                props.addAll(userProps);
            } else {
                props = userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection() ? userBdPropMap.getOrDefault(userRoleInfo.getRelatId(), Sets.newHashSetWithExpectedSize((int)0)) : roleBdPropMap.getOrDefault(userRoleInfo.getRoleId(), Sets.newHashSetWithExpectedSize((int)0));
            }
            if (props == null) {
                props = Sets.newHashSetWithExpectedSize((int)16);
            }
            dataRuleMultiBdProps.retainAll(props);
            if (!CollectionUtils.isEmpty((Collection)dataRuleMultiBdProps)) continue;
            break;
        }
        dimMultiBdProps.addAll(dataRuleMultiBdProps);
        return dimMultiBdProps;
    }

    private static Set<String> getEntityMultiBdProps(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map fieldMap = entityType.getAllFields();
        HashSet multiBdProps = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry entry : fieldMap.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (!(property instanceof MulBasedataProp)) continue;
            multiBdProps.add(entry.getKey());
        }
        return multiBdProps;
    }

    private static Map<String, Set<String>> queryRoleBdDataRuleProp(Set<String> roleIds, String entityNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledatarule");
        DynamicObjectCollection bdDataRuleColl = helper.queryOriginalCollection("role.id,hrcs_rolebdruleentry.propkey", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNumber), new QFilter("role.id", "in", roleIds)});
        HashMap roleBdPropMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyna : bdDataRuleColl) {
            String roleId = dyna.getString("role.id");
            Set props = (Set)roleBdPropMap.get(roleId);
            if (props == null) {
                props = Sets.newHashSetWithExpectedSize((int)16);
                roleBdPropMap.put(roleId, props);
            }
            props.add(dyna.getString("hrcs_rolebdruleentry.propkey"));
        }
        return roleBdPropMap;
    }

    private static Map<Long, Set<String>> queryUserBdDataRuleProp(Set<Long> userRoleIdSet, String entityNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userdatarule");
        DynamicObjectCollection bdDataRuleColl = helper.queryOriginalCollection("userrolerelate.id,bddataruleentry.propkey", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNumber), new QFilter("userrolerelate.id", "in", userRoleIdSet)});
        HashMap userBdPropMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyna : bdDataRuleColl) {
            Long relatId = dyna.getLong("userrolerelate.id");
            Set props = (Set)userBdPropMap.get(relatId);
            if (props == null) {
                props = Sets.newHashSetWithExpectedSize((int)16);
                userBdPropMap.put(relatId, props);
            }
            props.add(dyna.getString("bddataruleentry.propkey"));
        }
        return userBdPropMap;
    }

    private static String splitBdPrefix(String prop) {
        if (HRStringUtils.isEmpty((String)prop)) {
            return prop;
        }
        String[] arr = prop.split("\\.");
        return arr[0];
    }
}

