/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimDataCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRDataPermServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.UserRoleInfo;
import kd.hr.hrcs.common.util.LoggerStrUtil;

public class PermCheckService {
    private static final Log LOGGER = LogFactory.getLog(PermCheckService.class);

    public static QFilter assembleUserPermQFilter(Long userId, String appId, String entityNumber, String permItemId, Map<String, Object> customParam) {
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNumber, permItemId);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService assembleUserPermQFilter roleList is empty,return all.");
            return null;
        }
        Map<Long, QFilter> dimQFilterMap = PermDimDataCheckService.assembleUserDimValueQFilter(userId, appId, entityNumber, userRoleInfoList, customParam);
        Map<Object, Object> ruleQFilterMap = null;
        String ignoreDataRulePerm = (String)customParam.get("hr_dataperm_ignoreDataRulePerm");
        ruleQFilterMap = Objects.equals(ignoreDataRulePerm, "true") ? Maps.newHashMapWithExpectedSize((int)0) : HRDataPermServiceHelper.assembleUserEntryDataRuleQFilter(userId, appId, entityNumber, permItemId, userRoleInfoList);
        return PermCheckService.mergeRuleAndDimQFilter(userRoleInfoList, entityNumber, ruleQFilterMap, dimQFilterMap);
    }

    private static QFilter mergeRuleAndDimQFilter(List<UserRoleInfo> userRoleInfoList, String entityNumber, Map<Long, QFilter> ruleQFilterMap, Map<Long, QFilter> dimQFilterMap) {
        QFilter resultFilter = null;
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            QFilter dimQFilter;
            Long relatId = userRoleInfo.getRelatId();
            QFilter ruleQFilter = CollectionUtils.isEmpty(ruleQFilterMap) ? null : ruleQFilterMap.get(relatId);
            QFilter singleRelateFilter = HRPermCommonUtil.qFilterAnd((QFilter)ruleQFilter, (QFilter)(dimQFilter = CollectionUtils.isEmpty(dimQFilterMap) ? null : dimQFilterMap.get(relatId)));
            if (singleRelateFilter == null) {
                return null;
            }
            resultFilter = HRPermCommonUtil.qFilterOr(resultFilter, (QFilter)singleRelateFilter);
        }
        LOGGER.info("HRDataPermService mergeRuleAndDimQFilter resultFilter:{}", (Object)LoggerStrUtil.qFilterToString(resultFilter));
        return resultFilter;
    }

    public static QFilter assembleUserPermFilter4BdProp(Long userId, String appId, String parentEntityNumber, String propEntityNumber, String propKey, String propFullKey, String permItemId, Map<String, Object> customParam) {
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, parentEntityNumber, permItemId);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService assembleUserPermFilter4BdProp roleList is empty,return null.");
            return null;
        }
        Map<Long, QFilter> dataRuleFilterMap = HRDataPermServiceHelper.assembleUserBaseDataDataRuleQFilter(userId, appId, parentEntityNumber, propEntityNumber, propKey, permItemId);
        Map<Long, QFilter> dimValueFilter = PermDimDataCheckService.assembleUserF7DimValueQFilter(userId, appId, parentEntityNumber, propKey, propFullKey, userRoleInfoList, permItemId, customParam);
        QFilter resultFilter = PermCheckService.mergeRuleAndDimQFilter(userRoleInfoList, parentEntityNumber, dataRuleFilterMap, dimValueFilter);
        LOGGER.info("HRDataPermService assembleUserPermFilter4BdProp resultFilter {}", (Object)LoggerStrUtil.qFilterToString((QFilter)resultFilter));
        return resultFilter;
    }

    public static boolean isCustomParamHasAll(Map<String, Object> customParam) {
        if (customParam.get("hr_dataperm_hasall") == null) {
            return false;
        }
        String hasAllStr = (String)customParam.get("hr_dataperm_hasall");
        return HRStringUtils.equals((String)hasAllStr, (String)"true");
    }

    public static void convertCustomParamStructProjectType(Map<String, Object> customParam) {
        if (CollectionUtils.isEmpty(customParam)) {
            return;
        }
        for (Map.Entry<String, Object> entry : customParam.entrySet()) {
            Object dataPermStructProjectIdObj;
            String key = entry.getKey();
            if (!key.startsWith("hr_dataperm_structprojectid") || !((dataPermStructProjectIdObj = entry.getValue()) instanceof String)) continue;
            String dataPermStructProjectIdStr = (String)dataPermStructProjectIdObj;
            List dataPermStructProjectIds = (List)SerializationUtils.fromJsonString((String)dataPermStructProjectIdStr, List.class);
            ArrayList longList = Lists.newArrayListWithExpectedSize((int)dataPermStructProjectIds.size());
            for (Object structId : dataPermStructProjectIds) {
                longList.add(Long.parseLong(structId.toString()));
            }
            entry.setValue(longList);
        }
    }

    public static List<Long> getStructProjectIdsFromCustomParam(Map<String, Object> customParam, String propkey) {
        String structProjectIdKey = "hr_dataperm_structprojectid_prop_" + propkey;
        if (customParam.containsKey(structProjectIdKey)) {
            return (List)customParam.get(structProjectIdKey);
        }
        if (customParam.containsKey("hr_dataperm_structprojectid")) {
            return (List)customParam.get("hr_dataperm_structprojectid");
        }
        return null;
    }

    public static boolean containDynaCondNotNull(List<DimValue> dimValues) {
        if (CollectionUtils.isEmpty(dimValues)) {
            return false;
        }
        for (DimValue dimValue : dimValues) {
            if (!HRStringUtils.equals((String)dimValue.getDimVal(), (String)"DYNACOND_DIMVAL_NOTNULL_TAG")) continue;
            return true;
        }
        return false;
    }
}

