/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;

public class PermDimFuncService {
    private static final Log LOG = LogFactory.getLog(PermDimFuncService.class);

    public static Long getCheckFuncId(String appId, String entityNum) {
        Long funcId = PermDimFuncService.getEntityFuncIdByDb(entityNum);
        LOG.info("HRDataPermService getCheckFuncId from hrcs_entityspecfunc,appid:{},entityNum:{},funcId:{}", new Object[]{appId, entityNum, funcId});
        if (funcId == null) {
            funcId = HRBuCaServiceHelper.getAppFuncId(appId);
            LOG.info("HRDataPermService getCheckFuncId from app,appid:{},entityNum:{},funcId:{}", new Object[]{appId, entityNum, funcId});
            if (funcId == null) {
                funcId = HRCSBaseConstants.DEF_HR_FUNCID;
            }
        }
        LOG.info("HRDataPermService getCheckFuncId result,appid:{},entityNum:{},funcId:{}", new Object[]{appId, entityNum, funcId});
        return funcId;
    }

    private static Long getEntityFuncIdByDb(String entityNum) {
        HRBaseServiceHelper specFuncHelper = new HRBaseServiceHelper("hrcs_entityspecfunc");
        DynamicObject dyno = specFuncHelper.queryOriginalOne("bucafunc.id", new QFilter("entity.number", "=", (Object)entityNum));
        if (dyno == null) {
            return null;
        }
        return dyno.getLong("bucafunc.id");
    }

    public static Long getEntityFuncId(String entityNum) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String mainOrg = mainEntityType.getMainOrg();
        if (HRStringUtils.isEmpty((String)mainOrg)) {
            return null;
        }
        OrgProp orgProp = (OrgProp)mainEntityType.getProperty(mainOrg);
        if (orgProp == null) {
            return null;
        }
        String orgFunc = orgProp.getOrgFunc();
        return StringUtils.isEmpty((String)orgFunc) ? null : Long.valueOf(Long.parseLong(orgFunc));
    }
}

