/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.DimEft;
import kd.hr.hrcs.common.model.RoleRuleInfo;

public class RoleDimRelatService {
    private static final Log LOGGER = LogFactory.getLog(RoleDimRelatService.class);

    public static Map<String, List<RoleRuleInfo>> getRoleDimPropRelat(Set<String> roles, String appId, String entityNum, Long funcId, String propKey) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)0);
        if (CollectionUtils.isEmpty(roles)) {
            return data;
        }
        boolean flag = HRStringUtils.isEmpty((String)propKey);
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)16);
        filterList.add(new QFilter("entry.entitytype", "=", (Object)entityNum));
        filterList.add(new QFilter("entry.app", "=", (Object)appId));
        filterList.add(new QFilter("role", "in", roles));
        filterList.add(new QFilter("bucafunc", "=", (Object)funcId));
        if (!flag) {
            QFilter selfQFilter = new QFilter("entry.propkey", "=", (Object)propKey);
            QFilter cascadeQFilter = new QFilter("entry.propkey", "like", (Object)(propKey + ".%"));
            selfQFilter.or(cascadeQFilter);
            filterList.add(selfQFilter);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject[] relatDynoArr = helper.query("role,dimension,entry.propkey,entry.entitytype,entry.app,entry.propkey,entry.enable", HRPermCommonUtil.listToQFilters((List)filterList));
        boolean customEntityDim = PermCheckUtil.getSysParamCustomEntityDim();
        for (DynamicObject relatDyno : relatDynoArr) {
            DynamicObjectCollection entryColl = relatDyno.getDynamicObjectCollection("entry");
            String roleId = relatDyno.getString("role.id");
            for (DynamicObject entryDyno : entryColl) {
                String relatPropKey = entryDyno.getString("propkey");
                if (!HRStringUtils.equals((String)entityNum, (String)entryDyno.getString("entitytype.number")) || !HRStringUtils.equals((String)appId, (String)entryDyno.getString("app.id")) || !flag && !HRStringUtils.equals((String)relatPropKey, (String)propKey) && !relatPropKey.startsWith(propKey + ".")) continue;
                List propList = data.computeIfAbsent(roleId, key -> Lists.newArrayListWithExpectedSize((int)16));
                RoleDimRelatService.addRoleDimValue(roleId, entryDyno, relatDyno, propList, customEntityDim);
            }
        }
        LOGGER.info("HRDataPermService getRoleDimPropRelat() dataResult:{}", (Object)data);
        RoleDimRelatService.initCrossot(data, entityNum);
        return data;
    }

    private static void initCrossot(Map<String, List<RoleRuleInfo>> roleDimPropRelat, String entityNum) {
        Set<Long> dimIdSet = RoleDimRelatService.getDimIdSet(roleDimPropRelat);
        List<DimEft> dimAuthRangeList = RoleDimRelatService.getDimAuthRange(entityNum, dimIdSet);
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            for (RoleRuleInfo rr : entry.getValue()) {
                Optional<DimEft> first = dimAuthRangeList.stream().filter(it -> it.getDimensionId().equals(rr.getDimensionId()) && it.getPropKey().equalsIgnoreCase(rr.getPropkey())).findFirst();
                if (!first.isPresent()) continue;
                rr.setCrossot(first.get().getCrossot());
                rr.setAuthRange(first.get().getAuthRange());
            }
        }
    }

    public static List<DimEft> getDimAuthRange(String entityNum, Set<Long> dimIdSet) {
        ArrayList dimEftLst = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)16);
        qFilters.add(new QFilter("entitytype", "=", (Object)entityNum));
        qFilters.add(new QFilter("entryentity.dimension", "in", dimIdSet));
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] dyns = entityCtrlHelper.query("entitytype,entryentity.dimension,entryentity.authrange,entryentity.crossot,entryentity.propkey", HRPermCommonUtil.listToQFilters((List)qFilters));
        List<Object> crossot = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dyn : dyns) {
            DynamicObjectCollection entryColl = dyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : entryColl) {
                DynamicObjectCollection croDy = dy.getDynamicObjectCollection("crossot");
                if (Objects.nonNull(croDy)) {
                    crossot = croDy.stream().map(newIt -> Long.parseLong(newIt.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList());
                }
                String dbPropKey = dy.getString("propkey");
                Long dimensionId = dy.getLong("dimension.id");
                DimEft dimEft = new DimEft(dy.getString("authrange"), (List)crossot, dbPropKey, dimensionId);
                dimEftLst.add(dimEft);
            }
        }
        return dimEftLst;
    }

    private static Set<Long> getDimIdSet(Map<String, List<RoleRuleInfo>> roleDimPropRelat) {
        HashSet dimIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            dimIdSet.addAll(entry.getValue().stream().map(RoleRuleInfo::getDimensionId).collect(Collectors.toSet()));
        }
        return dimIdSet;
    }

    private static void addRoleDimValue(String roleId, DynamicObject entryDyno, DynamicObject relatDyno, List<RoleRuleInfo> propList, boolean customEntityDim) {
        if (!customEntityDim || customEntityDim && entryDyno.getBoolean("enable")) {
            String hisModelType;
            RoleRuleInfo roleRuleInfo = new RoleRuleInfo(roleId, entryDyno.getString("entitytype.number"), Long.valueOf(relatDyno.getLong("dimension.id")), relatDyno.getString("dimension.number"), entryDyno.getString("propkey"), Boolean.valueOf(entryDyno.getBoolean("enable")));
            String dimEntityNumber = relatDyno.getString("dimension.entitytype.number");
            roleRuleInfo.setDimEntityNumber(dimEntityNumber);
            roleRuleInfo.setDimensionType(relatDyno.getString("dimension.datasource"));
            roleRuleInfo.setDimensionShowType(relatDyno.getString("dimension.showtype"));
            roleRuleInfo.setOrgFuncId(Long.valueOf(relatDyno.getLong("dimension.hrbu.id")));
            Boolean isHisModel = Boolean.FALSE;
            if (HRStringUtils.isNotEmpty((String)dimEntityNumber) && !HRStringUtils.equals((String)(hisModelType = HisCommonService.getInstance().entityInhRelation(dimEntityNumber)), (String)EnumEntityTpl.COMMON_TPL.getNumber())) {
                isHisModel = Boolean.TRUE;
            }
            roleRuleInfo.setHisModel(isHisModel.booleanValue());
            propList.add(roleRuleInfo);
        }
    }

    public static Long getAdminOrgDimId() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject dyno = helper.queryOriginalOne("id", new QFilter("isadminorg", "=", (Object)"1"));
        if (dyno == null) {
            return null;
        }
        return dyno.getLong("id");
    }

    public static Map<String, List<Map<String, Object>>> getEntityDimList(QFilter entityDimQfilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObjectCollection dimArr = helper.queryOriginalCollection("entryentity.dimension,entitytype.number,entryentity.ismust,entryentity.propkey", new QFilter[]{entityDimQfilter});
        HashMap mapResult = Maps.newHashMapWithExpectedSize((int)dimArr.size());
        for (DynamicObject dy : dimArr) {
            String entityNum = dy.getString("entitytype.number");
            Long dim = dy.getLong("entryentity.dimension");
            Boolean isMust = dy.getBoolean("entryentity.ismust");
            String propKey = dy.getString("entryentity.propkey");
            HashMap<String, Object> dimMap = new HashMap<String, Object>(2);
            dimMap.put("dim", dim);
            dimMap.put("ismust", isMust);
            dimMap.put("propkey", propKey);
            mapResult.computeIfAbsent(entityNum, key -> new ArrayList(16)).add(dimMap);
        }
        return mapResult;
    }
}

