/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.MatchDataRuleByScriptService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.DimValueGroup;

@ExcludeFromJacocoGeneratedReport
public class UserAdminOrgService {
    private static final Log LOGGER = LogFactory.getLog(MatchDataRuleByScriptService.class);
    private static final Long ADMINORGDIM_ID = 1109486343509107712L;
    private static final Long ADMINORGDIM_OTCLASSIFY_ID = 1010L;
    private static final Long ADMINORGDIM_STRUCTPROJECT_ID = 1010L;

    public static HrApiResponse<Map<String, Object>> getUserListByAdminOrg(String appId, String entityNumber, String roleNumber, Long adminOrgId) {
        DynamicObject sysRoleDyn = UserAdminOrgService.getSysRoleDyna(roleNumber);
        if (sysRoleDyn == null) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)String.format("role number:%s not exist in bos or disabled.", roleNumber));
        }
        String roleId = sysRoleDyn.getString("id");
        DynamicObject hmpRoleDyn = UserAdminOrgService.getHmpRoleDyna(roleId);
        if (hmpRoleDyn == null) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)String.format("role number:%s not exist in hmp.", roleNumber));
        }
        ArrayList hasPermUserIdList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection relatDynaColl = UserAdminOrgService.getUserRoleRelatDynaColl(roleId);
        if (CollectionUtils.isEmpty((Collection)relatDynaColl)) {
            LOGGER.info("getUserListByAdminOrg userRoleRelat is null. return null list.");
            HashMap resultData = Maps.newHashMapWithExpectedSize((int)1);
            resultData.put("userIds", hasPermUserIdList);
            return HrApiResponse.success((Object)resultData);
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber);
        HashSet roleIds = Sets.newHashSet((Object[])new String[]{roleId});
        HashSet dimIds = Sets.newHashSet((Object[])new Long[]{ADMINORGDIM_ID});
        Set<Long> relationIds = relatDynaColl.stream().map(dyna -> dyna.getLong("id")).collect(Collectors.toSet());
        Map<String, List<DimValueGroup>> roleDimGroupMap = DataRangeServiceHelperWithCache.getRoleDimValGroupWithCache(roleIds, funcId, dimIds);
        Map<Long, List<DimValueGroup>> userRoleDimGroupMap = DataRangeServiceHelperWithCache.getUserRoleDimValGroupWithCache(relationIds, funcId, dimIds);
        ArrayList allAdminOrgs = Lists.newArrayListWithExpectedSize((int)16);
        allAdminOrgs.add(adminOrgId);
        List<DimValueGroup> roleDimValueGroups = roleDimGroupMap.get(roleId);
        allAdminOrgs.addAll(UserAdminOrgService.collectAllAdminOrgId(roleDimValueGroups));
        for (Map.Entry<Long, List<DimValueGroup>> entry : userRoleDimGroupMap.entrySet()) {
            allAdminOrgs.addAll(UserAdminOrgService.collectAllAdminOrgId(entry.getValue()));
        }
        Map<Long, String> adminOrgLongNumberMap = UserAdminOrgService.getAdminOrgStructLongNumber(allAdminOrgs);
        if (HRStringUtils.isEmpty((String)adminOrgLongNumberMap.get(adminOrgId))) {
            return HrApiResponse.fail((String)EnumResponseCode.FAIL.getCode(), (String)String.format("target adminorgId:%s structlongnumber is null.", adminOrgId));
        }
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        boolean isRoleContainDynaCond = DynaCondConverter.hasDynaCondInGroup(roleDimGroupMap);
        boolean isRoleContainAdminOrg = false;
        if (!isRoleContainDynaCond) {
            isRoleContainAdminOrg = UserAdminOrgService.isContainAdminOrg(adminOrgLongNumberMap, UserAdminOrgService.collectAdminOrgDimValues(roleDimValueGroups), adminOrgId);
        }
        LinkedHashMap dimPropType = Maps.newLinkedHashMapWithExpectedSize((int)1);
        dimPropType.put(ADMINORGDIM_ID, "long");
        String isIntersectionStr = hmpRoleDyn.getString("isintersection");
        boolean isIntersection = HRStringUtils.equals((String)isIntersectionStr, (String)"1") || HRStringUtils.equals((String)isIntersectionStr, (String)"2");
        LinkedHashSet hasPermUserIdSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        for (DynamicObject relatDyna : relatDynaColl) {
            Long userId = relatDyna.getLong("user.id");
            Long relatId = relatDyna.getLong("id");
            if (isRoleContainDynaCond) {
                Map<?, List<DimValueGroup>> roleDimGroupMapUser = DynaCondConverter.groupDynaCondConvertClone(userId, roleDimGroupMap, dimPropType, dynaCondMap);
                UserAdminOrgService.reAddLongNumber(adminOrgLongNumberMap, UserAdminOrgService.collectAllAdminOrgId(roleDimGroupMapUser.get(roleId)));
                isRoleContainAdminOrg = UserAdminOrgService.isContainAdminOrg(adminOrgLongNumberMap, UserAdminOrgService.collectAdminOrgDimValues(roleDimGroupMapUser.get(roleId)), adminOrgId);
            }
            Map<Object, Object> singleRelatDimGroupMap = Maps.newHashMapWithExpectedSize((int)1);
            List<DimValueGroup> singleRelatDimGroup = userRoleDimGroupMap.get(relatId);
            if (!Objects.isNull(singleRelatDimGroup)) {
                singleRelatDimGroupMap.put(relatId, userRoleDimGroupMap.get(relatId));
                singleRelatDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, singleRelatDimGroupMap, dimPropType, dynaCondMap);
            }
            UserAdminOrgService.reAddLongNumber(adminOrgLongNumberMap, UserAdminOrgService.collectAllAdminOrgId((List)singleRelatDimGroupMap.get(relatId)));
            if (!UserAdminOrgService.isUserRelatContainAdminOrg(relatDyna, adminOrgLongNumberMap, singleRelatDimGroupMap, adminOrgId, isIntersection, isRoleContainAdminOrg)) continue;
            hasPermUserIdSet.add(userId);
        }
        hasPermUserIdList.addAll(hasPermUserIdSet);
        HashMap resultData = Maps.newHashMapWithExpectedSize((int)1);
        resultData.put("userIds", hasPermUserIdList);
        return HrApiResponse.success((Object)resultData);
    }

    public static void reAddLongNumber(Map<Long, String> adminOrgLongNumberMap, List<Long> orgIds) {
        ArrayList needAddOrgIds = Lists.newArrayListWithExpectedSize((int)16);
        for (Long orgId : orgIds) {
            if (Objects.equals(orgId, 0L) || adminOrgLongNumberMap.containsKey(orgId)) continue;
            needAddOrgIds.add(orgId);
        }
        if (CollectionUtils.isEmpty((Collection)needAddOrgIds)) {
            return;
        }
        Map<Long, String> needAddOrgLongNumberMap = UserAdminOrgService.getAdminOrgStructLongNumber(needAddOrgIds);
        if (!CollectionUtils.isEmpty(needAddOrgLongNumberMap)) {
            adminOrgLongNumberMap.putAll(needAddOrgLongNumberMap);
        }
    }

    private static boolean isUserRelatContainAdminOrg(DynamicObject relatDyna, Map<Long, String> adminOrgLongNumberMap, Map<Long, List<DimValueGroup>> userRoleDimGroupMap, Long adminOrgId, boolean isIntersection, boolean isRoleContainAdminOrg) {
        boolean isCustom = relatDyna.getBoolean("customenable");
        Long relatId = relatDyna.getLong("id");
        Long userId = relatDyna.getLong("user.id");
        if (isCustom) {
            List<DimValueGroup> dimValueGroups = userRoleDimGroupMap.get(relatId);
            boolean isUserContainAdminOrg = UserAdminOrgService.isContainAdminOrg(adminOrgLongNumberMap, UserAdminOrgService.collectAdminOrgDimValues(dimValueGroups), adminOrgId);
            if (isIntersection ? isUserContainAdminOrg && isRoleContainAdminOrg : isUserContainAdminOrg) {
                return true;
            }
        } else if (isRoleContainAdminOrg) {
            return true;
        }
        return false;
    }

    public static DynamicObject getSysRoleDyna(String roleNumber) {
        HRBaseServiceHelper sysRoleHelper = new HRBaseServiceHelper("perm_role");
        return sysRoleHelper.queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)roleNumber), new QFilter("enable", "=", (Object)"1")});
    }

    public static DynamicObject getHmpRoleDyna(String roleId) {
        HRBaseServiceHelper hmpRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObject hmpRoleDyn = hmpRoleHelper.queryOne("property,isintersection", new QFilter("id", "=", (Object)roleId));
        return hmpRoleDyn;
    }

    public static DynamicObjectCollection getUserRoleRelatDynaColl(String roleId) {
        HRBaseServiceHelper relatHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)16);
        qFilterList.add(new QFilter("role.id", "=", (Object)roleId));
        qFilterList.add(new QFilter("permfile.permfileenable", "=", (Object)"1"));
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            Date today = new Date();
            qFilterList.add(new QFilter("validstart", "<=", (Object)today).or(QFilter.of((String)"validstart is null", (Object[])new Object[0])));
            qFilterList.add(new QFilter("validend", ">=", (Object)today).or(QFilter.of((String)"validend is null", (Object[])new Object[0])));
        }
        DynamicObjectCollection relatDynaColl = relatHelper.queryOriginalCollection("id,user.id,customenable", HRPermCommonUtil.listToQFilters((List)qFilterList));
        return relatDynaColl;
    }

    public static boolean isContainAdminOrg(Map<Long, String> adminOrgLongNumberMap, List<DimValue> dimValues, Long adminOrgId) {
        if (CollectionUtils.isEmpty(dimValues)) {
            return true;
        }
        String targetLongNumber = adminOrgLongNumberMap.get(adminOrgId);
        for (DimValue dimValue : dimValues) {
            String longNumber;
            if (HRStringUtils.isEmpty((String)dimValue.getDimVal()) || !HRStringUtils.equals((String)targetLongNumber, (String)(longNumber = adminOrgLongNumberMap.get(Long.parseLong(dimValue.getDimVal())))) && (!dimValue.isContainsSub() || !targetLongNumber.startsWith(longNumber))) continue;
            return true;
        }
        return false;
    }

    public static Map<Long, String> getAdminOrgStructLongNumber(List<Long> adminOrgIds) {
        HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObjectCollection orgDynaColl = orgTeamHelper.queryOriginalCollection("orgteam.id,structlongnumber", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("orgteam.id", "in", adminOrgIds), new QFilter("structproject.id", "=", (Object)ADMINORGDIM_STRUCTPROJECT_ID)});
        HashMap result = Maps.newHashMapWithExpectedSize((int)orgDynaColl.size());
        for (DynamicObject dynamicObject : orgDynaColl) {
            result.put(dynamicObject.getLong("orgteam.id"), dynamicObject.getString("structlongnumber"));
        }
        return result;
    }

    private static List<Long> collectAllAdminOrgId(List<DimValueGroup> dimValueGroups) {
        List<DimValue> dimValues = UserAdminOrgService.collectAdminOrgDimValues(dimValueGroups);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dimValues)) {
            return result;
        }
        for (DimValue dimValue : dimValues) {
            if (!HRStringUtils.isNotEmpty((String)dimValue.getDimVal())) continue;
            result.add(Long.parseLong(dimValue.getDimVal()));
        }
        return result;
    }

    private static List<DimValue> collectAdminOrgDimValues(List<DimValueGroup> dimValueGroups) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dimValueGroups)) {
            return result;
        }
        for (DimValueGroup valueGroup : dimValueGroups) {
            List dimValues;
            Map dimValueMap = valueGroup.getDimValuesMap();
            if (dimValueMap == null || CollectionUtils.isEmpty((Collection)(dimValues = (List)dimValueMap.get(ADMINORGDIM_ID)))) continue;
            for (DimValue dimValue : dimValues) {
                if (!Objects.equals(dimValue.getStructProjectId(), ADMINORGDIM_STRUCTPROJECT_ID)) continue;
                result.add(dimValue);
            }
        }
        return result;
    }
}

