/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DataRangeServiceHelper;
import kd.hr.hrcs.common.model.DimValueGroup;

public class DataRangeServiceHelperWithCache {
    public static Map<String, List<String>> queryRoleDataRuleWithCache(Set<String> roleIdSet, String appId, String entityId, String permItemId) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4DataRule();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = roleIdSet + "_" + appId + "_" + entityId + "_" + permItemId);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<String, List<String>> userRoleInfoList = DataRangeServiceHelper.queryRoleDataRule(roleIdSet, appId, entityId, permItemId);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(userRoleInfoList));
            return userRoleInfoList;
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
    }

    public static Map<Long, List<String>> queryUserDataRuleWithCache(Set<Long> userRoleRelIdSet, String appId, String entityId, String permItemId) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4DataRule();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = userRoleRelIdSet + "_" + appId + "_" + entityId + "_" + permItemId);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<Long, List<String>> userRoleInfoList = DataRangeServiceHelper.queryUserDataRule(userRoleRelIdSet, appId, entityId, permItemId);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(userRoleInfoList));
            return userRoleInfoList;
        }
        Map strKeyMap = (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
        return DataRangeServiceHelperWithCache.convertStringKeyToLong(strKeyMap);
    }

    public static Map<String, List<DimValueGroup>> getRoleDimValGroupWithCache(Set<String> roleIds, Long funcId, Set<Long> dimIds) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4RoleDimValue();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = roleIds + "_" + funcId + "_" + dimIds);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<String, List<DimValueGroup>> dbResult = DataRangeServiceHelper.getRoleDimValGroup(roleIds, funcId, dimIds);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(dbResult));
            return dbResult;
        }
        return DataRangeServiceHelperWithCache.convertToDimValueGroupType((Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class));
    }

    public static Map<Long, List<DimValueGroup>> getUserRoleDimValGroupWithCache(Set<Long> relatIds, Long funcId, Set<Long> dimIds) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4UserDimValue();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = relatIds + "_" + funcId + "_" + dimIds);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<Long, List<DimValueGroup>> dbResult = DataRangeServiceHelper.getUserRoleDimValGroup(relatIds, funcId, dimIds);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(dbResult));
            return dbResult;
        }
        Map strKeyMap = DataRangeServiceHelperWithCache.convertToDimValueGroupType((Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class));
        return DataRangeServiceHelperWithCache.convertStringKeyToLong(strKeyMap);
    }

    private static <V> Map<Long, V> convertStringKeyToLong(Map<String, V> map) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            result.put(Long.parseLong(entry.getKey()), entry.getValue());
        }
        return result;
    }

    private static <K> Map<K, List<DimValueGroup>> convertToDimValueGroupType(Map<K, List<Map>> map) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<K, List<Map>> entry : map.entrySet()) {
            List<Map> oriList = entry.getValue();
            ArrayList infoList = Lists.newArrayListWithExpectedSize((int)oriList.size());
            for (Map infoMap : oriList) {
                String str = SerializationUtils.toJsonString((Object)infoMap);
                DimValueGroup roleRuleInfo = (DimValueGroup)SerializationUtils.fromJsonString((String)str, DimValueGroup.class);
                infoList.add(roleRuleInfo);
            }
            result.put(entry.getKey(), infoList);
        }
        return result;
    }

    public static Map<String, List<String>> getRoleBDDataRuleJsonWithCache(Set<String> roleIdSet, String entityNum, String propKey, String appId) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4BdDataRule();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = roleIdSet + "_" + appId + "_" + entityNum + "_" + propKey);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<String, List<String>> dbResult = DataRangeServiceHelper.getRoleBDDataRuleJson(roleIdSet, entityNum, propKey, appId);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(dbResult));
            return dbResult;
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
    }

    public static Map<Long, List<String>> getUserDBDataRuleJsonWithCache(Set<Long> userRoleIdSet, String entityId, String propKey, String appId) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4BdDataRule();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = userRoleIdSet + "_" + appId + "_" + entityId + "_" + propKey);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<Long, List<String>> dbResult = DataRangeServiceHelper.getUserDBDataRuleJson(userRoleIdSet, entityId, propKey, appId);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(dbResult));
            return dbResult;
        }
        Map strKeyMap = (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
        return DataRangeServiceHelperWithCache.convertStringKeyToLong(strKeyMap);
    }
}

