/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.check.DimService;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimFuncService;
import kd.hr.hrcs.bussiness.service.perm.check.RoleDimRelatService;
import kd.hr.hrcs.common.model.RoleRuleInfo;

public class DimServiceWithCache {
    private static final Log LOGGER = LogFactory.getLog(DimServiceWithCache.class);

    public static Long getCheckFuncIdWithCache(String appId, String entityNum) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4EntityFunc();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = appId + "_" + entityNum);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Long dbResult = PermDimFuncService.getCheckFuncId(appId, entityNum);
            HRPermCacheMgr.putCache(cacheType, cacheKey, String.valueOf(dbResult));
            return dbResult;
        }
        LOGGER.info("HRDataPermService getCheckFuncIdWithCache result:{}", (Object)cacheVal);
        return Long.parseLong(cacheVal);
    }

    public static Map<String, List<RoleRuleInfo>> getRoleDimPropRelatWithCache(Set<String> roles, String appId, String entityNum, Long funcId, String propKey) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4RoleDimPropRelat();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = roles + "_" + appId + "_" + entityNum + "_" + funcId + "_" + propKey);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<String, List<RoleRuleInfo>> dbResult = RoleDimRelatService.getRoleDimPropRelat(roles, appId, entityNum, funcId, propKey);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(dbResult));
            return dbResult;
        }
        return DimServiceWithCache.convertToRoleRuleInfoType((Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class));
    }

    private static Map<String, List<RoleRuleInfo>> convertToRoleRuleInfoType(Map<String, List<Map>> map) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<String, List<Map>> entry : map.entrySet()) {
            List<Map> oriList = entry.getValue();
            ArrayList infoList = Lists.newArrayListWithExpectedSize((int)oriList.size());
            for (Map infoMap : oriList) {
                String str = SerializationUtils.toJsonString((Object)infoMap);
                RoleRuleInfo roleRuleInfo = (RoleRuleInfo)SerializationUtils.fromJsonString((String)str, RoleRuleInfo.class);
                infoList.add(roleRuleInfo);
            }
            result.put(entry.getKey(), infoList);
        }
        return result;
    }

    public static Map<Long, String> calCheckPropTypeWithCache(Set<Long> dimIds) {
        String cacheKey;
        String cacheType = HRPermCacheMgr.getType4RoleDimValueType();
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey = dimIds.toString());
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            Map<Long, String> dbResult = DimService.calCheckPropType(dimIds);
            HRPermCacheMgr.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(dbResult));
            return dbResult;
        }
        Map cacheMap = (Map)SerializationUtils.fromJsonString((String)cacheVal, Map.class);
        HashMap targetMap = Maps.newHashMapWithExpectedSize((int)16);
        cacheMap.forEach((key, value) -> targetMap.put(Long.parseLong(key), value));
        return targetMap;
    }
}

