/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.perm.dyna.condhandler.IDynaCondParser;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.FixedDimValue;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.DimValueGroup;

@ExcludeFromJacocoGeneratedReport
public class DynaCondConverter {
    private static final Log LOGGER = LogFactory.getLog(DynaCondConverter.class);

    public static Map<?, List<DimValue>> dimDynaCondConvertClone(Long userId, Map<?, List<DimValue>> dimValueMap, String dimPropType, Map<Long, DynamicObject> dynaCondMap) {
        if (CollectionUtils.isEmpty(dimValueMap)) {
            return dimValueMap;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dimValueMap.size());
        for (Map.Entry<?, List<DimValue>> dimValueEntry : dimValueMap.entrySet()) {
            List<DimValue> dimValues = dimValueEntry.getValue();
            List<DimValue> fixedDimValuesResult = DynaCondConverter.dimValues2Fixeds(userId, dimValues, dimPropType, dynaCondMap);
            resultMap.put(dimValueEntry.getKey(), fixedDimValuesResult);
        }
        return resultMap;
    }

    public static Map<?, List<DimValue>> dimDynaCondConvert(Long userId, Map<?, List<DimValue>> dimValueMap, String dimPropType, Map<Long, DynamicObject> dynaCondMap) {
        if (CollectionUtils.isEmpty(dimValueMap)) {
            return dimValueMap;
        }
        for (Map.Entry<?, List<DimValue>> dimValueEntry : dimValueMap.entrySet()) {
            List<DimValue> dimValues = dimValueEntry.getValue();
            List<DimValue> fixedDimValuesResult = DynaCondConverter.dimValues2Fixeds(userId, dimValues, dimPropType, dynaCondMap);
            dimValueEntry.setValue(fixedDimValuesResult);
        }
        return dimValueMap;
    }

    public static Map<?, List<DimValueGroup>> groupDynaCondConvertClone(Long userId, Map<?, List<DimValueGroup>> dimGroupMap, Map<Long, String> dimPropType, Map<Long, DynamicObject> dynaCondMap) {
        if (CollectionUtils.isEmpty(dimGroupMap)) {
            return dimGroupMap;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dimGroupMap.size());
        for (Map.Entry<?, List<DimValueGroup>> entry : dimGroupMap.entrySet()) {
            List<DimValueGroup> groupList = entry.getValue();
            ArrayList resultGroupList = Lists.newArrayListWithExpectedSize((int)groupList.size());
            for (DimValueGroup group : groupList) {
                DimValueGroup resultGroup = new DimValueGroup();
                Map dimValuesMap = group.getDimValuesMap();
                HashMap resultDimValuesMap = Maps.newHashMapWithExpectedSize((int)dimValuesMap.size());
                for (Map.Entry dimValuesEntry : dimValuesMap.entrySet()) {
                    Long dimId = (Long)dimValuesEntry.getKey();
                    String propType = dimPropType.get(dimId);
                    List dimValues = (List)dimValuesEntry.getValue();
                    List<DimValue> fixedDimValuesResult = DynaCondConverter.dimValues2Fixeds(userId, dimValues, propType, dynaCondMap);
                    resultDimValuesMap.put(dimId, fixedDimValuesResult);
                }
                resultGroup.setDimValuesMap((Map)resultDimValuesMap);
                resultGroupList.add(resultGroup);
            }
            resultMap.put(entry.getKey(), resultGroupList);
        }
        return resultMap;
    }

    public static Map<?, List<DimValueGroup>> groupDynaCondConvert(Long userId, Map<?, List<DimValueGroup>> dimGroupMap, Map<Long, String> dimPropType, Map<Long, DynamicObject> dynaCondMap) {
        if (CollectionUtils.isEmpty(dimGroupMap)) {
            return dimGroupMap;
        }
        for (Map.Entry<?, List<DimValueGroup>> entry : dimGroupMap.entrySet()) {
            List<DimValueGroup> groupList = entry.getValue();
            for (DimValueGroup group : groupList) {
                Map dimValuesMap = group.getDimValuesMap();
                for (Map.Entry entry2 : dimValuesMap.entrySet()) {
                    Long dimId = (Long)entry2.getKey();
                    String propType = dimPropType.get(dimId);
                    List dimValues = (List)entry2.getValue();
                    List<DimValue> fixedDimValuesResult = DynaCondConverter.dimValues2Fixeds(userId, dimValues, propType, dynaCondMap);
                    entry2.setValue(fixedDimValuesResult);
                }
            }
        }
        return dimGroupMap;
    }

    public static Map<Long, DynamicObject> getDynaCondMap() {
        HRBaseServiceHelper dynaCondHelper = new HRBaseServiceHelper("hrcs_dynacond");
        DynamicObjectCollection dynaCondColl = dynaCondHelper.queryOriginalCollection("id,number,parsertype,parserclass,mserviceapp.number,mserviceapp.isv,mserviceapp.bizcloud.number,mserviceclass", new QFilter[0]);
        HashMap dynaCondMap = Maps.newHashMapWithExpectedSize((int)dynaCondColl.size());
        for (DynamicObject dynaCondDyna : dynaCondColl) {
            dynaCondMap.put(dynaCondDyna.getLong("id"), dynaCondDyna);
        }
        return dynaCondMap;
    }

    public static List<DimValue> dimValues2Fixeds(Long userId, List<DimValue> dimValues, String dimPropType, Map<Long, DynamicObject> dynaCondMap) {
        ArrayList fixedDimValuesResult = Lists.newArrayListWithExpectedSize((int)16);
        for (DimValue dimValue : dimValues) {
            if (HRStringUtils.equals((String)dimValue.getValType(), (String)"2")) {
                try {
                    DynamicObject dynaCondDyna = dynaCondMap.get(dimValue.getDynaCondId());
                    if (dynaCondDyna == null) {
                        LOGGER.error("HRDataPermService dynaCondConvert error.dynaCond DynamicObject not exist,id:{}", (Object)dimValue.getDynaCondId());
                        continue;
                    }
                    String parserType = dynaCondDyna.getString("parsertype");
                    List fixedDimValues = Lists.newArrayListWithExpectedSize((int)16);
                    if (HRStringUtils.equals((String)parserType, (String)"1")) {
                        Class<?> serviceClass = Class.forName(dynaCondDyna.getString("parserclass"));
                        IDynaCondParser dynaCondParser = (IDynaCondParser)serviceClass.newInstance();
                        fixedDimValues = dynaCondParser.parseDynaCond(dimPropType, userId, (Map)Maps.newHashMap());
                    } else if (HRStringUtils.equals((String)parserType, (String)"2")) {
                        String appNum = dynaCondDyna.getString("mserviceapp.number");
                        String isvNum = dynaCondDyna.getString("mserviceapp.isv");
                        String cloudNum = dynaCondDyna.getString("mserviceapp.bizcloud.number").toLowerCase();
                        String mserviceClass = dynaCondDyna.getString("mserviceclass");
                        fixedDimValues = "kingdee".equals(isvNum) ? (List)HRMServiceHelper.invokeBizService((String)cloudNum, (String)appNum, (String)mserviceClass, (String)"parseDynaCond", (Object[])new Object[]{dimPropType, userId, Maps.newHashMap()}) : (List)HRMServiceHelper.invokeService((String)cloudNum, (String)appNum, (String)mserviceClass, (String)"parseDynaCond", (Object[])new Object[]{dimPropType, userId, Maps.newHashMap()});
                    }
                    if (CollectionUtils.isEmpty((Collection)fixedDimValues)) continue;
                    for (FixedDimValue fixedDimValue : fixedDimValues) {
                        fixedDimValue.setStructProjectId(dimValue.getStructProjectId());
                        fixedDimValuesResult.add(DynaCondConverter.toDimVal(fixedDimValue));
                    }
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.error("HRDataPermService dynaCondConvert error:{}", (Object)dimValue.getDynaCondId(), (Object)ex);
                    continue;
                }
            }
            fixedDimValuesResult.add(dimValue);
        }
        return fixedDimValuesResult;
    }

    private static DimValue toDimVal(FixedDimValue fixedDimValue) {
        DimValue newDimValue = new DimValue();
        newDimValue.setAll(false);
        newDimValue.setDimVal(fixedDimValue.getValue());
        newDimValue.setContainsSub(fixedDimValue.isContainsSub());
        newDimValue.setAdminContainsSub(fixedDimValue.isDependStructContainsSub());
        newDimValue.setStructProjectId(fixedDimValue.getStructProjectId());
        newDimValue.setEmpty(false);
        newDimValue.setValType("1");
        newDimValue.setDynaCondId(Long.valueOf(0L));
        return newDimValue;
    }

    private static boolean hasDynaCond(List<DimValue> dimValues) {
        for (DimValue dimValue : dimValues) {
            if (!HRStringUtils.equals((String)dimValue.getValType(), (String)"2")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDynaCondInDimValues(Map<?, List<DimValue>> dimValueMap) {
        if (CollectionUtils.isEmpty(dimValueMap)) {
            return false;
        }
        for (Map.Entry<?, List<DimValue>> dimValueEntry : dimValueMap.entrySet()) {
            if (!DynaCondConverter.hasDynaCond(dimValueEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDynaCondInGroup(Map<?, List<DimValueGroup>> dimGroupMap) {
        if (CollectionUtils.isEmpty(dimGroupMap)) {
            return false;
        }
        for (Map.Entry<?, List<DimValueGroup>> entry : dimGroupMap.entrySet()) {
            List<DimValueGroup> groupList = entry.getValue();
            for (DimValueGroup group : groupList) {
                Map dimValuesMap = group.getDimValuesMap();
                for (Map.Entry dimValuesEntry : dimValuesMap.entrySet()) {
                    if (!DynaCondConverter.hasDynaCond((List)dimValuesEntry.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

