/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.handler.AbstractDimQFilterHandler;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;

public class DefDimHandler
extends AbstractDimQFilterHandler {
    private static final Log LOGGER = LogFactory.getLog(DefDimHandler.class);

    @Override
    public QFilter buildDimValueQFilter(String entityNum, String propKey, String propType, List<DimValue> dimValues, RoleRuleInfo roleRuleInfo, Map<String, Object> customParam) {
        if (this.isContainAll(dimValues)) {
            LOGGER.info("HRDataPermService isContainAll is true,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        String qfilterPropKey = this.buildQfilterPropKey(entityNum, propKey, customParam);
        if (DefDimHandler.isNotSupportFilterProperty(qfilterPropKey)) {
            LOGGER.info("HRDataPermService qfilterPropKey isNotSupportFilterProperty,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        if (PermCheckService.containDynaCondNotNull(dimValues)) {
            return DefDimHandler.buildNotNullQfilter(qfilterPropKey, propType);
        }
        Set<String> strValues = this.dimValueToStringList(dimValues);
        if (HRStringUtils.equalsIgnoreCase((String)propType, (String)"string")) {
            if (roleRuleInfo.isHisModel()) {
                strValues = this.convertBoIdToFidsString(roleRuleInfo.getDimEntityNumber(), strValues);
            }
            return new QFilter(qfilterPropKey, "in", strValues);
        }
        Set<Long> ids = PermRoleUtil.str2LongSet(strValues);
        if (roleRuleInfo.isHisModel()) {
            ids = this.convertBoIdToFidsLong(roleRuleInfo.getDimEntityNumber(), ids);
        }
        return new QFilter(qfilterPropKey, "in", ids);
    }
}

