/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimDataCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.service.perm.check.handler.DimQFilterHandlerFactory;
import kd.hr.hrcs.bussiness.service.perm.check.handler.IDimQFilterHandler;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRPermDimServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.OrgTeamStructProjectServiceHelper;
import kd.hr.hrcs.common.constants.MethodSource;
import kd.hr.hrcs.common.model.DimValueGroup;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;
import kd.hr.hrcs.common.utils.DataRuleScriptUtil;

public class DataRuleScriptServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(DataRuleScriptServiceHelper.class);

    public static Map<Long, String> assembleUserEntryDataRuleScript(String appId, String entityNum, String permItemId, List<UserRoleInfo> userRoleInfoList) {
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleScript, appId:{},entityNum:{},permItemId:{}", new Object[]{appId, entityNum, permItemId});
        Set<String> roleIdList = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<String>> roleDataRuleMap = DataRangeServiceHelperWithCache.queryRoleDataRuleWithCache(roleIdList, appId, entityNum, permItemId);
        Set<Long> userRoleRelatIdList = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Map<Long, List<String>> userDataRuleMap = DataRangeServiceHelperWithCache.queryUserDataRuleWithCache(userRoleRelatIdList, appId, entityNum, permItemId);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleScript, role id:{}", roleIdList);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleScript, userRoleInfoList id:{}", userRoleInfoList);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleScript, roleDataRuleMap:{}", roleDataRuleMap);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleScript, userDataRuleMap:{}", userDataRuleMap);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        HashMap ruleScriptMap = Maps.newHashMapWithExpectedSize((int)userRoleInfoList.size());
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            String singleRoleScript = DataRuleScriptServiceHelper.getSingleUserRoleDataRuleScript(dataEntityType, userRoleInfo, roleDataRuleMap, userDataRuleMap);
            ruleScriptMap.put(userRoleInfo.getRelatId(), singleRoleScript);
        }
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleScript resultQFilterMap:{}", (Object)ruleScriptMap);
        return ruleScriptMap;
    }

    private static String getSingleUserRoleDataRuleScript(MainEntityType entityType, UserRoleInfo userRoleInfo, Map<String, List<String>> roleDataRuleMap, Map<Long, List<String>> userDataRuleMap) {
        if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
            List<String> userRuleList = userDataRuleMap.get(userRoleInfo.getRelatId());
            String userRuleScript = DataRuleScriptServiceHelper.getDataRuleScript(entityType, userRuleList);
            List<String> roleRuleList = roleDataRuleMap.get(userRoleInfo.getRoleId());
            String roleRuleScript = DataRuleScriptServiceHelper.getDataRuleScript(entityType, roleRuleList);
            return DataRuleScriptUtil.scriptAnd((String)userRuleScript, (String)roleRuleScript);
        }
        if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
            List<String> userRuleList = userDataRuleMap.get(userRoleInfo.getRelatId());
            return DataRuleScriptServiceHelper.getDataRuleScript(entityType, userRuleList);
        }
        List<String> roleRuleList = roleDataRuleMap.get(userRoleInfo.getRoleId());
        return DataRuleScriptServiceHelper.getDataRuleScript(entityType, roleRuleList);
    }

    private static String getDataRuleScript(MainEntityType entityType, List<String> roleDataRuleList) {
        if (CollectionUtils.isEmpty(roleDataRuleList)) {
            return null;
        }
        String dataRuleScript = null;
        for (String dataRule : roleDataRuleList) {
            String curScript = DataRuleScriptUtil.convertJsonToScript((MainEntityType)entityType, (String)dataRule);
            if (null == dataRuleScript) {
                dataRuleScript = curScript;
                continue;
            }
            dataRuleScript = DataRuleScriptUtil.scriptOr((String)dataRuleScript, (String)curScript);
        }
        return dataRuleScript;
    }

    public static Map<Long, String> assembleUserDimValueScript(Long userId, String appId, String entityNum, List<UserRoleInfo> userRoleInfoList, Map<String, Object> customParam) {
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, entityNum, funcId, null);
        if (CollectionUtils.isEmpty(roleDimPropRelat)) {
            LOGGER.info("HRDataPermService assembleUserDimValueScript roleDimPropRelat is empty,return empty Map.");
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, MethodSource.METHOD_LIST.getCode());
        OrgTeamStructProjectServiceHelper.setStructProjectConfig(entityNum, roleDimPropRelat, customParam);
        return DataRuleScriptServiceHelper.assembleUserDimValueScript(userId, appId, entityNum, userRoleInfoList, roleDimPropRelat, customParam);
    }

    private static Map<Long, String> assembleUserDimValueScript(Long userId, String appId, String entityNum, List<UserRoleInfo> userRoleInfoList, Map<String, List<RoleRuleInfo>> roleDimPropRelat, Map<String, Object> customParam) {
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Set<Long> relationIds = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Set<Long> dimIds = HRPermDimServiceHelper.collectEntityDimIds(roleDimPropRelat);
        Map<Long, String> dimPropType = DimServiceWithCache.calCheckPropTypeWithCache(dimIds);
        Map<String, List<DimValueGroup>> roleDimGroupMap = DataRangeServiceHelperWithCache.getRoleDimValGroupWithCache(roleIds, funcId, dimIds);
        Map<Long, List<DimValueGroup>> userRoleDimGroupMap = DataRangeServiceHelperWithCache.getUserRoleDimValGroupWithCache(relationIds, funcId, dimIds);
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        roleDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, roleDimGroupMap, dimPropType, dynaCondMap);
        userRoleDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, userRoleDimGroupMap, dimPropType, dynaCondMap);
        HashMap ruleScriptMap = Maps.newHashMapWithExpectedSize((int)userRoleInfoList.size());
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            Long relatId = userRoleInfo.getRelatId();
            String roleId = userRoleInfo.getRoleId();
            String singleRelateScript = DataRuleScriptServiceHelper.assembleSingleRelatDimValueScript(userRoleInfo, roleDimPropRelat.get(roleId), roleDimGroupMap.get(roleId), userRoleDimGroupMap.get(relatId), dimPropType, customParam);
            ruleScriptMap.put(userRoleInfo.getRelatId(), singleRelateScript);
        }
        LOGGER.info("HRDataPermService assembleUserDimValueScript ruleScriptMap:{}", (Object)ruleScriptMap);
        return ruleScriptMap;
    }

    private static String assembleSingleRelatDimValueScript(UserRoleInfo userRoleInfo, List<RoleRuleInfo> propRelatInfoList, List<DimValueGroup> roleDimGroupList, List<DimValueGroup> userRoleDimGroupList, Map<Long, String> dimPropType, Map<String, Object> customParam) {
        if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
            String roleScript = DataRuleScriptServiceHelper.assembleSingleRelatRoleScript(propRelatInfoList, roleDimGroupList, dimPropType, customParam);
            String userScript = DataRuleScriptServiceHelper.assembleSingleRelatRoleScript(propRelatInfoList, userRoleDimGroupList, dimPropType, customParam);
            return DataRuleScriptUtil.scriptOr((String)roleScript, (String)userScript);
        }
        if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
            return DataRuleScriptServiceHelper.assembleSingleRelatRoleScript(propRelatInfoList, userRoleDimGroupList, dimPropType, customParam);
        }
        return DataRuleScriptServiceHelper.assembleSingleRelatRoleScript(propRelatInfoList, roleDimGroupList, dimPropType, customParam);
    }

    private static String assembleSingleRelatRoleScript(List<RoleRuleInfo> propRelatInfoList, List<DimValueGroup> roleDimGroupList, Map<Long, String> dimPropType, Map<String, Object> customParam) {
        String resultScript = null;
        if (CollectionUtils.isEmpty(roleDimGroupList)) {
            LOGGER.info("HRDataPermService assembleSingleRelatRoleScript roleDimGroupList is empty.");
            return null;
        }
        for (DimValueGroup dimValueGroup : roleDimGroupList) {
            String groupScript = null;
            for (RoleRuleInfo propRelatInfo : propRelatInfoList) {
                Long dimId = propRelatInfo.getDimensionId();
                List dimValues = (List)dimValueGroup.getDimValuesMap().get(dimId);
                String propType = dimPropType.get(dimId);
                IDimQFilterHandler dimQFilterHandler = DimQFilterHandlerFactory.getHandler(propRelatInfo.getDimensionNumber(), propRelatInfo.getDimensionType(), propRelatInfo.getDimensionShowType());
                String filterProp = propRelatInfo.getPropkey();
                QFilter qFilter = dimQFilterHandler.buildDimValueQFilter(propRelatInfo.getEntityNum(), filterProp, propType, dimValues, propRelatInfo, customParam);
                if (qFilter == null) continue;
                String dimScript = DataRuleScriptUtil.convertInQFiltet2Script((QFilter)qFilter, (String)propType, (String)propRelatInfo.getEntityNum());
                groupScript = DataRuleScriptUtil.scriptAnd((String)groupScript, (String)dimScript);
            }
            if (HRStringUtils.isEmpty(groupScript)) {
                LOGGER.info("HRDataPermService assembleSingleRelatRoleScript groupFilter is null,return null.");
                return null;
            }
            if (HRStringUtils.isEmpty(resultScript)) {
                resultScript = groupScript;
                continue;
            }
            resultScript = DataRuleScriptUtil.scriptOr(resultScript, groupScript);
        }
        LOGGER.info("HRDataPermService assembleSingleRelatRoleScript resultScript:{}", resultScript);
        return resultScript;
    }
}

