/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimDataCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRDataPermServiceHelper;
import kd.hr.hrcs.common.constants.MethodSource;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.DimValueGroup;
import kd.hr.hrcs.common.model.OrgInfo;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;

public class HRBaseOrgServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRBaseOrgServiceHelper.class);

    public static Map<String, RoleRuleInfo> getRoleOrgTeamDim(Map<String, List<RoleRuleInfo>> roleDimPropRelat) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(roleDimPropRelat)) {
            return result;
        }
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            List<RoleRuleInfo> roleRuleInfoList = entry.getValue();
            for (RoleRuleInfo roleRuleInfo : roleRuleInfoList) {
                if (!HRStringUtils.equals((String)"orgteam", (String)roleRuleInfo.getDimensionType())) continue;
                result.put(entry.getKey(), roleRuleInfo);
            }
        }
        return result;
    }

    public static Map<String, List<DimValue>> getRoleDimValue(List<UserRoleInfo> userRoleInfoList, String appId, String entityNumber, Long dimId) {
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber);
        HashSet roleIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet relationIds = Sets.newHashSetWithExpectedSize((int)userRoleInfoList.size());
        userRoleInfoList.forEach(userRole -> {
            roleIds.add(userRole.getRoleId());
            relationIds.add(userRole.getRelatId());
        });
        Map<String, List<DimValueGroup>> roleDimGroupMap = DataRangeServiceHelperWithCache.getRoleDimValGroupWithCache(roleIds, funcId, Collections.singleton(dimId));
        LOGGER.info("HRDataPermService getEntityDimValueByRelation dimId:{},roleDimGroupMap:{}", (Object)dimId, roleDimGroupMap);
        HashMap result = Maps.newHashMapWithExpectedSize((int)roleDimGroupMap.size());
        for (Map.Entry<String, List<DimValueGroup>> entry : roleDimGroupMap.entrySet()) {
            ArrayList dimValues = Lists.newArrayListWithExpectedSize((int)16);
            for (DimValueGroup group : entry.getValue()) {
                dimValues.addAll((Collection)group.getDimValuesMap().get(dimId));
            }
            result.put(entry.getKey(), dimValues);
        }
        return result;
    }

    public static Map<Long, List<DimValue>> getUserRoleDimValue(List<UserRoleInfo> userRoleInfoList, String appId, String entityNumber, Long dimId) {
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber);
        HashSet roleIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet relationIds = Sets.newHashSetWithExpectedSize((int)userRoleInfoList.size());
        userRoleInfoList.forEach(userRole -> {
            roleIds.add(userRole.getRoleId());
            relationIds.add(userRole.getRelatId());
        });
        Map<Long, List<DimValueGroup>> userRoleDimGroupMap = DataRangeServiceHelperWithCache.getUserRoleDimValGroupWithCache(relationIds, funcId, Collections.singleton(dimId));
        LOGGER.info("HRDataPermService getEntityDimValueByRelation dimId:{},userRoleDimGroupMap:{}", (Object)dimId, userRoleDimGroupMap);
        HashMap result = Maps.newHashMapWithExpectedSize((int)userRoleDimGroupMap.size());
        for (Map.Entry<Long, List<DimValueGroup>> entry : userRoleDimGroupMap.entrySet()) {
            ArrayList dimValues = Lists.newArrayListWithExpectedSize((int)16);
            for (DimValueGroup group : entry.getValue()) {
                dimValues.addAll((Collection)group.getDimValuesMap().get(dimId));
            }
            result.put(entry.getKey(), dimValues);
        }
        return result;
    }

    public static void filterDimAuthRange(Map<String, List<RoleRuleInfo>> roleDimPropRelat, String permItemId) {
        if ("47150e89000000ac".equals(permItemId)) {
            PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, MethodSource.METHOD_LIST.getCode());
        } else {
            PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, MethodSource.METHOD_F7.getCode());
        }
    }

    public static List<Map<Long, Long>> getCroConfig4Cache(List<Long> dimCrossList) {
        String cacheType = HRPermCacheMgr.getType4RoleDimValue();
        String cacheKey = "hrcs_crossot";
        String cacheVal = HRPermCacheMgr.getCache(cacheType, cacheKey);
        LOGGER.info("getCroConfig4Cache:{}", (Object)cacheVal);
        if (HRStringUtils.isEmpty((String)cacheVal)) {
            HRBaseServiceHelper crossHelper = new HRBaseServiceHelper("hrcs_crossot");
            DynamicObject[] otClasses = crossHelper.queryOriginalArray("otclass, crossotclass", null);
            List<Map<Long, Long>> otClassesList = HRBaseOrgServiceHelper.getCrsCfg(otClasses, dimCrossList);
            if (!CollectionUtils.isEmpty(otClassesList)) {
                HRPermCacheMgr.putCacheToday(cacheType, cacheKey, SerializationUtils.toJsonString(otClassesList));
            }
            return otClassesList;
        }
        List cacheList = SerializationUtils.fromJsonStringToList((String)cacheVal, Map.class);
        ArrayList targetList = Lists.newArrayListWithExpectedSize((int)cacheList.size());
        for (Map longMap : cacheList) {
            longMap.forEach((key, value) -> {
                HashMap<Long, Long> targetMap = new HashMap<Long, Long>(1);
                targetMap.put(Long.parseLong(key), value.longValue());
                targetList.add(targetMap);
            });
        }
        return targetList;
    }

    private static List<Map<Long, Long>> getCrsCfg(DynamicObject[] otClasses, List<Long> dimCrossList) {
        if (Objects.isNull(otClasses)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)otClasses.length);
        for (Long dimCro : dimCrossList) {
            Optional<DynamicObject> otClass = Arrays.stream(otClasses).filter(it -> it.getLong("otclass") == dimCro.longValue()).findFirst();
            if (!otClass.isPresent()) continue;
            HashMap objMap = Maps.newHashMapWithExpectedSize((int)1);
            objMap.put(otClass.get().getLong("otclass"), otClass.get().getLong("crossotclass"));
            result.add(objMap);
        }
        return result;
    }

    public static Set<Long> getAuthorizedOrgTeams(List<Long> dimCrossList, List<DimValue> dimValues, Date bsedTime, Date bsledTime) {
        LOGGER.info("HRDataPermService getAuthorizedOrgTeams dimCrossList:{} ,dimValues:{},bsedTime:{},bsledTime:{}", new Object[]{dimCrossList, dimValues, bsedTime, bsledTime});
        HashMap otClassMap = Maps.newHashMapWithExpectedSize((int)16);
        List<Map<Long, Long>> croConfig4Cache = HRBaseOrgServiceHelper.getCroConfig4Cache(dimCrossList);
        croConfig4Cache.forEach(otClassMap::putAll);
        Set<Long> dimIdSet = dimValues.stream().map(it -> Long.parseLong(it.getDimVal())).collect(Collectors.toSet());
        List<OrgInfo> dimIdList = HRDataPermServiceHelper.getOrgTeamList(dimIdSet, false, Lists.newArrayList());
        for (OrgInfo org : dimIdList) {
            List dimValueLst = dimValues.stream().filter(it -> org.getId().equals(Long.parseLong(it.getDimVal()))).collect(Collectors.toList());
            for (DimValue dv : dimValueLst) {
                dv.setSelfOtClassify(org.getOtclassify());
            }
        }
        HashSet allQFilterOrgSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Long croCla : dimCrossList) {
            Long configCro = (Long)otClassMap.get(croCla);
            if (Objects.isNull(configCro) || configCro == 0L) {
                HRBaseOrgServiceHelper.dealNotCroOT(dimValues, croCla, allQFilterOrgSet, bsedTime, bsledTime);
                continue;
            }
            HRBaseOrgServiceHelper.dealCroOT(dimValues, croCla, configCro, allQFilterOrgSet, bsedTime, bsledTime);
        }
        LOGGER.info("HRDataPermService getAuthorizedOrgTeams allQFilterOrgSet:{} ", (Object)allQFilterOrgSet);
        return allQFilterOrgSet.stream().filter(it -> !it.equals(0L)).collect(Collectors.toSet());
    }

    private static void dealNotCroOT(List<DimValue> dimValues, Long croCla, Set<Long> allQFilterOrgSet, Date bsedTime, Date bsledTime) {
        Set<Long> containsSub = dimValues.stream().filter(el -> el.isContainsSub() && el.getOtClassify().equals(croCla)).map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
        Set<Long> notContainsSub = dimValues.stream().filter(el -> !el.isContainsSub() && el.getOtClassify().equals(croCla)).map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
        List<OrgInfo> containSubList = HRDataPermServiceHelper.getOrgTeamList(containsSub, true, Lists.newArrayList((Object[])new Long[]{croCla}));
        List<OrgInfo> notContainSubList = HRDataPermServiceHelper.getOrgTeamList(notContainsSub, false, Lists.newArrayList((Object[])new Long[]{croCla}));
        containSubList.addAll(notContainSubList);
        Set<Long> containNotSubSet = HRBaseOrgServiceHelper.getAdminNotSub(containSubList, notContainsSub, bsedTime, bsledTime);
        Set<Long> containSubSet = HRBaseOrgServiceHelper.getAdminSub(containSubList, dimValues, croCla, bsedTime, bsledTime);
        allQFilterOrgSet.addAll(containNotSubSet);
        allQFilterOrgSet.addAll(containSubSet);
    }

    private static Set<Long> getAdminSub(List<OrgInfo> containSubList, List<DimValue> dimValues, Long croCla, Date bsedTime, Date bsledTime) {
        if (containSubList.size() == 0) {
            return Sets.newHashSet();
        }
        List<OrgInfo> croOrgList = containSubList.stream().filter(el -> el.getOtclassify().equals(croCla)).collect(Collectors.toList());
        List<DimValue> containsSub = dimValues.stream().filter(el -> el.isContainsSub() && el.getOtClassify().equals(croCla)).collect(Collectors.toList());
        List<OrgInfo> croOtSubList = HRBaseOrgServiceHelper.getOrgInfosById(containSubList, containsSub);
        return HRBaseOrgServiceHelper.getOrgByLongNumber(croOrgList, croOtSubList, bsedTime, bsledTime);
    }

    private static Set<Long> getOrgByLongNumber(List<OrgInfo> croOrgList, List<OrgInfo> croOtSubList, Date bsedTime, Date bsledTime) {
        HashSet croOtSubSet = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgInfo croOrg : croOtSubList) {
            List otSub = croOrgList.stream().filter(it -> it.getLongNumber().startsWith(croOrg.getLongNumber() + "!")).collect(Collectors.toList());
            croOtSubSet.add(HRBaseOrgServiceHelper.getOtOrgId(croOrg, bsedTime, bsledTime));
            if (CollectionUtils.isEmpty(otSub)) continue;
            croOtSubSet.addAll(otSub.stream().map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).collect(Collectors.toSet()));
        }
        return croOtSubSet;
    }

    private static List<OrgInfo> getOTByLongNumber(List<OrgInfo> croOrgList, List<OrgInfo> croOtSubList) {
        ArrayList otSubList = Lists.newArrayListWithExpectedSize((int)croOrgList.size());
        for (OrgInfo croOrg : croOtSubList) {
            List otSub = croOrgList.stream().filter(it -> it.getLongNumber().startsWith(croOrg.getLongNumber() + "!")).collect(Collectors.toList());
            otSubList.add(croOrg);
            if (CollectionUtils.isEmpty(otSub)) continue;
            otSubList.addAll(otSub);
        }
        return otSubList;
    }

    private static Set<Long> getAdminNotSub(List<OrgInfo> containSubList, Set<Long> notContainsSub, Date bsedTime, Date bsledTime) {
        if (containSubList.size() == 0) {
            return Sets.newHashSet();
        }
        List collect = containSubList.stream().filter(it -> notContainsSub.contains(it.getId())).collect(Collectors.toList());
        return collect.stream().map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).collect(Collectors.toSet());
    }

    public static Long getOtOrgId(OrgInfo orgInfo, Date bsedTime, Date bsledTime) {
        if (!(HRObjectUtils.isEmpty((Object)bsedTime) && HRObjectUtils.isEmpty((Object)bsledTime) || bsedTime.compareTo(orgInfo.getBsedTime()) >= 0 && bsledTime.compareTo(orgInfo.getBsledTime()) <= 0)) {
            return 0L;
        }
        return orgInfo.getOrgTeamHisId();
    }

    private static void dealCroOT(List<DimValue> dimValues, Long selfOtCla, Long croOtCla, Set<Long> allQFilterOrgSet, Date bsedTime, Date bsledTime) {
        HRBaseOrgServiceHelper.dealCroOrg(dimValues, selfOtCla, croOtCla, allQFilterOrgSet, bsedTime, bsledTime);
        HRBaseOrgServiceHelper.dealSelfOrg(dimValues, selfOtCla, allQFilterOrgSet, bsedTime, bsledTime);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void dealSelfOrg(List<DimValue> dimValues, Long selfOtCla, Set<Long> allQFilterOrgSet, Date bsedTime, Date bsledTime) {
        List dimValuesTag = dimValues.stream().filter(el -> el.getOtClassify().equals(selfOtCla) && el.getSelfOtClassify().equals(selfOtCla)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dimValuesTag)) {
            return;
        }
        ArrayList otSubList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList otSelfList = Lists.newArrayListWithExpectedSize((int)16);
        for (DimValue dv : dimValuesTag) {
            if (dv.isContainsSub()) {
                otSubList.add(dv);
                continue;
            }
            otSelfList.add(dv);
        }
        Set<Long> totalIdSet = dimValuesTag.stream().map(it -> Long.parseLong(it.getDimVal())).collect(Collectors.toSet());
        List<OrgInfo> otSubLst = HRDataPermServiceHelper.getOrgTeamList(totalIdSet, true, Lists.newArrayList((Object[])new Long[]{selfOtCla}));
        Set<Long> containNotSubSet = HRBaseOrgServiceHelper.getOTNotSub(otSubLst, otSelfList, bsedTime, bsledTime);
        Set<Long> containSubSet = HRBaseOrgServiceHelper.getOTSub(otSubLst, otSubList, selfOtCla, bsedTime, bsledTime);
        allQFilterOrgSet.addAll(containNotSubSet);
        allQFilterOrgSet.addAll(containSubSet);
    }

    private static Set<Long> getOTSub(List<OrgInfo> otSubLst, List<DimValue> otSelfList, Long selfOtCla, Date bsedTime, Date bsledTime) {
        List<OrgInfo> croOrgList = otSubLst.stream().filter(it -> it.getOtclassify().equals(selfOtCla)).collect(Collectors.toList());
        List<OrgInfo> croOtSubList = HRBaseOrgServiceHelper.getOrgInfosById(otSubLst, otSelfList);
        return HRBaseOrgServiceHelper.getOrgByLongNumber(croOrgList, croOtSubList, bsedTime, bsledTime);
    }

    private static Set<Long> getOTNotSub(List<OrgInfo> otSubLst, List<DimValue> otNSubList, Date bsedTime, Date bsledTime) {
        List<OrgInfo> otNSub = HRBaseOrgServiceHelper.getOrgInfosById(otSubLst, otNSubList);
        Set otNSubIdSet = otNSub.stream().map(OrgInfo::getId).collect(Collectors.toSet());
        List collect = otSubLst.stream().filter(it -> otNSubIdSet.contains(it.getId())).collect(Collectors.toList());
        return collect.stream().map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).collect(Collectors.toSet());
    }

    private static void dealCroOrg(List<DimValue> dimValues, Long selfOtCla, Long croOtCla, Set<Long> allQFilterOrgSet, Date bsedTime, Date bsledTime) {
        HashSet fidSet = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList orgSubAndOtSub = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList orgSelfAndOtSub = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList orgSubAndOtSelf = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList orgSelfAndOtSelf = Lists.newArrayListWithExpectedSize((int)16);
        List dimValuesCroTag = dimValues.stream().filter(el -> el.getOtClassify().equals(selfOtCla) && el.getSelfOtClassify().equals(croOtCla)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dimValuesCroTag)) {
            return;
        }
        for (DimValue dv : dimValuesCroTag) {
            if (dv.isAdminContainsSub() && dv.isContainsSub()) {
                orgSubAndOtSub.add(dv);
                continue;
            }
            if (!dv.isAdminContainsSub() && dv.isContainsSub()) {
                orgSelfAndOtSub.add(dv);
                continue;
            }
            if (dv.isAdminContainsSub() && !dv.isContainsSub()) {
                orgSubAndOtSelf.add(dv);
                continue;
            }
            if (dv.isAdminContainsSub() || dv.isContainsSub()) continue;
            orgSelfAndOtSelf.add(dv);
        }
        ArrayList orgSubFLevel = Lists.newArrayListWithExpectedSize((int)16);
        orgSubFLevel.addAll(orgSubAndOtSub);
        orgSubFLevel.addAll(orgSelfAndOtSub);
        if (!CollectionUtils.isEmpty((Collection)orgSubFLevel)) {
            Set<Long> croOrgSubSet = orgSubFLevel.stream().map(el -> Long.parseLong(el.getDimVal())).collect(Collectors.toSet());
            List<OrgInfo> containSubList = HRDataPermServiceHelper.getOrgTeamList(croOrgSubSet, true, Lists.newArrayList((Object[])new Long[]{selfOtCla, croOtCla}));
            Set<Long> firstLevelOrg = HRBaseOrgServiceHelper.getOTFirstLevel(containSubList, orgSubAndOtSub, orgSelfAndOtSub, croOtCla, selfOtCla, bsedTime, bsledTime);
            fidSet.addAll(firstLevelOrg);
        }
        HashSet otSelftSub = Sets.newHashSetWithExpectedSize((int)(orgSelfAndOtSelf.size() + orgSubAndOtSelf.size()));
        otSelftSub.addAll(orgSelfAndOtSelf);
        otSelftSub.addAll(orgSubAndOtSelf);
        if (!CollectionUtils.isEmpty((Collection)otSelftSub)) {
            Set<Long> croOrgNotSub = otSelftSub.stream().map(el -> Long.parseLong(el.getDimVal())).collect(Collectors.toSet());
            List<OrgInfo> orgNotSubList = HRDataPermServiceHelper.getOrgTeamList(croOrgNotSub, true, Lists.newArrayList((Object[])new Long[]{selfOtCla, croOtCla}));
            Set<Long> croOtSubSet = HRBaseOrgServiceHelper.getCroOtSubSet(orgSubAndOtSelf, orgNotSubList, croOtCla);
            Set firstLevelCroOtSubSet = orgNotSubList.stream().filter(el -> croOtSubSet.contains(el.getParent()) && el.getOtclassify().equals(selfOtCla)).map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).collect(Collectors.toSet());
            fidSet.addAll(firstLevelCroOtSubSet);
            List<OrgInfo> croOrgList = orgNotSubList.stream().filter(el -> el.getOtclassify().equals(croOtCla)).collect(Collectors.toList());
            List<OrgInfo> croOtNSubList = HRBaseOrgServiceHelper.getOrgInfosById(croOrgList, orgSelfAndOtSelf);
            Set croOtNSubSet = croOtNSubList.stream().map(OrgInfo::getId).collect(Collectors.toSet());
            Set firstLevelCroOtNotSubSet = orgNotSubList.stream().filter(el -> croOtNSubSet.contains(el.getParent()) && el.getOtclassify().equals(selfOtCla)).map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).collect(Collectors.toSet());
            fidSet.addAll(firstLevelCroOtNotSubSet);
        }
        allQFilterOrgSet.addAll(fidSet);
    }

    private static Set<Long> getOTFirstLevel(List<OrgInfo> containSubList, List<DimValue> orgSubAndOtSub, List<DimValue> orgSelfAndOtSub, Long croOtCla, Long selfOtCla, Date bsedTime, Date bsledTime) {
        HashSet totalIdSet = Sets.newHashSetWithExpectedSize((int)containSubList.size());
        List<OrgInfo> crosOrgList = containSubList.stream().filter(el -> el.getOtclassify().equals(croOtCla)).collect(Collectors.toList());
        List<OrgInfo> croOtSubList = HRBaseOrgServiceHelper.getOrgInfosById(crosOrgList, orgSubAndOtSub);
        List<OrgInfo> croOtSubs = HRBaseOrgServiceHelper.getOTByLongNumber(crosOrgList, croOtSubList);
        Set croOtSub = croOtSubs.stream().map(OrgInfo::getId).collect(Collectors.toSet());
        List otFSubIdList = containSubList.stream().filter(it -> croOtSub.contains(it.getParent()) && it.getOtclassify().equals(selfOtCla)).collect(Collectors.toList());
        List<OrgInfo> croOtNotSubList = HRBaseOrgServiceHelper.getOrgInfosById(crosOrgList, orgSelfAndOtSub);
        Set croOtNSub = croOtNotSubList.stream().map(OrgInfo::getId).collect(Collectors.toSet());
        List otFNSubIdList = containSubList.stream().filter(it -> croOtNSub.contains(it.getParent()) && it.getOtclassify().equals(selfOtCla)).collect(Collectors.toList());
        ArrayList totalList = Lists.newArrayListWithExpectedSize((int)(otFSubIdList.size() + otFNSubIdList.size()));
        totalList.addAll(otFSubIdList);
        totalList.addAll(otFNSubIdList);
        List<OrgInfo> otTNSubList = HRBaseOrgServiceHelper.getOTByLongNumber(containSubList, totalList);
        Set otTNSubIdSet = otTNSubList.stream().filter(it -> it.getOtclassify().equals(selfOtCla)).map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).collect(Collectors.toSet());
        totalIdSet.addAll(otTNSubIdSet);
        return totalIdSet;
    }

    private static List<OrgInfo> getOrgInfosById(List<OrgInfo> otList, List<DimValue> dimOrgList) {
        Set croOtNotSub = dimOrgList.stream().map(el -> Long.parseLong(el.getDimVal())).collect(Collectors.toSet());
        ArrayList croOtNotSubList = Lists.newArrayListWithExpectedSize((int)16);
        for (Long orgId : croOtNotSub) {
            List collect = otList.stream().filter(it -> it.getId().equals(orgId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) continue;
            croOtNotSubList.addAll(collect);
        }
        return croOtNotSubList;
    }

    private static Set<Long> getCroOtSubSet(List<DimValue> orgSubAndOtSelf, List<OrgInfo> orgNotSubList, Long croOtCla) {
        List<OrgInfo> croOrgList = orgNotSubList.stream().filter(el -> el.getOtclassify().equals(croOtCla)).collect(Collectors.toList());
        List<OrgInfo> croOtSubList = HRBaseOrgServiceHelper.getOrgInfosById(croOrgList, orgSubAndOtSelf);
        List<OrgInfo> otByLongNumber = HRBaseOrgServiceHelper.getOTByLongNumber(croOrgList, croOtSubList);
        return otByLongNumber.stream().map(OrgInfo::getId).collect(Collectors.toSet());
    }
}

