/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimDataCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBaseOrgServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBaseOrgStructureServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.OrgTeamStructProjectServiceHelper;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;

public class HROrgTeamServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HROrgTeamServiceHelper.class);

    public static AuthorizedOrgTeamResult calAuthorizedOrgTeamsResult(Long userId, String appId, String entityNum, String permItemId, String propKey, String methodSource, Date bsedTime, Date bsledTime) {
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNum, permItemId);
        LOGGER.info("HRDataPermService calAuthorizedOrgTeamsResultWithSubInfo userRoleInfoList:{}", userRoleInfoList);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService calAuthorizedOrgTeamsResultWithSubInfo roleList is empty,return all.");
            return new AuthorizedOrgTeamResult(true);
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, entityNum, funcId, propKey);
        PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, methodSource);
        Map<String, RoleRuleInfo> roleDimIdRelat = HRBaseOrgServiceHelper.getRoleOrgTeamDim(roleDimPropRelat);
        if (CollectionUtils.isEmpty(roleDimIdRelat)) {
            LOGGER.info("HRDataPermService calAuthorizedOrgTeamsResult roleDimIdRelat is null,return all.");
            return AuthorizedOrgTeamResult.allOrg();
        }
        Long targetDimId = null;
        Map<Long, Long> structProjectMap = OrgTeamStructProjectServiceHelper.queryStructDependMapFromHaos(entityNum, propKey);
        for (String roleId : roleIds) {
            if (roleDimIdRelat.get(roleId) == null) {
                LOGGER.info("HRDataPermService calAuthorizedOrgTeamsResult roleId:{}  donot relate dimension,return all.", (Object)roleId);
                return AuthorizedOrgTeamResult.allOrg();
            }
            targetDimId = roleDimIdRelat.get(roleId).getDimensionId();
        }
        Map<String, List<DimValue>> roleDimValueMap = HRBaseOrgServiceHelper.getRoleDimValue(userRoleInfoList, appId, entityNum, targetDimId);
        Map<Long, List<DimValue>> userRoleDimValueMap = HRBaseOrgServiceHelper.getUserRoleDimValue(userRoleInfoList, appId, entityNum, targetDimId);
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        roleDimValueMap = DynaCondConverter.dimDynaCondConvert(userId, roleDimValueMap, "long", dynaCondMap);
        userRoleDimValueMap = DynaCondConverter.dimDynaCondConvert(userId, userRoleDimValueMap, "long", dynaCondMap);
        HashMap hasPermOrgTeamMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Long structProjectId : structProjectMap.keySet()) {
            hasPermOrgTeamMap.put(structProjectId, Lists.newArrayListWithExpectedSize((int)16));
        }
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            Map<Long, Set<Long>> structValueMap;
            List<DimValue> dimValues;
            if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
                List<DimValue> dimValues1 = roleDimValueMap.get(userRoleInfo.getRoleId());
                Map<Long, Set<Long>> structValueMap1 = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeamsGroup(structProjectMap, dimValues1, bsedTime, bsledTime);
                List<DimValue> dimValues2 = userRoleDimValueMap.get(userRoleInfo.getRelatId());
                Map<Long, Set<Long>> structValueMap2 = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeamsGroup(structProjectMap, dimValues2, bsedTime, bsledTime);
                if (CollectionUtils.isEmpty(dimValues1)) {
                    HROrgTeamServiceHelper.mergeToResult(hasPermOrgTeamMap, structValueMap2);
                    continue;
                }
                if (CollectionUtils.isEmpty(dimValues2)) {
                    HROrgTeamServiceHelper.mergeToResult(hasPermOrgTeamMap, structValueMap1);
                    continue;
                }
                Map<Long, Set<Long>> intersectionResult = HROrgTeamServiceHelper.doIntersection(structProjectMap.keySet(), structValueMap1, structValueMap2);
                HROrgTeamServiceHelper.mergeToResult(hasPermOrgTeamMap, intersectionResult);
                continue;
            }
            if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
                dimValues = userRoleDimValueMap.get(userRoleInfo.getRelatId());
                structValueMap = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeamsGroup(structProjectMap, dimValues, bsedTime, bsledTime);
                HROrgTeamServiceHelper.mergeToResult(hasPermOrgTeamMap, structValueMap);
                continue;
            }
            dimValues = roleDimValueMap.get(userRoleInfo.getRoleId());
            structValueMap = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeamsGroup(structProjectMap, dimValues, bsedTime, bsledTime);
            HROrgTeamServiceHelper.mergeToResult(hasPermOrgTeamMap, structValueMap);
        }
        return new AuthorizedOrgTeamResult(false, (Map)hasPermOrgTeamMap);
    }

    private static Map<Long, Set<Long>> doIntersection(Set<Long> structIds, Map<Long, Set<Long>> structValueMap1, Map<Long, Set<Long>> structValueMap2) {
        HashMap intersectionResult = Maps.newHashMapWithExpectedSize((int)structIds.size());
        for (Long structId : structIds) {
            Set<Long> idLists1 = structValueMap1.get(structId);
            if (CollectionUtils.isEmpty(idLists1)) {
                intersectionResult.put(structId, Sets.newHashSetWithExpectedSize((int)0));
                continue;
            }
            idLists1.retainAll((Collection)structValueMap2.getOrDefault(structId, Sets.newHashSet()));
            intersectionResult.put(structId, idLists1);
        }
        return intersectionResult;
    }

    private static void mergeToResult(Map<Long, List<Long>> hasPermOrgTeamMap, Map<Long, Set<Long>> structValueMap) {
        for (Map.Entry<Long, List<Long>> entry : hasPermOrgTeamMap.entrySet()) {
            Set<Long> set = structValueMap.get(entry.getKey());
            if (CollectionUtils.isEmpty(set)) continue;
            entry.getValue().addAll(set);
        }
    }
}

