/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.structcalc;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.hr.hrcs.common.constants.perm.PermissionConstants;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.OrgInfo;

public class CalcPermNoAdminStructService {
    private static volatile CalcPermNoAdminStructService calcPermNoAdminStructService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalcPermNoAdminStructService getInstance() {
        if (calcPermNoAdminStructService != null) return calcPermNoAdminStructService;
        Class<CalcPermNoAdminStructService> clazz = CalcPermNoAdminStructService.class;
        synchronized (CalcPermNoAdminStructService.class) {
            if (calcPermNoAdminStructService != null) return calcPermNoAdminStructService;
            calcPermNoAdminStructService = new CalcPermNoAdminStructService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return calcPermNoAdminStructService;
        }
    }

    public Set<Long> calcStructOrg(Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, List<DimValue> dimValues, Long structId, Map<String, List<OrgInfo>> dimOrgMapWithHis) {
        if (noAdminStructProjectOrgInfo == null || structId == null) {
            return null;
        }
        List<OrgInfo> orgInfoList = noAdminStructProjectOrgInfo.get(structId);
        Set containsSub = dimValues.stream().filter(el -> el.isContainsSub() && (el.getStructProjectId() == null ? 0L : el.getStructProjectId()) == structId).map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
        HashSet<Long> allOrgId = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(containsSub)) {
            for (Long orgId : containsSub) {
                List newDimOrgInfos;
                List<OrgInfo> dimOrgInfos = dimOrgMapWithHis.get(String.valueOf(orgId));
                if (CollectionUtils.isEmpty(dimOrgInfos) || CollectionUtils.isEmpty(newDimOrgInfos = dimOrgInfos.stream().filter(info -> structId.longValue() == info.getStructProjectId().longValue()).collect(Collectors.toList()))) continue;
                Set longNumberSet = newDimOrgInfos.stream().map(orgInfo -> orgInfo.getLongNumber()).collect(Collectors.toSet());
                for (String dimLongNumber : longNumberSet) {
                    for (OrgInfo orgInfo2 : orgInfoList) {
                        String longNumber = orgInfo2.getLongNumber();
                        if (longNumber == null || !longNumber.startsWith(dimLongNumber)) continue;
                        allOrgId.add(orgInfo2.getOrgTeamHisId());
                    }
                }
            }
        }
        for (DimValue dimValue2 : dimValues) {
            List<OrgInfo> dimOrgInfos;
            String dimVal;
            Long structProjectId;
            if (dimValue2.isContainsSub() || (structProjectId = dimValue2.getStructProjectId()) == null || structProjectId.longValue() != structId.longValue() || (dimVal = dimValue2.getDimVal()) == null || !CollectionUtils.isNotEmpty(dimOrgInfos = dimOrgMapWithHis.get(dimVal))) continue;
            allOrgId.addAll(dimOrgInfos.stream().map(info -> info.getOrgTeamHisId()).collect(Collectors.toList()));
        }
        return allOrgId;
    }

    public Set<Long> getNoAdminStructProjectSet(Map<Long, Long> mapStructProjects) {
        if (mapStructProjects == null || mapStructProjects.isEmpty()) {
            return null;
        }
        HashSet noAdminStructProjectSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, Long> entryStructProject : mapStructProjects.entrySet()) {
            Long dependStructProject;
            Long structProject = entryStructProject.getKey();
            if (structProject == null || structProject == 0L) continue;
            if (PermissionConstants.ADMIN_STRUCT_PROJECT.longValue() != structProject.longValue()) {
                noAdminStructProjectSet.add(structProject);
            }
            if ((dependStructProject = entryStructProject.getValue()) == null || dependStructProject == 0L || PermissionConstants.ADMIN_STRUCT_PROJECT.longValue() == dependStructProject.longValue()) continue;
            noAdminStructProjectSet.add(dependStructProject);
        }
        return noAdminStructProjectSet;
    }
}

