/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;

public class EntityOrgFieldBuQueryService {
    public Map<String, Integer> getPropBuMap(String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        return this.parseProperty((IDataEntityType)entityType, false);
    }

    public Map<String, Integer> parseProperty(IDataEntityType entityType, boolean isQueryEntity) {
        if (entityType == null) {
            return null;
        }
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        if (propertyCollection != null && !propertyCollection.isEmpty()) {
            Map<String, Integer> fieldBuInfo = this.listResult(entityType, propertyCollection, isQueryEntity);
            if (entityType instanceof QueryEntityType) {
                this.handleQueryEntityTypeSub((QueryEntityType)entityType, fieldBuInfo);
            }
            return fieldBuInfo;
        }
        return null;
    }

    private void handleQueryEntityTypeSub(QueryEntityType entityType, Map<String, Integer> fieldBuInfo) {
        List subEntityTypeList = entityType.getAllJoinEntityType();
        for (MainEntityType met : subEntityTypeList) {
            Map<String, Integer> itemList = this.parseProperty((IDataEntityType)met, true);
            fieldBuInfo.putAll(itemList);
        }
    }

    private Map<String, Integer> listResult(IDataEntityType entityType, DataEntityPropertyCollection propertyCollection, boolean isQueryEntity) {
        HashMap<String, Integer> propBuMap = new HashMap<String, Integer>(16);
        for (IDataEntityProperty property : propertyCollection) {
            DataEntityPropertyCollection props;
            BasedataProp basedataProp;
            String propNumber;
            if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                EntryType entryType = (EntryType)entryProp.getItemType();
                Map<String, Integer> fieldBuInfo = this.parseProperty((IDataEntityType)entryType, false);
                propBuMap.putAll(fieldBuInfo);
                continue;
            }
            if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) continue;
            String string = propNumber = isQueryEntity ? entityType.getName() + "." + property.getName() : property.getName();
            if (property instanceof BasedataProp) {
                basedataProp = (BasedataProp)property;
                if (property instanceof OrgProp) {
                    String orgFunc = ((OrgProp)property).getOrgFunc();
                    if (orgFunc != null) {
                        propBuMap.put(propNumber, Integer.valueOf(orgFunc));
                    } else {
                        propBuMap.put(propNumber, Integer.MAX_VALUE);
                    }
                }
                props = basedataProp.getDynamicComplexPropertyType().getProperties();
            } else {
                basedataProp = (MulBasedataProp)property;
                props = basedataProp.getComplexType().getProperties();
            }
            ArrayList properties = Lists.newArrayListWithExpectedSize((int)10);
            List entryProperties = props.stream().filter(it -> it instanceof EntryProp).collect(Collectors.toList());
            for (IDataEntityProperty entryProperty : entryProperties) {
                EntryProp entryProp = (EntryProp)entryProperty;
                EntryType entryType = (EntryType)entryProp.getItemType();
                List entrySubProperties = entryType.getProperties().stream().filter(it -> it instanceof OrgProp).collect(Collectors.toList());
                properties.addAll(entrySubProperties);
            }
            List orgProperties = props.stream().filter(it -> it instanceof OrgProp).collect(Collectors.toList());
            properties.addAll(orgProperties);
            for (IDataEntityProperty iDataEntityProperty : properties) {
                String subProp = iDataEntityProperty.getName();
                String keyId = propNumber + "." + subProp;
                String orgFunc = ((OrgProp)iDataEntityProperty).getOrgFunc();
                if (orgFunc != null) {
                    propBuMap.put(keyId, Integer.valueOf(orgFunc));
                    continue;
                }
                propBuMap.put(keyId, Integer.MAX_VALUE);
            }
        }
        return propBuMap;
    }
}

