/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.check.RoleDimRelatService;
import kd.hr.hrcs.bussiness.service.perm.check.helper.UserRoleServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.dimension.HRRelatePermTask;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.common.model.RelatePermInfo;

@ExcludeFromJacocoGeneratedReport
public class PermRtSyncService {
    private static Log LOGGER = LogFactory.getLog(PermRtSyncService.class);
    private static final HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");

    public static void addRoleDim(String role, RelatePermInfo rp, Long dim, String propKey, String bu) {
        DynamicObject dy = roleDimHelper.generateEmptyDynamicObject();
        dy.set("role", (Object)role);
        dy.set("dimension", (Object)dim);
        dy.set("bucafunc", (Object)Long.valueOf(bu));
        DynamicObjectCollection collection = dy.getDynamicObjectCollection("entry");
        DynamicObject entry = collection.addNew();
        entry.set("app", (Object)rp.getAppId());
        entry.set("entitytype", (Object)rp.getEntityNum());
        entry.set("propkey", (Object)propKey);
        entry.set("enable", (Object)"1");
        roleDimHelper.saveOne(dy);
    }

    private static Map<String, List<RelatePermInfo>> init(LinkedHashMap<String, List<Map<String, Object>>> resultRolePermMap) {
        HashMap resultRolePerm = Maps.newHashMapWithExpectedSize((int)resultRolePermMap.size());
        for (Map.Entry<String, List<Map<String, Object>>> entry : resultRolePermMap.entrySet()) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)entry.getValue().size());
            for (Map<String, Object> rp : entry.getValue()) {
                RelatePermInfo relatePermInfo = new RelatePermInfo((String)rp.get("entityNum"), (String)rp.get("appId"), (String)rp.get("permId"), (String)rp.get("mEntityNum"), (String)rp.get("mAppId"), (String)rp.get("mPermId"));
                list.add(relatePermInfo);
            }
            resultRolePerm.put(entry.getKey(), list);
        }
        return resultRolePerm;
    }

    private static boolean isExistRoleDim(DynamicObject relatDynoArr, RelatePermInfo rp, Map<String, Object> dimMap) {
        String propKey = (String)dimMap.get("propkey");
        if (Objects.isNull(relatDynoArr)) {
            return true;
        }
        DynamicObjectCollection entryColl = relatDynoArr.getDynamicObjectCollection("entry");
        for (DynamicObject entryDyno : entryColl) {
            String relatPropKey = entryDyno.getString("propkey");
            String app = entryDyno.getString("app.id");
            String number = entryDyno.getString("entitytype.number");
            if (!HRStringUtils.equals((String)number, (String)rp.getEntityNum()) || !HRStringUtils.equals((String)app, (String)entryDyno.getString("app.id")) || !HRStringUtils.equals((String)relatPropKey, (String)propKey)) continue;
            return true;
        }
        return false;
    }

    public static void syncRolePerm(LinkedHashMap<String, List<Map<String, Object>>> resultRolePermMap1) {
        Map<String, List<RelatePermInfo>> resultRolePermMap = PermRtSyncService.init(resultRolePermMap1);
        PermRtSyncService.syncRolePerms(resultRolePermMap);
    }

    public static void syncRolePerms(Map<String, List<RelatePermInfo>> resultRolePermMap) {
        HashSet listRoles = Sets.newHashSetWithExpectedSize((int)16);
        QFilter entityDimQfilter = null;
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)resultRolePermMap.size());
        for (Map.Entry<String, List<RelatePermInfo>> entry : resultRolePermMap.entrySet()) {
            for (RelatePermInfo re : entry.getValue()) {
                if (!entityNumSet.add(re.getEntityNum())) continue;
                if (entityDimQfilter == null) {
                    entityDimQfilter = new QFilter("entitytype.number", "=", (Object)re.getEntityNum());
                } else {
                    entityDimQfilter.or(new QFilter("entitytype.number", "=", (Object)re.getEntityNum()));
                }
                listRoles.add(entry.getKey());
            }
        }
        Map<String, String> permInfoMap = PermRelateServiceHelper.getPermInfo();
        HRBaseServiceHelper roleUpHelper = new HRBaseServiceHelper("perm_roleperm");
        DynamicObject[] dobjs = new DynamicObject[resultRolePermMap.size()];
        int index = 0;
        for (Map.Entry<String, List<RelatePermInfo>> entry : resultRolePermMap.entrySet()) {
            String roleID = entry.getKey();
            List<RelatePermInfo> relatePermInfos = entry.getValue();
            DynamicObject obj = roleUpHelper.queryOne("roleid,roleperm.entity,roleperm.permitem,roleperm.bizapp,roleperm.droleid", new QFilter[]{new QFilter("roleid", "=", (Object)roleID)});
            DynamicObjectCollection collection = obj.getDynamicObjectCollection("roleperm");
            for (RelatePermInfo rp : relatePermInfos) {
                long count = collection.stream().filter(it -> HRStringUtils.equals((String)rp.getEntityNum(), (String)it.getString("entity.number")) && HRStringUtils.equals((String)rp.getPermId(), (String)it.getString("permitem.number")) && HRStringUtils.equals((String)rp.getAppId(), (String)it.getString("bizapp.id"))).count();
                if (count != 0L) continue;
                DynamicObject permEntry = collection.addNew();
                permEntry.set("entity", (Object)rp.getEntityNum());
                permEntry.set("permitem", (Object)permInfoMap.get(rp.getPermId()));
                permEntry.set("bizapp", (Object)rp.getAppId());
                permEntry.set("droleid", (Object)roleID);
            }
            dobjs[index] = obj;
            ++index;
        }
        roleUpHelper.save(dobjs);
        Map<String, List<Map<String, Object>>> entityDimMap = RoleDimRelatService.getEntityDimList(entityDimQfilter);
        LOGGER.info("PermRtSyncService entity dim:{}", entityDimMap);
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObjectCollection roles = roleHelper.queryOriginalCollection("role,dimension,bucafunc,entry.app,entry.entitytype,entry.enable", new QFilter[]{new QFilter("role", "in", (Object)listRoles)});
        HashMap roleDimMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : roles) {
            if (HRStringUtils.equals((String)"0", (String)dy.getString("entry.enable"))) continue;
            String role = dy.getString("role");
            Long dimension = dy.getLong("dimension");
            roleDimMap.computeIfAbsent(role, key -> new HashSet(16)).add(dimension);
        }
        LOGGER.info("PermRtSyncService role dim:{}", (Object)roleDimMap);
        HashSet entitySet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, List<RelatePermInfo>> roleEntry : resultRolePermMap.entrySet()) {
            String role = roleEntry.getKey();
            List<RelatePermInfo> roleRelPerm = roleEntry.getValue();
            for (RelatePermInfo rp : roleRelPerm) {
                Long dim;
                if (!entitySet.add(rp.getEntityNum())) {
                    LOGGER.info("PermRtSyncService entity continue:{}", (Object)rp.getEntityNum());
                    continue;
                }
                List<Map<String, Object>> entityRp = entityDimMap.get(rp.getEntityNum());
                if (CollectionUtils.isEmpty(entityRp)) {
                    LOGGER.info("PermRtSyncService entity noDim:{}", (Object)rp.getEntityNum());
                    continue;
                }
                Set dimSet = (Set)roleDimMap.get(role);
                ArrayList notMust = Lists.newArrayListWithExpectedSize((int)16);
                List isMust = entityRp.stream().filter(it -> (Boolean)it.get("ismust")).collect(Collectors.toList());
                for (Map dimMap : isMust) {
                    dim = (Long)dimMap.get("dim");
                    List collect = entityRp.stream().filter(it -> dim.equals(it.get("dim")) && (Boolean)it.get("ismust") == false).collect(Collectors.toList());
                    notMust.addAll(collect);
                }
                if (!CollectionUtils.isEmpty((Collection)notMust)) {
                    isMust.addAll(notMust);
                }
                if (isMust.size() == 0 && Objects.isNull(roleDimMap.get(role))) {
                    LOGGER.info("PermRtSyncService entity no need deal dim");
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)dimSet)) {
                    for (Long dim2 : dimSet) {
                        Optional<Map> first = entityRp.stream().filter(it -> it.get("dim").equals(dim2) && (Boolean)it.get("ismust") == false).findFirst();
                        first.ifPresent(isMust::add);
                    }
                }
                LOGGER.info("PermRtSyncService entity need deal dim:{}", isMust);
                for (Map dimMap : isMust) {
                    dim = (Long)dimMap.get("dim");
                    String propKey = (String)dimMap.get("propkey");
                    String bu = HRBuCaServiceHelper.getBuCaFunc(rp.getEntityNum(), rp.getAppId());
                    if (!CollectionUtils.isEmpty((Collection)dimSet) && dimSet.contains(dim)) {
                        DynamicObject relatDynoArr = roleDimHelper.queryOne("role,dimension,bucafunc,entry.app,entry.entitytype,entry.propkey,entry.enable", new QFilter[]{new QFilter("role", "=", (Object)role), new QFilter("dimension", "=", (Object)dim), new QFilter("bucafunc", "=", (Object)Long.parseLong(bu))});
                        if (PermRtSyncService.isExistRoleDim(relatDynoArr, rp, dimMap)) continue;
                        PermRtSyncService.updateRoleDim(rp, propKey, relatDynoArr);
                        continue;
                    }
                    PermRtSyncService.addRoleDim(role, rp, dim, propKey, bu);
                    if (dimSet == null) {
                        dimSet = Sets.newHashSetWithExpectedSize((int)isMust.size());
                    }
                    dimSet.add(dim);
                }
            }
        }
        HRPermCacheMgr.clearAllCache();
    }

    private static void updateRoleDim(RelatePermInfo rp, String propKey, DynamicObject relatDynoArr) {
        DynamicObjectCollection collection = relatDynoArr.getDynamicObjectCollection("entry");
        DynamicObject entry = collection.addNew();
        entry.set("app", (Object)rp.getAppId());
        entry.set("entitytype", (Object)rp.getEntityNum());
        entry.set("propkey", (Object)propKey);
        entry.set("enable", (Object)"1");
        roleDimHelper.saveOne(relatDynoArr);
    }

    public static void syncAllRtPermRole(HRRelatePermTask task) {
        long start = System.currentTimeMillis();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] permRelates = serviceHelper.query("entitytype,bizapp,mainpermitem,entryentity.entitytypeid,entryentity.app,entryentity.permitemid", null);
        ArrayList relatePermInfoList = Lists.newArrayListWithExpectedSize((int)permRelates.length);
        ArrayList mainPermInfoList = Lists.newArrayListWithExpectedSize((int)permRelates.length);
        Arrays.stream(permRelates).forEach(it -> {
            mainPermInfoList.add(new RelatePermInfo(null, null, null, it.getString("entitytype.number"), it.getString("bizapp.id"), it.getString("mainpermitem")));
            DynamicObjectCollection entryEntity = it.getDynamicObjectCollection("entryentity");
            entryEntity.forEach(itm -> {
                String perm = itm.getString("permitemid");
                if (perm.contains(",")) {
                    String[] split;
                    for (String permStr : split = perm.split(",")) {
                        RelatePermInfo relatePermInfo = new RelatePermInfo(itm.getString("entitytypeid.number"), itm.getString("app.id"), permStr.trim(), it.getString("entitytype.number"), it.getString("bizapp.id"), it.getString("mainpermitem"));
                        relatePermInfoList.add(relatePermInfo);
                    }
                } else {
                    RelatePermInfo relatePermInfo = new RelatePermInfo(itm.getString("entitytypeid.number"), itm.getString("app.id"), perm.trim(), it.getString("entitytype.number"), it.getString("bizapp.id"), it.getString("mainpermitem"));
                    relatePermInfoList.add(relatePermInfo);
                }
            });
        });
        LOGGER.info("syncAllRtPermRole cost_time_mills 1:" + (System.currentTimeMillis() - start));
        task.feedbackProgressPub(30, null, null);
        LinkedHashMap<String, List<RelatePermInfo>> resultRolePermMap = PermRtSyncService.calcRtPermRole(relatePermInfoList, mainPermInfoList);
        LOGGER.info("syncAllRtPermRole cost_time_mills 2:" + (System.currentTimeMillis() - start));
        task.feedbackProgressPub(90, null, null);
        PermRtSyncService.syncRolePerms(resultRolePermMap);
        LOGGER.info("syncAllRtPermRole cost_time_mills 3:" + (System.currentTimeMillis() - start));
        task.feedbackProgressPub(99, null, null);
    }

    public static LinkedHashMap<String, List<RelatePermInfo>> calcRtPermRole(List<RelatePermInfo> relatePermInfoList, List<RelatePermInfo> mainPermInfoList) {
        HashSet appSet = Sets.newHashSetWithExpectedSize((int)relatePermInfoList.size());
        HashSet entitySet = Sets.newHashSetWithExpectedSize((int)relatePermInfoList.size());
        HashSet permIdSet = Sets.newHashSetWithExpectedSize((int)relatePermInfoList.size());
        Map<String, String> permInfoMap = PermRelateServiceHelper.getPermInfo();
        Map<String, String> permMap = PermRelateServiceHelper.getPermInfoNum();
        for (RelatePermInfo permInfo : mainPermInfoList) {
            appSet.add(permInfo.getmAppId());
            entitySet.add(permInfo.getmEntityNum());
            permIdSet.add(permInfoMap.get(permInfo.getmPermId()));
            permInfo.setPermId(permInfoMap.get(permInfo.getmPermId()));
        }
        for (RelatePermInfo relatePermInfo : relatePermInfoList) {
            appSet.add(relatePermInfo.getAppId());
            entitySet.add(relatePermInfo.getEntityNum());
            permIdSet.add(permInfoMap.get(relatePermInfo.getPermId()));
        }
        long start = System.currentTimeMillis();
        List<RelatePermInfo> permInfoList = UserRoleServiceHelper.queryRoleIdSetByPermItemSet(appSet, entitySet, permIdSet, mainPermInfoList);
        LinkedHashMap<String, List> targetRolePermMap = new LinkedHashMap<String, List>(permInfoList.size());
        LinkedHashMap<String, List> resultRolePermMap = new LinkedHashMap<String, List>(permInfoList.size());
        for (RelatePermInfo relatePermInfo : permInfoList) {
            relatePermInfo.setPermId(permMap.get(relatePermInfo.getPermId()));
            targetRolePermMap.computeIfAbsent(relatePermInfo.getRole(), key -> new ArrayList(16)).add(relatePermInfo);
        }
        for (Map.Entry entry : targetRolePermMap.entrySet()) {
            List relatePermInfos = (List)entry.getValue();
            for (RelatePermInfo rp : relatePermInfoList) {
                String mEntity = rp.getmEntityNum();
                String mAppId = rp.getmAppId();
                String mPermId = rp.getmPermId();
                String entity = rp.getEntityNum();
                String appId = rp.getAppId();
                String permId = rp.getPermId();
                long mainCount = relatePermInfos.stream().filter(it -> it.getAppId().equals(mAppId) && it.getPermId().equals(mPermId) && it.getEntityNum().equals(mEntity)).count();
                long count = relatePermInfos.stream().filter(it -> it.getAppId().equals(appId) && it.getPermId().equals(permId) && it.getEntityNum().equals(entity)).count();
                if (mainCount <= 0L || count != 0L) continue;
                resultRolePermMap.computeIfAbsent((String)entry.getKey(), key -> new ArrayList(16)).add(rp);
            }
        }
        LinkedHashMap<String, List<RelatePermInfo>> rolePermMap = new LinkedHashMap<String, List<RelatePermInfo>>(permInfoList.size());
        if (resultRolePermMap.size() > 0) {
            HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper("perm_role");
            DynamicObjectCollection dynamicObjects = hRBaseServiceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", resultRolePermMap.keySet())}, "modifytime desc");
            for (DynamicObject obj : dynamicObjects) {
                rolePermMap.put(obj.getString("id"), (List<RelatePermInfo>)resultRolePermMap.get(obj.getString("id")));
            }
        }
        LOGGER.info(" calcRtPermRole cost time:{}", (Object)(System.currentTimeMillis() - start));
        return rolePermMap;
    }

    public static void writeOpLog(boolean isSuccess, String appId, String entityNum, MultiLangEnumBridge opTName, MultiLangEnumBridge sycOpT, MultiLangEnumBridge sycOpf, String opKey) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        if (opTName != null) {
            appLogInfo.setOpName(opKey, opTName);
        }
        if (isSuccess) {
            if (sycOpT != null) {
                appLogInfo.setOpDesc(sycOpT, new String[0]);
            }
        } else if (sycOpf != null) {
            appLogInfo.setOpDesc(sycOpf, new String[0]);
        }
        appLogInfo.setBizObjID(entityNum);
        appLogInfo.setBizAppID(PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        service.addLog((AppLogInfo)appLogInfo);
    }
}

