/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleDataPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.util.DynaSchemeRoleAssignDetailBean;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleBdDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleMainModel;

@ExcludeFromJacocoGeneratedReport
public class DynaRoleDetailServiceHelper {
    public static void loadRoleCustomInfo(long schemeId, IFormView formView) {
        HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        DynamicObject schemeInfo = schemeHelper.queryOne("roleentry,roleentry.role,roleentry.customenable,roleentry.roleremark", (Object)schemeId);
        DynamicObjectCollection roleEntry = schemeInfo.getDynamicObjectCollection("roleentry");
        Set roleIds = roleEntry.stream().map(it -> it.getString("role.id")).collect(Collectors.toSet());
        HRBaseServiceHelper permRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection roleColl = permRoleHelper.queryOriginalCollection("id,property", new QFilter[]{new QFilter("id", "in", roleIds)});
        Map<String, String> rolePropertyMap = roleColl.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("property"), (newVal, oldVal) -> newVal));
        formView.getModel().beginInit();
        for (int index = 0; index < roleEntry.size(); ++index) {
            DynamicObject row = (DynamicObject)roleEntry.get(index);
            long roleEntryId = row.getLong("id");
            String roleId = row.getString("role.id");
            String customEnable = row.getString("customenable");
            DynaSchemeRoleAssignDetailBean dynaSchemeRoleAssignDetailBean = new DynaSchemeRoleAssignDetailBean();
            dynaSchemeRoleAssignDetailBean.setDynaSchemeId(schemeId);
            dynaSchemeRoleAssignDetailBean.setEntryId(row.getLong("id"));
            dynaSchemeRoleAssignDetailBean.setRoleId(roleId);
            if (HRStringUtils.equals((String)"1", (String)customEnable)) {
                Map<String, RoleDataPermModel> roleDataPermModels = DynaRoleDetailServiceHelper.assembleRoleDataPermModelList(schemeId, roleEntryId, roleId, Boolean.FALSE);
                Map<String, UserRoleFieldPermInfo> roleFieldPermInfoFromDatabase = DynaRoleDetailServiceHelper.getRoleFieldPermInfoFromDatabase(schemeId, roleEntryId, null, null, roleId);
                dynaSchemeRoleAssignDetailBean.setDataMap(roleDataPermModels);
                dynaSchemeRoleAssignDetailBean.setFieldDataMap(roleFieldPermInfoFromDatabase);
            }
            dynaSchemeRoleAssignDetailBean.setRoleProperty(rolePropertyMap.get(roleId));
            dynaSchemeRoleAssignDetailBean.setDataProperty(customEnable);
            HashMap languageMap = new HashMap();
            OrmLocaleValue roleRemark = (OrmLocaleValue)row.getLocaleString("roleremark");
            if (null != roleRemark) {
                roleRemark.forEach(languageMap::put);
            }
            dynaSchemeRoleAssignDetailBean.setRemark(LocaleString.fromMap(languageMap));
            String customInfo = SerializationUtils.toJsonString((Object)dynaSchemeRoleAssignDetailBean);
            formView.getModel().setValue("custominfo", (Object)customInfo, index);
        }
        formView.getModel().endInit();
        formView.getModel().setDataChanged(false);
        formView.updateView("roleentry");
    }

    public static Map<String, RoleDataPermModel> assembleRoleDataPermModelList(long schemeId, long roleEntryId, String roleId, boolean newflag) {
        HashMap roleDataPermModelMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, List<DynamicObject>> roleBuById = DynaRoleDetailServiceHelper.getRoleBuGroupByBu(schemeId, roleEntryId, roleId);
        Set<Long> buIdSet = roleBuById.keySet();
        DynamicObject[] roleImgGrpDys = DynaRoleDetailServiceHelper.getRoleDimgrp(schemeId, roleEntryId, roleId, buIdSet);
        Map<Long, List<DynamicObject>> roleImgGrpDysGroupByBu = Arrays.stream(roleImgGrpDys).collect(Collectors.groupingBy(roleImgGrpDy -> roleImgGrpDy.getLong("bucafunc.id")));
        Map<Long, List<String>> appByHrbucafunc = RoleMemberAssignServiceHelper.getAppByHrbucafunc(buIdSet);
        HashMap roleDataRuleByHrbu = Maps.newHashMapWithExpectedSize((int)16);
        appByHrbucafunc.forEach((appByBuKey, appByBuValue) -> {
            DynamicObject[] roleDataRuleDynamic = DynaRoleDetailServiceHelper.geDataRuleByApp(schemeId, roleEntryId, appByBuValue, roleId);
            roleDataRuleByHrbu.put(appByBuKey, roleDataRuleDynamic);
        });
        roleBuById.forEach((buKey, value) -> {
            HashMap appEntity2DataRules = Maps.newHashMapWithExpectedSize((int)16);
            HashMap dimGroupMap = Maps.newHashMapWithExpectedSize((int)16);
            RoleDataPermModel roleDataPermModel = new RoleDataPermModel();
            DynaRoleDetailServiceHelper.setOrgList(buKey, value, roleDataPermModel, newflag);
            List roleImgGrpList = (List)roleImgGrpDysGroupByBu.get(buKey);
            Optional.ofNullable(roleImgGrpList).ifPresent(roleImgGrps -> roleImgGrps.forEach(roleImgGrp -> {
                DimGrpModel dimGrpModel = new DimGrpModel();
                DynaRoleDetailServiceHelper.setDimGroupModel(dimGroupMap, roleImgGrp, dimGrpModel, newflag);
            }));
            roleDataPermModel.setDimGroupMap((Map)dimGroupMap);
            DynaRoleDetailServiceHelper.setRoleDataRuleModel(appEntity2DataRules, roleDataRuleByHrbu.getOrDefault(buKey, new DynamicObject[0]), newflag);
            roleDataPermModel.setAppEntity2DataRules((Map)appEntity2DataRules);
            roleDataPermModelMap.put(buKey.toString(), roleDataPermModel);
        });
        return roleDataPermModelMap;
    }

    private static void setRoleDataRuleModel(Map<String, RoleDataRuleMainModel> appEntity2DataRules, DynamicObject[] roleDataRuleDynamic, boolean newflag) {
        Arrays.stream(roleDataRuleDynamic).forEach(roleDataRuleObj -> {
            String entitytype = roleDataRuleObj.getString("entitytype");
            RoleDataRuleMainModel roleDataRuleMainModel = new RoleDataRuleMainModel();
            DynamicObjectCollection roleDataruleEntry = roleDataRuleObj.getDynamicObjectCollection("dataruleentry");
            DynamicObjectCollection roleBdRuleEntry = roleDataRuleObj.getDynamicObjectCollection("hrcs_rolebdruleentry");
            HashMap dataRuleMap = Maps.newHashMapWithExpectedSize((int)roleDataruleEntry.size());
            HashMap bdDataRuleMap = Maps.newHashMapWithExpectedSize((int)roleBdRuleEntry.size());
            Map<Long, List<DynamicObject>> dataRule = roleDataruleEntry.stream().collect(Collectors.groupingBy(roleDataGroup -> roleDataGroup.getLong("datarule.id")));
            dataRule.forEach((dataRuleKey, dataRuleValue) -> {
                RoleDataRuleEntryModel roleDataRuleEntryModel = new RoleDataRuleEntryModel();
                roleDataRuleEntryModel.setBusinessObject(entitytype);
                roleDataRuleEntryModel.setDataRuleId(String.valueOf(dataRuleKey));
                roleDataRuleEntryModel.setPermItem(dataRuleValue.stream().map(roleDataRuleEntryDynamic -> roleDataRuleEntryDynamic.getString("permitem.id")).collect(Collectors.toList()));
                dataRuleMap.put(String.valueOf(dataRuleKey), roleDataRuleEntryModel);
            });
            roleBdRuleEntry.forEach(roleBdRuleEntryDyn -> {
                RoleBdDataRuleEntryModel roleBdDataRuleEntryModel = new RoleBdDataRuleEntryModel();
                String proKey = roleBdRuleEntryDyn.getString("propkey");
                roleBdDataRuleEntryModel.setBusinessObject(entitytype);
                roleBdDataRuleEntryModel.setDataRuleId(roleBdRuleEntryDyn.getString("bddatarule.id"));
                roleBdDataRuleEntryModel.setProperty(roleBdRuleEntryDyn.getString("propkey"));
                roleBdDataRuleEntryModel.setPropertyNum(roleBdRuleEntryDyn.getString("propentnum"));
                bdDataRuleMap.put(proKey, roleBdDataRuleEntryModel);
            });
            if (newflag) {
                roleDataRuleMainModel.setDataRuleMap(new HashMap());
                roleDataRuleMainModel.setBdDataRuleMap(new HashMap());
            } else {
                roleDataRuleMainModel.setDataRuleMap((Map)dataRuleMap);
                roleDataRuleMainModel.setBdDataRuleMap((Map)bdDataRuleMap);
            }
            String concat = roleDataRuleObj.getString("app").concat("#").concat(entitytype);
            appEntity2DataRules.put(concat, roleDataRuleMainModel);
        });
    }

    private static void setDimGroupModel(Map<String, DimGrpModel> dimGroupMap, DynamicObject roleImgGrp, DimGrpModel dimGrpModel, boolean newflag) {
        TreeMap dimMap = Maps.newTreeMap();
        dimGrpModel.setDimGroup(String.valueOf(roleImgGrp.get("id")));
        dimGrpModel.setSeq(roleImgGrp.getInt("index"));
        DynamicObjectCollection entry = roleImgGrp.getDynamicObjectCollection("dimvalentry");
        Map<Long, List<DynamicObject>> collect = entry.stream().collect(Collectors.groupingBy(en -> en.getLong("dimension.id")));
        collect.forEach((dimId, dimensionValue) -> {
            String dimNumber = ((DynamicObject)dimensionValue.get(0)).getString("dimension.number");
            DimModel dimModel = new DimModel();
            dimModel.setDimId(dimId.toString());
            dimModel.setDimNumber(dimNumber);
            HashMap dimValues = Maps.newHashMapWithExpectedSize((int)dimensionValue.size());
            dimensionValue.forEach(dimModelVal -> {
                HashMap dimValMap = Maps.newHashMapWithExpectedSize((int)16);
                dimModel.setDimNumber(dimModelVal.getString("dimension.number"));
                if (newflag) {
                    return;
                }
                DynamicObject structProject = dimModelVal.getDynamicObject("structproject");
                String dimVal = dimModelVal.getString("dimval");
                RoleDataPermHelper.getDimensionValName(dimModelVal, dimValMap, dimVal);
                dimValMap.put("includeSub", dimModelVal.get("containssub"));
                dimValMap.put("includeSubAdminOrg", dimModelVal.get("admincontainssub"));
                dimValMap.put("dimval", dimVal);
                dimValMap.put("id", dimVal);
                dimValMap.put("valueType", dimModelVal.getString("valtype"));
                dimValMap.put("dynamicCondition", dimModelVal.getString("dynacond.id"));
                dimModel.setLimit(dimModelVal.getBoolean("isall") ? "1" : "0");
                if (null != structProject) {
                    dimValMap.put("structProject", structProject);
                    dimValues.put(dimVal + "#" + structProject.getPkValue(), dimValMap);
                } else {
                    dimValues.put(dimVal, dimValMap);
                }
            });
            dimModel.setDimValues((Map)dimValues);
            dimMap.put(dimNumber, dimModel);
        });
        dimGrpModel.setDimMap(dimMap);
        dimGroupMap.put(roleImgGrp.getString("id"), dimGrpModel);
    }

    private static void setOrgList(Long buKey, List<DynamicObject> value, RoleDataPermModel roleDataPermModel, boolean newflag) {
        HashMap orgMap = Maps.newHashMapWithExpectedSize((int)16);
        roleDataPermModel.setHrBuCaFunc(buKey.longValue());
        value.forEach(dynamicObject -> {
            HashMap orgInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            orgInfoMap.put("id", dynamicObject.getString("org.id"));
            orgInfoMap.put("name", dynamicObject.getString("org.name"));
            orgInfoMap.put("includeSub", dynamicObject.getBoolean("includesuborg"));
            orgMap.put(dynamicObject.getString("org.id"), orgInfoMap);
        });
        if (newflag) {
            roleDataPermModel.setOrgMap(new HashMap());
        } else {
            roleDataPermModel.setOrgMap((Map)orgMap);
        }
    }

    public static Map<Long, List<DynamicObject>> getRoleBuGroupByBu(long schemeId, long roleEntryId, String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemeorg");
        DynamicObject[] roleBu = helper.queryOriginalArray("id,org.id,org.name,includesuborg,bucafunc", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("roleentryid", "=", (Object)roleEntryId), new QFilter("role", "=", (Object)roleId), new QFilter("iscurrentversion", "=", (Object)"1")});
        return Arrays.stream(roleBu).collect(Collectors.groupingBy(dy -> dy.getLong("bucafunc")));
    }

    public static DynamicObject[] getRoleDimgrp(long schemeId, long roleEntryId, String roleId, Set<Long> bucafuncid) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemedimgrp");
        DynamicObject[] roleBu = helper.query("id,index,bucafunc,dimvalentry,dimvalentry.dimension,dimvalentry.isall,dimvalentry.dimval,dimvalentry.containssub,dimvalentry.admincontainssub,dimvalentry.otclassify,dimvalentry.structproject,dimvalentry.valtype,dimvalentry.dynacond", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("roleentryid", "=", (Object)roleEntryId), new QFilter("role", "=", (Object)roleId), new QFilter("bucafunc", "in", bucafuncid), new QFilter("iscurrentversion", "=", (Object)"1")});
        return roleBu;
    }

    public static DynamicObject[] geDataRuleByApp(long schemeId, long roleEntryId, List<String> appIds, String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaschemedatarule");
        DynamicObject[] roleBu = helper.query("id,app,entitytype,dataruleentry,hrcs_rolebdruleentry,dataruleentry.datarule,dataruleentry.permitem,hrcs_rolebdruleentry.bddatarule,hrcs_rolebdruleentry.propkey,hrcs_rolebdruleentry.propentnum", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("roleentryid", "=", (Object)roleEntryId), new QFilter("app", "in", appIds), new QFilter("role", "=", (Object)roleId), new QFilter("iscurrentversion", "=", (Object)"1")});
        return roleBu;
    }

    public static Map<String, UserRoleFieldPermInfo> getRoleFieldPermInfoFromDatabase(long schemeId, long roleEntryId, String appIdStr, String entityNumStr, String roleId) {
        DynamicObject[] roleFieldDys;
        HashMap userRoleFieldPermInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper roleFieldHelper = new HRBaseServiceHelper("hrcs_dynaschemefield");
        QFilter qFilter = new QFilter("role", "=", (Object)roleId).and(new QFilter("scheme", "=", (Object)schemeId)).and(new QFilter("roleentryid", "=", (Object)roleEntryId)).and(new QFilter("iscurrentversion", "=", (Object)"1"));
        if (HRStringUtils.isNotEmpty((String)entityNumStr) && HRStringUtils.isNotEmpty((String)appIdStr)) {
            qFilter.and(new QFilter("entitytype", "=", (Object)entityNumStr)).and(new QFilter("app", "=", (Object)appIdStr));
        }
        if (Objects.isNull(roleFieldDys = roleFieldHelper.query("id, app,entitytype, fieldpermentry, fieldpermentry.fieldname, fieldpermentry.isbanread, fieldpermentry.isbanwrite", new QFilter[]{qFilter}))) {
            return userRoleFieldPermInfoMap;
        }
        for (DynamicObject roleFieldDy : roleFieldDys) {
            String appId = roleFieldDy.getString("app.id");
            String entityNum = roleFieldDy.getString("entitytype_id");
            String key = appId + "@" + entityNum;
            UserRoleFieldPermInfo userRoleFieldPermInfo = new UserRoleFieldPermInfo();
            userRoleFieldPermInfo.setId(roleFieldDy.getLong("id"));
            Map<String, String> fieldMap = RoleServiceHelper.getEntityFieldMap(entityNum);
            List<FieldPermModel> fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
            DynamicObjectCollection roleFieldEntry = roleFieldDy.getDynamicObjectCollection("fieldpermentry");
            for (DynamicObject userFieldRow : roleFieldEntry) {
                FieldPermModel fieldPermModel = new FieldPermModel();
                fieldPermModel.setRoleFieldId(roleId);
                fieldPermModel.setEntryId(userFieldRow.get("id"));
                String fieldName = userFieldRow.getString("fieldname");
                fieldPermModel.setFiledNum(fieldName);
                fieldPermModel.setEntityNum(entityNum);
                fieldPermModel.setFiledName(fieldMap.get(fieldName));
                fieldPermModel.setIsBanRead(DynaRoleDetailServiceHelper.getBlValue(userFieldRow.getString("isbanread")));
                fieldPermModel.setIsBanWrite(DynaRoleDetailServiceHelper.getBlValue(userFieldRow.getString("isbanwrite")));
                fieldPermModelList.add(fieldPermModel);
            }
            userRoleFieldPermInfoMap.put(key, userRoleFieldPermInfo);
        }
        return userRoleFieldPermInfoMap;
    }

    public static String getBlValue(String value) {
        if (HRStringUtils.equals((String)"true", (String)value)) {
            return "1";
        }
        if (HRStringUtils.equals((String)"false", (String)value)) {
            return "0";
        }
        if (HRStringUtils.equals((String)"1", (String)value)) {
            return "1";
        }
        if (HRStringUtils.equals((String)"0", (String)value)) {
            return "0";
        }
        return null;
    }
}

