/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perm.SceneRoleInfo;
import kd.hr.hrcs.common.model.perm.UserRoleRelat;
import kd.hr.hrcs.common.model.perm.dyna.ApplyRecord;
import kd.hr.hrcs.common.model.perm.dyna.AssignRecord;
import kd.hr.hrcs.common.model.perm.dyna.CancelRecord;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import kd.hr.hrcs.common.model.perm.dyna.PermFile;

@ExcludeFromJacocoGeneratedReport
public class DynaApplyRecordService {
    private static final Log LOGGER = LogFactory.getLog(DynaApplyRecordService.class);
    private static final HRBaseServiceHelper ASSIGN_APPLY_RECORD_HELPER = new HRBaseServiceHelper("hrcs_permapplybill");

    public static CancelRecord buildCancelRecord(UserRoleRelat userRoleRelat, DynaScheme schemeInfo) {
        Long schemeId = schemeInfo.getId();
        CancelRecord cancelRecord = new CancelRecord();
        cancelRecord.setPermFile(userRoleRelat.getPermFileId());
        cancelRecord.setRoleId(userRoleRelat.getRoleId());
        cancelRecord.setValidEnd(userRoleRelat.getValidEnd());
        cancelRecord.setValidStart(userRoleRelat.getValidStart());
        cancelRecord.setSchemeId(schemeId);
        cancelRecord.setUserId(userRoleRelat.getUserId());
        cancelRecord.setReason(userRoleRelat.getCancelReason());
        return cancelRecord;
    }

    public static void addUpdatedRelatRoleToApplyRecord(ApplyRecord applyRecord, List<DynamicObject> needUpdateRelatDynas, Long schemeId, SceneRoleInfo roleInfo, PermFile permFile) {
        if (CollectionUtils.isEmpty(needUpdateRelatDynas)) {
            return;
        }
        for (DynamicObject relatDyna : needUpdateRelatDynas) {
            AssignRecord assignRecord = new AssignRecord();
            assignRecord.setPermFile(Long.valueOf(relatDyna.getLong("permfile.id")));
            assignRecord.setSchemeId(schemeId);
            assignRecord.setRoleEntryId(roleInfo.getRoleEntryId());
            assignRecord.setValidStart(relatDyna.getDate("validstart"));
            assignRecord.setValidEnd(relatDyna.getDate("validend"));
            assignRecord.setDealWay("2");
            assignRecord.setUserId(Long.valueOf(relatDyna.getLong("user.id")));
            assignRecord.setRoleId(roleInfo.getRoleId());
            assignRecord.setFileChangeType(permFile.getChangeType());
            applyRecord.getAssignRdList().add(assignRecord);
            applyRecord.getUserSet().add(relatDyna.getLong("user.id"));
        }
    }

    public static void addAddedRelatRoleToApplyRecord(ApplyRecord applyRecord, UserRoleAssignParam assignParam, PermFile permFile) {
        AssignRecord assignRecord = new AssignRecord();
        assignRecord.setUserId(permFile.getUserId());
        assignRecord.setPermFile(assignParam.getPermFileId());
        assignRecord.setDealWay("1");
        assignRecord.setValidEnd(assignParam.getValidEnd());
        assignRecord.setValidStart(assignParam.getValidStart());
        assignRecord.setSchemeId(assignParam.getAssignSource().getSchemeId());
        assignRecord.setRoleId(assignParam.getRoleId());
        assignRecord.setFileChangeType(permFile.getChangeType());
        applyRecord.getAssignRdList().add(assignRecord);
        applyRecord.getUserSet().add(permFile.getUserId());
    }

    public static Set<Long> saveApplyRecord(ApplyRecord applyRecord) {
        LOGGER.info("DynaPermMsgConsumer saveApplyRecord entry model:{}", (Object)applyRecord);
        if (CollectionUtils.isEmpty((Collection)applyRecord.getAssignRdList()) && CollectionUtils.isEmpty((Collection)applyRecord.getCancelRdList())) {
            LOGGER.info("DynaPermMsgConsumer saveApplyRecord AssignRdList and CancelRdList is null. Exit");
            return Sets.newHashSet();
        }
        HashMap assignRdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object assignRecord : applyRecord.getAssignRdList()) {
            assignRdMap.computeIfAbsent(assignRecord.getUserId(), key -> new ArrayList(16)).add(assignRecord);
        }
        HashMap cancelRdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (CancelRecord cancelRecord : applyRecord.getCancelRdList()) {
            cancelRdMap.computeIfAbsent(cancelRecord.getUserId(), key -> new ArrayList(16)).add(cancelRecord);
        }
        DynamicObjectCollection addColl = new DynamicObjectCollection();
        String authAction = null;
        for (Long userId : applyRecord.getUserSet()) {
            List cancelRecords;
            DynamicObject record = ASSIGN_APPLY_RECORD_HELPER.generateEmptyDynamicObject();
            addColl.add((Object)record);
            record.set("billno", (Object)String.valueOf(System.currentTimeMillis()));
            record.set("message", (Object)applyRecord.getMessageId());
            record.set("msgpublisher", (Object)applyRecord.getMsgPublisher());
            record.set("user", (Object)userId);
            record.set("scene", (Object)applyRecord.getSceneId());
            record.set("auditstatus", (Object)"C");
            record.set("billstatus", (Object)"C");
            PermInitServiceHelper.setOperatorAndDate(record);
            DynamicObjectCollection assignEntryColl = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryCollection(record, "assignentry");
            DynamicObjectCollection cancelEntryColl = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryCollection(record, "cancelentry");
            record.set("assignentry", (Object)assignEntryColl);
            record.set("cancelentry", (Object)cancelEntryColl);
            List assignRecords = (List)assignRdMap.get(userId);
            if (!CollectionUtils.isEmpty((Collection)assignRecords)) {
                authAction = "1";
                for (AssignRecord assignRecord : assignRecords) {
                    DynamicObject entryDyna = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryDynamicObject("assignentry");
                    entryDyna.set("assign_permfile", (Object)assignRecord.getPermFile());
                    entryDyna.set("assign_role", (Object)assignRecord.getRoleId());
                    entryDyna.set("assign_scheme", (Object)assignRecord.getSchemeId());
                    entryDyna.set("assign_validstart", (Object)assignRecord.getValidStart());
                    entryDyna.set("assign_validend", (Object)assignRecord.getValidEnd());
                    entryDyna.set("assign_dealway", (Object)assignRecord.getDealWay());
                    entryDyna.set("assign_filechangetype", (Object)assignRecord.getFileChangeType());
                    assignEntryColl.add((Object)entryDyna);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(cancelRecords = (List)cancelRdMap.get(userId)))) {
                authAction = "2";
                for (CancelRecord cancelRecord : cancelRecords) {
                    DynamicObject entryDyna = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryDynamicObject("cancelentry");
                    entryDyna.set("cancel_permfile", (Object)cancelRecord.getPermFile());
                    entryDyna.set("cancel_role", (Object)cancelRecord.getRoleId());
                    entryDyna.set("cancel_scheme", (Object)cancelRecord.getSchemeId());
                    entryDyna.set("cancel_desc", (Object)cancelRecord.getDesc());
                    entryDyna.set("cancel_reason", (Object)cancelRecord.getReason());
                    cancelEntryColl.add((Object)entryDyna);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)cancelRecords) && !CollectionUtils.isEmpty((Collection)assignRecords)) {
                authAction = "3";
            }
            record.set("authaction", (Object)authAction);
        }
        Object[] applyDy = ASSIGN_APPLY_RECORD_HELPER.save(addColl);
        if (applyDy == null || applyDy.length == 0) {
            return Sets.newHashSet();
        }
        HashSet applyIdSet = Sets.newHashSetWithExpectedSize((int)applyDy.length);
        for (Object obj : applyDy) {
            DynamicObject dy = (DynamicObject)obj;
            applyIdSet.add(dy.getLong("id"));
        }
        return applyIdSet;
    }
}

