/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermCommonService;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import kd.hr.hrcs.common.model.perm.dyna.RuleParamCalResult;

@ExcludeFromJacocoGeneratedReport
public class DynaPermDealTraceService {
    private static final Log LOGGER = LogFactory.getLog(DynaPermDealTraceService.class);

    public static void writeDealTraceLog(DynaPermConsumeContext context) {
        try {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynamsgdealtrace");
            DynamicObject msgDealTraceDyna = helper.generateEmptyDynamicObject();
            msgDealTraceDyna.set("traceid", (Object)context.getTraceId());
            msgDealTraceDyna.set("message", (Object)context.getMsgId());
            msgDealTraceDyna.set("scene", (Object)context.getScene().getId());
            msgDealTraceDyna.set("assignds", (Object)context.getAssignDs().getId());
            if (!Objects.isNull(context.getCancelDs())) {
                msgDealTraceDyna.set("cancelds", (Object)context.getCancelDs().getId());
            }
            msgDealTraceDyna.set("dynadsperson", (Object)DynaPermCommonService.objectToString(context.getDsPersonList()));
            msgDealTraceDyna.set("chginforesult", (Object)DynaPermCommonService.objectToString(context.getChgInfoResult()));
            DynamicObjectCollection schemeEntryCollection = msgDealTraceDyna.getDynamicObjectCollection("schemeentry");
            DynamicObjectCollection calResultEntryCollection = msgDealTraceDyna.getDynamicObjectCollection("ruleparamcalentry");
            List schemeList = context.getSchemeList();
            for (DynaScheme scheme : schemeList) {
                DynamicObject row = schemeEntryCollection.addNew();
                row.set("scheme", (Object)scheme.getId());
                row.set("conditionsize", (Object)scheme.getCondition().length());
                row.set("assign_person", (Object)DynaPermCommonService.objectToString(scheme.getAssignPersonInfos()));
                row.set("assign_ruleparamval", (Object)DynaPermCommonService.objectToString(scheme.getAssignMatchRuleParamVal()));
                row.set("assign_matchresult", (Object)DynaPermCommonService.objectToString(scheme.getAssignMatchRuleResult()));
                row.set("assign_dealedperson", (Object)DynaPermCommonService.objectToString(scheme.getAssignDealedPersonInfos()));
                row.set("assign_matchedperson", (Object)DynaPermCommonService.objectToString(scheme.getMatchedAssignPersonInfos()));
                row.set("assign_permfile", (Object)DynaPermCommonService.objectToString(scheme.getNeedAssignPermFiles()));
                row.set("cancel_person", (Object)DynaPermCommonService.objectToString(scheme.getCancelPersonInfos()));
                row.set("cancel_ruleparamval", (Object)DynaPermCommonService.objectToString(scheme.getCancelMatchRuleParamVal()));
                row.set("cancel_matchresult", (Object)DynaPermCommonService.objectToString(scheme.getCancelMatchRuleResult()));
                row.set("cancel_dealedperson", (Object)DynaPermCommonService.objectToString(scheme.getCancelDealedPersonInfos()));
                row.set("cancel_nomatcheduser", (Object)DynaPermCommonService.objectToString(scheme.getNoMatchedUserIds()));
                row.set("cancel_relats", (Object)DynaPermCommonService.objectToString(scheme.getNeedCancelRelats()));
                for (RuleParamCalResult calResult : scheme.getRuleParamCalResults()) {
                    DynamicObject calResultDyna = calResultEntryCollection.addNew();
                    calResultDyna.set("calparam_scheme", (Object)calResult.getSchemeId());
                    DynamicObjectCollection ruleParamColl = calResultDyna.getDynamicObjectCollection("multiruleparam");
                    DynamicObjectType orgRangeType = ruleParamColl.getDynamicObjectType();
                    for (Long ruleParamId : calResult.getRuleParamIds()) {
                        DynamicObject ruleParamDyna = new DynamicObject(orgRangeType);
                        ruleParamDyna.set("fbasedataid", (Object)ruleParamId);
                        ruleParamColl.add((Object)ruleParamDyna);
                    }
                    calResultDyna.set("calmode", (Object)calResult.getCalMode());
                    calResultDyna.set("appnumber", (Object)calResult.getAppNumber());
                    calResultDyna.set("mserviceclass", (Object)calResult.getMserviceClass());
                    calResultDyna.set("mservicemethod", (Object)calResult.getMserviceMethod());
                    calResultDyna.set("apiinparam", (Object)calResult.getApiInParam());
                    calResultDyna.set("apiresult", (Object)calResult.getApiResult());
                    calResultDyna.set("ruleparamval", (Object)calResult.getRuleParamVal());
                }
            }
            helper.saveOne(msgDealTraceDyna);
        }
        catch (Exception ex) {
            LOGGER.error("DynaPermMsgConsumer writeDealTraceLog error. ", (Throwable)ex);
        }
    }
}

