/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.consume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.extpoint.permission.dyna.RuleMatchBO;
import kd.hr.hbp.business.extpoint.permission.dyna.RuleMatchResponseBO;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaFormulaService;
import kd.hr.hrcs.bussiness.service.perm.dyna.consume.DynaPermCommonService;
import kd.hr.hrcs.bussiness.service.perm.dyna.rulehandler.PermRuleMatchService;
import kd.hr.hrcs.bussiness.util.PermRuleValidateUtil;
import kd.hr.hrcs.common.model.perm.DepInfo;
import kd.hr.hrcs.common.model.perm.PermConditionInfo;
import kd.hr.hrcs.common.model.perm.PermRuleConditionInfo;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.dyna.ChgInfoResult;
import kd.hr.hrcs.common.model.perm.dyna.DynaApiInParam;
import kd.hr.hrcs.common.model.perm.dyna.DynaApiInfo;
import kd.hr.hrcs.common.model.perm.dyna.DynaDs;
import kd.hr.hrcs.common.model.perm.dyna.DynaDsParam;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsts;
import kd.hr.hrcs.common.model.perm.dyna.DynaPermConsumeContext;
import kd.hr.hrcs.common.model.perm.dyna.DynaRuleParam;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import kd.hr.hrcs.common.model.perm.dyna.RuleParamCalResult;

@ExcludeFromJacocoGeneratedReport
public class DynaSchemeMatchService {
    private static final Log LOGGER = LogFactory.getLog(DynaSchemeMatchService.class);

    public static void setAllRuleParamsToContext(DynaPermConsumeContext context) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaruleparam");
        DynamicObject[] allRuleParamDynaArr = helper.queryOriginalArray("id,number,datatype,entitytype.number,isrelatparam,relatruleparam.id,relatpropkey", null);
        HashMap ruleParamMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap allRuleParamDynaMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject ruleParamDyna : allRuleParamDynaArr) {
            Long id = ruleParamDyna.getLong("id");
            allRuleParamDynaMap.put(id, ruleParamDyna);
            DynaRuleParam dynaRuleParam = new DynaRuleParam();
            dynaRuleParam.setId(id);
            dynaRuleParam.setNumber(ruleParamDyna.getString("number"));
            dynaRuleParam.setDataType(ruleParamDyna.getString("datatype"));
            dynaRuleParam.setEntityType(ruleParamDyna.getString("entitytype.number"));
            Boolean isRelatParam = ruleParamDyna.getBoolean("isrelatparam");
            dynaRuleParam.setIsRelatParam(isRelatParam);
            if (isRelatParam.booleanValue()) {
                dynaRuleParam.setRelatRuleParamId(Long.valueOf(ruleParamDyna.getLong("relatruleparam.id")));
                dynaRuleParam.setRelatPropKey(ruleParamDyna.getString("relatpropkey"));
            }
            ruleParamMap.put(id, dynaRuleParam);
        }
        context.setAllRuleParamMap((Map)ruleParamMap);
        context.setAllRuleParamDynaMap((Map)allRuleParamDynaMap);
    }

    public static Map<Long, DynaApiInfo> getApiInParamInfoByDs(DynaDs dynaDs) {
        List paramList = dynaDs.getParamList();
        Set publisherDsIds = paramList.stream().filter(param -> !Objects.equals(param.getPublisherDsId(), 0L)).map(DynaDsParam::getPublisherDsId).collect(Collectors.toSet());
        Set apiIds = paramList.stream().filter(param -> !Objects.equals(param.getApiSourceId(), 0L)).map(DynaDsParam::getApiSourceId).collect(Collectors.toSet());
        HRBaseServiceHelper publisherDsHelper = new HRBaseServiceHelper("hrcs_dynapublisherds");
        DynamicObject[] publisherDsDynaArr = publisherDsHelper.query("id,apisource.id,paramentry.apifieldkey,paramentry.seq,paramentry.inputparamentryid,paramentry.invokeapisource", new QFilter[]{new QFilter("id", "in", publisherDsIds)});
        HRBaseServiceHelper apiHelper = new HRBaseServiceHelper("hrcs_apideploy");
        DynamicObject[] apiDynaArr = apiHelper.query("id,type,bizcloud.number,bizapp.number,bizapp.isv,service,method,inputentryentity.id,inputentryentity.inputfieldkey,inputentryentity.inputfieldtype,inputentryentity.inputfielddefault,inputentryentity.seq,entryfield1.id,entryfield1.apifieldtype1,entryfield1.apifieldkey1,entryfield1.seq", new QFilter[]{new QFilter("id", "in", apiIds)});
        HashMap apiDynaMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(apiDynaArr).forEach(dyna -> apiDynaMap.put(dyna.getLong("id"), dyna));
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyna2 : publisherDsDynaArr) {
            DynaApiInfo dynaApiInfo = new DynaApiInfo();
            dynaApiInfo.setPublisherDsId(Long.valueOf(dyna2.getLong("id")));
            Long apiId = dyna2.getLong("apisource.id");
            dynaApiInfo.setApiSourceId(apiId);
            DynamicObject apiDyna = (DynamicObject)apiDynaMap.get(apiId);
            HashMap customInParamEntryDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap configInParamEntryDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            if (apiDyna != null) {
                dynaApiInfo.setType(apiDyna.getString("type"));
                dynaApiInfo.setCloudNumber(apiDyna.getString("bizcloud.number"));
                dynaApiInfo.setAppNumber(apiDyna.getString("bizapp.number"));
                dynaApiInfo.setIsv(apiDyna.getString("bizapp.isv"));
                dynaApiInfo.setServiceClass(apiDyna.getString("service"));
                dynaApiInfo.setMethod(apiDyna.getString("method"));
                for (DynamicObject inParamEntryDyna : apiDyna.getDynamicObjectCollection("inputentryentity")) {
                    customInParamEntryDynaMap.put(inParamEntryDyna.getLong("id"), inParamEntryDyna);
                }
                for (DynamicObject inParamEntryDyna : apiDyna.getDynamicObjectCollection("entryfield1")) {
                    configInParamEntryDynaMap.put(inParamEntryDyna.getLong("id"), inParamEntryDyna);
                }
            }
            ArrayList apiInParams = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObjectCollection paramEntry = dyna2.getDynamicObjectCollection("paramentry");
            for (DynamicObject entryDyna : paramEntry) {
                DynamicObject inParamEntryDyna;
                DynaApiInParam inParam = new DynaApiInParam();
                inParam.setInParamEntryId(Long.valueOf(entryDyna.getLong("inputparamentryid")));
                inParam.setSrcFieldKey(entryDyna.getString("apifieldkey"));
                inParam.setInvokeApiSourceId(Long.valueOf(entryDyna.getLong("invokeapisource.id")));
                if (HRStringUtils.equals((String)dynaApiInfo.getType(), (String)"2")) {
                    inParamEntryDyna = (DynamicObject)customInParamEntryDynaMap.get(entryDyna.getLong("inputparamentryid"));
                    if (Objects.isNull(inParamEntryDyna)) {
                        LOGGER.warn("DynaPermMsgConsumer getApiInParamInfoByDs customApi apiinput entryid not exist!!!! apiId:{},entryid:{}", (Object)apiId, (Object)entryDyna.getLong("inputparamentryid"));
                        continue;
                    }
                    inParam.setInParamType(inParamEntryDyna.getString("inputfieldtype"));
                    inParam.setInParamDefault(inParamEntryDyna.getString("inputfielddefault"));
                    inParam.setInputFieldKey(inParamEntryDyna.getString("inputfieldkey"));
                    inParam.setSeq(Integer.valueOf(inParamEntryDyna.getInt("seq")));
                } else if (HRStringUtils.equals((String)dynaApiInfo.getType(), (String)"1")) {
                    inParamEntryDyna = (DynamicObject)configInParamEntryDynaMap.get(entryDyna.getLong("inputparamentryid"));
                    if (Objects.isNull(inParamEntryDyna)) {
                        LOGGER.warn("DynaPermMsgConsumer getApiInParamInfoByDs configedApi apiinput entryid not exist!!!! apiId:{},entryid:{}", (Object)apiId, (Object)entryDyna.getLong("inputparamentryid"));
                        continue;
                    }
                    inParam.setInParamType(inParamEntryDyna.getString("apifieldtype1"));
                    inParam.setInputFieldKey(inParamEntryDyna.getString("apifieldkey1"));
                    inParam.setSeq(Integer.valueOf(inParamEntryDyna.getInt("seq")));
                }
                apiInParams.add(inParam);
            }
            Collections.sort(apiInParams, new Comparator<DynaApiInParam>(){

                @Override
                public int compare(DynaApiInParam o1, DynaApiInParam o2) {
                    return o1.getSeq().compareTo(o2.getSeq());
                }
            });
            dynaApiInfo.setApiInParams((List)apiInParams);
            result.put(dynaApiInfo.getPublisherDsId(), dynaApiInfo);
        }
        LOGGER.info("DynaPermMsgConsumer getApiInParamInfoByDs datasource number:{},apiInfoMap:{}", (Object)dynaDs.getNumber(), (Object)result);
        return result;
    }

    private static List<PersonInfo> clonePersonInfos(List<PersonInfo> personInfos, Boolean isMatch, String matchMsg) {
        ArrayList dealedPersonInfos = Lists.newArrayListWithExpectedSize((int)personInfos.size());
        for (PersonInfo PersonInfo2 : personInfos) {
            PersonInfo dealedPersonInfo = (PersonInfo)PersonInfo2.clone();
            dealedPersonInfo.setIsMatchRule(isMatch);
            dealedPersonInfo.setMatchRuleMsg(matchMsg);
            Set depSet = PersonInfo2.getDepSet();
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)depSet)) {
                HashSet dealedDepSet = Sets.newHashSetWithExpectedSize((int)depSet.size());
                for (DepInfo depInfo : depSet) {
                    DepInfo dealedDepInfo = (DepInfo)depInfo.clone();
                    dealedDepInfo.setIsMatchRule(isMatch);
                    dealedDepInfo.setMatchRuleMsg(matchMsg);
                    dealedDepSet.add(dealedDepInfo);
                }
                dealedPersonInfo.setDepSet((Set)dealedDepSet);
            }
            dealedPersonInfos.add(dealedPersonInfo);
        }
        return dealedPersonInfos;
    }

    public static List<PersonInfo> schemeMatchRule(DynaPermConsumeContext context, String authAction, DynaScheme scheme, List<PersonInfo> schemePersonInfos, DynamicObject dataSource, Map<Long, DynaApiInfo> apiInfoMap) {
        if (HRStringUtils.isEmpty((String)scheme.getCondition())) {
            if (HRStringUtils.equals((String)authAction, (String)"1")) {
                List<PersonInfo> dealedPersonInfos = DynaSchemeMatchService.clonePersonInfos(schemePersonInfos, true, "");
                scheme.setAssignDealedPersonInfos(dealedPersonInfos);
                return dealedPersonInfos;
            }
            if (HRStringUtils.equals((String)authAction, (String)"2")) {
                List<PersonInfo> dealedPersonInfos = DynaSchemeMatchService.clonePersonInfos(schemePersonInfos, false, ResManager.loadKDString((String)"\u6761\u4ef6\u4e3a\u7a7a\uff0c\u9700\u8981\u53d6\u6d88\u3002", (String)"DynaSchemeService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                scheme.setCancelDealedPersonInfos(dealedPersonInfos);
                return dealedPersonInfos;
            }
        }
        PermRuleConditionInfo ruleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)scheme.getCondition(), PermRuleConditionInfo.class);
        List conditionList = ruleConditionInfo.getConditionList();
        Map allRuleParamMap = context.getAllRuleParamMap();
        HashSet schemeRuleParamIds = Sets.newHashSetWithExpectedSize((int)16);
        for (PermConditionInfo conditionInfo : conditionList) {
            Long ruleParamId = Long.parseLong(conditionInfo.getParam());
            schemeRuleParamIds.add(ruleParamId);
            DynaRuleParam dynaRuleParam = (DynaRuleParam)allRuleParamMap.get(ruleParamId);
            if (dynaRuleParam == null || !dynaRuleParam.getIsRelatParam().booleanValue()) continue;
            schemeRuleParamIds.add(dynaRuleParam.getRelatRuleParamId());
        }
        List dsParamList = Lists.newArrayListWithExpectedSize((int)16);
        if (HRStringUtils.equals((String)authAction, (String)"1")) {
            dsParamList = context.getAssignDs().getParamList();
        } else if (HRStringUtils.equals((String)authAction, (String)"2")) {
            dsParamList = context.getCancelDs().getParamList();
        }
        ArrayList schemeParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (Object dsParam : dsParamList) {
            if (!schemeRuleParamIds.contains(dsParam.getRuleParamId())) continue;
            schemeParamList.add(dsParam);
        }
        HashMap sameApiMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object dsParam : schemeParamList) {
            if (!HRStringUtils.equals((String)dsParam.getFetchMode(), (String)"1") || !HRStringUtils.equals((String)dsParam.getFetchSource(), (String)"2")) continue;
            Long publisherDsId = dsParam.getPublisherDsId();
            List apiRuleParamIds = sameApiMap.getOrDefault(publisherDsId, Lists.newArrayListWithExpectedSize((int)16));
            apiRuleParamIds.add(dsParam.getRuleParamId());
            sameApiMap.put(publisherDsId, apiRuleParamIds);
        }
        HashMap dsParamMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynaDsParam dsParam : schemeParamList) {
            dsParamMap.put(dsParam.getRuleParamId(), dsParam);
        }
        RuleMatchBO ruleMatchBO = new RuleMatchBO();
        Map allRuleParamDynaMap = context.getAllRuleParamDynaMap();
        HashMap schemeRuleParamDynaMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Long ruleParamId : schemeRuleParamIds) {
            schemeRuleParamDynaMap.put(ruleParamId.toString(), allRuleParamDynaMap.get(ruleParamId));
        }
        ruleMatchBO.setRuleParamMap((Map)schemeRuleParamDynaMap);
        HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)1);
        conditionMap.put(scheme.getId(), scheme.getCondition());
        ruleMatchBO.setConditionMap((Map)conditionMap);
        ArrayList schemeRuleParamCalResults = Lists.newArrayListWithExpectedSize((int)16);
        HashMap bizDataMap = Maps.newHashMapWithExpectedSize((int)16);
        for (PersonInfo personInfo : schemePersonInfos) {
            Set depSet = personInfo.getDepSet();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)depSet)) {
                ArrayList ruleParamCalResults = Lists.newArrayListWithExpectedSize((int)16);
                List<Map<String, Object>> singleMatchRuleDataParam = DynaSchemeMatchService.buildSingleMatchBizData(context, sameApiMap, dsParamMap, apiInfoMap, schemeRuleParamIds, personInfo, personInfo.getDepempId(), ruleParamCalResults);
                bizDataMap.put(personInfo.getUserId(), singleMatchRuleDataParam);
                schemeRuleParamCalResults.addAll(ruleParamCalResults);
                continue;
            }
            for (DepInfo depInfo : depSet) {
                ArrayList ruleParamCalResults = Lists.newArrayListWithExpectedSize((int)16);
                List<Map<String, Object>> singleMatchRuleDataParam = DynaSchemeMatchService.buildSingleMatchBizData(context, sameApiMap, dsParamMap, apiInfoMap, schemeRuleParamIds, personInfo, depInfo.getDepId(), ruleParamCalResults);
                bizDataMap.put(depInfo.getDepId(), singleMatchRuleDataParam);
                schemeRuleParamCalResults.addAll(ruleParamCalResults);
            }
        }
        schemeRuleParamCalResults.stream().forEach(calResult -> calResult.setSchemeId(scheme.getId()));
        scheme.setRuleParamCalResults((List)schemeRuleParamCalResults);
        DynaSchemeMatchService.fillBoId(conditionMap, schemeRuleParamDynaMap, bizDataMap);
        DynaSchemeMatchService.replaceOrgLongNum(conditionMap, schemeRuleParamDynaMap, bizDataMap);
        ruleMatchBO.setBizDataMap((Map)bizDataMap);
        LOGGER.info("DynaPermMsgConsumer matchRule entry params,conditionMap:{} ,bizDataMap:{}", (Object)ruleMatchBO.getConditionMap(), (Object)bizDataMap);
        Map<Long, Map<Long, RuleMatchResponseBO>> matchRuleResultMap = new PermRuleMatchService().matchRule(ruleMatchBO);
        LOGGER.info("DynaPermMsgConsumer matchRule result, matchRuleResultMap:{},come from schemeInfo:{} ", matchRuleResultMap, (Object)scheme.getName());
        Map<Long, RuleMatchResponseBO> schemeMatchResponseBOMap = matchRuleResultMap.get(scheme.getId());
        ArrayList dealedPersonInfos = Lists.newArrayListWithExpectedSize((int)16);
        for (PersonInfo personInfo : schemePersonInfos) {
            Set depSet = personInfo.getDepSet();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)depSet)) {
                RuleMatchResponseBO ruleMatchResponseBO = schemeMatchResponseBOMap.get(personInfo.getUserId());
                PersonInfo dealedPersonInfo = (PersonInfo)personInfo.clone();
                dealedPersonInfo.setIsMatchRule(Boolean.valueOf(ruleMatchResponseBO.isMatch()));
                dealedPersonInfo.setMatchRuleMsg(ruleMatchResponseBO.getMsg());
                dealedPersonInfos.add(dealedPersonInfo);
                continue;
            }
            PersonInfo dealedPersonInfo = (PersonInfo)personInfo.clone();
            HashSet dealedDepInfos = Sets.newHashSetWithExpectedSize((int)depSet.size());
            for (DepInfo depInfo : depSet) {
                RuleMatchResponseBO ruleMatchResponseBO = schemeMatchResponseBOMap.get(depInfo.getDepId());
                DepInfo dealedDepInfo = (DepInfo)depInfo.clone();
                dealedDepInfo.setIsMatchRule(Boolean.valueOf(ruleMatchResponseBO.isMatch()));
                if (ruleMatchResponseBO.isMatch()) {
                    dealedPersonInfo.setIsMatchRule(Boolean.valueOf(true));
                }
                dealedDepInfo.setMatchRuleMsg(ruleMatchResponseBO.getMsg());
                dealedDepInfos.add(dealedDepInfo);
            }
            dealedPersonInfo.setDepSet((Set)dealedDepInfos);
            dealedPersonInfos.add(dealedPersonInfo);
        }
        if (HRStringUtils.equals((String)authAction, (String)"1")) {
            scheme.setAssignMatchRuleParamVal((Map)bizDataMap);
            scheme.setAssignMatchRuleResult(matchRuleResultMap);
            scheme.setAssignDealedPersonInfos((List)dealedPersonInfos);
        } else if (HRStringUtils.equals((String)authAction, (String)"2")) {
            scheme.setCancelMatchRuleParamVal((Map)bizDataMap);
            scheme.setCancelMatchRuleResult(matchRuleResultMap);
            scheme.setCancelDealedPersonInfos((List)dealedPersonInfos);
        }
        return dealedPersonInfos;
    }

    private static List<Map<String, Object>> buildSingleMatchBizData(DynaPermConsumeContext context, Map<Long, List<Long>> sameApiMap, Map<Long, DynaDsParam> dsParamMap, Map<Long, DynaApiInfo> apiInfoMap, Set<Long> schemeRuleParamIds, PersonInfo personInfo, Long depId, List<RuleParamCalResult> ruleParamCalResults) {
        ArrayList ruleParamValueResult = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<Long, List<Long>> entry : sameApiMap.entrySet()) {
            Object paramValMap;
            List<Long> apiRuleParamIds = entry.getValue();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(apiRuleParamIds)) continue;
            DynaApiInfo apiInfo = apiInfoMap.get(entry.getKey());
            Object cloudNumber = apiInfo.getCloudNumber().toLowerCase(Locale.ROOT);
            String appNumber = apiInfo.getAppNumber();
            ArrayList invokeParams = Lists.newArrayListWithExpectedSize((int)16);
            if (HRStringUtils.equals((String)apiInfo.getType(), (String)"2")) {
                for (Object apiInParam : apiInfo.getApiInParams()) {
                    ChgInfoResult chgInfoResult = DynaPermCommonService.getChgInfoResultFromContext(context, apiInParam.getInvokeApiSourceId());
                    invokeParams.add(DynaPermCommonService.getApiInParamValueByFieldKey((DynaApiInParam)apiInParam, chgInfoResult, personInfo, depId));
                }
            } else if (HRStringUtils.equals((String)apiInfo.getType(), (String)"1")) {
                Object apiInParam;
                cloudNumber = "hrmp";
                appNumber = "hrcs";
                QFilter resultQFilter = null;
                apiInParam = apiInfo.getApiInParams().iterator();
                while (apiInParam.hasNext()) {
                    DynaApiInParam apiInParam2 = (DynaApiInParam)apiInParam.next();
                    ChgInfoResult chgInfoResult = DynaPermCommonService.getChgInfoResultFromContext(context, apiInParam2.getInvokeApiSourceId());
                    Object object = DynaPermCommonService.getApiInParamValueByFieldKey(apiInParam2, chgInfoResult, personInfo, depId);
                    QFilter qFilter = new QFilter(apiInParam2.getInputFieldKey(), "=", object);
                    if (resultQFilter == null) {
                        resultQFilter = qFilter;
                        continue;
                    }
                    resultQFilter = resultQFilter.and(qFilter);
                }
                invokeParams.add(apiInfo.getApiSourceId());
                invokeParams.add(resultQFilter);
                invokeParams.add("");
            }
            LOGGER.info("DynaPermMsgConsumer buildSingleMatchBizData ready to invokeBizService coludNumber:{},appNumber:{},serviceClass:{},method:{},params:{}", new Object[]{cloudNumber, appNumber, apiInfo.getServiceClass(), apiInfo.getMethod(), invokeParams});
            Object mserviceResult = DynaPermCommonService.invokeMservice((String)cloudNumber, appNumber, apiInfo, invokeParams.toArray());
            LOGGER.info("DynaPermMsgConsumer buildSingleMatchBizData invokeBizService result coludNumber:{},appNumber:{},serviceClass:{},method:{},mserviceResult:{}", new Object[]{cloudNumber, appNumber, apiInfo.getServiceClass(), apiInfo.getMethod(), mserviceResult});
            ArrayList ruleParamVals = Lists.newArrayListWithExpectedSize((int)16);
            if (mserviceResult instanceof List) {
                List<Map<String, Object>> mserviceResultList = (List<Map<String, Object>>)mserviceResult;
                mserviceResultList = DynaPermCommonService.trimBusinessStatus(mserviceResultList);
                LOGGER.info("DynaPermMsgConsumer buildSingleMatchBizData after trimBusinessStatus,mserviceResult:{}", mserviceResultList);
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(mserviceResultList) && apiRuleParamIds.size() == 1 && Objects.equals(apiRuleParamIds.get(0), DynaPermConsts.RULEPARAMID_ISCADRE)) {
                    paramValMap = Maps.newHashMapWithExpectedSize((int)1);
                    paramValMap.put(DynaPermConsts.RULEPARAMID_ISCADRE.toString(), Boolean.FALSE);
                    ruleParamVals.add(paramValMap);
                } else {
                    for (Map map : mserviceResultList) {
                        HashMap paramValMap2 = Maps.newHashMapWithExpectedSize((int)16);
                        for (Long ruleParamId : apiRuleParamIds) {
                            DynaDsParam dsParamTemp = dsParamMap.get(ruleParamId);
                            Object paramValue = DynaPermCommonService.getPropValFromMserviceMap(map, dsParamTemp.getPropKey(), context, ruleParamId);
                            paramValMap2.put(ruleParamId.toString(), paramValue);
                        }
                        ruleParamVals.add(paramValMap2);
                    }
                }
            } else if (mserviceResult instanceof Map) {
                Map mserviceResultMap = (Map)mserviceResult;
                paramValMap = Maps.newHashMapWithExpectedSize((int)16);
                for (Long ruleParamId : apiRuleParamIds) {
                    DynaDsParam dsParamTemp = dsParamMap.get(ruleParamId);
                    Object paramValue = DynaPermCommonService.getPropValFromMserviceMap(mserviceResultMap, dsParamTemp.getPropKey(), context, ruleParamId);
                    paramValMap.put(ruleParamId.toString(), paramValue);
                }
                ruleParamVals.add(paramValMap);
            }
            RuleParamCalResult ruleParamCalResult = new RuleParamCalResult();
            ruleParamCalResult.setRuleParamIds(apiRuleParamIds);
            ruleParamCalResult.setCalMode("2");
            ruleParamCalResult.setAppNumber(apiInfo.getAppNumber());
            ruleParamCalResult.setMserviceClass(apiInfo.getServiceClass());
            ruleParamCalResult.setMserviceMethod(apiInfo.getMethod());
            ruleParamCalResult.setApiInParam(((Object)invokeParams).toString());
            ruleParamCalResult.setApiResult(mserviceResult.toString());
            ruleParamCalResult.setRuleParamVal(((Object)ruleParamVals).toString());
            ruleParamCalResult.setDepempId(depId);
            ruleParamCalResults.add(ruleParamCalResult);
            ruleParamValueResult.add(ruleParamVals);
        }
        DynamicObject billDyna = context.getBillDyna();
        Map<String, List<String>> entryNumMap = DynaSchemeMatchService.loadMetaField(billDyna.getDynamicObjectType().getName());
        Map originData = null;
        if (billDyna != null) {
            originData = DynamicObjectUtil.serializeToMap((DynamicObject)billDyna);
        }
        Map allRuleParamMap = context.getAllRuleParamMap();
        for (Long ruleParamId : schemeRuleParamIds) {
            DynaDsParam dsParam = dsParamMap.get(ruleParamId);
            if (dsParam == null) continue;
            RuleParamCalResult ruleParamCalResult = new RuleParamCalResult();
            ruleParamCalResult.setRuleParamIds((List)Lists.newArrayList((Object[])new Long[]{ruleParamId}));
            ruleParamCalResult.setDepempId(depId);
            if (HRStringUtils.equals((String)dsParam.getFetchMode(), (String)"1")) {
                if (!HRStringUtils.equals((String)dsParam.getFetchSource(), (String)"1") || originData == null) continue;
                String newPropKey = DynaSchemeMatchService.getNewPropKey(dsParam.getPropKey(), entryNumMap);
                DynaRuleParam dynaRuleParam = (DynaRuleParam)allRuleParamMap.get(ruleParamId);
                if (dynaRuleParam == null) continue;
                Object value = DynaSchemeMatchService.getValue(newPropKey, originData, dynaRuleParam.getDataType());
                HashMap hashMap = Maps.newHashMapWithExpectedSize((int)1);
                hashMap.put(ruleParamId.toString(), value);
                ArrayList ruleParamValList = Lists.newArrayListWithExpectedSize((int)1);
                ruleParamValList.add(hashMap);
                ruleParamValueResult.add(ruleParamValList);
                ruleParamCalResult.setCalMode("1");
                ruleParamCalResult.setRuleParamVal(((Object)ruleParamValList).toString());
                ruleParamCalResults.add(ruleParamCalResult);
                continue;
            }
            if (!HRStringUtils.equals((String)dsParam.getFetchMode(), (String)"2")) continue;
            Long formulaId = dsParam.getFormulaId();
            List<Map<String, Object>> formulaValList = DynaFormulaService.calRuleParamVal(context, ruleParamId, formulaId, personInfo, depId);
            ruleParamValueResult.add(formulaValList);
            ruleParamCalResult.setCalMode("3");
            ruleParamCalResult.setRuleParamVal(formulaValList.toString());
            ruleParamCalResults.add(ruleParamCalResult);
        }
        for (List ruleParamValueMap : ruleParamValueResult) {
            for (Map ruleParmValueMap : ruleParamValueMap) {
                HashMap clonedRuleParmValueMap = Maps.newHashMap((Map)ruleParmValueMap);
                for (Map.Entry ruleParmValueEntry : clonedRuleParmValueMap.entrySet()) {
                    Long l = Long.parseLong((String)ruleParmValueEntry.getKey());
                    Object mainId = ruleParmValueEntry.getValue();
                    List<DynaRuleParam> relatedRuleParams = DynaSchemeMatchService.getRelatedRuleParams(l, schemeRuleParamIds, allRuleParamMap);
                    for (DynaRuleParam dynaRuleParam : relatedRuleParams) {
                        DynaRuleParam mainRuleParam = (DynaRuleParam)allRuleParamMap.get(l);
                        Object relatRuleParamValue = DynaSchemeMatchService.getRelatRuleParamValByMainRuleParam(mainRuleParam.getEntityType(), mainId, dynaRuleParam.getRelatPropKey(), dynaRuleParam.getDataType());
                        ruleParmValueMap.put(dynaRuleParam.getId().toString(), relatRuleParamValue);
                        RuleParamCalResult ruleParamCalResult = new RuleParamCalResult();
                        ruleParamCalResult.setRuleParamIds((List)Lists.newArrayList((Object[])new Long[]{dynaRuleParam.getId()}));
                        ruleParamCalResult.setCalMode("4");
                        ruleParamCalResult.setDepempId(depId);
                        ruleParamCalResult.setRuleParamVal(DynaPermCommonService.objectToString(relatRuleParamValue));
                        ruleParamCalResults.add(ruleParamCalResult);
                    }
                }
            }
        }
        ArrayList matchRuleDataParam = Lists.newArrayListWithExpectedSize((int)16);
        List cartesianList = Lists.cartesianProduct((List)ruleParamValueResult);
        for (List cartesian : cartesianList) {
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)cartesian)) continue;
            HashMap rowDataMap = Maps.newHashMapWithExpectedSize((int)cartesian.size());
            for (Map map : cartesian) {
                rowDataMap.putAll(map);
            }
            matchRuleDataParam.add(rowDataMap);
        }
        return matchRuleDataParam;
    }

    private static Object getRelatRuleParamValByMainRuleParam(String entityNumber, Object mainId, String propKey, String relatDataType) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        DynamicObject mainDyna = helper.queryOne(mainId);
        if (Objects.isNull(mainDyna)) {
            return null;
        }
        if (HRStringUtils.equals((String)relatDataType, (String)"bd") || HRStringUtils.equals((String)relatDataType, (String)"org")) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map entityMap = entityType.getAllFields();
            IDataEntityProperty property = (IDataEntityProperty)entityMap.get(propKey);
            if (property == null) {
                return null;
            }
            if (property instanceof BasedataProp) {
                return mainDyna.get(propKey + ".id");
            }
            if (property instanceof MulBasedataProp) {
                DynamicObjectCollection valDynaColl = mainDyna.getDynamicObjectCollection(propKey);
                List valList = valDynaColl.stream().map(dyna -> dyna.get("fbasedataid_id")).collect(Collectors.toList());
                return valList;
            }
        } else {
            return mainDyna.get(propKey);
        }
        return null;
    }

    private static List<DynaRuleParam> getRelatedRuleParams(Long mainRuleParamId, Set<Long> schemeRuleParamIds, Map<Long, DynaRuleParam> allRuleParamMap) {
        ArrayList ruleParams = Lists.newArrayListWithCapacity((int)16);
        for (Long ruleParamId : schemeRuleParamIds) {
            DynaRuleParam dynaRuleParam = allRuleParamMap.get(ruleParamId);
            if (dynaRuleParam == null || !dynaRuleParam.getIsRelatParam().booleanValue() || !Objects.equals(dynaRuleParam.getRelatRuleParamId(), mainRuleParamId)) continue;
            ruleParams.add(dynaRuleParam);
        }
        return ruleParams;
    }

    private static Object getValue(String proKey, Map<String, Object> originData, String type) {
        String[] split = proKey.split("\\.");
        return DynaSchemeMatchService.getValue(originData.get(split[0]), split, 0, type);
    }

    private static Object getValue(Object bizValue, String[] filedSplit, int index, String type) {
        Object result = null;
        if (index == filedSplit.length - 1) {
            if ("bd".equals(type) || "org".equals(type)) {
                if (bizValue instanceof List) {
                    List mulCol = (List)bizValue;
                    ArrayList idList = Lists.newArrayListWithExpectedSize((int)mulCol.size());
                    for (Map map : mulCol) {
                        idList.add(map.get("fbasedataid_id"));
                    }
                    bizValue = idList;
                } else if (bizValue instanceof Map) {
                    Map map = (Map)bizValue;
                    Object id = map.get("boid");
                    bizValue = id == null ? map.get("id") : id;
                }
            }
            return bizValue;
        }
        String propKey = filedSplit[index];
        if (bizValue instanceof List) {
            List list = (List)bizValue;
            result = Lists.newArrayListWithExpectedSize((int)list.size());
            ++index;
            for (Map map : list) {
                Object value = DynaSchemeMatchService.getValue(map.get(propKey), filedSplit, index, type);
                ((List)result).add(value);
            }
        } else if (bizValue instanceof Map) {
            Map map = (Map)bizValue;
            result = DynaSchemeMatchService.getValue(map.get(propKey), filedSplit, ++index, type);
        }
        return result;
    }

    private static Map<String, List<String>> loadMetaField(String entityNum) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        Map allFields = dataEntityType.getAllFields();
        HashMap entryNumMap = Maps.newHashMapWithExpectedSize((int)allFields.size());
        for (Map.Entry entry : allFields.entrySet()) {
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            DynaSchemeMatchService.addEntryKey(value, entryNumMap);
        }
        return entryNumMap;
    }

    private static void addEntryKey(IDataEntityProperty property, Map<String, List<String>> entryNumMap) {
        block4: {
            block3: {
                if (property.getParent() instanceof EntryType) {
                    List<String> entryNumList = entryNumMap.getOrDefault(property.getName(), Lists.newArrayListWithExpectedSize((int)3));
                    entryNumList.add(property.getParent().getName());
                    entryNumMap.put(property.getName(), entryNumList);
                }
                if (!(property instanceof BasedataProp)) break block3;
                IDataEntityType complexType = ((BasedataProp)property).getComplexType();
                DataEntityPropertyCollection properties = complexType.getProperties();
                for (IDataEntityProperty sonProperty : properties) {
                    DynaSchemeMatchService.addEntryKey(sonProperty, entryNumMap);
                }
                break block4;
            }
            if (!(property instanceof EntryProp)) break block4;
            DynamicObjectType dynamicObjectType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
            for (IDataEntityProperty sonProperty : properties) {
                DynaSchemeMatchService.addEntryKey(sonProperty, entryNumMap);
            }
        }
    }

    private static String getNewPropKey(String oldKey, Map<String, List<String>> entryNumMap) {
        String[] split = oldKey.split("\\.");
        ArrayList keyList = Lists.newArrayListWithExpectedSize((int)split.length);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)entryNumMap.size());
        for (String propKey : split) {
            Integer count;
            List<String> entryNumList = entryNumMap.get(propKey);
            Integer n = count = countMap.get(propKey) == null ? Integer.valueOf(0) : (Integer)countMap.get(propKey);
            if (!CollectionUtils.isEmpty(entryNumList)) {
                if (count > 0) {
                    entryNumList.remove(0);
                }
                if (!entryNumList.isEmpty()) {
                    keyList.add(entryNumList.get(0));
                    Integer n2 = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    countMap.put(propKey, count);
                }
            }
            keyList.add(propKey);
        }
        return String.join((CharSequence)".", keyList);
    }

    private static void fillBoId(Map<Long, String> conditionMap, Map<String, DynamicObject> paramMap, Map<Long, List<Map<String, Object>>> bizDataMap) {
        HashMap fieldBaseEntityMap = Maps.newHashMapWithExpectedSize((int)paramMap.size());
        for (Map.Entry<Long, String> entry : conditionMap.entrySet()) {
            if (PermRuleValidateUtil.isDecisionSetConditionEmpty(entry.getValue())) continue;
            PermRuleConditionInfo permRuleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)entry.getValue(), PermRuleConditionInfo.class);
            List conditionList = permRuleConditionInfo.getConditionList();
            for (Object permConditionInfo : conditionList) {
                String suitType;
                String string = permConditionInfo.getParam();
                DynamicObject paramDyn = paramMap.get(string);
                if (paramDyn == null || !"bd".equals(suitType = paramDyn.getString("datatype")) && !"org".equals(suitType)) continue;
                String baseEntityNum = "org".equals(suitType) ? "haos_adminorghr" : paramDyn.getString("entitytype.number");
                String type = HisModelController.getInstance().entityInhRelation(baseEntityNum);
                if (EnumEntityTpl.COMMON_TPL.getNumber().equals(type)) continue;
                fieldBaseEntityMap.put(string, baseEntityNum);
            }
        }
        if (!fieldBaseEntityMap.isEmpty()) {
            HashMap fIdMap = Maps.newHashMapWithExpectedSize((int)10);
            for (Map.Entry entry : fieldBaseEntityMap.entrySet()) {
                String baseEntityNum = (String)entry.getValue();
                HashSet fidSet = Sets.newHashSetWithExpectedSize((int)bizDataMap.size());
                for (Map.Entry entry2 : bizDataMap.entrySet()) {
                    DynaSchemeMatchService.addFId(fidSet, (String)entry.getKey(), (List)entry2.getValue());
                }
                Set allFidSet = (Set)fIdMap.get(baseEntityNum);
                if (allFidSet != null) {
                    allFidSet.addAll(fidSet);
                } else {
                    allFidSet = fidSet;
                }
                fIdMap.put(baseEntityNum, allFidSet);
            }
            HashMap baseEntityBoIdMap = Maps.newHashMapWithExpectedSize((int)fIdMap.size());
            for (Map.Entry entry : fIdMap.entrySet()) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper((String)entry.getKey());
                DynamicObject[] results = serviceHelper.queryOriginalArray("id,boid", new QFilter[]{new QFilter("id", "in", entry.getValue())});
                Map<Long, Long> map = Arrays.stream(results).collect(Collectors.toMap(rs -> rs.getLong("id"), rs -> rs.getLong("boid")));
                baseEntityBoIdMap.put(entry.getKey(), map);
            }
            for (Map.Entry entry : fieldBaseEntityMap.entrySet()) {
                String baseEntityNum = (String)entry.getValue();
                Map boIdMap = (Map)baseEntityBoIdMap.get(baseEntityNum);
                for (Map.Entry<Long, List<Map<String, Object>>> sonEntry : bizDataMap.entrySet()) {
                    DynaSchemeMatchService.fillBoId(boIdMap, (String)entry.getKey(), sonEntry.getValue());
                }
            }
        }
    }

    private static void addFId(Set<Long> fidSet, String param, List<Map<String, Object>> bizDataMap) {
        if (CollectionUtils.isEmpty(bizDataMap) || !bizDataMap.get(0).containsKey(param)) {
            return;
        }
        for (Map<String, Object> bizData : bizDataMap) {
            Object bizValue = bizData.get(param);
            if (!(bizValue instanceof Long)) continue;
            fidSet.add((Long)bizValue);
        }
    }

    private static void fillBoId(Map<Long, Long> boIdMap, String param, List<Map<String, Object>> bizDataMap) {
        if (CollectionUtils.isEmpty(bizDataMap) || !bizDataMap.get(0).containsKey(param)) {
            return;
        }
        for (Map<String, Object> bizData : bizDataMap) {
            Long boId;
            Object bizValue = bizData.get(param);
            if (!(bizValue instanceof Long) || (boId = boIdMap.get(bizValue)) == null) continue;
            bizData.put(param, boId);
        }
    }

    private static void replaceOrgLongNum(Map<Long, String> conditionMap, Map<String, DynamicObject> paramMap, Map<Long, List<Map<String, Object>>> bizDataMap) {
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)10);
        HashSet fieldKeySet = Sets.newHashSetWithExpectedSize((int)paramMap.size());
        for (Map.Entry<Long, String> entry : conditionMap.entrySet()) {
            if (PermRuleValidateUtil.isDecisionSetConditionEmpty(entry.getValue())) continue;
            PermRuleConditionInfo ruleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)entry.getValue(), PermRuleConditionInfo.class);
            List list = ruleConditionInfo.getConditionList();
            for (PermConditionInfo permConditionInfo : list) {
                String[] split;
                String operators;
                String param = permConditionInfo.getParam();
                DynamicObject paramDyn = paramMap.get(param);
                if (paramDyn == null || !"containsub".equals(operators = permConditionInfo.getOperators())) continue;
                for (String s : split = permConditionInfo.getValue().split(",")) {
                    orgIdSet.add(Long.parseLong(s));
                }
                fieldKeySet.add(param);
            }
        }
        if (!fieldKeySet.isEmpty()) {
            for (String fieldKey : fieldKeySet) {
                for (Map.Entry entry : bizDataMap.entrySet()) {
                    DynaSchemeMatchService.addOrgId(orgIdSet, (List)entry.getValue(), fieldKey);
                }
            }
        }
        Map results = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{Lists.newArrayList((Iterable)orgIdSet), new Date(), true});
        for (Map.Entry<Long, String> entry : conditionMap.entrySet()) {
            if (HRStringUtils.isEmpty((String)entry.getValue())) continue;
            PermRuleConditionInfo permRuleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)entry.getValue(), PermRuleConditionInfo.class);
            List conditionList = permRuleConditionInfo.getConditionList();
            for (PermConditionInfo permConditionInfo : conditionList) {
                String operators;
                String param = permConditionInfo.getParam();
                DynamicObject paramDyn = paramMap.get(param);
                if (paramDyn == null || !"containsub".equals(operators = permConditionInfo.getOperators())) continue;
                String[] split = permConditionInfo.getValue().split(",");
                ArrayList appendList = Lists.newArrayListWithExpectedSize((int)split.length);
                for (String s : split) {
                    Map map = (Map)results.get(s);
                    appendList.add((String)map.get("longnumber"));
                }
                permConditionInfo.setValue(String.join((CharSequence)",", appendList));
            }
            conditionMap.put(entry.getKey(), SerializationUtils.toJsonString((Object)permRuleConditionInfo));
        }
        if (!fieldKeySet.isEmpty()) {
            for (String fieldKey : fieldKeySet) {
                for (Map.Entry<Long, List<Map<String, Object>>> entry : bizDataMap.entrySet()) {
                    DynaSchemeMatchService.replaceOrgId(results, entry.getValue(), fieldKey);
                }
            }
        }
    }

    private static void addOrgId(Set<Long> orgIdSet, List<Map<String, Object>> bizDataMap, String param) {
        if (CollectionUtils.isEmpty(bizDataMap) || !bizDataMap.get(0).containsKey(param)) {
            return;
        }
        for (Map<String, Object> bizData : bizDataMap) {
            Object bizValue = bizData.get(param);
            if (bizValue instanceof List) {
                List list = (List)bizValue;
                for (Object id : list) {
                    orgIdSet.add((Long)id);
                }
                continue;
            }
            if (!(bizValue instanceof Long)) continue;
            orgIdSet.add((Long)bizValue);
        }
    }

    private static void replaceOrgId(Map<String, Map<String, Object>> results, List<Map<String, Object>> bizDataMap, String param) {
        if (CollectionUtils.isEmpty(bizDataMap) || !bizDataMap.get(0).containsKey(param)) {
            return;
        }
        for (Map<String, Object> bizData : bizDataMap) {
            Map<String, Object> orgMap;
            Object bizValue = bizData.get(param);
            if (bizValue instanceof List) {
                List list = (List)bizValue;
                ArrayList longNumberList = Lists.newArrayListWithExpectedSize((int)list.size());
                for (Object id : list) {
                    Map<String, Object> orgMap2 = results.get(id.toString());
                    if (orgMap2 == null) continue;
                    longNumberList.add((String)orgMap2.get("longnumber"));
                }
                bizData.put(param, longNumberList);
                continue;
            }
            if (!(bizValue instanceof Long) || (orgMap = results.get(bizValue.toString())) == null) continue;
            bizData.put(param, orgMap.get("longnumber"));
        }
    }
}

