/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.dyna.rulehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.extpoint.permission.dyna.IPermRuleMatchPlugin;
import kd.hr.hbp.business.extpoint.permission.dyna.RuleMatchBO;
import kd.hr.hbp.business.extpoint.permission.dyna.RuleMatchResponseBO;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.service.perm.dyna.rulehandler.ISchemaRuleParser;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermRuleValidateUtil;
import kd.hr.hrcs.common.model.perm.PermConditionInfo;
import kd.hr.hrcs.common.model.perm.PermRuleConditionInfo;

@ExcludeFromJacocoGeneratedReport
public class PermRuleMatchService
implements IPermRuleMatchPlugin {
    private static final Log LOGGER = LogFactory.getLog(PermRuleMatchService.class);
    Map<String, DynamicObject> opMap;

    public PermRuleMatchService() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaruleoperator");
        DynamicObject[] ops = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
        this.opMap = Arrays.stream(ops).collect(Collectors.toMap(op -> op.getString("number"), op -> op));
    }

    public Map<Long, Map<Long, RuleMatchResponseBO>> matchRule(RuleMatchBO ruleMatchBO) {
        Map conditionMap = ruleMatchBO.getConditionMap();
        HashMap matchResultsMap = Maps.newHashMapWithExpectedSize((int)conditionMap.size());
        if (!CollectionUtils.isEmpty((Map)conditionMap)) {
            Map bizDataMap = ruleMatchBO.getBizDataMap();
            for (Map.Entry entry : conditionMap.entrySet()) {
                HashMap bizDataResultMap = Maps.newHashMapWithExpectedSize((int)bizDataMap.size());
                if (PermRuleValidateUtil.isDecisionSetConditionEmpty((String)entry.getValue())) {
                    for (Map.Entry bizDataEntry : bizDataMap.entrySet()) {
                        bizDataResultMap.put(bizDataEntry.getKey(), new RuleMatchResponseBO(true, null));
                    }
                } else {
                    PermRuleConditionInfo ruleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)((String)entry.getValue()), PermRuleConditionInfo.class);
                    for (Map.Entry bizDataEntry : bizDataMap.entrySet()) {
                        RuleMatchResponseBO responseBO = this.matchSingleRule(ruleConditionInfo, ruleMatchBO.getRuleParamMap(), (List)bizDataEntry.getValue());
                        bizDataResultMap.put(bizDataEntry.getKey(), responseBO);
                    }
                }
                matchResultsMap.put(entry.getKey(), bizDataResultMap);
            }
        }
        LOGGER.info("PermRuleMatchService_matchRule,results:{}", (Object)matchResultsMap);
        this.handResultsByExt(matchResultsMap, ruleMatchBO);
        return matchResultsMap;
    }

    private RuleMatchResponseBO matchSingleRule(PermRuleConditionInfo ruleConditionInfo, Map<String, DynamicObject> paramMap, List<Map<String, Object>> bizDataList) {
        List conditionList = ruleConditionInfo.getConditionList();
        String conditionExpressStr = ruleConditionInfo.getConditionExpressStr();
        String msg = "";
        boolean results = true;
        if (!CollectionUtils.isEmpty((Collection)conditionList)) {
            ArrayList paramNameList = Lists.newArrayListWithExpectedSize((int)conditionList.size());
            for (int i = 0; i < conditionList.size(); ++i) {
                String param;
                DynamicObject paramDyn;
                PermConditionInfo conditionInfo = (PermConditionInfo)conditionList.get(i);
                boolean isMatch = this.matchSingleCondition(conditionInfo, paramDyn = paramMap.get(param = conditionInfo.getParam()), bizDataList);
                if (!isMatch) {
                    paramNameList.add(conditionInfo.getDisplayParam());
                }
                String re = i < 9 ? "T0" + (i + 1) : "T" + (i + 1);
                conditionExpressStr = conditionExpressStr.replace(re, Boolean.toString(isMatch));
            }
            try {
                results = (Boolean)HRFunctionHelper.executeFunction((String)conditionExpressStr, null);
            }
            catch (Exception e) {
                LOGGER.error("matchSingleRule_executeFunction_error,param:{},ex:{}", (Object)conditionExpressStr, (Object)e.getMessage());
                throw new KDBizException("matchSingleRule_executeFunction_error");
            }
            if (!results) {
                String names = String.join((CharSequence)ResManager.loadKDString((String)"\u3001", (String)"PermRuleMatchService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), paramNameList);
                msg = ResManager.loadKDString((String)"%s\u4e0d\u6ee1\u8db3", (String)"PermRuleMatchService_1", (String)"hrmp-hrcs-business", (Object[])new Object[]{names});
            }
        }
        return new RuleMatchResponseBO(results, msg);
    }

    private boolean matchSingleCondition(PermConditionInfo conditionInfo, DynamicObject paramDyn, List<Map<String, Object>> bizDataList) {
        boolean isMatch = false;
        if (paramDyn != null) {
            String propKey = paramDyn.getString("id");
            String operators = conditionInfo.getOperators();
            DynamicObject operatorDyn = this.opMap.get(operators);
            if (operatorDyn != null) {
                boolean isReflect = "1".equals(operatorDyn.getString("parsertype"));
                String value = conditionInfo.getValue();
                if (isReflect) {
                    try {
                        String serviceName = operatorDyn.getString("parserclass");
                        Class<?> serviceClass = Class.forName(serviceName);
                        ISchemaRuleParser schemaRuleParser = (ISchemaRuleParser)serviceClass.newInstance();
                        isMatch = schemaRuleParser.match(propKey, paramDyn, value, bizDataList);
                    }
                    catch (Exception e) {
                        LOGGER.error("matchSingleCondition_reflect_error", (Throwable)e);
                        throw new KDBizException("matchSingleCondition_reflect_error");
                    }
                }
                DynamicObject app = operatorDyn.getDynamicObject("mserviceapp");
                String cloudNum = app.getString("bizcloud.number").toLowerCase(Locale.ROOT);
                String appNum = app.getString("number");
                String isvNum = app.getString("isv");
                String serviceName = operatorDyn.getString("mserviceclass");
                try {
                    isMatch = "kingdee".equals(isvNum) ? ((Boolean)HRMServiceHelper.invokeBizService((String)cloudNum, (String)appNum, (String)serviceName, (String)"match", (Object[])new Object[]{propKey, paramDyn, value, bizDataList})).booleanValue() : ((Boolean)HRMServiceHelper.invokeService((String)cloudNum, (String)appNum, (String)serviceName, (String)"match", (Object[])new Object[]{propKey, paramDyn, value, bizDataList})).booleanValue();
                }
                catch (Exception e) {
                    LOGGER.error("matchSingleCondition_invoke_error", (Throwable)e);
                    throw new KDBizException("matchSingleCondition_invoke_error");
                }
            }
        }
        return isMatch;
    }

    private void handResultsByExt(Map<Long, Map<Long, RuleMatchResponseBO>> matchResultsMap, RuleMatchBO ruleMatchBO) {
        HRPluginProxy proxy = new HRPluginProxy((Object)this, IPermRuleMatchPlugin.class, "kd.hr.hbp.business.extpoint.permission.dyna.IPermRuleMatchPlugin", null);
        List extResults = proxy.callReplace(p -> p.matchRule(ruleMatchBO));
        LOGGER.info("PermRuleMatchService_handResultsByExt,ext:{}", (Object)extResults);
        for (Map extResult : extResults) {
            for (Map.Entry entry : extResult.entrySet()) {
                if (CollectionUtils.isEmpty((Map)((Map)entry.getValue()))) continue;
                Long schemeId = (Long)entry.getKey();
                Map ruleMatchResponseBOMap = matchResultsMap.get(schemeId);
                for (Map.Entry ruleMatchResponseBOEntry : ((Map)entry.getValue()).entrySet()) {
                    RuleMatchResponseBO ruleMatchResponseBO;
                    Long bizId = (Long)ruleMatchResponseBOEntry.getKey();
                    RuleMatchResponseBO extValue = (RuleMatchResponseBO)ruleMatchResponseBOEntry.getValue();
                    if (ruleMatchResponseBOMap == null || extValue == null || (ruleMatchResponseBO = (RuleMatchResponseBO)ruleMatchResponseBOMap.get(bizId)) == null) continue;
                    ruleMatchResponseBO.setMatch(extValue.isMatch() && ruleMatchResponseBO.isMatch());
                    String msg = ruleMatchResponseBO.getMsg();
                    if (!HRStringUtils.isEmpty((String)msg)) {
                        ruleMatchResponseBO.setMsg(msg + ";" + extValue.getMsg());
                        continue;
                    }
                    ruleMatchResponseBO.setMsg(extValue.getMsg());
                }
                if (ruleMatchResponseBOMap == null) {
                    ruleMatchResponseBOMap = (Map)entry.getValue();
                }
                matchResultsMap.put(schemeId, ruleMatchResponseBOMap);
            }
        }
    }
}

