/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.hradmin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.bean.AdminGroupOrgSearchBean;
import kd.bos.permission.formplugin.bean.AdminGroupSysSearchBean;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.hradmin.HRAdminGroupService;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRRoleFunctionPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HrbuCaControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.hradmin.HRAdminGroupPermHelper;

public class AdminGroupService {
    private Map<String, String> sysNodeNameMap;
    private Map<String, String> appNodeNameMap;
    private Map<String, String> bizUnitNodeMap;
    private Map<String, String> allOrgNameMap;
    private Map<String, String> orgPatternTypeMap;
    private Map<String, String> appIdNameMap;
    private Map<String, String> entityNumNameMap;
    private Set<String> HRapp;
    private Map<String, String> appCloudInfoMap;
    private static final String KEY_GROUP = "key_group";
    private static final String KEY_ORG = "key_org";
    private static final String KEY_BIZAPP = "key_bizapp";
    private static final String KEY_ENTITY = "key_entity";
    private static final String KEY_PERMITEM = "key_permitem";
    private static final String PAGECACHE_ORIGIN_BUDADATA = "orignBuData";
    private static final String FIELD_PARENT_GROUP_ID = "parentgroupid";
    private static final String FIELD_ORG_RANGE = "orgrange";
    private static final String FIELD_ORG_NAME = "orgname";
    private static final String FIELD_BUCA_RANGE = "bucarange";
    private static final String FIELD_BU_TYPE = "butype";
    private static final String FIELD_BU_CLASS = "buclass";
    private static final String FIELD_ADMIN_GROUP = "admingroup";
    private static final String ALL_ASSIGNED_HR_BUCA = "allAssignedHRBuCa";
    private static final String BU_CHANGE = "bu_change";
    private static final String BU_REDRAWN = "bu_redrawn";
    private static final String ORG_CHANGE = "org_change";
    private static final String KEY_BU_ENTRY = "buentry";
    private static final String KEY_ORG_ENTRY = "orgentry";
    private static Log LOGGER;
    public HRAdminGroupPermHelper hrAdminGroupPermHelper;
    private AbstractBasePlugIn formPlugin;
    private static final String KEY_STRUCT = "struct";
    private static final String KEY_STRUCT_ID = "struct.id";
    private static final String KEY_ADMINORG_ID = "adminorg.id";
    private static final String KEY_ADMINORG = "adminorg";
    private static final String KEY_USERGROUP = "usergroup";
    private Set<String> allEntityFuncPerms = Sets.newHashSetWithExpectedSize((int)16);
    private Set<String> cloudSet = Sets.newHashSetWithExpectedSize((int)16);
    private boolean isBatchAuth;

    public AdminGroupService(AbstractBasePlugIn formPlugin, Log LOGGER, boolean isBatchAuth) {
        this.formPlugin = formPlugin;
        AdminGroupService.LOGGER = LOGGER;
        this.hrAdminGroupPermHelper = new HRAdminGroupPermHelper(this.getPageCache());
        this.isBatchAuth = isBatchAuth;
    }

    public void initialize() {
        String appCloudInfoMapStr;
        IPageCache pageCache = this.getPageCache();
        String sysNodeNameMapStr = pageCache.get("sysNodeNameMap");
        this.sysNodeNameMap = StringUtils.isNotEmpty((String)sysNodeNameMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)sysNodeNameMapStr, Map.class) : new HashMap<String, String>(16);
        String appNodeNameMapStr = pageCache.get("appNodeNameMap");
        this.appNodeNameMap = StringUtils.isNotEmpty((String)appNodeNameMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)appNodeNameMapStr, Map.class) : new HashMap<String, String>(16);
        String bizUnitNodeMapStr = pageCache.get("bizUnitNodeMap");
        this.bizUnitNodeMap = StringUtils.isNotEmpty((String)bizUnitNodeMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)bizUnitNodeMapStr, Map.class) : new HashMap<String, String>(16);
        String appIdNameMapStr = pageCache.getBigObject("appIdNameMap");
        if (StringUtils.isNotEmpty((String)appIdNameMapStr)) {
            this.appIdNameMap = (Map)SerializationUtils.fromJsonString((String)appIdNameMapStr, Map.class);
        } else {
            this.appIdNameMap = AppHelper.getAllAppIdNameMap();
            pageCache.putBigObject("appIdNameMap", SerializationUtils.toJsonString(this.appIdNameMap));
        }
        String entityNumNameMapStr = pageCache.getBigObject("entityNumNameMap");
        if (StringUtils.isNotEmpty((String)entityNumNameMapStr)) {
            this.entityNumNameMap = (Map)SerializationUtils.fromJsonString((String)entityNumNameMapStr, Map.class);
        } else {
            this.entityNumNameMap = PermCommonUtil.getAllEntNumAndNameMap();
            pageCache.putBigObject("entityNumNameMap", SerializationUtils.toJsonString(this.entityNumNameMap));
        }
        if (CollectionUtils.isEmpty(this.HRapp)) {
            this.HRapp = AdminGroupService.getHRApp();
        }
        if (CollectionUtils.isEmpty(this.cloudSet)) {
            this.cloudSet.add("0QLCSO6KKZC9");
            this.cloudSet.add("0PEIU203SX4Y");
            this.cloudSet.add("83bfebc800000bac");
        }
        if (StringUtils.isNotEmpty((String)(appCloudInfoMapStr = pageCache.getBigObject("appCloudInfoMap")))) {
            this.appCloudInfoMap = (Map)SerializationUtils.fromJsonString((String)appCloudInfoMapStr, Map.class);
        } else {
            this.appCloudInfoMap = AppHelper.getAppCloudInfo(null);
            pageCache.putBigObject("appCloudInfoMap", SerializationUtils.toJsonString(this.appCloudInfoMap));
        }
        this.addListener(this.formPlugin);
    }

    public void addListener(AbstractBasePlugIn formPlugin) {
        long adminGroupId;
        Map customParams = formPlugin.getView().getFormShowParameter().getCustomParams();
        String adminGroupParentStr = (String)customParams.get("adminGroupParentId");
        String levelStr = (String)customParams.get("level");
        String type = (String)customParams.get("type");
        boolean batchAuth = HRStringUtils.isNotEmpty((String)type) && HRStringUtils.equals((String)type, (String)"batchAuth");
        long level = Long.parseLong(levelStr);
        long adminGroupParentId = 0L;
        if (level != 1L) {
            adminGroupParentId = Long.parseLong(adminGroupParentStr);
        }
        if (batchAuth) {
            adminGroupId = adminGroupParentId;
        } else {
            String adminGroupStr = (String)customParams.get("adminGroupId");
            if (HRStringUtils.isEmpty((String)adminGroupStr)) {
                adminGroupId = ORM.create().genLongId("perm_admingroup");
                adminGroupStr = Long.toString(adminGroupId);
                customParams.put("adminGroupId", adminGroupStr);
                customParams.put("isAddNew", "1");
            } else {
                adminGroupId = Long.parseLong(adminGroupStr);
            }
        }
        IFormView formView = formPlugin.getView();
        Search sysLeftSearch = (Search)formView.getControl("sysleftsearch");
        long finalAdminGroupParentId = adminGroupParentId;
        sysLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = formView.getPageCache();
            TreeView tv = (TreeView)formView.getControl("systree");
            tv.deleteAllNodes();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                HashSet<String> selectData = new HashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysLeftSource"), Map.class);
                for (Map.Entry entry : dataSource.entrySet()) {
                    AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)((String)entry.getValue()), AdminGroupSysSearchBean.class);
                    String entityName = bean.getEntityName();
                    if (!HRStringUtils.isNotEmpty((String)entityName) || !entityName.contains(searchText)) continue;
                    for (String permItem : bean.getPermItems()) {
                        selectData.add((String)entry.getKey() + '|' + permItem);
                    }
                }
                TreeNode rootNode = this.getSelectPermRootNode(tv, selectData, this.getSysRootNodeText(), true);
                formView.getPageCache().put("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
            } else {
                formView.getPageCache().remove("sysTreeLeftRoot");
                this.initSysLeftTree(finalAdminGroupParentId, level, formView);
                formView.updateView("systree");
            }
        });
        Search sysRightSearch = (Search)formView.getControl("sysrightsearch");
        sysRightSearch.addEnterListener(see -> {
            IPageCache pageCache = formView.getPageCache();
            TreeView tv = (TreeView)formView.getControl("selectedsystree");
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                HashSet<String> selectData = new HashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysRightSource"), Map.class);
                if (CollectionUtils.isEmpty((Map)dataSource)) {
                    return;
                }
                for (Map.Entry entry : dataSource.entrySet()) {
                    AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)((String)entry.getValue()), AdminGroupSysSearchBean.class);
                    String entityName = bean.getEntityName();
                    if (!HRStringUtils.isNotEmpty((String)entityName) || !entityName.contains(searchText)) continue;
                    for (String permItem : bean.getPermItems()) {
                        selectData.add((String)entry.getKey() + '|' + permItem);
                    }
                }
                tv.deleteAllNodes();
                this.getSelectPermRootNode(tv, selectData, this.getSelectSysRootNodeText(), true);
            } else {
                this.rebuildSysRightTree(true, new HashSet<String>(16), formView);
            }
        });
        Search bizLeftSearch = (Search)formView.getControl("bizleftsearch");
        bizLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = formView.getPageCache();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                TreeView tv = (TreeView)formView.getControl("orgtree");
                int i = 0;
                HashSet<String> selectData = new HashSet<String>(1000);
                ArrayList<AdminGroupOrgSearchBean> selectSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get("bizLeftSource"), AdminGroupOrgSearchBean.class);
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getOrgName().contains(searchText) && !bean.getNumber().contains(searchText)) continue;
                    if (++i > 1000) {
                        formView.showTipNotification(this.getSearchTips());
                        return;
                    }
                    selectData.add(bean.getDetail());
                    selectSource.add(bean);
                }
                ArrayList<String> dataList = new ArrayList<String>(selectData);
                this.orgDataSort(dataList);
                pageCache.put("orgtree_search", "true");
                tv.deleteAllNodes();
                this.buildOrgTreeForSearch("orgTreeLeftRoot", tv, this.getBizUnitRootNodeText(), dataList, true);
                pageCache.put("bizLeftSource_search", SerializationUtils.toJsonString(selectSource));
            } else {
                pageCache.remove("orgtree_search");
                pageCache.remove("bizLeftSource_search");
                if (StringUtils.isNotEmpty((String)pageCache.get("15_super"))) {
                    this.initUnitTreeSuper("11");
                } else {
                    this.initUnitTreeNormal("11", finalAdminGroupParentId, level);
                }
            }
        });
        Search bizRightSearch = (Search)formView.getControl("bizrightsearch");
        bizRightSearch.addEnterListener(see -> {
            IPageCache pageCache = formView.getPageCache();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                TreeView tv = (TreeView)formView.getControl("selectedorgtree");
                int i = 0;
                HashSet<String> selectData = new HashSet<String>(1000);
                ArrayList<AdminGroupOrgSearchBean> selectSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get("bizRightSource"), AdminGroupOrgSearchBean.class);
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getOrgName().contains(searchText) && !bean.getNumber().contains(searchText)) continue;
                    if (++i > 1000) {
                        formView.showTipNotification(this.getSearchTips());
                        return;
                    }
                    selectData.add(bean.getDetail());
                    selectSource.add(bean);
                }
                ArrayList<String> dataList = new ArrayList<String>(selectData);
                this.orgDataSort(dataList);
                pageCache.put("selectedorgtree_search", "true");
                tv.deleteAllNodes();
                this.buildOrgTreeForSearch("orgTreeRightRoot", tv, this.getSelBizUnitRootText(), dataList, true);
                pageCache.put("bizRightSource_search", SerializationUtils.toJsonString(selectSource));
            } else {
                pageCache.remove("selectedorgtree_search");
                pageCache.remove("bizRightSource_search");
                this.buildSelectedOrgTree(adminGroupId, "11", level);
            }
        });
        Search appLeftSearch = (Search)formView.getControl("appleftsearch");
        appLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = formView.getPageCache();
            TreeView tv = (TreeView)formView.getControl("apptree");
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                HashSet<String> selectData = new HashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("appLeftSource"), Map.class);
                if (CollectionUtils.isEmpty((Map)dataSource)) {
                    return;
                }
                for (Map.Entry entry : dataSource.entrySet()) {
                    if (!((String)entry.getValue()).contains(searchText)) continue;
                    selectData.add((String)entry.getKey());
                }
                tv.deleteAllNodes();
                this.getAppTreeRootNodeForSearch(tv, selectData, this.getAppRootNodeText());
            } else if (batchAuth) {
                this.rebuildAppTree();
            } else {
                this.initAppTree(finalAdminGroupParentId, level, null);
            }
        });
        Search appRightSearch = (Search)formView.getControl("apprightsearch");
        appRightSearch.addEnterListener(see -> {
            IPageCache pageCache = formView.getPageCache();
            TreeView tv = (TreeView)formView.getControl("selectedapptree");
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                HashSet<String> selectData = new HashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("appRightSource"), Map.class);
                if (CollectionUtils.isEmpty((Map)dataSource)) {
                    return;
                }
                for (Map.Entry entry : dataSource.entrySet()) {
                    if (!((String)entry.getValue()).contains(searchText)) continue;
                    selectData.add((String)entry.getKey());
                }
                tv.deleteAllNodes();
                String rootNode = this.getCommonRootText();
                if (level > 2L) {
                    rootNode = this.getSelectAppRootNodeText();
                }
                this.getAppTreeRootNodeForSearch(tv, selectData, rootNode);
            } else {
                this.rebuildAppRightTree(true, new HashSet<String>(16));
            }
        });
        TreeView bizUnitTree = (TreeView)formView.getControl("orgtree");
        bizUnitTree.addTreeNodeQueryListener((TreeNodeQueryListener)formPlugin);
        bizUnitTree.addTreeNodeCheckListener((TreeNodeCheckListener)formPlugin);
        TreeView selBizUnitTree = (TreeView)formView.getControl("selectedorgtree");
        selBizUnitTree.addTreeNodeQueryListener((TreeNodeQueryListener)formPlugin);
        selBizUnitTree.addTreeNodeCheckListener((TreeNodeCheckListener)formPlugin);
        Tab mainTab = (Tab)formView.getControl("tabap");
        mainTab.addTabSelectListener((TabSelectListener)formPlugin);
        BasedataEdit buCaRange = (BasedataEdit)formView.getControl(FIELD_BUCA_RANGE);
        buCaRange.addBeforeF7SelectListener((BeforeF7SelectListener)formPlugin);
        formPlugin.addClickListeners(new String[]{"btn_addorg", "btn_deleteorg", "btn_addadminorg", "btn_deleteadminorg", "btn_addapp", "btn_delapp", "btn_addsys", "btn_delsys", FIELD_ORG_NAME});
        formPlugin.addItemClickListeners(new String[]{"tbmain", "toolbarap"});
    }

    public Map<String, List<Object>> queryBuRange(long adminGroupId) {
        String buRangeStr = this.getPageCache().get(PAGECACHE_ORIGIN_BUDADATA + adminGroupId);
        if (buRangeStr != null) {
            return (Map)SerializationUtils.fromJsonString((String)buRangeStr, Map.class);
        }
        HRBaseServiceHelper funcHelper = new HRBaseServiceHelper("hrcs_admingroupfunc");
        QFilter filter = new QFilter("admingroup.id", "=", (Object)adminGroupId);
        DynamicObject[] dys = funcHelper.query("bucafunc.id,entryentity.org", new QFilter[]{filter});
        HashMap<String, List<Object>> ret = new HashMap<String, List<Object>>(dys.length);
        for (DynamicObject dy : dys) {
            DynamicObjectCollection entry;
            List objects;
            String buCaId = dy.getString("bucafunc.id");
            if (buCaId == null || (objects = (entry = dy.getDynamicObjectCollection("entryentity")).stream().filter(it -> it.get("org.id") != null).map(it -> it.get("org.id")).collect(Collectors.toList())).size() <= 0) continue;
            ret.put(buCaId, objects);
        }
        this.getPageCache().put(PAGECACHE_ORIGIN_BUDADATA + adminGroupId, SerializationUtils.toJsonString(ret));
        return ret;
    }

    public void rebuildAppTree() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long adminGroupId = dataEntity.getLong("parentgroupid.id");
        long level = dataEntity.getLong("level");
        Set<String> assignableApps = this.queryAssignableApps();
        if (CollectionUtils.isEmpty(assignableApps)) {
            TreeView tv = this.getControl("apptree");
            tv.deleteAllNodes();
            TreeNode rootNode = new TreeNode("", "-1", this.getAppRootNodeText(), true);
            rootNode.setIsOpened(true);
        } else {
            this.initAppTree(adminGroupId, level, assignableApps);
        }
        this.hrAdminGroupPermHelper.fillCloudEntryCard(this.getView(), Maps.newLinkedHashMapWithExpectedSize((int)0));
        this.clearSelectApp();
        this.getPageCache().put("tree_app_loaded", "true");
    }

    private Set<String> queryAssignableApps() {
        Map<String, List<Long>> appBuMap = this.queryAppBuMap();
        Set<Long> commonFuncs = this.getCommonFuncs();
        HashSet assignableApps = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, List<Long>> entry : appBuMap.entrySet()) {
            String appId = entry.getKey();
            List<Long> appFuncs = entry.getValue();
            if (!commonFuncs.containsAll(appFuncs)) continue;
            assignableApps.add(appId);
        }
        return assignableApps;
    }

    private Map<String, List<Long>> queryAppBuMap() {
        Map<String, Long> allEntitySpecFunc = HRRoleFunctionPermHelper.getAllEntitySpecFunc();
        Map<String, HashSet<String>> specEntityApp = HrbuCaControlHelper.querySpecEntityApp(allEntitySpecFunc.keySet());
        Map<String, List<Long>> appBuMap = HrbuCaControlHelper.queryAppSelfBuCa();
        for (Map.Entry<String, HashSet<String>> entry : specEntityApp.entrySet()) {
            String entity = entry.getKey();
            Long bucaId = allEntitySpecFunc.get(entity);
            HashSet<String> appIds = entry.getValue();
            for (String appId : appIds) {
                List buList = appBuMap.computeIfAbsent(appId, key -> Lists.newArrayListWithExpectedSize((int)10));
                buList.add(bucaId);
            }
        }
        return appBuMap;
    }

    private Set<Long> getCommonFuncs() {
        List<Long> targetAdminGroupIds = this.getTargetAdminGroupIds();
        HRBaseServiceHelper funcHelper = new HRBaseServiceHelper("hrcs_admingroupfunc");
        DynamicObjectCollection coll = funcHelper.queryOriginalCollection("admingroup,bucafunc", new QFilter[]{new QFilter(FIELD_ADMIN_GROUP, "in", targetAdminGroupIds)});
        HashMap adminFuncMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject row : coll) {
            long adminGroupId = row.getLong(FIELD_ADMIN_GROUP);
            long bucaFuncId = row.getLong("bucafunc");
            Set buSet = adminFuncMap.computeIfAbsent(adminGroupId, key -> Sets.newHashSetWithExpectedSize((int)16));
            buSet.add(bucaFuncId);
        }
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        boolean emptyFlag = true;
        for (Map.Entry entry : adminFuncMap.entrySet()) {
            Set funcs = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)resultSet) && emptyFlag) {
                resultSet.addAll(funcs);
                emptyFlag = false;
                continue;
            }
            resultSet.retainAll(funcs);
        }
        return resultSet;
    }

    private List<Long> getTargetAdminGroupIds() {
        String adminGroupIdStr = this.getModel().getDataEntity().getString("targetadmingroupids");
        if (HRStringUtils.isEmpty((String)adminGroupIdStr)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        String[] targetAdminGroupIdArr = adminGroupIdStr.split(";");
        List<Long> adminGroupIds = Arrays.stream(targetAdminGroupIdArr).map(Long::parseLong).collect(Collectors.toList());
        return adminGroupIds;
    }

    public void setOrgName(Object returnData) {
        if (null == returnData) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(KEY_ORG_ENTRY);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        Object[] pks = listSelectedRows.getPrimaryKeyValues();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamquery");
        DynamicObjectCollection orgTeams = serviceHelper.queryOriginalCollection("name", new QFilter[]{new QFilter("id", "in", (Object)pks)});
        String orgTeamNames = orgTeams.stream().map(it -> it.getString("name")).collect(Collectors.joining(";"));
        this.getModel().setValue(FIELD_ORG_NAME, (Object)orgTeamNames, index);
        StringBuilder orgIdStr = new StringBuilder();
        for (Object pk : pks) {
            orgIdStr.append(pk).append(';');
        }
        this.getModel().setValue(FIELD_ORG_RANGE, (Object)orgIdStr.toString(), index);
    }

    public void showOrgF7() {
        int row = this.getModel().getEntryCurrentRowIndex(KEY_ORG_ENTRY);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject struct = (DynamicObject)this.getModel().getValue(KEY_STRUCT, row);
        int level = dataEntity.getInt("level");
        long structId = struct.getLong("id");
        long parentStructId = struct.getLong("relyonstructproject.id");
        long otClassId = struct.getLong("otclassify.id");
        List<Long> customOtClazzs = HRAdminGroupService.queryCustomTeamTypes();
        DynamicObjectCollection orgEntry = dataEntity.getDynamicObjectCollection(KEY_ORG_ENTRY);
        String orgRangeStr = ((DynamicObject)orgEntry.get(row)).getString(FIELD_ORG_RANGE);
        ArrayList usedOrgIds = Lists.newArrayListWithExpectedSize((int)10);
        if (HRStringUtils.isNotEmpty((String)orgRangeStr)) {
            String[] orgIdArr;
            for (String orgId : orgIdArr = orgRangeStr.split(";")) {
                usedOrgIds.add(Long.parseLong(orgId));
            }
        }
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("620px");
        styleCss.setWidth("960px");
        if (customOtClazzs.contains(otClassId)) {
            ListShowParameter formShowParameter = new ListShowParameter();
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            openStyle.setInlineStyleCss(styleCss);
            formShowParameter.setBillFormId("haos_cusadminorgteam");
            formShowParameter.setFormId("haos_customottreelistf7");
            formShowParameter.setMultiSelect(true);
            formShowParameter.setLookUp(true);
            formShowParameter.setShowTitle(false);
            formShowParameter.setHasRight(true);
            formShowParameter.setShowUsed(true);
            formShowParameter.setSelectedRows(usedOrgIds.toArray());
            formShowParameter.setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList(structId)));
            if (level > 3 || this.isBatchAuth) {
                this.orgContainSub(formShowParameter, "haos_customotstruct", structId, parentStructId);
            }
            formShowParameter.setCustomParam("struct_project_classify_id", (Object)otClassId);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "haos_customortreelistf7"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("haos_adminorghr");
            listShowParameter.setMultiSelect(true);
            listShowParameter.setLookUp(true);
            listShowParameter.setShowTitle(false);
            listShowParameter.setHasRight(true);
            listShowParameter.setF7ClickByFilter(true);
            listShowParameter.setShowUsed(true);
            listShowParameter.setSelectedRows(usedOrgIds.toArray());
            listShowParameter.setFormId("haos_orgtreelistf7");
            listShowParameter.setCustomParam("customHREntityNumber", (Object)"hrcs_admingroupdetail");
            listShowParameter.setCustomParam("custom_parent_f7_prop", (Object)FIELD_ORG_NAME);
            this.getView().cacheFormShowParameter();
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "haos_customortreelistf7"));
            OpenStyle openStyle = listShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            openStyle.setInlineStyleCss(styleCss);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ORG_ENTRY).get(row);
            parentStructId = parentStructId == 0L ? dynamicObject.getLong(KEY_STRUCT_ID) : parentStructId;
            listShowParameter.setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList(parentStructId)));
            listShowParameter.setCustomParam("isvirtualorg", (Object)"1");
            listShowParameter.setCustomParam("struct_project_is_to_all_areas", (Object)"true");
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "haos_customortreelistf7"));
            if (level > 3 || this.isBatchAuth) {
                this.orgContainSub(listShowParameter, "haos_adminorgstructure", structId, parentStructId);
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void orgContainSub(ListShowParameter listShowParameter, String orgTeamPage, long structId, long parentStructId) {
        parentStructId = parentStructId == 0L ? structId : parentStructId;
        Map originMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("parentOrgIds"), Map.class);
        Map<Long, List<Long>> parentOrgIdMap = this.transToLongMap(originMap);
        List<Long> orgIdList = parentOrgIdMap.getOrDefault(structId, Lists.newArrayListWithExpectedSize((int)10));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(orgTeamPage);
        QFilter orgIdFilter = new QFilter("orgteam.id", "in", orgIdList);
        DynamicObject[] longNumberDys = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgIdFilter, new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("structproject", "=", (Object)parentStructId)});
        QFilter longNumbreQfilter = null;
        for (DynamicObject dyna2 : longNumberDys) {
            String longNumber = dyna2.getString("structlongnumber");
            QFilter qfilter = new QFilter("structlongnumber", "like", (Object)(longNumber + "%"));
            if (longNumbreQfilter == null) {
                longNumbreQfilter = qfilter;
                continue;
            }
            longNumbreQfilter.or(qfilter);
        }
        LOGGER.info("from parent longNumberQfilterStr:{}", longNumbreQfilter);
        if (parentStructId == 1010L) {
            if (longNumbreQfilter != null) {
                listShowParameter.setCustomParam("bizQFilterKey", (Object)longNumbreQfilter.toSerializedString());
                listShowParameter.getListFilterParameter().getQFilters().add(longNumbreQfilter);
            }
        } else {
            DynamicObject[] orgTeamDys = serviceHelper.queryOriginalArray("orgteam.id", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), longNumbreQfilter, new QFilter("structproject", "=", (Object)parentStructId)});
            Set subOrgIds = Arrays.stream(orgTeamDys).map(dyna -> dyna.getLong("orgteam.id")).collect(Collectors.toSet());
            QFilter idQfilter = new QFilter(KEY_ADMINORG_ID, "in", subOrgIds);
            listShowParameter.setCustomParam("bizQFilterKey", (Object)idQfilter.toSerializedString());
            QFilter idListQfilter = new QFilter("id", "in", subOrgIds);
            listShowParameter.getListFilterParameter().getQFilters().add(idListQfilter);
        }
    }

    private Map<Long, List<Long>> transToLongMap(Map<Object, List<Object>> map) {
        HashMap longMap = Maps.newHashMapWithExpectedSize((int)map.size());
        map.forEach((key, value) -> {
            ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)value.size());
            value.forEach(v -> orgIdList.add(Long.parseLong(v.toString())));
            longMap.put(Long.parseLong(key.toString()), orgIdList);
        });
        return longMap;
    }

    public void removeSelApp() {
        TreeView tv = this.getControl("selectedapptree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u9009\u5e94\u7528\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermEdit_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            IPageCache pageCache = this.getPageCache();
            this.getPageCache().put("dataChanged", "true");
            pageCache.put("app_change", "true");
            pageCache.put(BU_CHANGE, "true");
            pageCache.put(BU_REDRAWN, "true");
            HashSet<String> removeIds = new HashSet<String>(16);
            for (String nodeId : checkedNodeIds) {
                if (!nodeId.startsWith("app#")) continue;
                int app = nodeId.lastIndexOf(35);
                int cloud = nodeId.lastIndexOf(124);
                String appSub = nodeId.substring(app + 1, cloud);
                String cloudSub = nodeId.substring(cloud + 1);
                removeIds.add(cloudSub + "|" + appSub);
            }
            this.updateAddCache(removeIds, false, "app_add_ids");
            if (!this.isBatchAuth) {
                this.updateDelCache(removeIds, true, "app_del_ids");
            }
            this.rebuildAppRightTree(false, removeIds);
        }
    }

    public List<DynamicObject> getOrgStructList() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] results = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "in", (Object)new String[]{"1", "0"})});
        ArrayList typeIdList = Lists.newArrayListWithExpectedSize((int)results.length);
        ArrayList dynList = Lists.newArrayListWithExpectedSize((int)results.length);
        for (DynamicObject result : results) {
            typeIdList.add(result.getLong("otclassify.teamtype.id"));
            dynList.add(result);
        }
        HRBaseServiceHelper typeServiceHelper = new HRBaseServiceHelper("hbss_teamtype");
        DynamicObject[] typeResults = typeServiceHelper.loadDynamicObjectArray(typeIdList.toArray());
        Map<Long, Boolean> typeMap = Arrays.stream(typeResults).collect(Collectors.toMap(r -> r.getLong("id"), r -> r.getBoolean("issyspreset")));
        this.sorted(dynList, typeMap);
        return dynList;
    }

    private void sorted(List<DynamicObject> dynList, Map<Long, Boolean> typeMap) {
        HRAdminGroupService.sorted(dynList, typeMap);
    }

    public void addApp() {
        TreeView tv = this.getControl("apptree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f85\u9009\u5e94\u7528\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermEdit_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        this.getPageCache().put("dataChanged", "true");
        pageCache.put("app_change", "true");
        pageCache.put(BU_CHANGE, "true");
        pageCache.put(BU_REDRAWN, "true");
        HashSet<String> addIds = new HashSet<String>(16);
        for (String nodeId : checkedNodeIds) {
            if (!nodeId.startsWith("app#")) continue;
            int app = nodeId.lastIndexOf(35);
            int cloud = nodeId.lastIndexOf(124);
            String appSub = nodeId.substring(app + 1, cloud);
            String cloudSub = nodeId.substring(cloud + 1);
            addIds.add(cloudSub + "|" + appSub);
        }
        this.updateAddCache(addIds, true, "app_add_ids");
        if (!this.isBatchAuth) {
            this.updateDelCache(addIds, false, "app_del_ids");
        }
        this.rebuildAppRightTree(true, addIds);
        tv.uncheckNodes(checkedNodeIds);
    }

    private void rebuildAppRightTree(boolean isAdd, Set<String> apps) {
        IPageCache pageCache = this.getPageCache();
        String appDataStr = pageCache.get("Current_AppData");
        Set appData = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)appDataStr)) {
            appData = (Set)SerializationUtils.fromJsonString((String)appDataStr, Set.class);
        }
        if (isAdd) {
            appData.addAll(apps);
        } else {
            appData.removeAll(apps);
        }
        pageCache.put("Current_AppData", SerializationUtils.toJsonString(appData));
        TreeView tv = this.getControl("selectedapptree");
        long level = this.getModel().getDataEntity().getLong("level");
        tv.deleteAllNodes();
        if (appData.size() == 0) {
            TreeNode commonRightRootNode = this.getCommonRightRootNode(level);
            tv.addNode(commonRightRootNode);
        }
        long adminGroupId = this.getModel().getDataEntity().getLong(KEY_USERGROUP);
        this.buildSelectedAppTree(adminGroupId, level);
    }

    public void buildSelectedAppTree(Long adminGroupId, Long level) {
        TreeView tv = this.getControl("selectedapptree");
        tv.deleteAllNodes();
        TreeNode rootNode = new TreeNode();
        rootNode.setId("-1");
        rootNode.setParentid("");
        rootNode.setText(this.getSelectAppRootNodeText());
        rootNode.setIsOpened(true);
        HashMap<String, String> dataSource = new HashMap<String, String>(16);
        if (level >= 2L) {
            Set<String> appRanges;
            String appRangeStr = this.getPageCache().get("Current_AppData");
            if (StringUtils.isNotEmpty((String)appRangeStr)) {
                appRanges = (Set<String>)SerializationUtils.fromJsonString((String)appRangeStr, Set.class);
            } else {
                appRanges = this.queryAssignableAppRange("selectedapptree", adminGroupId, false, null);
                this.getPageCache().put("Current_AppData", SerializationUtils.toJsonString(appRanges));
                this.getPageCache().put("Origin_AppData", SerializationUtils.toJsonString(appRanges));
            }
            if (!CollectionUtils.isEmpty(appRanges)) {
                HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
                ArrayList<TreeNode> clouds = new ArrayList<TreeNode>(16);
                HashSet<String> forBidApps = new HashSet<String>(16);
                EntityCtrlServiceHelper.queryEntityForBidInfo(null, forBidApps, null);
                for (String appRange : appRanges) {
                    String[] appInfo = appRange.split("\\|");
                    String cloudId = appInfo[0];
                    String cloudName = this.appNodeNameMap.get(cloudId);
                    String appId = appInfo[1];
                    String appName = this.appNodeNameMap.get(appId);
                    TreeNode treeNode = (TreeNode)cloudNodes.get(cloudId);
                    if (forBidApps.contains(appId)) continue;
                    if (treeNode == null) {
                        treeNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                        cloudNodes.put(cloudId, treeNode);
                        clouds.add(treeNode);
                    }
                    TreeNode children = new TreeNode(treeNode.getId(), "app#" + appId + "|" + cloudId, appName, false);
                    treeNode.addChild(children);
                    dataSource.put(cloudId + '|' + appId, appName);
                }
                List<String> cloudIds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
                ArrayList nodes = Lists.newArrayListWithExpectedSize((int)clouds.size());
                cloudIds.forEach(id -> clouds.stream().filter(node -> HRStringUtils.equals((String)id, (String)node.getId().substring(node.getId().indexOf(35) + 1))).findFirst().ifPresent(nodes::add));
                rootNode.addChildren((List)nodes);
            }
        } else {
            rootNode.setText(this.getVirtualRightRootText());
        }
        tv.addNode(rootNode);
        this.getPageCache().put("appRightSource", SerializationUtils.toJsonString(dataSource));
        HashMap<String, Set<String>> assignedCloudBuCaFunc = new HashMap<String, Set<String>>(16);
        HashSet<String> allAssignedHRBuCa = new HashSet<String>(16);
        this.buildAssignedHRBUCa(dataSource, assignedCloudBuCaFunc, allAssignedHRBuCa);
        this.getPageCache().put(ALL_ASSIGNED_HR_BUCA, SerializationUtils.toJsonString(allAssignedHRBuCa));
        this.hrAdminGroupPermHelper.fillCloudEntryCard(this.getView(), assignedCloudBuCaFunc);
    }

    public void clearSelectApp() {
        TreeView tv = this.getControl("selectedapptree");
        tv.deleteAllNodes();
        TreeNode rootNode = new TreeNode();
        rootNode.setId("-1");
        rootNode.setParentid("");
        rootNode.setText(this.getSelectAppRootNodeText());
        rootNode.setIsOpened(true);
        this.getPageCache().remove("app_add_ids");
        this.getPageCache().remove("Current_AppData");
        this.getPageCache().remove("appRightSource");
    }

    private void buildAssignedHRBUCa(Map<String, String> dataSource, Map<String, Set<String>> assignedCloudBuCaFunc, Set<String> allAssignedHRBuCa) {
        for (Map.Entry<String, String> entry : dataSource.entrySet()) {
            String[] split = entry.getKey().split("\\|");
            Set<String> cloudBuCa = assignedCloudBuCaFunc.get(split[0]);
            if (null == cloudBuCa) {
                cloudBuCa = new HashSet<String>(16);
            }
            Set<String> res = this.hrAdminGroupPermHelper.getBuCaFunctionsInApp(split[0], split[1]);
            cloudBuCa.addAll(res);
            if (cloudBuCa.size() <= 0) continue;
            allAssignedHRBuCa.addAll(cloudBuCa);
            assignedCloudBuCaFunc.put(split[0], cloudBuCa);
            LOGGER.info("assignedCloudBuCaFunc = {}, allAssignedHRBuCa = {}", assignedCloudBuCaFunc, allAssignedHRBuCa);
        }
    }

    public void initAppTree(Long adminGroupId, Long level, Set<String> assignableApps) {
        TreeView tv = this.getControl("apptree");
        tv.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", "-1", this.getAppRootNodeText(), true);
        rootNode.setIsOpened(true);
        Set<Object> appRanges = new HashSet(16);
        Long currentGroupId = adminGroupId;
        if (level > 2L) {
            appRanges = this.queryAssignableAppRange("apptree", currentGroupId, false, assignableApps);
            if (level == 3L && CollectionUtils.isEmpty(appRanges)) {
                appRanges = this.queryAssignableAppRange("apptree", currentGroupId, true, assignableApps);
            }
        } else {
            appRanges = this.queryAssignableAppRange("apptree", currentGroupId, true, assignableApps);
        }
        HashSet<String> forBidApps = new HashSet<String>(16);
        EntityCtrlServiceHelper.queryEntityForBidInfo(null, forBidApps, null);
        Set<Object> appIds = Sets.newHashSetWithExpectedSize((int)0);
        if (appRanges != null) {
            appIds = appRanges.stream().map(it -> it.split("\\|")[2]).filter(it -> !forBidApps.contains(it)).collect(Collectors.toSet());
        }
        this.hrAdminGroupPermHelper.setAllAppFunc(appIds);
        HashMap<String, String> dataSource = new HashMap<String, String>(16);
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
        ArrayList<TreeNode> clouds = new ArrayList<TreeNode>(16);
        for (String string : appRanges) {
            TreeNode treeNode;
            String[] appInfo = string.split("\\|");
            String cloudId = appInfo[0];
            String cloudName = StringUtils.isEmpty((String)appInfo[1]) ? cloudId : appInfo[1];
            String appId = appInfo[2];
            String appName = this.appIdNameMap.get(appId);
            if (forBidApps.contains(appId)) continue;
            if (StringUtils.isEmpty((String)appName)) {
                String string2 = appName = StringUtils.isEmpty((String)appInfo[3]) ? appId : appInfo[3];
            }
            if ((treeNode = (TreeNode)cloudNodes.get(cloudId)) == null) {
                treeNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                cloudNodes.put(cloudId, treeNode);
                this.appNodeNameMap.put(cloudId, cloudName);
                clouds.add(treeNode);
            }
            TreeNode children = new TreeNode(treeNode.getId(), "app#" + appId + "|" + cloudId, appName, false);
            treeNode.addChild(children);
            this.appNodeNameMap.put(appId, appName);
            dataSource.put(cloudId + '|' + appId, appName);
        }
        List<String> cloudIds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)clouds.size());
        cloudIds.forEach(id -> clouds.stream().filter(node -> HRStringUtils.equals((String)id, (String)node.getId().substring(node.getId().indexOf(35) + 1))).findFirst().ifPresent(nodes::add));
        rootNode.addChildren((List)arrayList);
        tv.addNode(rootNode);
        this.getPageCache().put("appLeftSource", SerializationUtils.toJsonString(dataSource));
        this.getPageCache().put("appNodeNameMap", SerializationUtils.toJsonString(this.appNodeNameMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryAssignableAppRange(String treeView, Long adminGroupId, boolean isTopTree, Set<String> assignableApps) {
        HashSet<String> hashSet;
        String langName = RequestContext.get().getLang().name();
        String algoPrefixKey = this.getClass().getName() + ".queryAssignableAppRange.";
        DataSet cloudAppDS = null;
        DataSet adminAppDS = null;
        DataSet finalDS = null;
        try {
            Row row;
            StringBuilder sbCloudAppSql = new StringBuilder().append("SELECT t.cloudl_id, t.cloudl_name, t.cloud_seq, t.app_id, t.app_name, t.app_seq, t.temp_id, t.finheritpath FROM ").append("(SELECT DISTINCT cloudl.fid cloudl_id, cloudl.fname cloudl_name, cloud.fseq cloud_seq, a.fmasterid app_id, b.fname app_name, a.fseq app_seq, a.fid temp_id, a.finheritpath ").append("FROM t_meta_bizapp a JOIN t_meta_bizapp_l b ON (a.fid = b.fid and b.flocaleid = ?) ").append("JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = a.fbizcloudid AND cloudl.flocaleid = ?) ").append("JOIN t_meta_bizcloud cloud ON cloud.FID = cloudl.FID ").append("WHERE NOT EXISTS (SELECT 1 FROM t_meta_appruntime c WHERE (a.fid = c.fid OR a.fmasterid = c.fid) AND c.falluserapp = '1') ").append("AND a.fdeploystatus = '2' ").append("AND a.falluserapp = '0' ").append("AND a.fmasterid <> ' ' ").append("AND a.fid NOT IN (SELECT a.fparentid FROM t_meta_bizapp a) ").append("AND cloud.fid != '83bfebc800000bac' ").append("UNION ").append("SELECT DISTINCT cloudl.fid cloudl_id, cloudl.fname cloudl_name, cloud.fseq cloud_seq, a.fid app_id, b.fname app_name, a.fseq app_seq, a.fmasterid temp_id, a.finheritpath ").append("FROM t_meta_bizapp a JOIN t_meta_bizapp_l b ON (a.fid = b.fid AND b.flocaleid = ?) ").append("JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = a.fbizcloudid AND cloudl.flocaleid = ?) ").append("JOIN t_meta_bizcloud cloud ON cloud.FID = cloudl.FID ").append("WHERE a.fmasterid = ' ' ").append("AND a.fid NOT IN (select a.fparentid from t_meta_bizapp a) ").append("AND a.fdeploystatus = '2' ").append("AND a.falluserapp = '0' ").append("AND cloud.fid != '83bfebc800000bac' ").append(") t ");
            boolean hasCloudFilter = this.appendCloudFilter(sbCloudAppSql);
            this.appendAppFilter(sbCloudAppSql, hasCloudFilter, assignableApps);
            sbCloudAppSql.append(" order by t.cloud_seq, t.app_seq, t.finheritpath desc ");
            cloudAppDS = DB.queryDataSet((String)(algoPrefixKey + ".cloudAppDS"), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])new Object[]{langName, langName, langName, langName});
            Set<String> allHRCloudId = HRCloudServiceHelper.getAllHRCloudId();
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(1);
            map.put("allHRCloudId", allHRCloudId);
            cloudAppDS = cloudAppDS.filter("cloudl_id in allHRCloudId", map);
            finalDS = null;
            if (!isTopTree) {
                String adminAppEntrySql = "SELECT paae.fappid paae_appid FROM t_perm_admingroupapp paae where paae.fusergroupid = ? ";
                adminAppDS = DB.queryDataSet((String)(algoPrefixKey + ".adminAppDS"), (DBRoute)DBRoute.permission, (String)adminAppEntrySql, (Object[])new Object[]{adminGroupId});
                finalDS = cloudAppDS.join(adminAppDS).on("app_id", "paae_appid").select(new String[]{"cloudl_id", "cloudl_name", "cloud_seq", "app_id", "app_name", "app_seq"}, new String[0]).finish().orderBy(new String[]{"cloud_seq", "app_seq"});
            } else {
                finalDS = cloudAppDS;
            }
            HashSet<String> appRange = new HashSet<String>(16);
            HashSet<String> appIds = new HashSet<String>(100);
            if ("apptree".equals(treeView)) {
                while (finalDS.hasNext()) {
                    row = finalDS.next();
                    String appId = row.getString("app_id");
                    if (appIds.contains(appId)) continue;
                    String info = row.getString("cloudl_id") + "|" + row.getString("cloudl_name") + "|" + appId + "|" + (StringUtils.isNotEmpty((String)row.getString("app_name")) ? row.getString("app_name") : row.getString("app_id"));
                    appRange.add(info);
                    appIds.add(appId);
                }
            } else {
                while (finalDS.hasNext()) {
                    row = finalDS.next();
                    String appId = row.getString("app_id");
                    if (appIds.contains(appId)) continue;
                    String info = row.getString("cloudl_id") + "|" + appId;
                    appRange.add(info);
                    appIds.add(appId);
                }
            }
            hashSet = appRange;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{cloudAppDS, adminAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{cloudAppDS, adminAppDS, finalDS});
        return hashSet;
    }

    private void appendAppFilter(StringBuilder sb, boolean hasCloudFilter, Set<String> assignableApps) {
        String appStr;
        List appIdsBlackListFromStd;
        StringBuilder app = new StringBuilder();
        String appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist();
        if (StringUtils.isNotEmpty((String)appIdBlackList)) {
            app.append(appIdBlackList);
        }
        if (!CollectionUtils.isEmpty((Collection)(appIdsBlackListFromStd = PermFormCommonUtil.getAppIdsFromStdBlackList()))) {
            for (int i = 0; i < appIdsBlackListFromStd.size(); ++i) {
                appIdsBlackListFromStd.set(i, "'" + (String)appIdsBlackListFromStd.get(i) + "'");
            }
            String appIds = String.join((CharSequence)",", appIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)appIds)) {
                if (StringUtils.isNotEmpty((String)app.toString())) {
                    app.append(',').append(appIds);
                } else {
                    app.append(appIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(appStr = app.toString()))) {
            if (hasCloudFilter) {
                sb.append(" AND");
            } else {
                sb.append(" WHERE");
            }
            sb.append(" t.app_id NOT IN (").append(appStr).append(')');
        }
        if (!CollectionUtils.isEmpty(assignableApps)) {
            String assignableAppStr = assignableApps.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
            if (StringUtils.isNotEmpty((String)app.toString())) {
                sb.append(" AND t.app_id IN (").append(assignableAppStr).append(')');
            }
        }
    }

    private boolean appendCloudFilter(StringBuilder sb) {
        String cloudStr;
        List cloudIdsBlackListFromStd;
        StringBuilder cloud = new StringBuilder();
        String cloudIdBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (StringUtils.isNotEmpty((String)cloudIdBlackList)) {
            cloud.append(cloudIdBlackList);
        }
        if (!CollectionUtils.isEmpty((Collection)(cloudIdsBlackListFromStd = PermFormCommonUtil.getCloudIdsFromStdBlackList()))) {
            for (int i = 0; i < cloudIdsBlackListFromStd.size(); ++i) {
                cloudIdsBlackListFromStd.set(i, "'" + (String)cloudIdsBlackListFromStd.get(i) + "'");
            }
            String cloudIds = String.join((CharSequence)",", cloudIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)cloudIds)) {
                if (StringUtils.isNotEmpty((String)cloud.toString())) {
                    cloud.append(',').append(cloudIds);
                } else {
                    cloud.append(cloudIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(cloudStr = cloud.toString()))) {
            sb.append(" WHERE t.cloudl_id NOT IN (").append(cloudStr).append(')');
            return true;
        }
        return false;
    }

    public void rebuildSysRightTree(boolean isAdd, Set<String> perms) {
        IPageCache pageCache = this.getPageCache();
        String adminGroupPermStr = pageCache.get("Current_SysData");
        Set<String> adminGroupPerm = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)adminGroupPermStr)) {
            adminGroupPerm = (Set)SerializationUtils.fromJsonString((String)adminGroupPermStr, Set.class);
        }
        if (isAdd) {
            adminGroupPerm.addAll(perms);
        } else {
            adminGroupPerm.removeAll(perms);
        }
        pageCache.put("Current_SysData", SerializationUtils.toJsonString(adminGroupPerm));
        TreeView tv = this.getControl("selectedsystree");
        tv.deleteAllNodes();
        if (adminGroupPerm.size() == 0) {
            long level = this.getModel().getDataEntity().getLong("level");
            TreeNode commonRightRootNode = this.getCommonRightRootNode(level);
            tv.addNode(commonRightRootNode);
        } else {
            this.getSelectPermRootNode(tv, adminGroupPerm, this.getSelectSysRootNodeText(), false);
        }
    }

    public void updateAddCache(Set<String> ids, boolean isAdd, String cacheKey) {
        String toAddIdsJson = this.getPageCache().get(cacheKey);
        Set<String> toAddIdSet = new HashSet(16);
        if (StringUtils.isNotEmpty((String)toAddIdsJson)) {
            toAddIdSet = (Set)SerializationUtils.fromJsonString((String)toAddIdsJson, Set.class);
        }
        boolean idsChanged = false;
        idsChanged = isAdd ? toAddIdSet.addAll(ids) : toAddIdSet.removeAll(ids);
        if (idsChanged) {
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(toAddIdSet));
        }
    }

    public void removeSys() {
        TreeView tv = this.getControl("selectedsystree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u5206\u914d\u6743\u9650\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermEdit_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            IPageCache pageCache = this.getPageCache();
            this.getPageCache().put("dataChanged", "true");
            pageCache.put("sys_change", "true");
            Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysRightSource"), Map.class);
            HashMap<String, List> entityPermItems = new HashMap<String, List>(16);
            HashSet<String> removeIds = new HashSet<String>(16);
            for (String string : checkedNodeIds) {
                if (!string.startsWith("permitem#")) continue;
                int permItem = string.lastIndexOf(35);
                int entity = string.lastIndexOf(64);
                int app = string.lastIndexOf(124);
                String permItemSub = string.substring(permItem + 1, entity);
                String entitySub = string.substring(entity + 1, app);
                String appSub = string.substring(app + 1);
                removeIds.add(appSub + "|" + entitySub + "|" + permItemSub);
                entityPermItems.computeIfAbsent(appSub + "|" + entitySub, k -> new ArrayList(10)).add(permItemSub);
            }
            for (Map.Entry entry : entityPermItems.entrySet()) {
                String appEntity = (String)entry.getKey();
                List permItems = (List)entry.getValue();
                String source = (String)dataSource.get(appEntity);
                AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)source, AdminGroupSysSearchBean.class);
                if (bean.getPermItems().size() == permItems.size()) {
                    dataSource.remove(appEntity);
                    continue;
                }
                bean.getPermItems().removeAll(permItems);
                dataSource.put(appEntity, SerializationUtils.toJsonString((Object)bean));
            }
            this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString((Object)dataSource));
            this.updateAddCache(removeIds, false, "sys_add_ids");
            if (!this.isBatchAuth) {
                this.updateDelCache(removeIds, true, "sys_del_ids");
            }
            this.rebuildSysRightTree(false, removeIds);
        }
    }

    public void addSys() {
        TreeView tv = this.getControl("systree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53ef\u5206\u914d\u6743\u9650\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermEdit_22", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        this.getPageCache().put("dataChanged", "true");
        pageCache.put("sys_change", "true");
        Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysRightSource"), Map.class);
        HashMap<String, List> entityPermItems = new HashMap<String, List>(16);
        HashSet<String> addIds = new HashSet<String>(16);
        for (String string : checkedNodeIds) {
            if (!string.startsWith("permitem#")) continue;
            int permItem = string.lastIndexOf(35);
            int entity = string.lastIndexOf(64);
            int app = string.lastIndexOf(124);
            String permItemSub = string.substring(permItem + 1, entity);
            String entitySub = string.substring(entity + 1, app);
            String appSub = string.substring(app + 1);
            String mainId = appSub + "|" + entitySub + "|" + permItemSub;
            addIds.add(mainId);
            entityPermItems.computeIfAbsent(appSub + "|" + entitySub, k -> new ArrayList(10)).add(permItemSub);
        }
        for (Map.Entry entry : entityPermItems.entrySet()) {
            AdminGroupSysSearchBean bean;
            String appEntity = (String)entry.getKey();
            String entityNum = appEntity.substring(appEntity.lastIndexOf(124) + 1);
            List permItems = (List)entry.getValue();
            String source = (String)dataSource.get(appEntity);
            if (StringUtils.isEmpty((String)source)) {
                bean = new AdminGroupSysSearchBean(appEntity, this.sysNodeNameMap.get(entityNum), permItems);
                dataSource.put(appEntity, SerializationUtils.toJsonString((Object)bean));
                continue;
            }
            bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)source, AdminGroupSysSearchBean.class);
            bean.getPermItems().addAll(permItems);
            dataSource.put(appEntity, SerializationUtils.toJsonString((Object)bean));
        }
        this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString((Object)dataSource));
        this.updateAddCache(addIds, true, "sys_add_ids");
        if (!this.isBatchAuth) {
            this.updateDelCache(addIds, false, "sys_del_ids");
        }
        this.rebuildSysRightTree(true, addIds);
    }

    public void commonQueryTreeNodeChildren(TreeView tv, String nodeId, String orgViewType, Long adminGroupId, String treeRootCache, boolean isLeftTree, String treeNodeIdCheckedCache) {
        String orgDataStr;
        String orgDataCacheKey = null;
        String errorMsgNotInView = null;
        String errorMsgNotInView2 = null;
        boolean isBizTree = false;
        if (orgViewType.equals("11")) {
            orgDataCacheKey = adminGroupId + "_current_BizDatas";
            errorMsgNotInView = ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermEdit_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            errorMsgNotInView2 = ResManager.loadKDString((String)"\u90e8\u5206\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermEdit_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            isBizTree = true;
        }
        List orgData = StringUtils.isNotEmpty((String)(orgDataStr = this.getPageCache().get(orgDataCacheKey))) && !"[]".equals(orgDataStr) ? SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class) : this.queryOrgLongNumberByAdminGroupId(adminGroupId, orgViewType, isLeftTree);
        Map checkedNodeLongInfo = OrgServiceHelper.getOrgLongProperty((String)orgViewType, (long)Long.parseLong(nodeId));
        String checkedNodeLongNumber = (String)checkedNodeLongInfo.get("number");
        if (checkedNodeLongNumber == null) {
            return;
        }
        checkedNodeLongNumber = checkedNodeLongNumber.replace('!', ' ');
        TreeNode treeRootNodeCache = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeRootCache), TreeNode.class);
        TreeNode parentTreeNode = treeRootNodeCache.getTreeNode(nodeId, 100);
        int size = orgData.size();
        int i = 0;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        String lastLongNumber = "_";
        for (String data : orgData) {
            String[] orgDataArr = data.split("_split_");
            String orgName = orgDataArr[1];
            if (orgDataArr.length < 5) {
                ++i;
                continue;
            }
            String orgLongNumber = orgDataArr[2];
            if (null == orgLongNumber || orgName == null) {
                this.getView().showTipNotification(errorMsgNotInView2, Integer.valueOf(7000));
                ++i;
                continue;
            }
            if (orgLongNumber.equals(checkedNodeLongNumber) || !orgLongNumber.startsWith(checkedNodeLongNumber + " ")) {
                ++i;
                continue;
            }
            if (!orgLongNumber.startsWith(lastLongNumber + " ") && !orgLongNumber.equals(lastLongNumber)) {
                TreeNode node = new TreeNode();
                node.setParentid(nodeId);
                if (i + 1 < size) {
                    String nextOrg = (String)orgData.get(i + 1);
                    String[] orgDataArrNext = nextOrg.split("_split_");
                    if (orgDataArrNext.length < 5) continue;
                    String nextLongNumber = orgDataArrNext[2];
                    if (nextLongNumber.startsWith(orgLongNumber + " ")) {
                        node.setChildren(new ArrayList());
                    }
                }
                node.setId(orgDataArr[0]);
                node.setText(orgDataArr[1]);
                node.setLongNumber(orgDataArr[2]);
                if (isBizTree && Boolean.parseBoolean(orgDataArr[3])) {
                    node.setIcon("kdfont kdfont-faren");
                }
                nodes.add(node);
                lastLongNumber = orgLongNumber;
            }
            ++i;
        }
        tv.addNodes(nodes);
        String treeNodeIdCheckedJson = this.getPageCache().get(treeNodeIdCheckedCache);
        Set ids = new HashSet(1000);
        if (StringUtils.isNotEmpty((String)treeNodeIdCheckedJson)) {
            ids = (Set)SerializationUtils.fromJsonString((String)treeNodeIdCheckedJson, Set.class);
        }
        ArrayList<TreeNode> needCheckChildren = new ArrayList<TreeNode>(10);
        for (TreeNode node : nodes) {
            if (!ids.contains(node.getId())) continue;
            node.setCheckable(true);
            needCheckChildren.add(node);
        }
        tv.checkNodes(needCheckChildren);
        if (!CollectionUtils.isEmpty(nodes)) {
            if (parentTreeNode.getChildren() == null) {
                parentTreeNode.setChildren(new ArrayList(10));
            }
            parentTreeNode.getChildren().addAll(nodes);
            this.getPageCache().put(treeRootCache, SerializationUtils.toJsonString((Object)treeRootNodeCache));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        long level = (Long)this.getModel().getValue("level");
        if (HRStringUtils.equals((String)name, (String)FIELD_BUCA_RANGE)) {
            long adminGroupParentId;
            Map<String, List<Object>> parentBuData;
            List<Object> buRange;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            int row = beforeF7SelectEvent.getRow();
            String buType = ((DynamicObject)dataEntity.getDynamicObjectCollection(KEY_BU_ENTRY).get(row)).getString("butype.id");
            if (level > (long)(this.isBatchAuth ? 2 : 3) && (buRange = (parentBuData = this.queryBuRange(adminGroupParentId = dataEntity.getLong("parentgroupid.id"))).get(buType)) != null) {
                QFilter idFilter = new QFilter("id", "in", buRange);
                listShowParameter.getListFilterParameter().setFilter(idFilter);
            }
            listShowParameter.setCustomParam("orgFuncId", (Object)buType);
        }
        LOGGER.info("AdminGroupPermEdit orgrange beforeF7Select formShowParameter customParam:{}", (Object)listShowParameter.getCustomParams());
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        TreeView tv = (TreeView)event.getSource();
        String nodeId = (String)event.getNodeId();
        Boolean checked = event.getChecked();
        String treeViewKey = tv.getKey();
        if ("-1".equals(nodeId)) {
            if (checked.booleanValue()) {
                this.checkAtRoot(tv, treeViewKey);
            } else {
                tv.uncheckNodes(tv.getTreeState().getCheckedNodeIds());
                this.treeNodeUncheckAtRoot(treeViewKey);
            }
        } else {
            this.checkTreeNode(tv, treeViewKey, nodeId, checked);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkTreeNode(TreeView tv, String treeViewKey, String nodeId, boolean checked) {
        IPageCache pageCache = this.getPageCache();
        String longNumber = "";
        String leftNodesCheckedCacheKey = null;
        String orgRootNodeCacheKey = null;
        boolean includeSub = false;
        boolean searchMode = false;
        String treeSource = "";
        if ("orgtree".equals(treeViewKey)) {
            longNumber = this.bizUnitNodeMap.get(nodeId).split("_split_")[2];
            leftNodesCheckedCacheKey = "orgTreeLeftNodeIds";
            orgRootNodeCacheKey = "orgTreeLeftRoot";
            includeSub = (Boolean)this.getModel().getValue("bizleftincludesub");
            searchMode = !StringUtils.isEmpty((String)pageCache.get("orgtree_search"));
            treeSource = "bizLeftSource";
        } else if ("selectedorgtree".equals(treeViewKey)) {
            String orgInfo = this.bizUnitNodeMap.get(nodeId);
            longNumber = StringUtils.isEmpty((String)orgInfo) ? this.queryOrgLongNumber(Long.parseLong(nodeId), 15L) : orgInfo.split("_split_")[2];
            leftNodesCheckedCacheKey = "orgTreeRightNodeIds";
            orgRootNodeCacheKey = "orgTreeRightRoot";
            includeSub = (Boolean)this.getModel().getValue("bizrightincludesub");
            searchMode = !StringUtils.isEmpty((String)pageCache.get("selectedorgtree_search"));
            treeSource = "bizRightSource";
        }
        String leftTreeNodeIdsJson = pageCache.get(leftNodesCheckedCacheKey);
        HashSet<String> ids = new HashSet<String>(1000);
        if (StringUtils.isNotEmpty((String)leftTreeNodeIdsJson)) {
            ids = (Set)SerializationUtils.fromJsonString((String)leftTreeNodeIdsJson, Set.class);
        }
        if (checked) {
            ids.add(nodeId);
        } else {
            ids.remove(nodeId);
        }
        TreeNode treeRootFromCache = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(orgRootNodeCacheKey), TreeNode.class);
        TreeNode parentTreeNode = treeRootFromCache.getTreeNode(nodeId, 100);
        parentTreeNode.setCheckable(checked);
        if (includeSub) {
            ArrayList<TreeNode> childrenNodes2Handle = new ArrayList<TreeNode>(10);
            ArrayList<String> childrenNodes2HandleId = new ArrayList<String>(10);
            if (searchMode) {
                this.synchronizeSubOrg(parentTreeNode, ids, childrenNodes2Handle, childrenNodes2HandleId, checked);
            } else {
                List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get(treeSource), AdminGroupOrgSearchBean.class);
                longNumber = longNumber + ' ';
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getLongNumber().startsWith(longNumber)) continue;
                    String currentNodeId = bean.getId();
                    TreeNode treeNode = treeRootFromCache.getTreeNode(currentNodeId, 100);
                    if (treeNode != null) {
                        childrenNodes2Handle.add(treeNode);
                        childrenNodes2HandleId.add(currentNodeId);
                        treeNode.setCheckable(checked);
                    }
                    if (checked) {
                        ids.add(currentNodeId);
                        continue;
                    }
                    ids.remove(currentNodeId);
                }
            }
            if (checked) {
                tv.checkNodes(childrenNodes2Handle);
            } else {
                tv.uncheckNodes(childrenNodes2HandleId);
            }
        }
        pageCache.put(orgRootNodeCacheKey, SerializationUtils.toJsonString((Object)treeRootFromCache));
        pageCache.put(leftNodesCheckedCacheKey, SerializationUtils.toJsonString(ids));
    }

    private void synchronizeSubOrg(TreeNode treeNode, Set<String> ids, List<TreeNode> childrenNodes2Handle, List<String> childrenNodes2HandleId, boolean checked) {
        List children = treeNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (TreeNode child : children) {
                String id = child.getId();
                child.setCheckable(checked);
                if (checked) {
                    ids.add(id);
                } else {
                    ids.remove(id);
                    childrenNodes2HandleId.add(id);
                }
                this.synchronizeSubOrg(child, ids, childrenNodes2Handle, childrenNodes2HandleId, checked);
            }
            childrenNodes2Handle.addAll(children);
        }
    }

    private void checkAtRoot(TreeView tv, String treeViewKey) {
        TreeNode rootOrgNode;
        String orgTreeRootCache;
        IPageCache pageCache = this.getPageCache();
        String treeNodeCacheId = "";
        String treeNodesCheckedCacheId = "";
        String treeSource = "";
        if ("orgtree".equals(treeViewKey)) {
            treeNodeCacheId = "orgTreeLeftRoot";
            treeNodesCheckedCacheId = "orgTreeLeftNodeIds";
            treeSource = StringUtils.isEmpty((String)pageCache.get("orgtree_search")) ? "bizLeftSource" : "bizLeftSource_search";
        } else if ("selectedorgtree".equals(treeViewKey)) {
            treeNodeCacheId = "orgTreeRightRoot";
            treeNodesCheckedCacheId = "orgTreeRightNodeIds";
            treeSource = StringUtils.isEmpty((String)pageCache.get("selectedorgtree_search")) ? "bizRightSource" : "bizRightSource_search";
        }
        String orgTreeLeftNodeIdsJson = pageCache.get(treeNodesCheckedCacheId);
        HashSet<String> orgTreeLeftNodeIds = orgTreeLeftNodeIdsJson != null ? (HashSet<String>)SerializationUtils.fromJsonString((String)orgTreeLeftNodeIdsJson, Set.class) : new HashSet<String>(16);
        String treeSourceData = pageCache.get(treeSource);
        if (StringUtils.isNotEmpty((String)treeSourceData)) {
            List dataSource = SerializationUtils.fromJsonStringToList((String)treeSourceData, AdminGroupOrgSearchBean.class);
            for (AdminGroupOrgSearchBean bean : dataSource) {
                orgTreeLeftNodeIds.add(bean.getId());
            }
        }
        if (StringUtils.isNotEmpty((String)(orgTreeRootCache = pageCache.get(treeNodeCacheId))) && (rootOrgNode = (TreeNode)SerializationUtils.fromJsonString((String)orgTreeRootCache, TreeNode.class)) != null) {
            rootOrgNode.setCheckable(true);
            ArrayList<TreeNode> childNodeNeedChecked = new ArrayList<TreeNode>(1000);
            ArrayList<String> childrenNodes2HandleId = new ArrayList<String>(10);
            this.synchronizeSubOrg(rootOrgNode, orgTreeLeftNodeIds, childNodeNeedChecked, childrenNodes2HandleId, true);
            tv.checkNodes(childNodeNeedChecked);
            this.getPageCache().put(treeNodesCheckedCacheId, SerializationUtils.toJsonString(orgTreeLeftNodeIds));
            this.getPageCache().put(treeNodeCacheId, SerializationUtils.toJsonString((Object)rootOrgNode));
        }
    }

    public void removeSelOrg(Long adminGroupId, Long level, String viewType) {
        String rightNodeIds;
        String noticeMsg = null;
        String rightNodeIdCacheKey = null;
        String toDelIdCacheKey = null;
        String toAddIdCacheKey = null;
        String modelChangeKey = null;
        if (viewType.equals("11")) {
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u9009\u4e1a\u52a1\u5355\u5143\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermEdit_19", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            rightNodeIdCacheKey = "orgTreeRightNodeIds";
            toDelIdCacheKey = "biz_del_ids";
            toAddIdCacheKey = "biz_add_ids";
            modelChangeKey = "biz_change";
        }
        if (StringUtils.isEmpty((String)(rightNodeIds = this.getPageCache().get(rightNodeIdCacheKey)))) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        Set rightNodeIdSets = (Set)SerializationUtils.fromJsonString((String)rightNodeIds, Set.class);
        if (rightNodeIdSets.size() == 0) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        this.getPageCache().put("dataChanged", "true");
        this.getPageCache().put(modelChangeKey, "true");
        this.updateAddCache(rightNodeIdSets, false, toAddIdCacheKey);
        if (!this.isBatchAuth) {
            this.updateDelCache(rightNodeIdSets, true, toDelIdCacheKey);
        }
        this.deleteEntryByList(adminGroupId, rightNodeIdSets, viewType);
        this.buildSelectedOrgTree(adminGroupId, viewType, level);
        this.getPageCache().remove(rightNodeIdCacheKey);
    }

    private void deleteEntryByList(Long adminGroupId, Set<String> toDeleteIds, String viewType) {
        String orgSourceKey;
        String currentOrgDataCacheKey;
        IPageCache pageCache = this.getPageCache();
        if ("11".equals(viewType)) {
            currentOrgDataCacheKey = adminGroupId + "_current_BizDatas";
            orgSourceKey = "bizRightSource";
        } else {
            currentOrgDataCacheKey = adminGroupId + "_current_AdminOrgDatas";
            orgSourceKey = "adminRightSource";
        }
        List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get(orgSourceKey), AdminGroupOrgSearchBean.class);
        String orgDataStr = this.getPageCache().get(currentOrgDataCacheKey);
        List<String> orgData = StringUtils.isNotEmpty((String)orgDataStr) ? SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class) : this.queryOrgLongNumberByAdminGroupId(adminGroupId, viewType, false);
        Iterator<String> it = orgData.iterator();
        while (it.hasNext()) {
            String data = it.next();
            String orgId = data.split("_split_")[0];
            if (StringUtils.isEmpty((String)orgId) || !toDeleteIds.contains(orgId)) continue;
            it.remove();
        }
        dataSource.removeIf(bean -> toDeleteIds.contains(bean.getId()));
        pageCache.put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        pageCache.put(orgSourceKey, SerializationUtils.toJsonString((Object)dataSource));
    }

    public void addOrg(Long adminGroupId, Long level, String viewType) {
        String leftNodeIdCacheJson;
        String treeViewKey = null;
        String noticeMsg = null;
        String rootTreeNodeCacheKey = null;
        String leftNodeIdCacheKey = null;
        String rightNodeIdCacheKey = null;
        String toDelIdCacheKey = null;
        String toAddIdCacheKey = null;
        String modelChangeKey = null;
        if (viewType.equals("11")) {
            treeViewKey = "orgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f85\u9009\u4e1a\u52a1\u5355\u5143\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermEdit_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            rootTreeNodeCacheKey = "orgTreeLeftRoot";
            leftNodeIdCacheKey = "orgTreeLeftNodeIds";
            rightNodeIdCacheKey = "orgTreeRightNodeIds";
            toDelIdCacheKey = "biz_del_ids";
            toAddIdCacheKey = "biz_add_ids";
            modelChangeKey = "biz_change";
        }
        if (StringUtils.isEmpty((String)(leftNodeIdCacheJson = this.getPageCache().get(leftNodeIdCacheKey)))) {
            this.getView().showTipNotification(noticeMsg, Integer.valueOf(2000));
            return;
        }
        Set leftNodeIds = (Set)SerializationUtils.fromJsonString((String)leftNodeIdCacheJson, Set.class);
        if (leftNodeIds.size() == 0) {
            this.getView().showTipNotification(noticeMsg, Integer.valueOf(2000));
            return;
        }
        this.getPageCache().put("dataChanged", "true");
        this.getPageCache().put(modelChangeKey, "true");
        this.updateAddCache(leftNodeIds, true, toAddIdCacheKey);
        if (!this.isBatchAuth) {
            this.updateDelCache(leftNodeIds, false, toDelIdCacheKey);
        }
        this.getPageCache().remove(leftNodeIdCacheKey);
        this.getPageCache().remove(rightNodeIdCacheKey);
        this.adjustEntry(adminGroupId, leftNodeIds, true, viewType);
        this.buildSelectedOrgTree(adminGroupId, viewType, level);
        TreeView tree = this.getControl(treeViewKey);
        List checkedNodeIdList = tree.getTreeState().getCheckedNodeIds();
        tree.uncheckNodes(checkedNodeIdList);
        TreeNode rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(rootTreeNodeCacheKey), TreeNode.class);
        rootTreeNode.setCheckable(false);
        List children = rootTreeNode.getChildren();
        this.uncheckChildNodes(children);
        this.getPageCache().put(rootTreeNodeCacheKey, SerializationUtils.toJsonString((Object)rootTreeNode));
    }

    public void updateDelCache(Set<String> ids, boolean isDelete, String cacheKey) {
        String toDeleteIdsJson = this.getPageCache().get(cacheKey);
        Set<String> toDeletegIdSet = new HashSet(16);
        if (StringUtils.isNotEmpty((String)toDeleteIdsJson)) {
            toDeletegIdSet = (Set)SerializationUtils.fromJsonString((String)toDeleteIdsJson, Set.class);
        }
        boolean idsChanged = false;
        idsChanged = isDelete ? toDeletegIdSet.addAll(ids) : toDeletegIdSet.removeAll(ids);
        if (idsChanged) {
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(toDeletegIdSet));
        }
    }

    private void adjustEntry(Long adminGroupId, Set<String> nodeIds, boolean isAdd, String viewType) {
        IPageCache pageCache = this.getPageCache();
        String langName = RequestContext.get().getLang().name();
        String currentOrgDataCacheKey = adminGroupId + "_current_BizDatas";
        Map<String, String> orgNodeMap = this.bizUnitNodeMap;
        String orgSourceKey = "bizRightSource";
        String orgDataStr = pageCache.get(currentOrgDataCacheKey);
        List<String> orgData = StringUtils.isNotEmpty((String)orgDataStr) ? SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class) : this.queryOrgLongNumberByAdminGroupId(adminGroupId, viewType, false);
        List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get(orgSourceKey), AdminGroupOrgSearchBean.class);
        if (isAdd) {
            HashSet<String> orgDataSet = new HashSet<String>(orgData);
            for (String nodeId : nodeIds) {
                String[] details;
                String info = orgNodeMap.get(nodeId);
                boolean success = orgDataSet.add(info);
                if (!success || (details = info.split("_split_")).length != 5) continue;
                dataSource.add(new AdminGroupOrgSearchBean(details[0], details[1], details[2], Boolean.parseBoolean(details[3]), info, details[4]));
            }
            orgData = new ArrayList<String>(orgDataSet);
            orgData.sort((org1, org2) -> {
                String[] orgFromArr = org1.split("_split_");
                String[] orgToArr = org2.split("_split_");
                if (orgFromArr.length < 5 || orgToArr.length < 5) {
                    return 0;
                }
                String longNumber1 = orgFromArr[2];
                String longNumber2 = orgToArr[2];
                return longNumber1.compareTo(longNumber2);
            });
        }
        pageCache.put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        pageCache.put(orgSourceKey, SerializationUtils.toJsonString((Object)dataSource));
    }

    public void treeNodeUncheckAtRoot(String treeViewKey) {
        String treeNodeRootCache = null;
        if ("selectedorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "orgTreeRightRoot";
            this.getPageCache().remove("orgTreeRightNodeIds");
        } else if ("orgtree".equals(treeViewKey)) {
            treeNodeRootCache = "orgTreeLeftRoot";
            this.getPageCache().remove("orgTreeLeftNodeIds");
        } else if ("selectedadminorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "AdminOrgTreeRightRoot";
            this.getPageCache().remove("AdminOrgTreeRightNodeIds");
        } else if ("adminorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "AdminOrgTreeLeftRoot";
            this.getPageCache().remove("AdminOrgTreeLeftNodeIds");
        }
        TreeNode treeNodeRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeRootCache), TreeNode.class);
        treeNodeRoot.setCheckable(false);
        List children = treeNodeRoot.getChildren();
        this.uncheckChildNodes(children);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)treeNodeRoot));
    }

    private void uncheckChildNodes(List<TreeNode> nodes) {
        if (!CollectionUtils.isEmpty(nodes)) {
            nodes.forEach(x -> {
                x.setCheckable(false);
                List children = x.getChildren();
                this.uncheckChildNodes(children);
            });
        }
    }

    private void initUnitTreeNormal(String viewType, Long adminGroupParentId, long level) {
        String currentOrgDataCacheKey = "11".equals(viewType) ? adminGroupParentId + "_current_BizDatas" : adminGroupParentId + "_current_AdminOrgDatas";
        Long currentGroupId = adminGroupParentId;
        List<String> orgData = this.queryOrgLongNumberByAdminGroupId(currentGroupId, viewType, true);
        if (level == 1L && CollectionUtils.isEmpty(orgData)) {
            this.initUnitTreeSuper(viewType);
        } else {
            this.getPageCache().put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
            if (CollectionUtils.isEmpty(orgData)) {
                this.initUnitTreeSuper(viewType);
            } else {
                this.loadUnitTree(viewType, orgData);
            }
        }
    }

    public void initUnitTree(String viewType, Long adminGroupParentId, long level, boolean modifyAdmin) {
        int superAdminLevel;
        int n = superAdminLevel = modifyAdmin ? 3 : 2;
        if (level <= (long)superAdminLevel) {
            this.initUnitTreeSuper(viewType);
        } else {
            this.initUnitTreeNormal(viewType, adminGroupParentId, level);
        }
    }

    private void loadUnitTree(String viewType, List<String> orgData) {
        String treeViewKey = "orgtree";
        String rootNodeText = this.getBizUnitRootNodeText();
        String errorMsg = ResManager.loadKDString((String)"\u90e8\u5206\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermEdit_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String rootNodeCacheKey = "orgTreeLeftRoot";
        TreeView tv = this.getControl(treeViewKey);
        tv.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("-1");
        root.setText(rootNodeText);
        root.setIsOpened(true);
        int size = orgData.size();
        int i = 0;
        String lastLongNumber = "";
        String longNumber = "";
        for (String data : orgData) {
            String[] orgDataArr = data.split("_split_");
            if (orgDataArr.length < 5) {
                ++i;
                continue;
            }
            longNumber = orgDataArr[2];
            if (StringUtils.isEmpty((String)longNumber)) {
                ++i;
                continue;
            }
            if (longNumber.equals(lastLongNumber) || longNumber.startsWith(lastLongNumber + " ")) {
                ++i;
                continue;
            }
            lastLongNumber = longNumber;
            TreeNode childNode = new TreeNode();
            childNode.setText(orgDataArr[1]);
            childNode.setParentid("-1");
            childNode.setId(orgDataArr[0]);
            if (Boolean.parseBoolean(orgDataArr[3])) {
                childNode.setIcon("kdfont kdfont-faren");
            }
            if (i + 1 < size) {
                String[] orgDataArrNext = orgData.get(i + 1).split("_split_");
                if (orgDataArrNext.length < 5) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (StringUtils.isEmpty((String)nextLongNumber)) {
                    this.getView().showTipNotification(errorMsg, Integer.valueOf(2000));
                    return;
                }
                if (nextLongNumber.startsWith(longNumber + " ")) {
                    childNode.setChildren(new ArrayList(10));
                }
            }
            root.addChild(childNode);
            ++i;
        }
        this.getPageCache().put(rootNodeCacheKey, SerializationUtils.toJsonString((Object)root));
        tv.addNode(root);
        String firstNodeId = null;
        List childNodes = root.getChildren();
        if (!CollectionUtils.isEmpty((Collection)childNodes)) {
            firstNodeId = ((TreeNode)childNodes.get(0)).getId();
        }
        if (StringUtils.isNotEmpty(firstNodeId)) {
            tv.queryTreeNodeChildren("-1", firstNodeId);
            tv.expand(firstNodeId);
        }
    }

    public void buildSelectedOrgTree(Long adminGroupId, String orgViewType, long level) {
        List<String> orgData;
        boolean isBizTree = false;
        String selTreeKey = "selectedorgtree";
        String rootNodeText = this.getSelBizUnitRootText();
        String currentOrgDataCacheKey = adminGroupId + "_current_BizDatas";
        String originOrgDataCacheKey = adminGroupId + "_BizDatas";
        String treeNodeRootCache = "orgTreeRightRoot";
        isBizTree = true;
        TreeView tree = this.getControl(selTreeKey);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        if (level == 1L) {
            root.setText(this.getVirtualRightRootText());
            tree.addNode(root);
            this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)root));
            return;
        }
        root.setText(rootNodeText);
        String orgDataStr = this.getPageCache().get(currentOrgDataCacheKey);
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgData = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else {
            orgData = this.queryOrgLongNumberByAdminGroupId(adminGroupId, orgViewType, false);
            this.getPageCache().put(originOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
            this.getPageCache().put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        }
        int size = orgData.size();
        int i = 0;
        String lastLongNumber = "_";
        String firstOrgNodeId = null;
        for (String data : orgData) {
            String[] orgDataArr = data.split("_split_");
            if (orgDataArr.length < 5) {
                ++i;
                continue;
            }
            String orgId = orgDataArr[0];
            String orgName = orgDataArr[1];
            String orgLongNumber = orgDataArr[2];
            if (null == orgId || orgLongNumber.startsWith(lastLongNumber + " ") || orgLongNumber.equals(lastLongNumber)) {
                ++i;
                continue;
            }
            TreeNode newNode = new TreeNode();
            newNode.setParentid("-1");
            newNode.setId(orgId);
            if (isBizTree && Boolean.parseBoolean(orgDataArr[3])) {
                newNode.setIcon("kdfont kdfont-faren");
            }
            newNode.setText(orgName);
            if (firstOrgNodeId == null) {
                firstOrgNodeId = orgId;
            }
            if (i + 1 < size) {
                String nextOrgData = orgData.get(i + 1);
                String[] orgDataArrNext = nextOrgData.split("_split_");
                if (orgDataArrNext.length < 5) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (nextLongNumber.startsWith(orgLongNumber + " ")) {
                    newNode.addChildren(new ArrayList(10));
                }
            }
            lastLongNumber = orgLongNumber;
            root.addChild(newNode);
            ++i;
        }
        if (size == 0) {
            root.setText(level <= 2L ? this.getCommonRootText() : this.getSelBizUnitRootText());
        }
        tree.addNode(root);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)root));
        if (StringUtils.isNotEmpty(firstOrgNodeId)) {
            tree.queryTreeNodeChildren("-1", firstOrgNodeId);
            tree.expand(firstOrgNodeId);
        }
    }

    private List<String> queryOrgLongNumberByAdminGroupId(Long adminGroupId, final String orgViewType, final boolean isLeftTree) {
        this.initBizUnitMap();
        String originOrgDataCacheKey = "";
        if (!orgViewType.equals("01") && orgViewType.equals("11")) {
            originOrgDataCacheKey = adminGroupId + "_BizDatas";
        }
        StringBuilder sql = new StringBuilder();
        if (adminGroupId == 0L) {
            sql.append(" SELECT os.forgid, os.flongnumber, org.fnumber, org.forgpatternid FROM t_org_org org ").append(" INNER JOIN t_org_structure os ON org.fid = os.forgid ").append(" WHERE org.fenable = '1' AND os.fisfreeze = '0' ").append(" AND EXISTS(SELECT 1 FROM t_org_viewschema ov WHERE ov.fid = os.fviewid AND ov.FTREETYPE = '").append(orgViewType).append("' AND ov.FISDEFAULT = '1') ");
        } else {
            Set<Long> orgIdSet = this.filterHROrgIds(adminGroupId);
            sql.append(" SELECT os.forgid, os.flongnumber, org.fnumber, org.forgpatternid ").append(" FROM ").append("  t_org_org org ").append(" INNER JOIN t_org_structure os ON org.fid = os.forgid ");
            if (CollectionUtils.isEmpty(orgIdSet)) {
                sql.append(" WHERE  org.fid = 0 ");
            } else {
                sql.append("WHERE  org.fid in ").append(this.splitId(orgIdSet));
            }
            if (isLeftTree) {
                sql.append(" AND  org.fenable = '1' ").append(" AND os.fisfreeze = '0' ");
            }
            sql.append(" AND EXISTS (SELECT 1 FROM t_org_viewschema ov WHERE ov.fid = os.fviewid AND ov.FTREETYPE = '").append(orgViewType).append("' AND ov.FISDEFAULT = '1') ");
        }
        List orgData = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> result = new ArrayList<String>(1000);
                HashMap<String, String> orgNodeMap = new HashMap<String, String>(1000);
                ArrayList<AdminGroupOrgSearchBean> dataSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                while (rs.next()) {
                    boolean isCorporateOrg = false;
                    String orgPatternId = rs.getString(4);
                    String patternType = (String)AdminGroupService.this.orgPatternTypeMap.get(orgPatternId);
                    if ("1".equals(patternType) || "2".equals(patternType)) {
                        isCorporateOrg = true;
                    }
                    String orgId = rs.getString(1);
                    String longNumber = rs.getString(2).replace('!', ' ');
                    String number = rs.getString(3);
                    String orgName = '(' + number + ") " + (String)AdminGroupService.this.allOrgNameMap.get(orgId);
                    String orgAndLongNumber = orgId + "_split_" + orgName + "_split_" + longNumber + "_split_" + isCorporateOrg + "_split_" + number;
                    result.add(orgAndLongNumber);
                    orgNodeMap.put(orgId, orgAndLongNumber);
                    dataSource.add(new AdminGroupOrgSearchBean(orgId, orgName, longNumber, isCorporateOrg, orgAndLongNumber, number));
                }
                if (isLeftTree && orgViewType.equals("11")) {
                    AdminGroupService.this.bizUnitNodeMap = orgNodeMap;
                    AdminGroupService.this.getPageCache().put("bizUnitNodeMap", SerializationUtils.toJsonString((Object)AdminGroupService.this.bizUnitNodeMap));
                    AdminGroupService.this.getPageCache().put("bizLeftSource", SerializationUtils.toJsonString(dataSource));
                } else if (!isLeftTree && orgViewType.equals("11")) {
                    AdminGroupService.this.getPageCache().put("bizRightSource", SerializationUtils.toJsonString(dataSource));
                } else {
                    AdminGroupService.this.getPageCache().put("adminRightSource", SerializationUtils.toJsonString(dataSource));
                }
                return result;
            }
        });
        this.orgDataSort(orgData);
        this.getPageCache().put(originOrgDataCacheKey, SerializationUtils.toJsonString((Object)orgData));
        return orgData;
    }

    public void initBizUnitMap() {
        String allOrgNameMapStr = this.getPageCache().getBigObject("allOrgNameMap");
        if (StringUtils.isNotEmpty((String)allOrgNameMapStr)) {
            this.allOrgNameMap = (Map)SerializationUtils.fromJsonString((String)allOrgNameMapStr, Map.class);
        } else {
            this.allOrgNameMap = OrgHelper.getAllOrgNameMap();
            this.getPageCache().putBigObject("allOrgNameMap", SerializationUtils.toJsonString(this.allOrgNameMap));
        }
        String orgPatternTypeMapStr = this.getPageCache().getBigObject("orgPatternTypeMap");
        if (StringUtils.isNotEmpty((String)orgPatternTypeMapStr)) {
            this.orgPatternTypeMap = (Map)SerializationUtils.fromJsonString((String)orgPatternTypeMapStr, Map.class);
        } else {
            this.orgPatternTypeMap = OrgHelper.getOrgPatternTypeMap();
            this.getPageCache().putBigObject("orgPatternTypeMap", SerializationUtils.toJsonString(this.orgPatternTypeMap));
        }
    }

    private Set<Long> filterHROrgIds(Long adminGroupId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_admingroupfile");
        DynamicObject[] orgDyns = helper.queryOriginalArray("org", new QFilter[]{new QFilter(FIELD_ADMIN_GROUP, "=", (Object)adminGroupId)});
        return Arrays.stream(orgDyns).map(el -> el.getLong("org")).collect(Collectors.toSet());
    }

    private String splitId(Set<Long> idSet) {
        ArrayList arrayList = Lists.newArrayList(idSet);
        StringBuilder sql = new StringBuilder("(");
        int size = arrayList.size();
        for (int idx = 0; idx < size; ++idx) {
            sql.append(arrayList.get(idx));
            if (idx >= size - 1) continue;
            sql.append(',');
        }
        return sql + ")";
    }

    private void initUnitTreeSuper(String viewType) {
        String currentOrgDataCacheKey = "11".equals(viewType) ? "0_current_BizDatas" : "0_current_AdminOrgDatas";
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(Long.parseLong(viewType));
        param.setIncludeDisable(false);
        param.setIncludeFreeze(false);
        TreeNode firstOrgNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (firstOrgNode == null) {
            if ("11".equals(viewType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u5143\u89c6\u56fe\u662f\u5426\u6b63\u786e\u3002", (String)"AdminGroupPermEdit_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6839\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u4fee\u590d\u6570\u636e\u3002", (String)"AdminGroupPermEdit_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        List<String> orgData = this.queryOrgLongNumberByAdminGroupId(0L, viewType, true);
        this.getPageCache().put(viewType + "_super", "true");
        this.getPageCache().put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        this.loadUnitTree(viewType, orgData);
    }

    private TreeNode buildOrgTreeForSearch(String rootCache, TreeView tv, String rootNodeName, List<String> orgData, boolean isBizTree) {
        TreeNode root = new TreeNode("", "-1", rootNodeName, false);
        root.setIsOpened(true);
        tv.addNode(root);
        if (!CollectionUtils.isEmpty(orgData)) {
            root.setChildren(new ArrayList(10));
            HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(orgData.size());
            for (String data : orgData) {
                String[] infos = data.split("_split_");
                String id = infos[0];
                String orgName = infos[1];
                String longNumber = infos[2];
                String parentLongNumber = infos[2];
                TreeNode node = new TreeNode("-1", id, orgName);
                node.setIsOpened(true);
                if (isBizTree && Boolean.parseBoolean(infos[3])) {
                    node.setIcon("kdfont kdfont-faren");
                }
                if (!longNumber.contains(" ")) {
                    root.addChild(node);
                } else {
                    TreeNode parentNode;
                    while ((parentNode = (TreeNode)nodeMap.get(parentLongNumber = parentLongNumber.substring(0, parentLongNumber.lastIndexOf(32)))) == null && parentLongNumber.contains(" ")) {
                    }
                    if (parentNode != null) {
                        node.setParentid(parentNode.getId());
                        parentNode.addChild(node);
                    } else {
                        root.addChild(node);
                    }
                }
                nodeMap.put(longNumber, node);
            }
        }
        this.getPageCache().put(rootCache, SerializationUtils.toJsonString((Object)root));
        return root;
    }

    private TreeNode getAppTreeRootNodeForSearch(TreeView tv, Set<String> selectData, String rootNodeText) {
        TreeNode rootNode = new TreeNode("", "-1", rootNodeText, true);
        rootNode.setIsOpened(true);
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
        if (!CollectionUtils.isEmpty(selectData)) {
            for (String data : selectData) {
                String[] dataInfo = data.split("\\|");
                String cloudId = dataInfo[0];
                String appId = dataInfo[1];
                TreeNode treeNode = (TreeNode)cloudNodes.get(cloudId);
                if (treeNode == null) {
                    treeNode = new TreeNode("-1", "cloud#" + cloudId, this.appNodeNameMap.get(cloudId), true);
                    treeNode.setIsOpened(true);
                    cloudNodes.put(cloudId, treeNode);
                    rootNode.addChild(treeNode);
                }
                TreeNode children = new TreeNode(treeNode.getId(), "app#" + appId + "|" + cloudId, this.appNodeNameMap.get(appId), false);
                treeNode.addChild(children);
            }
        }
        tv.addNode(rootNode);
        return rootNode;
    }

    private void orgDataSort(List<String> orgData) {
        orgData.sort(new Comparator<String>(){

            @Override
            public int compare(String org1, String org2) {
                String[] orgFromArr = org1.split("_split_");
                String[] orgToArr = org2.split("_split_");
                if (orgFromArr.length < 5 || orgToArr.length < 5) {
                    return 0;
                }
                String longNumber1 = orgFromArr[2];
                String longNumber2 = orgToArr[2];
                return longNumber1.compareTo(longNumber2);
            }
        });
    }

    public void rebuildSysRightTree(boolean isAdd, Set<String> perms, IFormView formView) {
        IPageCache pageCache = formView.getPageCache();
        String adminGroupPermStr = pageCache.get("Current_SysData");
        Set<String> adminGroupPerm = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)adminGroupPermStr)) {
            adminGroupPerm = (Set)SerializationUtils.fromJsonString((String)adminGroupPermStr, Set.class);
        }
        if (isAdd) {
            adminGroupPerm.addAll(perms);
        } else {
            adminGroupPerm.removeAll(perms);
        }
        pageCache.put("Current_SysData", SerializationUtils.toJsonString(adminGroupPerm));
        TreeView tv = (TreeView)formView.getControl("selectedsystree");
        tv.deleteAllNodes();
        if (adminGroupPerm.size() == 0) {
            long level = formView.getModel().getDataEntity().getLong("level");
            TreeNode commonRightRootNode = this.getCommonRightRootNode(level);
            tv.addNode(commonRightRootNode);
        } else {
            this.getSelectPermRootNode(tv, adminGroupPerm, this.getSelectSysRootNodeText(), false);
        }
    }

    private TreeNode getCommonRightRootNode(long level) {
        return new TreeNode("", "-1", level > 2L ? this.getSelectCommonRootNodeText() : this.getCommonRootText(), false);
    }

    private TreeNode getVirtualRightRootNode() {
        return new TreeNode("", "-1", this.getVirtualRightRootText(), false);
    }

    public void loadAppTab(Long adminGroupParentId, Long adminGroupId, Long level) {
        String treeLoaded = this.getPageCache().get("tree_app_loaded");
        if (StringUtils.isNotEmpty((String)treeLoaded)) {
            return;
        }
        this.initAppTree(adminGroupParentId, level, null);
        this.buildSelectedAppTree(adminGroupId, level);
        this.getPageCache().put("tree_app_loaded", "true");
    }

    public void initSysRightTree(Long adminGroupId, Long level) {
        TreeNode rootNode;
        TreeView sysTvRight = this.getControl("selectedsystree");
        sysTvRight.deleteAllNodes();
        IPageCache pageCache = this.getPageCache();
        String rootNodeStr = pageCache.get("sysTreeRightRoot");
        if (StringUtils.isNotEmpty((String)rootNodeStr)) {
            TreeNode rootNode2 = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            sysTvRight.addNode(rootNode2);
            return;
        }
        if (level <= 1L) {
            rootNode = this.getVirtualRightRootNode();
        } else {
            HashMap<String, String> dataSource = new HashMap<String, String>(100);
            String entityNum = "";
            String lastAppEnt = "";
            String lastEntityNum = "";
            ArrayList<String> entityPermItems = new ArrayList<String>(10);
            HashSet<String> groupPerm = new HashSet<String>(16);
            HRBaseServiceHelper adminGroupPerm = null;
            adminGroupPerm = BusinessDataServiceHelper.load((String)"perm_admingroupfunperm", (String)"app, entitynum, permitem", (QFilter[])new QFilter[]{new QFilter(KEY_USERGROUP, "=", (Object)adminGroupId)}, (String)"app, entitynum");
            if (((DynamicObject[])adminGroupPerm).length > 0) {
                if (CollectionUtils.isEmpty(this.allEntityFuncPerms)) {
                    HRBaseServiceHelper functionPermHelper = new HRBaseServiceHelper("perm_functionperm");
                    DynamicObjectCollection funcPermDynaColl = functionPermHelper.queryOriginalCollection("entitytype.id,permitem.id", null);
                    this.allEntityFuncPerms = funcPermDynaColl.stream().map(dyna -> dyna.getString("entitytype.id") + "_" + dyna.getString("permitem.id")).collect(Collectors.toSet());
                }
                for (HRBaseServiceHelper perm : adminGroupPerm) {
                    String appId = perm.getString("app.id");
                    entityNum = perm.getString("entitynum.number");
                    String permitemId = perm.getString("permitem.id");
                    if (!this.cloudSet.contains(this.getCloudId(appId))) continue;
                    if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                        if (!CollectionUtils.isEmpty(entityPermItems)) {
                            AdminGroupSysSearchBean bean = new AdminGroupSysSearchBean(lastAppEnt, this.sysNodeNameMap.get(lastEntityNum), entityPermItems);
                            dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)bean));
                            entityPermItems.clear();
                        }
                        lastAppEnt = appId + "|" + entityNum;
                        lastEntityNum = entityNum;
                    }
                    entityPermItems.add(permitemId);
                    String permKey = appId + "|" + entityNum + "|" + permitemId;
                    groupPerm.add(permKey);
                }
                if (!CollectionUtils.isEmpty(entityPermItems)) {
                    AdminGroupSysSearchBean bean = new AdminGroupSysSearchBean(lastAppEnt, this.sysNodeNameMap.get(entityNum), entityPermItems);
                    dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)bean));
                }
                rootNode = this.getSelectPermRootNode(sysTvRight, groupPerm, this.getSelectSysRootNodeText(), false);
            } else {
                rootNode = this.getCommonRightRootNode(level);
            }
            this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString(dataSource));
            this.getPageCache().put("Current_SysData", SerializationUtils.toJsonString(groupPerm));
            this.getPageCache().put("Origin_SysData", SerializationUtils.toJsonString(groupPerm));
        }
        rootNode.setIsOpened(true);
        sysTvRight.addNode(rootNode);
        this.getView().getPageCache().put("sysTreeRightRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    public void initSysLeftTree(Long adminGroupId, long level, IFormView formView) {
        TreeView tv = (TreeView)formView.getControl("systree");
        tv.deleteAllNodes();
        IPageCache pageCache = formView.getPageCache();
        String rootNodeStr = pageCache.get("sysTreeLeftRoot");
        if (StringUtils.isNotEmpty((String)rootNodeStr)) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            tv.addNode(rootNode);
            return;
        }
        String langStr = RequestContext.get().getLang().name();
        DynamicObject adminGroup = (DynamicObject)formView.getModel().getValue(FIELD_PARENT_GROUP_ID);
        long adminScheme = 0L;
        long adminType = 0L;
        if (Objects.isNull(adminGroup)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_adminscheme");
            DynamicObject[] dys = helper.queryOriginalArray("entryentity.admintype, id", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            DynamicObject dy = dys[0];
            if (Objects.nonNull(dy)) {
                adminScheme = dy.getLong("id");
                adminType = dy.getLong("entryentity.admintype");
            }
        } else {
            adminScheme = adminGroup.getLong("adminscheme.id");
            adminType = adminGroup.getLong("admintype.id");
        }
        if (level <= 2L && !this.isBatchAuth) {
            this.initSysLeftTreeSuper(tv, adminScheme, adminType, langStr, pageCache);
        } else {
            this.initSysLeftTreeNormal(tv, adminGroupId, pageCache);
        }
    }

    private void initSysLeftTreeNormal(TreeView tv, long adminGroup, IPageCache pageCache) {
        AdminGroupSysSearchBean adminGroupSysSearchBean;
        HRBaseServiceHelper adminGroupPerm = null;
        adminGroupPerm = BusinessDataServiceHelper.load((String)"perm_admingroupfunperm", (String)"app, entitynum, permitem", (QFilter[])new QFilter[]{new QFilter(KEY_USERGROUP, "=", (Object)adminGroup)}, (String)"app, entitynum");
        HashMap<String, String> dataSource = new HashMap<String, String>(((DynamicObject[])adminGroupPerm).length);
        String entityName = "";
        String lastAppEnt = "";
        String lastEntityName = "";
        ArrayList<String> entityPermItems = new ArrayList<String>(10);
        HashSet<String> groupPerm = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(this.allEntityFuncPerms)) {
            HRBaseServiceHelper functionPermHelper = new HRBaseServiceHelper("perm_functionperm");
            DynamicObjectCollection funcPermDynaColl = functionPermHelper.queryOriginalCollection("entitytype.id,permitem.id", null);
            this.allEntityFuncPerms = funcPermDynaColl.stream().map(dyna -> dyna.getString("entitytype.id") + "_" + dyna.getString("permitem.id")).collect(Collectors.toSet());
        }
        for (HRBaseServiceHelper perm : adminGroupPerm) {
            String entityNum;
            String appId = perm.getString("app.id");
            if (!this.cloudSet.contains(this.getCloudId(appId))) continue;
            String appName = this.appIdNameMap.get(appId);
            if (StringUtils.isEmpty((String)appName)) {
                appName = perm.getString("app.name");
            }
            if (StringUtils.isEmpty((String)(entityName = this.entityNumNameMap.get(entityNum = perm.getString("entitynum.number"))))) {
                entityName = StringUtils.isEmpty((String)perm.getString("entitynum.name")) ? entityNum : perm.getString("entitynum.name");
            }
            String permitemId = perm.getString("permitem.id");
            String permitemName = perm.getString("permitem.name");
            if (HRStringUtils.isNotEmpty((String)appId)) {
                this.sysNodeNameMap.putIfAbsent(appId, appName);
            }
            if (HRStringUtils.isNotEmpty((String)entityNum)) {
                this.sysNodeNameMap.putIfAbsent(entityNum, entityName);
            }
            if (HRStringUtils.isNotEmpty((String)permitemId)) {
                this.sysNodeNameMap.putIfAbsent(permitemId, permitemName);
            }
            if (!this.allEntityFuncPerms.contains(entityNum + "_" + permitemId)) continue;
            if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                if (!CollectionUtils.isEmpty(entityPermItems)) {
                    adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, lastEntityName, entityPermItems);
                    dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
                    entityPermItems.clear();
                }
                lastAppEnt = appId + "|" + entityNum;
                lastEntityName = entityName;
            }
            entityPermItems.add(permitemId);
            String permKey = appId + "|" + entityNum + "|" + permitemId;
            groupPerm.add(permKey);
        }
        if (!CollectionUtils.isEmpty(entityPermItems)) {
            adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, entityName, entityPermItems);
            dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
        }
        LOGGER.info("AdminGroupPermEdit.initSysLeftTreeNormal sysLeftSource:{}", (Object)((Object)dataSource).toString());
        LOGGER.info("AdminGroupPermEdit.initSysLeftTreeNormal sysNodeNameMap:{}", (Object)this.sysNodeNameMap.toString());
        pageCache.put("sysLeftSource", SerializationUtils.toJsonString(dataSource));
        pageCache.put("sysNodeNameMap", SerializationUtils.toJsonString(this.sysNodeNameMap));
        TreeNode rootNode = this.getSelectPermRootNode(tv, groupPerm, this.getSysRootNodeText(), false);
        pageCache.put("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSysLeftTreeSuper(TreeView tv, long adminScheme, long adminType, String langStr, IPageCache pageCache) {
        String selectEntryIdSql = " SELECT fentryid From t_perm_adminschemeentry where fid = ? AND fadmintype = ? ";
        Long entryId = (Long)DB.query((DBRoute)DBRoute.permission, (String)selectEntryIdSql, (Object[])new Object[]{adminScheme, adminType}, rs -> {
            Long entryId1 = null;
            while (rs.next() && (entryId1 = Long.valueOf(rs.getLong("fentryid"))) == null) {
            }
            return entryId1;
        });
        TreeNode rootNode = new TreeNode("", "-1", this.getSysRootNodeText(), true);
        rootNode.setIsOpened(true);
        tv.addNode(rootNode);
        TreeNode cloudNode = new TreeNode("-1", "cloud#83bfebc800000bac", this.getSysCloudName(), true);
        cloudNode.setIsOpened(true);
        HashMap<String, String> dataSource = new HashMap<String, String>(16);
        DataSet hasPermEntityDS = null;
        DataSet appDS = null;
        DataSet hasPermEntityAppDS = null;
        DataSet entityDS = null;
        DataSet hasPermEntityEntityDS = null;
        DataSet funcPermDS = null;
        DataSet finalDS = null;
        try {
            AdminGroupSysSearchBean adminGroupSysSearchBean;
            String selectHasPermEntitySql = " SELECT distinct fbizappid app_id, fentitynum entity_num FROM t_perm_adminschemedetail WHERE fentryid = ? ";
            hasPermEntityDS = DB.queryDataSet((String)"hasPermEntityDS", (DBRoute)DBRoute.permission, (String)selectHasPermEntitySql, (Object[])new Object[]{entryId});
            String selectAppSql = " SELECT app.fid app_id, app.fnumber app_num, l.fname app_name, al.fname app_runtimename FROM t_meta_bizapp app  LEFT JOIN t_meta_bizapp_l l ON (app.fid = l.fid and l.flocaleid = '" + langStr + "')  LEFT JOIN t_meta_appruntime_l al ON (app.fnumber = al.fappid and al.flocaleid = '" + langStr + "')  WHERE app.fdeploystatus = '2' ";
            appDS = DB.queryDataSet((String)"appDS", (DBRoute)DBRoute.meta, (String)selectAppSql);
            String selectEntitySql = " SELECT e.fid entity_id, e.fnumber entity_num, el.fname entity_name FROM t_meta_entitydesign e LEFT JOIN t_meta_entitydesign_l el ON (e.fid = el.fid and el.flocaleid = '" + langStr + "') ";
            entityDS = DB.queryDataSet((String)"entityDS", (DBRoute)DBRoute.meta, (String)selectEntitySql);
            hasPermEntityAppDS = hasPermEntityDS.join(appDS).on("app_id", "app_id").select(new String[]{"app_id", "entity_num"}, new String[]{"app_num", "app_name", "app_runtimename"}).finish();
            hasPermEntityEntityDS = hasPermEntityAppDS.join(entityDS).on("entity_num", "entity_num").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_num"}, new String[]{"entity_id", "entity_name"}).finish();
            funcPermDS = DB.queryDataSet((String)"funcPermDS", (DBRoute)DBRoute.permission, (String)"select distinct funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm  INNER JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID ");
            hasPermEntityEntityDS = hasPermEntityEntityDS.join(funcPermDS).on("entity_id", "funcperm_entid").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_id", "entity_num", "entity_name"}).finish();
            String selectFuncPermSql = "SELECT DISTINCT funcperm.fdentitytypeid funcperm_entid, funcperm.fid funcperm_id,  permiteml.fid permiteml_id, permiteml.fname permiteml_name, permitem.fnumber permitem_num FROM t_perm_functionperm funcperm  INNER JOIN t_perm_permitem permitem ON permitem.fid = funcperm.fpermitemid  INNER JOIN t_perm_permitem_l permiteml ON (permiteml.fid = permitem.fid AND permiteml.flocaleid = '" + langStr + "') ";
            funcPermDS = DB.queryDataSet((String)"funcPermDS", (DBRoute)DBRoute.permission, (String)selectFuncPermSql);
            finalDS = hasPermEntityEntityDS.leftJoin(funcPermDS).on("entity_id", "funcperm_entid").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_id", "entity_num", "entity_name"}, new String[]{"permiteml_id", "permiteml_name"}).finish().orderBy(new String[]{"app_id", "entity_id"});
            String entityName = "";
            String lastAppEnt = "";
            String lastEntityName = "";
            ArrayList<String> entityPermItems = new ArrayList<String>(10);
            HashSet<String> cloudIds = new HashSet<String>(16);
            HashSet<String> appIds = new HashSet<String>(16);
            HashSet<String> entityIds = new HashSet<String>(16);
            String cloudId = null;
            while (finalDS.hasNext()) {
                TreeNode entityNode;
                TreeNode appNode;
                String cloudInfoStr;
                Row row = finalDS.next();
                String appId = row.getString("app_id");
                String appNum = row.getString("app_num");
                String appName = row.getString("app_runtimename");
                if (StringUtils.isEmpty((String)appName)) {
                    appName = row.getString("app_name");
                }
                String entityId = row.getString("entity_id");
                String entityNum = row.getString("entity_num");
                entityName = StringUtils.isEmpty((String)row.getString("entity_name")) ? entityNum : row.getString("entity_name");
                String permitemId = row.getString("permiteml_id");
                String permitemName = row.getString("permiteml_name");
                if (!this.cloudSet.contains(this.getCloudId(appId)) || HRStringUtils.isEmpty((String)appName) || HRStringUtils.isEmpty((String)entityNum) || HRStringUtils.isEmpty((String)entityName)) continue;
                if (HRStringUtils.isNotEmpty((String)appId)) {
                    this.sysNodeNameMap.putIfAbsent(appId, appName);
                }
                if (HRStringUtils.isNotEmpty((String)entityNum)) {
                    this.sysNodeNameMap.putIfAbsent(entityNum, entityName);
                }
                if (HRStringUtils.isNotEmpty((String)permitemId)) {
                    this.sysNodeNameMap.putIfAbsent(permitemId, permitemName);
                }
                if (HRStringUtils.isNotEmpty((String)(cloudInfoStr = this.appCloudInfoMap.get(appId)))) {
                    String[] cloudInfo = cloudInfoStr.split("\\|");
                    cloudId = cloudInfo[0];
                    if (cloudIds.contains(cloudId)) {
                        cloudNode = rootNode.getTreeNode("cloud#" + cloudId, 100);
                    } else {
                        cloudIds.add(cloudId);
                        String cloudNumber = cloudInfo[1];
                        String cloudName = cloudInfo[2];
                        cloudNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                        cloudNode.setIsOpened(true);
                        rootNode.addChild(cloudNode);
                    }
                }
                if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                    if (!CollectionUtils.isEmpty(entityPermItems)) {
                        adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, lastEntityName, entityPermItems);
                        dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
                        entityPermItems.clear();
                    }
                    lastAppEnt = appId + "|" + entityNum;
                    lastEntityName = entityName;
                }
                entityPermItems.add(permitemId);
                if (appIds.contains(appId)) {
                    appNode = cloudNode.getTreeNode("app#" + appId, 100);
                } else {
                    appIds.add(appId);
                    appNode = new TreeNode("cloud#83bfebc800000bac", "app#" + appId, appName, true);
                    cloudNode.addChild(appNode);
                }
                if (entityIds.contains(entityId + "@" + appId)) {
                    entityNode = appNode.getTreeNode("entity#" + entityNum + "@" + appId, 100);
                } else {
                    entityIds.add(entityId + "@" + appId);
                    entityNode = new TreeNode("app#" + appId, "entity#" + entityNum + "@" + appId, entityName, true);
                    appNode.addChild(entityNode);
                }
                TreeNode permItemNode = new TreeNode("entity#" + entityNum + "@" + appId, "permitem#" + permitemId + "@" + entityNum + "|" + appId, permitemName);
                entityNode.addChild(permItemNode);
            }
            if (!CollectionUtils.isEmpty(entityPermItems)) {
                adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, entityName, entityPermItems);
                dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
            }
            LOGGER.info("sysNodeNameMap:{}", (Object)this.sysNodeNameMap.toString());
            pageCache.put("sysLeftSource", SerializationUtils.toJsonString(dataSource));
            pageCache.put("sysNodeNameMap", SerializationUtils.toJsonString(this.sysNodeNameMap));
            pageCache.put("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{hasPermEntityDS, appDS, hasPermEntityAppDS, entityDS, hasPermEntityEntityDS, funcPermDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{hasPermEntityDS, appDS, hasPermEntityAppDS, entityDS, hasPermEntityEntityDS, funcPermDS, finalDS});
        this.initHRCloud(rootNode, dataSource, pageCache);
    }

    private void initHRCloud(TreeNode rootNode, Map<String, String> dataSource, IPageCache pageCache) {
        AdminGroupSysSearchBean adminGroupSysSearchBean;
        TreeNode cloudNode = new TreeNode("-1", "cloud#0PEIU203SX4Y", this.getHRCloudText(), true);
        cloudNode.setIsOpened(true);
        rootNode.addChild(cloudNode);
        ArrayList entityNums = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList apps = Lists.newArrayListWithExpectedSize((int)10);
        HashMap appEntity = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entityPerm = Maps.newHashMapWithExpectedSize((int)16);
        HashMap appEntityPerm = Maps.newHashMapWithExpectedSize((int)16);
        EntityCtrlServiceHelper.queryEntityForBidInfo(entityNums, apps, appEntity, entityPerm, appEntityPerm);
        String entityName = "";
        String lastAppEnt = "";
        String lastEntityName = "";
        ArrayList<String> entityPermItems = new ArrayList<String>(10);
        HashSet hrEntityPermSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet<String> appIds = new HashSet<String>(16);
        HashSet<String> entityIds = new HashSet<String>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_admindomain");
        QFilter forbidFilter = new QFilter("entryentity.app", "not in", (Object)apps).and("entryentity.entity", "not in", (Object)entityNums);
        DynamicObject[] data = helper.queryOriginalArray("entryentity.app,entryentity.app.name,entryentity.entity,entryentity.entity.name,entryentity.entity.number,entryentity.permitem,entryentity.permitem.number, entryentity.permitem.name", new QFilter[]{new QFilter("number", "=", (Object)"hr"), forbidFilter}, "entryentity.app asc,entryentity.entity.number asc");
        if (CollectionUtils.isEmpty(this.allEntityFuncPerms)) {
            Set domainFuncPermAppIds = Arrays.stream(data).map(dyna -> dyna.getString("entryentity.app")).collect(Collectors.toSet());
            HRBaseServiceHelper functionPermHelper = new HRBaseServiceHelper("perm_functionperm");
            DynamicObjectCollection funcPermDynaColl = functionPermHelper.queryOriginalCollection("entitytype.id,permitem.id", new QFilter[]{new QFilter("entitytype.bizappid.id", "in", domainFuncPermAppIds)});
            this.allEntityFuncPerms = funcPermDynaColl.stream().map(dyna -> dyna.getString("entitytype.id") + "_" + dyna.getString("permitem.id")).collect(Collectors.toSet());
        }
        for (DynamicObject obj : data) {
            TreeNode entityNode;
            TreeNode appNode;
            String appId = obj.getString("entryentity.app");
            String appName = obj.getString("entryentity.app.name");
            String entityId = obj.getString("entryentity.entity");
            String entityNum = obj.getString("entryentity.entity.number");
            entityName = obj.getString("entryentity.entity.name");
            String permitemId = obj.getString("entryentity.permitem");
            String permitemName = obj.getString("entryentity.permitem.name");
            if (HRStringUtils.isEmpty((String)entityNum) || HRStringUtils.isEmpty((String)entityName)) continue;
            String key = appId + "|" + entityId + "|" + permitemId;
            if (!hrEntityPermSet.add(key)) {
                LOGGER.info("initHRCloud the same permitem {}. ", (Object)key);
                continue;
            }
            if (appEntity.containsKey(appId) && ((List)appEntity.get(appId)).contains(entityNum) || entityPerm.containsKey(entityNum) && ((List)entityPerm.get(entityNum)).contains(permitemId) || appEntityPerm.containsKey(appId) && ((Map)appEntityPerm.get(appId)).containsKey(entityNum) && ((List)((Map)appEntityPerm.get(appId)).get(entityNum)).contains(permitemId)) continue;
            if (HRStringUtils.isNotEmpty((String)appId)) {
                this.sysNodeNameMap.putIfAbsent(appId, appName);
            }
            if (HRStringUtils.isNotEmpty((String)entityNum)) {
                this.sysNodeNameMap.putIfAbsent(entityNum, entityName);
            }
            if (HRStringUtils.isNotEmpty((String)permitemId)) {
                this.sysNodeNameMap.putIfAbsent(permitemId, permitemName);
            }
            if (!this.allEntityFuncPerms.contains(entityNum + "_" + permitemId)) continue;
            if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                if (!CollectionUtils.isEmpty(entityPermItems)) {
                    adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, lastEntityName, entityPermItems);
                    dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
                    entityPermItems.clear();
                }
                lastAppEnt = appId + "|" + entityNum;
                lastEntityName = entityName;
            }
            entityPermItems.add(permitemId);
            if (appIds.contains(appId)) {
                appNode = cloudNode.getTreeNode("app#" + appId, 100);
            } else {
                appIds.add(appId);
                appNode = new TreeNode("cloud#0PEIU203SX4Y", "app#" + appId, appName, true);
                cloudNode.addChild(appNode);
            }
            if (entityIds.contains(entityId + "@" + appId)) {
                entityNode = appNode.getTreeNode("entity#" + entityNum + "@" + appId, 100);
            } else {
                entityIds.add(entityId + "@" + appId);
                entityNode = new TreeNode("app#" + appId, "entity#" + entityNum + "@" + appId, entityName, true);
                appNode.addChild(entityNode);
            }
            TreeNode permItemNode = new TreeNode("entity#" + entityNum + "@" + appId, "permitem#" + permitemId + "@" + entityNum + "|" + appId, permitemName);
            entityNode.addChild(permItemNode);
        }
        if (!CollectionUtils.isEmpty(entityPermItems)) {
            adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, entityName, entityPermItems);
            dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
        }
        pageCache.put("sysLeftSource", SerializationUtils.toJsonString(dataSource));
        pageCache.put("sysNodeNameMap", SerializationUtils.toJsonString(this.sysNodeNameMap));
        pageCache.put("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    private TreeNode getSelectPermRootNode(TreeView tv, Set<String> adminGroupPerm, String rootName, boolean searchMode) {
        TreeNode rootNode = new TreeNode("", "-1", rootName, true);
        rootNode.setIsOpened(true);
        tv.addNode(rootNode);
        boolean isAddHR = false;
        TreeNode cloudNode = new TreeNode("-1", "cloud#83bfebc800000bac", this.getSysCloudName(), true);
        cloudNode.setIsOpened(true);
        TreeNode hrCloudNode = new TreeNode("-1", "cloud#0PEIU203SX4Y", this.getHRCloudText(), true);
        hrCloudNode.setIsOpened(true);
        HashSet<String> appIds = new HashSet<String>(16);
        HashSet<String> entityIds = new HashSet<String>(16);
        HashSet<String> cloudIds = new HashSet<String>(16);
        ArrayList<String> adminGroupPermList = new ArrayList<String>(adminGroupPerm);
        adminGroupPermList.sort(Comparator.naturalOrder());
        for (String perm : adminGroupPermList) {
            TreeNode entityNode;
            TreeNode appNode;
            String[] ids = perm.split("\\|");
            String appId = ids[0];
            String appName = this.sysNodeNameMap.get(appId);
            String entityId = ids[1];
            String entityName = this.sysNodeNameMap.get(entityId);
            String permitemId = ids[2];
            String permitemName = this.sysNodeNameMap.get(permitemId);
            if (!this.cloudSet.contains(this.getCloudId(appId))) continue;
            if (HRStringUtils.isEmpty((String)entityName)) {
                entityName = this.entityNumNameMap.get(entityId);
            }
            if (HRStringUtils.isEmpty((String)appName) || HRStringUtils.isEmpty((String)permitemName) || HRStringUtils.isEmpty((String)entityName)) continue;
            String cloudInfoStr = this.appCloudInfoMap.get(appId);
            if (HRStringUtils.isNotEmpty((String)cloudInfoStr)) {
                String[] cloudInfo = cloudInfoStr.split("\\|");
                String cloudId = cloudInfo[0];
                if (cloudIds.contains(cloudId) && !"0PEIU203SX4Y".equals(cloudId)) {
                    cloudNode = rootNode.getTreeNode("cloud#" + cloudId, 100);
                } else if (!"0PEIU203SX4Y".equals(cloudId)) {
                    cloudIds.add(cloudId);
                    String cloudName = cloudInfo[2];
                    cloudNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                    cloudNode.setIsOpened(true);
                    rootNode.addChild(cloudNode);
                }
            }
            if (appIds.contains(appId)) {
                if (this.HRapp.contains(appId)) {
                    isAddHR = true;
                }
                appNode = this.getCloudNode(appId, cloudNode, hrCloudNode).getTreeNode("app#" + appId, 100);
            } else {
                if (this.HRapp.contains(appId)) {
                    isAddHR = true;
                }
                appIds.add(appId);
                appNode = new TreeNode("cloud#" + this.getCloudNodeId(appId), "app#" + appId, appName, true);
                if (searchMode) {
                    appNode.setIsOpened(true);
                }
                this.getCloudNode(appId, cloudNode, hrCloudNode).addChild(appNode);
            }
            if (entityIds.contains(entityId + "@" + appId)) {
                entityNode = appNode.getTreeNode("entity#" + entityId + "@" + appId, 100);
            } else {
                entityIds.add(entityId + "@" + appId);
                entityNode = new TreeNode("app#" + appId, "entity#" + entityId + "@" + appId, entityName, true);
                appNode.addChild(entityNode);
            }
            TreeNode permItemNode = new TreeNode("entity#" + entityId + "@" + appId, "permitem#" + permitemId + "@" + entityId + "|" + appId, permitemName);
            entityNode.addChild(permItemNode);
        }
        if (isAddHR) {
            rootNode.addChild(hrCloudNode);
        }
        return rootNode;
    }

    private String queryOrgLongNumber(long orgId, long viewId) {
        String sql = "SELECT flongnumber FROM t_org_structure WHERE forgid = ? and fviewid = ? ";
        return (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{orgId, viewId}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String longNumber = "";
                if (rs.next()) {
                    longNumber = rs.getString(1);
                }
                if (StringUtils.isNotEmpty((String)longNumber)) {
                    longNumber = longNumber.replace('!', ' ');
                }
                return longNumber;
            }
        });
    }

    private TreeNode getCloudNode(String appId, TreeNode cloudNode, TreeNode hrCloudNode) {
        if (this.HRapp.contains(appId)) {
            return hrCloudNode;
        }
        return cloudNode;
    }

    private String getCloudNodeId(String appId) {
        if (this.HRapp.contains(appId)) {
            return "0PEIU203SX4Y";
        }
        return "83bfebc800000bac";
    }

    private String getCloudId(String appId) {
        String cloudInfoStr = this.appCloudInfoMap.get(appId);
        if (HRStringUtils.isNotEmpty((String)cloudInfoStr)) {
            String[] cloudInfo = cloudInfoStr.split("\\|");
            String cloudId = cloudInfo[0];
            return cloudId;
        }
        return "";
    }

    public static Set<String> getHRApp() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_admindomain");
        DynamicObject[] data = helper.queryOriginalArray("entryentity.app", new QFilter[]{new QFilter("number", "=", (Object)"hr")});
        return Arrays.stream(data).map(el -> el.getString("entryentity.app")).collect(Collectors.toSet());
    }

    private String getSysCloudName() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SYS")});
        return load[0].getString("name");
    }

    private String getSelectCommonRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"AdminGroupPermEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getSelectAppRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"AdminGroupPermEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getAppRootNodeText() {
        return ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AdminGroupPermEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getSelBizUnitRootText() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"AdminGroupPermEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getCommonRootText() {
        return ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u8303\u56f4\u4e0e\u5de6\u4fa7\u8303\u56f4\u76f8\u540c\u3002", (String)"AdminGroupPermEdit_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getVirtualRightRootText() {
        return ResManager.loadKDString((String)"\u9876\u7ea7\u7ba1\u7406\u5458\u8303\u56f4\u4e0e\u5de6\u4fa7\u4e00\u81f4\u3002", (String)"AdminGroupPermEdit_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getSelectSysRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"AdminGroupPermEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getSysRootNodeText() {
        return ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AdminGroupPermEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getBizUnitRootNodeText() {
        return ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AdminGroupPermEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getSearchTips() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5927\u4e8e1000\u6761\uff0c\u8bf7\u5b8c\u5584\u641c\u7d22\u5173\u952e\u5b57\u3002", (String)"AdminGroupPermEdit_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private String getHRCloudText() {
        return new HRBaseServiceHelper("bos_devportal_bizcloud").queryOriginalOne("name", new QFilter("id", "=", (Object)"0PEIU203SX4Y")).getString("name");
    }

    private IPageCache getPageCache() {
        return this.formPlugin.getPageCache();
    }

    private IDataModel getModel() {
        return this.formPlugin.getView().getModel();
    }

    private IFormView getView() {
        return this.formPlugin.getView();
    }

    private TreeView getControl(String treeViewKey) {
        return (TreeView)this.formPlugin.getControl(treeViewKey);
    }
}

