/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.hradmin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.role.HRRolePermHelper;

public class HRAdminGroupService {
    private static final String ROOT_NODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final Log logger = LogFactory.getLog(HRAdminGroupService.class);

    public static TreeNode initAdminGroupTree(TreeView tv, IPageCache pageCache) throws Exception {
        QFilter[] filters;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String adminSchemeStr = pageCache.get("adminScheme");
        Long adminScheme = null;
        if (StringUtils.isEmpty((String)adminSchemeStr)) {
            filters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
            DynamicObjectCollection adminSchemes = QueryServiceHelper.query((String)"perm_adminscheme", (String)"id", (QFilter[])filters);
            adminScheme = (Long)((DynamicObject)adminSchemes.get(0)).get("id");
        } else {
            adminScheme = Long.valueOf(adminSchemeStr);
        }
        QFilter filter = null;
        HashSet<String> superiorGroupLongNumberSet = new HashSet<String>(16);
        HashSet<String> currentUserInGroup = new HashSet<String>(16);
        filters = new QFilter[]{new QFilter("user.id", "=", (Object)userId).and("usergroup.adminscheme.id", "=", (Object)adminScheme).and("usergroup.isdomain", "=", (Object)"1").and("usergroup.domain", "=", (Object)1386267129346523136L).or("usergroup.id", "=", (Object)1393280986623636480L).and("user.id", "=", (Object)userId)};
        DynamicObject[] userAdminGroup = BusinessDataServiceHelper.load((String)"hrcs_useradmingroup", (String)"user,usergroup", (QFilter[])filters);
        Long adminType = null;
        try {
            adminType = (Long)userAdminGroup[0].getDynamicObject("usergroup").get("admintype.id");
        }
        catch (Exception e) {
            logger.error("[AdminGroupService]\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u6570\u636e\u5f02\u5e38\u6216\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u65b0\u5347\u7ea7\u7ba1\u7406\u5458\u6570\u636e\u3002", (String)"AdminGroupService_0", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        String longNumberFirst = (String)userAdminGroup[0].getDynamicObject("usergroup").get("longnumber");
        for (int i = 0; i < userAdminGroup.length; ++i) {
            DynamicObject value = userAdminGroup[i];
            String longNumber = (String)value.getDynamicObject("usergroup").get("longnumber");
            currentUserInGroup.add(longNumber);
            if (filter == null) {
                filter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
            } else {
                filter.or(new QFilter("longnumber", "like", (Object)(longNumber + "%")));
            }
            if (!StringUtils.isNotEmpty((String)longNumber)) continue;
            while (longNumber.lastIndexOf(46) > 0) {
                superiorGroupLongNumberSet.add(longNumber);
                longNumber = longNumber.substring(0, longNumber.lastIndexOf(46));
            }
            superiorGroupLongNumberSet.add(longNumber);
        }
        QFilter filter2 = new QFilter("longnumber", "in", superiorGroupLongNumberSet);
        filter2.or(filter);
        filters = new QFilter[]{filter2};
        DynamicObject[] adminGroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id, name, parent, longnumber, level", (QFilter[])filters, (String)"longnumber,level");
        ArrayList<Long> adminGroupCanSee = new ArrayList<Long>(10);
        tv.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(ROOT_NODE);
        root.setText(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4", (String)"AdminGroupService_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
        root.setIsOpened(true);
        root.setLongNumber("");
        tv.addNode(root);
        ArrayList<String[]> treeNodeInfos = new ArrayList<String[]>(30);
        ArrayList<Long> superiorGroupIds = new ArrayList<Long>(10);
        TreeNode focusNode = new TreeNode();
        ArrayList toCheckNodes = Lists.newArrayListWithExpectedSize((int)10);
        List toCheckNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        String toCheckNodeIdStr = pageCache.get("toCheckNodeIds");
        if (HRStringUtils.isNotEmpty((String)toCheckNodeIdStr)) {
            toCheckNodeIds = (List)SerializationUtils.fromJsonString((String)toCheckNodeIdStr, List.class);
        }
        for (DynamicObject adminGroup : adminGroups) {
            Long id = (Long)adminGroup.get("id");
            adminGroupCanSee.add(id);
            Long parent = (Long)adminGroup.get("parent.id");
            String longNumber = (String)adminGroup.get("longnumber");
            Integer level = (Integer)adminGroup.get("level");
            TreeNode node = new TreeNode();
            if (parent == null) {
                node.setParentid(ROOT_NODE);
            } else {
                node.setParentid(parent.toString() + "_" + (level - 1));
            }
            node.setId(id.toString() + "_" + level);
            ILocaleString nameLoc = (ILocaleString)adminGroup.get("name");
            String name = nameLoc.getLocaleValue();
            if (name == null) {
                name = (String)nameLoc.get((Object)"GLang");
            }
            node.setText(name);
            node.setIsOpened(true);
            node.setLongNumber(longNumber);
            tv.addNode(node);
            if (longNumberFirst.equalsIgnoreCase(longNumber)) {
                focusNode = node;
            }
            if (superiorGroupLongNumberSet.contains(longNumber) && currentUserInGroup.stream().noneMatch(x -> longNumber.startsWith((String)x) && !longNumber.equals(x))) {
                superiorGroupIds.add(id);
            }
            String[] treeNodeInfo = new String[]{node.getText(), node.getId(), node.getParentid()};
            treeNodeInfos.add(treeNodeInfo);
            if (!toCheckNodeIds.contains(id)) continue;
            toCheckNodes.add(node);
        }
        tv.checkNodes((List)toCheckNodes);
        tv.focusNode(focusNode);
        tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        pageCache.put("adminScheme", adminScheme.toString());
        if (adminType != null) {
            pageCache.put("adminType", adminType.toString());
        }
        pageCache.put("currentUserInGroup", SerializationUtils.toJsonString(currentUserInGroup));
        pageCache.put("superiorGroupIds", SerializationUtils.toJsonString(superiorGroupIds));
        pageCache.put("adminGroupCanSee", SerializationUtils.toJsonString(adminGroupCanSee));
        pageCache.put("treeNodeInfos", SerializationUtils.toJsonString(treeNodeInfos));
        pageCache.remove("searchResult");
        pageCache.remove("lastSearchText");
        pageCache.remove("searchIndex");
        return root;
    }

    public static TreeNode initAdminGroupTreeForScheme(TreeView tv, IPageCache pageCache) throws Exception {
        String justSub = pageCache.get("justSub");
        String adminGroupLongNumber = pageCache.get("adminGroupLongNumber");
        String adminGroupId = pageCache.get("adminGroupId");
        String curNodeIdStr = pageCache.get("curNodeId");
        QFilter filter = HRRolePermHelper.buildHRAdminGroupFilter();
        TreeNode root = new TreeNode();
        if (HRStringUtils.isNotEmpty((String)justSub) && HRStringUtils.isNotEmpty((String)adminGroupLongNumber)) {
            filter = filter.and(new QFilter("longnumber", "like", (Object)(adminGroupLongNumber + "%")));
            root.setId(adminGroupId);
            root.setText(pageCache.get("adminGroupName"));
            root.setExpend(true);
            root.setDisabled(true);
        } else {
            root.setId(ROOT_NODE);
            root.setText(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4", (String)"AdminGroupService_1", (String)"bos-mservice-permission", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] adminGroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id, name, parent, longnumber, level", (QFilter[])filters, (String)"longnumber,level");
        tv.deleteAllNodes();
        root.setParentid("");
        root.setIsOpened(true);
        root.setLongNumber("");
        tv.addNode(root);
        ArrayList<String[]> treeNodeInfos = new ArrayList<String[]>(30);
        HashMap parentNodeMap = Maps.newHashMapWithExpectedSize((int)adminGroups.length);
        HashMap childNodeMap = Maps.newHashMapWithExpectedSize((int)adminGroups.length);
        ArrayList toCheckNodes = Lists.newArrayListWithExpectedSize((int)10);
        List toCheckNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        String toCheckNodeIdStr = pageCache.get("toCheckNodeIds");
        if (HRStringUtils.isNotEmpty((String)toCheckNodeIdStr)) {
            toCheckNodeIds = (List)SerializationUtils.fromJsonString((String)toCheckNodeIdStr, List.class);
        }
        TreeNode focusNode = root;
        for (DynamicObject adminGroup : adminGroups) {
            Long id = (Long)adminGroup.get("id");
            Long parent = (Long)adminGroup.get("parent.id");
            String longNumber = (String)adminGroup.get("longnumber");
            Integer level = (Integer)adminGroup.get("level");
            TreeNode node = new TreeNode();
            String parentIdStr = parent.toString();
            if (HRStringUtils.equals((String)longNumber, (String)adminGroupLongNumber)) continue;
            if (parent == null || level == 2) {
                node.setParentid(ROOT_NODE);
            } else {
                node.setParentid(parentIdStr);
            }
            String idStr = id.toString();
            node.setId(idStr);
            ILocaleString nameLoc = (ILocaleString)adminGroup.get("name");
            String name = nameLoc.getLocaleValue();
            if (name == null) {
                name = (String)nameLoc.get((Object)"GLang");
            }
            node.setText(name);
            node.setIsOpened(true);
            node.setLongNumber(longNumber);
            tv.addNode(node);
            parentNodeMap.put(idStr, parent);
            List childIds = childNodeMap.computeIfAbsent(parent, key -> Lists.newArrayListWithExpectedSize((int)10));
            childIds.add(id);
            String[] treeNodeInfo = new String[]{node.getText(), node.getId(), node.getParentid()};
            treeNodeInfos.add(treeNodeInfo);
            if (toCheckNodeIds.contains(id)) {
                toCheckNodes.add(node);
            }
            if (!HRStringUtils.equals((String)idStr, (String)curNodeIdStr)) continue;
            focusNode = node;
        }
        tv.checkNodes((List)toCheckNodes);
        tv.focusNode(focusNode);
        tv.treeNodeClick(root.getParentid(), root.getId());
        tv.getView().updateView("treeview");
        HashMap childNodeMapCopy = Maps.newHashMapWithExpectedSize((int)adminGroups.length);
        for (Map.Entry entry : childNodeMap.entrySet()) {
            Long parentId = (Long)entry.getKey();
            List childIds = (List)entry.getValue();
            ArrayList childIdsCopy = new ArrayList(childIds);
            for (Long childId : childIds) {
                if (!childNodeMap.containsKey(childId)) continue;
                childIdsCopy.addAll((Collection)childNodeMap.get(childId));
            }
            childNodeMapCopy.put(parentId, childIdsCopy);
        }
        pageCache.put("treeNodeInfos", SerializationUtils.toJsonString(treeNodeInfos));
        pageCache.put("parentNodeMap", SerializationUtils.toJsonString((Object)parentNodeMap));
        pageCache.put("childNodeMap", SerializationUtils.toJsonString((Object)childNodeMapCopy));
        pageCache.remove("searchResult");
        pageCache.remove("lastSearchText");
        pageCache.remove("searchIndex");
        return root;
    }

    public static void sorted(List<DynamicObject> dynList, Map<Long, Boolean> typeMap) {
        dynList.sort((x1, x2) -> {
            String number = x1.getString("otclassify.teamtype.number");
            String number2 = x2.getString("otclassify.teamtype.number");
            long typeId = x1.getLong("otclassify.teamtype.id");
            long typeId2 = x2.getLong("otclassify.teamtype.id");
            boolean isSys = typeMap.getOrDefault(typeId, false);
            boolean isSys2 = typeMap.getOrDefault(typeId2, false);
            if (isSys && !isSys2) {
                return -1;
            }
            if (!isSys && isSys2) {
                return 1;
            }
            return number.compareTo(number2);
        });
        HashSet idSet = Sets.newHashSet((Object[])new Long[]{1010L, 1020L, 1030L});
        dynList.sort((x1, x2) -> {
            long typeId2;
            long sortId = x1.getLong("otclassify.id");
            long sortId2 = x2.getLong("otclassify.id");
            String number = x1.getString("otclassify.number");
            String number2 = x2.getString("otclassify.number");
            long typeId = x1.getLong("otclassify.teamtype.id");
            if (typeId == (typeId2 = x2.getLong("otclassify.teamtype.id"))) {
                if (!idSet.contains(sortId) && !idSet.contains(sortId2)) {
                    return number.compareTo(number2);
                }
                return Long.compare(sortId, sortId2);
            }
            return 0;
        });
        dynList.sort((x1, x2) -> {
            long sortId = x1.getLong("otclassify.id");
            long sortId2 = x2.getLong("otclassify.id");
            String number = x1.getString("number");
            String number2 = x2.getString("number");
            long typeId = x1.getLong("otclassify.teamtype.id");
            long typeId2 = x2.getLong("otclassify.teamtype.id");
            boolean isSys = x1.getBoolean("issyspreset");
            boolean isSys2 = x2.getBoolean("issyspreset");
            if (typeId == typeId2 && sortId == sortId2) {
                if (isSys && !isSys2) {
                    return -1;
                }
                if (!isSys && isSys2) {
                    return 1;
                }
                return number.compareTo(number2);
            }
            return 0;
        });
    }

    public static List<Long> queryCustomTeamTypes() {
        HRBaseServiceHelper teamTypeHelper = new HRBaseServiceHelper("hbss_teamtype");
        List customTeamTypes = teamTypeHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("iscustom", "=", (Object)"1")}).stream().map(it -> it.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper otClassHelper = new HRBaseServiceHelper("haos_otclassify");
        return otClassHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("teamtype.id", "in", customTeamTypes)}).stream().map(it -> it.getLong("id")).collect(Collectors.toList());
    }
}

