/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.ImportUserBdDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDataRuleModel;
import kd.hr.hrcs.common.model.perminit.ImportUserDimModel;
import kd.hr.hrcs.common.model.perminit.ImportUserFieldModel;
import kd.hr.hrcs.common.model.perminit.OrgRangeBean;
import kd.hr.hrcs.common.model.perminit.PermInitRecord;
import kd.hr.hrcs.common.model.perminit.PermInitTccParam;

public class PermInitConvertToHmpTccService
extends TCCAdapterService {
    private static final Log LOGGER = LogFactory.getLog(PermInitConvertToHmpTccService.class);
    private static final HRBaseServiceHelper PERM_INIT_RECORD_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");
    private static final HRBaseServiceHelper PERM_FILE_HELPER = new HRBaseServiceHelper("hrcs_userpermfile");
    private static final HRBaseServiceHelper USER_ROLE_RELAT_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper USER_ROLE_HELPER = new HRBaseServiceHelper("hrcs_userrole");
    private static final HRBaseServiceHelper USER_ROLE_DIMGRP_HELPER = new HRBaseServiceHelper("hrcs_userroledimgrp");
    private static final HRBaseServiceHelper USER_DATARULE_HELPER = new HRBaseServiceHelper("hrcs_userdatarule");
    private static final HRBaseServiceHelper USER_FIELD_HELPER = new HRBaseServiceHelper("hrcs_userfield");

    public void Try(Object param) throws Exception {
        PermInitTccParam tccParam = (PermInitTccParam)param;
        PermInitRecord initRecord = tccParam.getInitRecord();
        LOGGER.info("ConvertPermInitRecord to hmp Try start,recordId:{}", (Object)initRecord.getId());
        DynamicObject recordDyna = PERM_INIT_RECORD_HELPER.queryOriginalOne("dealstatus", new QFilter("id", "=", (Object)initRecord.getId()));
        if (HRStringUtils.equals((String)recordDyna.getString("dealstatus"), (String)"1")) {
            LOGGER.error("perminitrecord id:{},dealstatus is 1.return.", (Object)initRecord.getId());
            return;
        }
        Map<String, Long> userRoleRelatIdMap = this.buildUserRoleRelatIdMap(initRecord);
        DynamicObjectCollection userRoleRelatColl = this.buildUserRoleRelatDynaColl(initRecord, userRoleRelatIdMap);
        USER_ROLE_RELAT_HELPER.save(userRoleRelatColl);
        DynamicObjectCollection userRoleDynaColl = this.buildUserRoleDynaColl(initRecord, userRoleRelatIdMap);
        USER_ROLE_HELPER.save(userRoleDynaColl);
        DynamicObjectCollection userDimGroupDynaColl = this.buildUserDimGroupDynaColl(initRecord, userRoleRelatIdMap);
        USER_ROLE_DIMGRP_HELPER.save(userDimGroupDynaColl);
        Collection<DynamicObject> userDataRuleDynaColl = this.buildUserDataRuleDynaColl(initRecord, userRoleRelatIdMap);
        USER_DATARULE_HELPER.save(userDataRuleDynaColl.toArray(new DynamicObject[0]));
        Collection<DynamicObject> userFieldDynaColl = this.buildUserFieldDynaColl(initRecord, userRoleRelatIdMap);
        USER_FIELD_HELPER.save(userFieldDynaColl.toArray(new DynamicObject[0]));
        LOGGER.info("ConvertPermInitRecord to hmp Try end,recordId:{}", (Object)initRecord.getId());
    }

    public DtxResponse confirm(Object param, Object lastReturn) throws Exception {
        PermInitTccParam tccParam = (PermInitTccParam)param;
        PermInitRecord initRecord = tccParam.getInitRecord();
        LOGGER.info("ConvertPermInitRecord to hmp confirm start,recordId:{}", (Object)initRecord.getId());
        DynamicObject dynamicObject = PERM_INIT_RECORD_HELPER.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)initRecord.getId());
        dynamicObject.set("dealstatus", (Object)"1");
        SaveServiceHelper.update((DynamicObject)dynamicObject);
        HRPermCacheMgr.clearAllCache();
        LOGGER.info("ConvertPermInitRecord to hmp confirm end,recordId:{}", (Object)initRecord.getId());
        return null;
    }

    private void batchInsertLog(PermInitRecord initRecord) {
        try {
            LOGGER.info("ConvertPermInitRecord batchInsertLog,recordId:{}", (Object)initRecord.getId());
            HRBaseServiceHelper logview = new HRBaseServiceHelper("hbss_logview");
            DynamicObject dyn = logview.generateEmptyDynamicObject();
            dyn.set("user", (Object)RequestContext.get().getCurrUserId());
            dyn.set("bizapp", (Object)"15NPDX/GJFOO");
            dyn.set("bizobj", (Object)"hrcs_perminitrecord");
            dyn.set("optime", (Object)new Date());
            dyn.set("modifybillid", (Object)initRecord.getId());
            DynamicObject recordDyna = PERM_INIT_RECORD_HELPER.queryOriginalOne("number", new QFilter("id", "=", (Object)initRecord.getId()));
            String number = recordDyna.getString("number");
            dyn.set("modifybillno", (Object)number);
            HashMap entityModifyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            entityModifyInfoMap.put("k", initRecord.getId());
            entityModifyInfoMap.put("c", number);
            HashMap fieldModifyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            fieldModifyInfoMap.put("c", ResManager.loadKDString((String)"\u72b6\u6001", (String)"PermInitConvertToHmpTccService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            fieldModifyInfoMap.put("o", ResManager.loadKDString((String)"\u6682\u5b58", (String)"PermInitConvertToHmpTccService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            fieldModifyInfoMap.put("n", ResManager.loadKDString((String)"\u5b8c\u6210", (String)"PermInitConvertToHmpTccService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            entityModifyInfoMap.put("dealstatus", fieldModifyInfoMap);
            dyn.set("modifyContent", (Object)JSONObject.toJSONString((Object)entityModifyInfoMap));
            logview.saveOne(dyn);
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    public void cancel(Object param) throws Exception {
        PermInitTccParam tccParam = (PermInitTccParam)param;
        PermInitRecord initRecord = tccParam.getInitRecord();
        LOGGER.info("ConvertPermInitRecord to hmp cancel start,recordId:{}", (Object)initRecord.getId());
        Long recordId = initRecord.getId();
        DynamicObjectCollection relatColl = USER_ROLE_RELAT_HELPER.queryOriginalCollection("id", new QFilter[]{new QFilter("initrecord", "=", (Object)recordId)});
        List relatIds = relatColl.stream().map(dyna -> dyna.getLong("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"hrcs_userrole", (QFilter[])new QFilter[]{new QFilter("userrolerealt", "in", relatIds)});
        DeleteServiceHelper.delete((String)"hrcs_userroledimgrp", (QFilter[])new QFilter[]{new QFilter("userrolerelat", "in", relatIds)});
        DeleteServiceHelper.delete((String)"hrcs_userdatarule", (QFilter[])new QFilter[]{new QFilter("userrolerelate", "in", relatIds)});
        DeleteServiceHelper.delete((String)"hrcs_userfield", (QFilter[])new QFilter[]{new QFilter("userrolerealt", "in", relatIds)});
        DeleteServiceHelper.delete((String)"hrcs_userrolerelat", (QFilter[])new QFilter[]{new QFilter("initrecord", "=", (Object)recordId)});
        LOGGER.info("ConvertPermInitRecord to hmp cancel end,recordId:{}", (Object)initRecord.getId());
    }

    private Map<String, Long> buildUserRoleRelatIdMap(PermInitRecord initRecord) {
        List userDimModelList = initRecord.getUserDimModelList();
        HashMap userRoleRelatIdMap = Maps.newHashMapWithExpectedSize((int)userDimModelList.size());
        for (ImportUserDimModel userDimModel : userDimModelList) {
            String key = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId());
            userRoleRelatIdMap.put(key, 0L);
        }
        long[] relatIds = ORM.create().genLongIds("hrcs_userrolerelat", userRoleRelatIdMap.size());
        int userRoleRelatIdx = 0;
        for (Map.Entry entry : userRoleRelatIdMap.entrySet()) {
            userRoleRelatIdMap.put(entry.getKey(), relatIds[userRoleRelatIdx]);
            ++userRoleRelatIdx;
        }
        return userRoleRelatIdMap;
    }

    private DynamicObjectCollection buildUserRoleRelatDynaColl(PermInitRecord initRecord, Map<String, Long> userRoleRelatIdMap) {
        List userDimModelList = initRecord.getUserDimModelList();
        Set userIds = userDimModelList.stream().map(userDimModel -> userDimModel.getUserId()).collect(Collectors.toSet());
        DynamicObject[] permFileDynaArr = PERM_FILE_HELPER.queryOriginalArray("id,user.id,org.id,permfileenable", new QFilter[]{new QFilter("user.id", "in", userIds)});
        HashMap permFileIdMap = Maps.newHashMapWithExpectedSize((int)permFileDynaArr.length);
        for (DynamicObject permFileDyna : permFileDynaArr) {
            String key = PermInitServiceHelper.joinToKey(permFileDyna.getLong("user.id"), permFileDyna.getLong("org.id"));
            permFileIdMap.put(key, permFileDyna.getLong("id"));
        }
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        DynamicObjectCollection userRoleRelatColl = new DynamicObjectCollection();
        HashSet relatTrimRepeatSet = Sets.newHashSetWithExpectedSize((int)userDimModelList.size());
        for (ImportUserDimModel userDimModel2 : userDimModelList) {
            String trimRepeatKey = PermInitServiceHelper.joinToKey(userDimModel2.getUserId(), userDimModel2.getFileOrgId(), userDimModel2.getRoleId());
            if (relatTrimRepeatSet.contains(trimRepeatKey)) continue;
            relatTrimRepeatSet.add(trimRepeatKey);
            DynamicObject userRoleRelatDyna = USER_ROLE_RELAT_HELPER.generateEmptyDynamicObject();
            String permFileKey = PermInitServiceHelper.joinToKey(userDimModel2.getUserId(), userDimModel2.getFileOrgId());
            String relatIdKey = PermInitServiceHelper.joinToKey(permFileKey, userDimModel2.getRoleId());
            userRoleRelatDyna.set("id", (Object)userRoleRelatIdMap.get(relatIdKey));
            Long permFileId = (Long)permFileIdMap.get(permFileKey);
            if (permFileId == null) {
                throw new KDBizException("permFileKey[" + permFileKey + "] not exist perm file.");
            }
            userRoleRelatDyna.set("permfile", (Object)permFileId);
            userRoleRelatDyna.set("user", (Object)userDimModel2.getUserId());
            userRoleRelatDyna.set("role", (Object)userDimModel2.getRoleId());
            userRoleRelatDyna.set("customenable", (Object)userDimModel2.getCustomEnableStr());
            userRoleRelatDyna.set("sourcetype", (Object)"3");
            userRoleRelatDyna.set("initrecord", (Object)initRecord.getId());
            if (enableValidateTime) {
                userRoleRelatDyna.set("validstart", (Object)userDimModel2.getValidStart());
                userRoleRelatDyna.set("validend", (Object)userDimModel2.getValidEnd());
            }
            PermInitServiceHelper.setOperatorAndDate(userRoleRelatDyna);
            userRoleRelatColl.add((Object)userRoleRelatDyna);
        }
        return userRoleRelatColl;
    }

    private DynamicObjectCollection buildUserRoleDynaColl(PermInitRecord initRecord, Map<String, Long> userRoleRelatIdMap) {
        Map sysUserRoleIdMap = initRecord.getSysUserRoleIdMap();
        HashMap hmpUserRoleIdMap = Maps.newHashMapWithExpectedSize((int)sysUserRoleIdMap.size());
        long[] hmpUserRoleIds = ORM.create().genLongIds("hrcs_userrole", sysUserRoleIdMap.size());
        int sysUserRoleIdx = 0;
        for (Map.Entry entry : sysUserRoleIdMap.entrySet()) {
            hmpUserRoleIdMap.put(entry.getKey(), hmpUserRoleIds[sysUserRoleIdx]);
            ++sysUserRoleIdx;
        }
        DynamicObjectCollection userRoleDynaColl = new DynamicObjectCollection();
        List userDimModelList = initRecord.getUserDimModelList();
        HashSet trimRepeatSet = Sets.newHashSetWithExpectedSize((int)userDimModelList.size());
        Map roleOrgRangeMap = initRecord.getRoleOrgRangeMap();
        for (ImportUserDimModel userDimModel : userDimModelList) {
            String trimRepeatKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId(), userDimModel.getBucaFuncId());
            if (trimRepeatSet.contains(trimRepeatKey)) continue;
            trimRepeatSet.add(trimRepeatKey);
            if (userDimModel.getCustomEnable()) {
                for (Long orgId : userDimModel.getOrgRangeList()) {
                    DynamicObject userRoleDyna = this.genUserRoleDyna(userDimModel, userDimModel.getBucaFuncId(), orgId, initRecord.getIncludeSub(), userRoleRelatIdMap, hmpUserRoleIdMap, sysUserRoleIdMap);
                    userRoleDynaColl.add((Object)userRoleDyna);
                }
                continue;
            }
            List orgRangeBeans = (List)roleOrgRangeMap.get(userDimModel.getRoleId());
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                if (!Objects.equals(orgRangeBean.getBucaFuncId(), userDimModel.getBucaFuncId())) continue;
                DynamicObject userRoleDyna = this.genUserRoleDyna(userDimModel, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId(), orgRangeBean.getIncludeSub(), userRoleRelatIdMap, hmpUserRoleIdMap, sysUserRoleIdMap);
                userRoleDynaColl.add((Object)userRoleDyna);
            }
        }
        return userRoleDynaColl;
    }

    private DynamicObject genUserRoleDyna(ImportUserDimModel userDimModel, Long bucaFuncId, Long orgId, Boolean includeSub, Map<String, Long> userRoleRelatIdMap, Map<String, Long> hmpUserRoleIdMap, Map<String, String> sysUserRoleIdMap) {
        DynamicObject userRoleDyna = USER_ROLE_HELPER.generateEmptyDynamicObject();
        String idMapKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getRoleId(), bucaFuncId, orgId);
        userRoleDyna.set("id", (Object)hmpUserRoleIdMap.get(idMapKey));
        userRoleDyna.set("org", (Object)orgId);
        userRoleDyna.set("includesuborg", (Object)includeSub);
        String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId());
        Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
        userRoleDyna.set("userrolerealt", (Object)relatId);
        String sysUserRoleIdKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId(), bucaFuncId, orgId);
        String sysUserRoleId = sysUserRoleIdMap.get(sysUserRoleIdKey);
        userRoleDyna.set("userrolepf", (Object)sysUserRoleId);
        userRoleDyna.set("bucafunc", (Object)bucaFuncId);
        return userRoleDyna;
    }

    private void setDataRuleOperatorAndDate(DynamicObject dyna) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        dyna.set("createrfield", (Object)userId);
        dyna.set("createdatefield", (Object)now);
        dyna.set("modifierfield", (Object)userId);
        dyna.set("modifydatefield", (Object)now);
    }

    private DynamicObjectCollection buildUserDimGroupDynaColl(PermInitRecord initRecord, Map<String, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userDimGroupDynaColl = new DynamicObjectCollection();
        List userDimModelList = initRecord.getUserDimModelList();
        long[] userDimGroupIds = ORM.create().genLongIds("hrcs_userroledimgrp", userDimModelList.size());
        int userDimGroupIdx = 0;
        Map<Object, Object> orgStructsMap = Maps.newHashMapWithExpectedSize((int)16);
        Set<Object> orgTeamDimIds = Sets.newHashSetWithExpectedSize((int)16);
        if (initRecord.getIncludeSub()) {
            orgTeamDimIds = this.queryAllOrgTeamDim();
            orgStructsMap = this.collectOrgStructs(userDimModelList, (Set<Long>)orgTeamDimIds);
        }
        for (ImportUserDimModel userDimModel : userDimModelList) {
            if (!userDimModel.getCustomEnable()) continue;
            DynamicObject userDimGroupDyna = USER_ROLE_DIMGRP_HELPER.generateEmptyDynamicObject();
            userDimGroupDyna.set("id", (Object)userDimGroupIds[userDimGroupIdx]);
            ++userDimGroupIdx;
            String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId());
            Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
            userDimGroupDyna.set("userrolerelat", (Object)relatId);
            userDimGroupDyna.set("bucafunc", (Object)userDimModel.getBucaFuncId());
            PermInitServiceHelper.setOperatorAndDate(userDimGroupDyna);
            DynamicObjectCollection userDimValEntryColl = USER_ROLE_DIMGRP_HELPER.generateEmptyEntryCollection(userDimGroupDyna, "entry");
            for (DimValueBean dimValueBean : userDimModel.getDimValues()) {
                DynamicObject userDimValEntryDyna = USER_ROLE_DIMGRP_HELPER.generateEmptyEntryDynamicObject("entry");
                userDimValEntryDyna.set("dimension", (Object)dimValueBean.getDimId());
                userDimValEntryDyna.set("dimval", (Object)dimValueBean.getDimVal());
                userDimValEntryDyna.set("isall", (Object)dimValueBean.isAll());
                userDimValEntryDyna.set("containssub", (Object)initRecord.getIncludeSub());
                userDimValEntryDyna.set("otclassify", (Object)dimValueBean.getOtClassifyId());
                if (initRecord.getIncludeSub() && orgTeamDimIds.contains(dimValueBean.getDimId())) {
                    Long orgId = Long.parseLong(dimValueBean.getDimVal());
                    Set structIds = (Set)orgStructsMap.get(orgId);
                    if (structIds != null && !structIds.contains(dimValueBean.getStructProjectId())) {
                        LOGGER.info("PermInitConvertToHmpTccService.buildUserDimGroupDynaColl orgId:{},structId:{},org structIds:{},,admincontainssub set to true", new Object[]{orgId, dimValueBean.getStructProjectId(), structIds});
                        userDimValEntryDyna.set("admincontainssub", (Object)true);
                    } else {
                        LOGGER.info("PermInitConvertToHmpTccService.buildUserDimGroupDynaColl orgId:{},structId:{},org structIds:{},admincontainssub set to false", new Object[]{orgId, dimValueBean.getStructProjectId(), structIds});
                        userDimValEntryDyna.set("admincontainssub", (Object)false);
                    }
                } else {
                    userDimValEntryDyna.set("admincontainssub", (Object)false);
                }
                userDimValEntryDyna.set("structproject", (Object)dimValueBean.getStructProjectId());
                userDimValEntryColl.add((Object)userDimValEntryDyna);
            }
            userDimGroupDyna.set("entry", (Object)userDimValEntryColl);
            userDimGroupDynaColl.add((Object)userDimGroupDyna);
        }
        return userDimGroupDynaColl;
    }

    private Set<Long> queryAllOrgTeamDim() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObjectCollection dynaColl = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("datasource", "=", (Object)"orgteam")});
        Set<Long> orgTeamDimIds = dynaColl.stream().map(dyna -> dyna.getLong("id")).collect(Collectors.toSet());
        return orgTeamDimIds;
    }

    private Map<Long, Set<Long>> collectOrgStructs(List<ImportUserDimModel> userDimModelList, Set<Long> orgTeamDimIds) {
        HashSet dimOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        for (ImportUserDimModel userDimModel : userDimModelList) {
            for (DimValueBean dimValueBean : userDimModel.getDimValues()) {
                if (!orgTeamDimIds.contains(dimValueBean.getDimId())) continue;
                dimOrgIds.add(Long.parseLong(dimValueBean.getDimVal()));
            }
        }
        HashMap orgStructsMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObjectCollection orgStructDynaColl = helper.queryOriginalCollection("orgteam.id,structproject.id", new QFilter[]{new QFilter("orgteam.id", "in", (Object)dimOrgIds), new QFilter("iscurrentversion", "=", (Object)"1")});
        for (DynamicObject dyna : orgStructDynaColl) {
            Long orgId = dyna.getLong("orgteam.id");
            Set structIds = (Set)orgStructsMap.get(orgId);
            if (Objects.isNull(structIds)) {
                structIds = Sets.newHashSetWithExpectedSize((int)16);
                orgStructsMap.put(orgId, structIds);
            }
            structIds.add(dyna.getLong("structproject.id"));
        }
        return orgStructsMap;
    }

    private Collection<DynamicObject> buildUserDataRuleDynaColl(PermInitRecord initRecord, Map<String, Long> userRoleRelatIdMap) {
        Object relatId;
        String userRoleRelatIdKey;
        DynamicObject userDataRuleDyna;
        String dataRuleDynaKey;
        List userDataRuleModelList = initRecord.getUserDataRuleModelList();
        List userBdDataRuleModelList = initRecord.getUserBdDataRuleModelList();
        long[] userDataRuleIds = ORM.create().genLongIds("hrcs_userdatarule", userDataRuleModelList.size() + userBdDataRuleModelList.size());
        int userDataRuleIdx = 0;
        HashMap userDataRuleDynaMap = Maps.newHashMapWithExpectedSize((int)userDataRuleModelList.size());
        for (ImportUserDataRuleModel userDataRuleModel : userDataRuleModelList) {
            dataRuleDynaKey = PermInitServiceHelper.joinToKey(userDataRuleModel.getUserId(), userDataRuleModel.getFileOrgId(), userDataRuleModel.getRoleId(), userDataRuleModel.getAppId(), userDataRuleModel.getEntityNumber());
            userDataRuleDyna = (DynamicObject)userDataRuleDynaMap.get(dataRuleDynaKey);
            if (userDataRuleDyna == null) {
                userDataRuleDyna = USER_DATARULE_HELPER.generateEmptyDynamicObject();
                userDataRuleDyna.set("id", (Object)userDataRuleIds[userDataRuleIdx]);
                ++userDataRuleIdx;
                userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userDataRuleModel.getUserId(), userDataRuleModel.getFileOrgId(), userDataRuleModel.getRoleId());
                relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
                userDataRuleDyna.set("userrolerelate", relatId);
                userDataRuleDyna.set("app", (Object)userDataRuleModel.getAppId());
                userDataRuleDyna.set("entitytype", (Object)userDataRuleModel.getEntityNumber());
                this.setDataRuleOperatorAndDate(userDataRuleDyna);
                userDataRuleDynaMap.put(dataRuleDynaKey, userDataRuleDyna);
            }
            DynamicObjectCollection userDataRuleEntryColl = userDataRuleDyna.getDynamicObjectCollection("dataruleentry");
            for (String permItemId : userDataRuleModel.getPermItemList()) {
                DynamicObject userDataRuleEntryDyna = USER_DATARULE_HELPER.generateEmptyEntryDynamicObject("dataruleentry");
                userDataRuleEntryDyna.set("permitem", (Object)permItemId);
                userDataRuleEntryDyna.set("datarule", (Object)userDataRuleModel.getDataRuleId());
                userDataRuleEntryColl.add((Object)userDataRuleEntryDyna);
            }
            userDataRuleDyna.set("dataruleentry", (Object)userDataRuleEntryColl);
        }
        for (ImportUserBdDataRuleModel userBdDataRuleModel : userBdDataRuleModelList) {
            dataRuleDynaKey = PermInitServiceHelper.joinToKey(userBdDataRuleModel.getUserId(), userBdDataRuleModel.getFileOrgId(), userBdDataRuleModel.getRoleId(), userBdDataRuleModel.getAppId(), userBdDataRuleModel.getEntityNumber());
            userDataRuleDyna = (DynamicObject)userDataRuleDynaMap.get(dataRuleDynaKey);
            if (userDataRuleDyna == null) {
                userDataRuleDyna = USER_DATARULE_HELPER.generateEmptyDynamicObject();
                userDataRuleDyna.set("id", (Object)userDataRuleIds[userDataRuleIdx]);
                ++userDataRuleIdx;
                userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userBdDataRuleModel.getUserId(), userBdDataRuleModel.getFileOrgId(), userBdDataRuleModel.getRoleId());
                relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
                userDataRuleDyna.set("userrolerelate", relatId);
                userDataRuleDyna.set("app", (Object)userBdDataRuleModel.getAppId());
                userDataRuleDyna.set("entitytype", (Object)userBdDataRuleModel.getEntityNumber());
                this.setDataRuleOperatorAndDate(userDataRuleDyna);
                userDataRuleDynaMap.put(dataRuleDynaKey, userDataRuleDyna);
            }
            DynamicObjectCollection userBdDataRuleEntryColl = userDataRuleDyna.getDynamicObjectCollection("bddataruleentry");
            DynamicObject userBdDataRuleEntryDyna = USER_DATARULE_HELPER.generateEmptyEntryDynamicObject("bddataruleentry");
            userBdDataRuleEntryDyna.set("propkey", (Object)userBdDataRuleModel.getPropKey());
            userBdDataRuleEntryDyna.set("propentnum", (Object)userBdDataRuleModel.getPropEntNum());
            userBdDataRuleEntryDyna.set("bddatarule", (Object)userBdDataRuleModel.getDataRuleId());
            userBdDataRuleEntryColl.add((Object)userBdDataRuleEntryDyna);
            userDataRuleDyna.set("bddataruleentry", (Object)userBdDataRuleEntryColl);
        }
        return userDataRuleDynaMap.values();
    }

    private Collection<DynamicObject> buildUserFieldDynaColl(PermInitRecord initRecord, Map<String, Long> userRoleRelatIdMap) {
        List userFieldModelList = initRecord.getUserFieldModelList();
        long[] userFieldIds = ORM.create().genLongIds("hrcs_userfield", userFieldModelList.size());
        int userFieldIdx = 0;
        HashMap userFileDynaMap = Maps.newHashMapWithExpectedSize((int)userFieldModelList.size());
        for (ImportUserFieldModel userFieldModel : userFieldModelList) {
            String userFieldDynaKey = PermInitServiceHelper.joinToKey(userFieldModel.getUserId(), userFieldModel.getFileOrgId(), userFieldModel.getRoleId(), userFieldModel.getAppId(), userFieldModel.getEntityNumber());
            DynamicObject userFieldDyna = (DynamicObject)userFileDynaMap.get(userFieldDynaKey);
            if (userFieldDyna == null) {
                userFieldDyna = USER_FIELD_HELPER.generateEmptyDynamicObject();
                userFieldDyna.set("id", (Object)userFieldIds[userFieldIdx]);
                ++userFieldIdx;
                String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userFieldModel.getUserId(), userFieldModel.getFileOrgId(), userFieldModel.getRoleId());
                Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
                userFieldDyna.set("userrolerealt", (Object)relatId);
                userFieldDyna.set("app", (Object)userFieldModel.getAppId());
                userFieldDyna.set("entitytype", (Object)userFieldModel.getEntityNumber());
                PermInitServiceHelper.setOperatorAndDate(userFieldDyna);
                userFileDynaMap.put(userFieldDynaKey, userFieldDyna);
            }
            DynamicObjectCollection userFieldEntryColl = userFieldDyna.getDynamicObjectCollection("entryentity");
            DynamicObject userFieldEntryDyna = USER_FIELD_HELPER.generateEmptyEntryDynamicObject("entryentity");
            userFieldEntryDyna.set("fieldname", (Object)userFieldModel.getPropKey());
            userFieldEntryDyna.set("isbanread", (Object)(!userFieldModel.isCanRead() ? 1 : 0));
            userFieldEntryDyna.set("isbanwrite", (Object)(!userFieldModel.isCanWrite() ? 1 : 0));
            userFieldEntryColl.add((Object)userFieldEntryDyna);
            userFieldDyna.set("entryentity", (Object)userFieldEntryColl);
        }
        return userFileDynaMap.values();
    }
}

