/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.ImportUserDimModel;
import kd.hr.hrcs.common.model.perminit.OrgRangeBean;
import kd.hr.hrcs.common.model.perminit.PermInitRecord;
import kd.hr.hrcs.common.model.perminit.PermInitTccParam;

public class PermInitConvertToSysTccService
extends TCCAdapterService {
    private static final Log LOGGER = LogFactory.getLog(PermInitConvertToSysTccService.class);
    private static final HRBaseServiceHelper PERM_INIT_RECORD_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");
    private static final HRBaseServiceHelper SYS_USER_ROLE_HELPER = new HRBaseServiceHelper("perm_userrole");

    public void Try(Object param) throws Exception {
        PermInitTccParam tccParam = (PermInitTccParam)param;
        PermInitRecord initRecord = tccParam.getInitRecord();
        LOGGER.info("ConvertPermInitRecord to sys Try start,recordId:{}", (Object)initRecord.getId());
        DynamicObject recordDyna = PERM_INIT_RECORD_HELPER.queryOriginalOne("dealstatus", new QFilter("id", "=", (Object)initRecord.getId()));
        if (HRStringUtils.equals((String)recordDyna.getString("dealstatus"), (String)"1")) {
            LOGGER.error("perminitrecord id:{},dealstatus is 1.return.", (Object)initRecord.getId());
            return;
        }
        List userDimModelList = initRecord.getUserDimModelList();
        DynamicObjectCollection userRoleDynaColl = new DynamicObjectCollection();
        HashSet trimRepeatSet = Sets.newHashSetWithExpectedSize((int)userDimModelList.size());
        Map roleOrgRangeMap = initRecord.getRoleOrgRangeMap();
        Map sysUserRoleIdMap = initRecord.getSysUserRoleIdMap();
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        for (ImportUserDimModel userDimModel : userDimModelList) {
            String trimRepeatKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId(), userDimModel.getBucaFuncId());
            if (trimRepeatSet.contains(trimRepeatKey)) continue;
            trimRepeatSet.add(trimRepeatKey);
            if (userDimModel.getCustomEnable()) {
                for (Long orgId : userDimModel.getOrgRangeList()) {
                    DynamicObject userRoleDyna = this.genUserRoleDyna(userDimModel, userDimModel.getBucaFuncId(), orgId, initRecord.getIncludeSub(), enableValidateTime, sysUserRoleIdMap);
                    userRoleDynaColl.add((Object)userRoleDyna);
                }
                continue;
            }
            List orgRangeBeans = (List)roleOrgRangeMap.get(userDimModel.getRoleId());
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                if (!Objects.equals(orgRangeBean.getBucaFuncId(), userDimModel.getBucaFuncId())) continue;
                DynamicObject userRoleDyna = this.genUserRoleDyna(userDimModel, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId(), orgRangeBean.getIncludeSub(), enableValidateTime, sysUserRoleIdMap);
                userRoleDynaColl.add((Object)userRoleDyna);
            }
        }
        if (userRoleDynaColl.size() > 0) {
            SYS_USER_ROLE_HELPER.save(userRoleDynaColl);
        }
        LOGGER.info("ConvertPermInitRecord to sys Try end,recordId:{}", (Object)initRecord.getId());
    }

    public DtxResponse confirm(Object param, Object lastReturn) throws Exception {
        PermInitTccParam tccParam = (PermInitTccParam)param;
        PermInitRecord initRecord = tccParam.getInitRecord();
        LOGGER.info("ConvertPermInitRecord to sys confirm start,recordId:{}", (Object)initRecord.getId());
        return null;
    }

    public void cancel(Object param) throws Exception {
        PermInitTccParam tccParam = (PermInitTccParam)param;
        PermInitRecord initRecord = tccParam.getInitRecord();
        LOGGER.info("ConvertPermInitRecord to sys cancel start,recordId:{}", (Object)initRecord.getId());
        Map sysUserRoleIdMap = initRecord.getSysUserRoleIdMap();
        Collection ids = sysUserRoleIdMap.values();
        SYS_USER_ROLE_HELPER.deleteByFilter(new QFilter[]{new QFilter("id", "in", ids)});
        LOGGER.info("ConvertPermInitRecord to sys cancel end,recordId:{}", (Object)initRecord.getId());
    }

    private DynamicObject genUserRoleDyna(ImportUserDimModel userDimModel, Long bucaFuncId, Long orgId, Boolean includeSub, boolean enableValidateTime, Map<String, String> sysUserRoleIdMap) {
        DynamicObject userRoleDyna = SYS_USER_ROLE_HELPER.generateEmptyDynamicObject();
        String idMapKey = PermInitServiceHelper.joinToKey(userDimModel.getUserId(), userDimModel.getFileOrgId(), userDimModel.getRoleId(), bucaFuncId, orgId);
        userRoleDyna.set("id", (Object)sysUserRoleIdMap.get(idMapKey));
        userRoleDyna.set("user", (Object)userDimModel.getUserId());
        userRoleDyna.set("role", (Object)userDimModel.getRoleId());
        userRoleDyna.set("org", (Object)orgId);
        userRoleDyna.set("includesuborg", (Object)includeSub);
        userRoleDyna.set("source", (Object)"hr");
        userRoleDyna.set("dimtype", (Object)"bos_org");
        if (enableValidateTime) {
            userRoleDyna.set("starttime", (Object)userDimModel.getValidStart());
            userRoleDyna.set("endtime", (Object)userDimModel.getValidEnd());
        }
        return userRoleDyna;
    }
}

