/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.query.ChoiceFieldPageCustomQuery;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.helper.EntityPropParser;
import kd.hr.hrcs.bussiness.service.perm.init.PermTemplateFieldMap;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.ObjStatus;
import kd.hr.hrcs.common.model.perminit.RoleInfoData;

public class PermInitImportService {
    private static final Log LOGGER = LogFactory.getLog(PermInitImportService.class);
    private Map<String, Long> buMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Long> drMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, String> appMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, String> permMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Long> dimMap = Maps.newHashMapWithExpectedSize((int)16);

    public Long getBuId(String buName) {
        if (this.buMap.size() == 0) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
            DynamicObjectCollection dys = hrBaseServiceHelper.queryOriginalCollection("id,name", null);
            for (DynamicObject obj : dys) {
                this.buMap.put(obj.getString("name"), obj.getLong("id"));
            }
        }
        return this.buMap.get(buName);
    }

    public List<Long> getBuIdByCode(Set<String> buCodeSet, Long buFunId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org");
        DynamicObjectCollection dys = helper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", buCodeSet)});
        return dys.stream().map(it -> it.getLong("id")).collect(Collectors.toList());
    }

    public Map<String, DynamicObject> getBuIdMapByCode(Set<String> buCodeSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org");
        DynamicObjectCollection dys = helper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", buCodeSet)});
        Map<String, DynamicObject> number = dys.stream().collect(Collectors.toMap(dynamicObj -> dynamicObj.getString("number"), o -> o));
        return number;
    }

    public Long queryDataRuleColByNumber(String drCode) {
        if (this.drMap.size() == 0) {
            HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_datarule");
            DynamicObjectCollection dys = dataRuleHelper.queryOriginalCollection("id, number, entitynum, enable", null);
            for (DynamicObject obj : dys) {
                this.drMap.put(obj.getString("number"), obj.getLong("id"));
            }
        }
        return this.drMap.get(drCode);
    }

    public String getAppId(String appCode) {
        if (this.appMap.size() == 0) {
            HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            DynamicObjectCollection dys = dataRuleHelper.queryOriginalCollection("id, number", null);
            for (DynamicObject obj : dys) {
                this.appMap.put(obj.getString("number"), obj.getString("id"));
            }
        }
        return this.appMap.get(appCode);
    }

    public List<String> getPermItemId(List<String> names) {
        if (this.permMap.size() == 0) {
            HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("perm_permitem");
            DynamicObjectCollection dys = dataRuleHelper.queryOriginalCollection("id, name", null);
            for (DynamicObject obj : dys) {
                this.permMap.put(obj.getString("name"), obj.getString("id"));
            }
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)names.size());
        for (String name : names) {
            list.add(this.permMap.get(name));
        }
        return list;
    }

    public List<String> getEntityItems(String entityNum) {
        HRBaseServiceHelper permHelper = new HRBaseServiceHelper("perm_functionperm");
        DynamicObjectCollection dynamicObjects = permHelper.queryOriginalCollection("permitem", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNum), new QFilter("permitem", "not in", (Object)Sets.newHashSet((Object[])new String[]{"4730fc9f000003ae", "4730fc9f000004ae"}))});
        return dynamicObjects.stream().map(it -> it.getString("permitem")).collect(Collectors.toList());
    }

    public Map<String, Long> getDims(boolean isDis) {
        if (this.dimMap.size() == 0) {
            DynamicObjectCollection dys = null;
            HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_dimension");
            dys = isDis ? dataRuleHelper.queryOriginalCollection("id, number", new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))}) : dataRuleHelper.queryOriginalCollection("id, number", null);
            for (DynamicObject obj : dys) {
                this.dimMap.put(obj.getString("number").trim(), obj.getLong("id"));
            }
        }
        return this.dimMap;
    }

    public Object getDimVal(String code, Long dimId, String str) {
        DynamicObject[] dimArr;
        String val = null;
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        for (DynamicObject dim : dimArr = dimHelper.query("id,datasource,hrbu.id,entitytype.id,teamtype.id,entry.displayvalue,entry.value", new QFilter[]{new QFilter("id", "=", (Object)dimId)})) {
            String datasource = dim.getString("datasource");
            if (HRStringUtils.equals((String)"basedata", (String)datasource)) {
                String entityId = dim.getString("entitytype.id");
                if (HRStringUtils.isEmpty((String)entityId)) continue;
                HRBaseServiceHelper bdHelper = new HRBaseServiceHelper(entityId);
                DynamicObjectCollection bdCol = bdHelper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "=", (Object)code)});
                List id = bdCol.stream().map(it -> it.get("id")).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(id)) continue;
                val = id.get(0);
                continue;
            }
            if (!HRStringUtils.equals((String)"enum", (String)datasource)) continue;
            Map<String, String> enumVal = dim.getDynamicObjectCollection("entry").stream().collect(Collectors.toMap(it -> it.getString("displayvalue"), it -> it.getString("value")));
            val = enumVal.get(code);
        }
        return val;
    }

    public Set<String> getAllDimValTip() {
        HashSet set = Sets.newHashSet((Object[])new String[]{"all", "All", "ALL", "aLL", "alL", "aLl", "AlL"});
        String all = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PermInitImportService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        set.add(all);
        return set;
    }

    public Map<String, RoleInfoData> getRoleInitInfo(Set<String> roles, Map<String, String> roleNumIdMap, Map<String, Set<String>> roleEntityMap, Map<String, Set<String>> roleBdEntityMap) {
        DynamicObject[] dyns;
        HashMap roleProMap = Maps.newHashMapWithExpectedSize((int)roleNumIdMap.size());
        HRBaseServiceHelper hrRole = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection roleIdDys = hrRole.queryOriginalCollection("id,property", new QFilter[]{new QFilter("id", "in", roleNumIdMap.values())});
        for (DynamicObject rid : roleIdDys) {
            roleProMap.put(rid.getString("id"), rid.getString("property"));
        }
        HashMap buMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList buList = Lists.newArrayListWithExpectedSize((int)16);
        HRBaseServiceHelper buHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObjectCollection budys = buHelper.queryOriginalCollection("id,name", new QFilter[]{new QFilter("issyspreset", "=", (Object)"1")});
        for (DynamicObject dy : budys) {
            String name = dy.getString("name");
            Long id = dy.getLong("id");
            buList.add(name);
            buMap.put(id, name);
        }
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObjectCollection roleDims = roleDimHelper.queryOriginalCollection("role.id,dimension.id,dimension.number,dimension.teamtype,bucafunc.id", new QFilter[]{new QFilter("role.id", "in", roleNumIdMap.values())});
        HashBasedTable roleBuDimTb = HashBasedTable.create();
        for (DynamicObject dy : roleDims) {
            String roleId = dy.getString("role.id");
            String buName = (String)buMap.get(dy.getLong("bucafunc.id"));
            Long dimId = dy.getLong("dimension.id");
            String dimCode = dy.getString("dimension.number");
            Long dimTypeId = dy.getLong("dimension.teamtype");
            DimValueBean dimValueBean = new DimValueBean();
            dimValueBean.setDimId(dimId);
            dimValueBean.setOtClassifyId(dimTypeId);
            dimValueBean.setDimCode(dimCode);
            if (roleBuDimTb.contains((Object)roleId, (Object)buName)) {
                ((List)roleBuDimTb.get((Object)roleId, (Object)buName)).add(dimValueBean);
                continue;
            }
            ArrayList dimValueBeans = Lists.newArrayListWithExpectedSize((int)4);
            dimValueBeans.add(dimValueBean);
            roleBuDimTb.put((Object)roleId, (Object)buName, (Object)dimValueBeans);
        }
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        DynamicObjectCollection roleBu = roleBuHelper.queryOriginalCollection("hrbucafunc,role", new QFilter[]{new QFilter("role", "in", roleNumIdMap.values())});
        HashMap roleBuMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : roleBu) {
            Long buId = dy.getLong("hrbucafunc");
            String roleId = dy.getString("role");
            roleBuMap.computeIfAbsent(roleId, key -> new ArrayList(16)).add(buMap.get(buId));
        }
        HRBaseServiceHelper role = new HRBaseServiceHelper("perm_role");
        DynamicObjectCollection roleDys = role.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", roles)});
        List ids = roleDys.stream().map(it -> it.getString("id")).collect(Collectors.toList());
        HashMap roleExcelData = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_roleperm");
        for (DynamicObject dy : dyns = roleHelper.query("roleid,roleperm.entity,roleperm.permitem,roleperm.bizapp,roleperm.droleid", new QFilter[]{new QFilter("roleid", "in", ids)})) {
            DynamicObjectCollection entry = dy.getDynamicObjectCollection("roleperm");
            String roleNum = dy.getString("roleid.number");
            String roleId = dy.getString("roleid.id");
            for (DynamicObject entryDy : entry) {
                String entityNum = entryDy.getString("entity.number");
                String appNum = entryDy.getString("bizapp.number");
                String permName = entryDy.getString("permitem.name");
                String permId = entryDy.getString("permitem.id");
                RoleInfoData excelData = roleExcelData.computeIfAbsent(roleNum, key -> new RoleInfoData());
                excelData.setRoleNum(roleNum);
                excelData.setBuType((List)buList);
                excelData.setDataScope((String)roleProMap.get(roleId));
                excelData.getAppSet().add(appNum);
                excelData.setRoleBuType((List)roleBuMap.get(roleId));
                excelData.setDimValuesMap(roleBuDimTb.row((Object)roleId));
                excelData.getEntityNumberMap().computeIfAbsent(appNum, key -> new HashSet(16)).add(entityNum);
                if (HRStringUtils.equals((String)"4730fc9f000003ae", (String)permId) || HRStringUtils.equals((String)"4730fc9f000004ae", (String)permId)) continue;
                ObjStatus objStatus = new ObjStatus();
                objStatus.setName(permName);
                objStatus.setPermId(permId);
                excelData.getEntityNumPermMap().computeIfAbsent(entityNum, key -> new ArrayList(16)).add(objStatus);
            }
        }
        ArrayList<RoleInfoData> data = new ArrayList<RoleInfoData>(roleExcelData.values());
        this.initEntityInfo(data, roleEntityMap, roleBdEntityMap);
        return roleExcelData;
    }

    private void initEntityInfo(List<RoleInfoData> data, Map<String, Set<String>> roleEntityMap, Map<String, Set<String>> roleBdEntityMap) {
        for (RoleInfoData roleInfoData : data) {
            String roleNum = roleInfoData.getRoleNum();
            Set<String> entitySet = roleEntityMap.get(roleNum);
            Set<String> bdEntitySet = roleBdEntityMap.get(roleNum);
            if (CollectionUtils.isNotEmpty(entitySet)) {
                this.initEntityDr(entitySet, roleInfoData);
                for (String entityNum : entitySet) {
                    this.initEntityField(entityNum, roleInfoData, "entity");
                }
            }
            if (!CollectionUtils.isNotEmpty(bdEntitySet)) continue;
            this.initEntityDr(bdEntitySet, roleInfoData);
            for (String entityNum : bdEntitySet) {
                this.initEntityField(entityNum, roleInfoData, "bd");
            }
        }
    }

    private void initEntityField(String entityNum, RoleInfoData roleInfoData, String type) {
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            ChoiceFieldPageCustomQuery customQuery = new ChoiceFieldPageCustomQuery();
            HashMap<String, String> customs = new HashMap<String, String>(1);
            boolean isBd = HRStringUtils.equals((String)"bd", (String)type);
            if (isBd) {
                customs.put("param_ifShowBaseDataProp", "true");
            }
            List propertyMap = customQuery.parseProperty((IDataEntityType)mainEntityType, null, customs, "1=1");
            Set fields = propertyMap.stream().map(it -> (String)it.get("field_id")).collect(Collectors.toSet());
            if (isBd) {
                roleInfoData.getEntityBdFieldProMap().put(entityNum, fields);
            } else {
                roleInfoData.getEntityFieldProMap().put(entityNum, fields);
            }
        }
        catch (Exception ex) {
            LOGGER.error("initEntityField error:", (Throwable)ex);
        }
    }

    private void initEntityDr(Set<String> entitySet, RoleInfoData roleInfoData) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_datarule");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("number,name,status,enable,entitynum.number", new QFilter[]{new QFilter("entitynum.number", "in", entitySet)});
        for (DynamicObject obj : dynamicObjects) {
            String entityNum = obj.getString("entitynum.number");
            ObjStatus objStatus = new ObjStatus();
            objStatus.setEnable(obj.getString("enable"));
            objStatus.setStatus(obj.getString("status"));
            objStatus.setNumber(obj.getString("number"));
            objStatus.setName(obj.getString("name"));
            roleInfoData.getEntityDataRuleMap().computeIfAbsent(entityNum, key -> new ArrayList(16)).add(objStatus);
        }
    }

    public Map<String, List<ObjStatus>> getUserPermFile(Set<String> userCodeSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        HashMap userPermFileMap = Maps.newHashMapWithExpectedSize((int)userCodeSet.size());
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("user.number,org.id,org.number,permfileenable,username", new QFilter[]{new QFilter("user.number", "in", userCodeSet)});
        for (DynamicObject obj : dynamicObjects) {
            String userNum = obj.getString("user.number");
            ObjStatus objStatus = new ObjStatus();
            objStatus.setNumber(userNum);
            objStatus.setStatus(obj.getString("permfileenable"));
            objStatus.setOrgNumber(obj.getString("org.number"));
            objStatus.setOrgId(Long.valueOf(obj.getLong("org.id")));
            userPermFileMap.computeIfAbsent(userNum, key -> new ArrayList(16)).add(objStatus);
        }
        return userPermFileMap;
    }

    public String getBdEntity(String entityNum, String bdPro) {
        String targetEntityNumber = null;
        try {
            targetEntityNumber = EntityPropParser.getPropF7EntityNumber(entityNum, bdPro);
        }
        catch (Exception ex) {
            LOGGER.error("getBdEntity error:", (Throwable)ex);
        }
        return targetEntityNumber;
    }

    public String getYear() {
        return ResManager.loadKDString((String)"\u5e74", (String)"PermInitImportService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getMonth() {
        return ResManager.loadKDString((String)"\u6708", (String)"PermInitImportService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public String getDay() {
        return ResManager.loadKDString((String)"\u65e5", (String)"PermInitImportService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public Date parseDate(String dateString) {
        Date date = null;
        try {
            if (HRStringUtils.isNotEmpty((String)dateString) && dateString.contains(this.getYear())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy" + this.getYear() + "MM" + this.getMonth() + "dd" + this.getDay());
                date = sdf.parse(dateString);
            } else {
                date = HRDateTimeUtils.parseDate((String)dateString);
            }
        }
        catch (ParseException ex) {
            LOGGER.error("parseDate error", (Throwable)ex);
        }
        return date;
    }

    public String dealSheetName(String sheetName) {
        if (sheetName.length() > 32) {
            return sheetName.substring(0, 31);
        }
        return sheetName;
    }

    public boolean containsValue(String sheetName) {
        long count = PermTemplateFieldMap.getTemplateNames().values().stream().filter(it -> it.contains(sheetName)).count();
        return count > 0L;
    }

    public static Date parseDateString(String str) throws ParseException {
        try {
            return HRDateTimeUtils.parseDate((String)str, (String)"MM/dd/yyyy");
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("parseDate info:" + str + ",fmt:MM/dd/yyyy");
            }
            try {
                return HRDateTimeUtils.parseDate((String)str, (String)"yyyy/MM/dd HH:mm:ss");
            }
            catch (ParseException e2) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parseDate info:" + str + ",fmt:yyyy/MM/dd HH:mm:ss");
                }
                try {
                    return HRDateTimeUtils.parseDate((String)str, (String)"yyyy/MM/dd");
                }
                catch (ParseException e3) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("parseDate info:" + str + ",fmt:yyyy/MM/dd");
                    }
                    try {
                        return HRDateTimeUtils.parseDate((String)str, (String)"yyyy-MM-dd");
                    }
                    catch (ParseException e4) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("parseDate info:" + str + ",fmt:yyyy-MM-dd");
                        }
                        throw new ParseException("can not understand your format", -1);
                    }
                }
            }
        }
    }

    public boolean checkDate(String startTime) {
        boolean check;
        try {
            if (HRStringUtils.isNotEmpty((String)startTime) && startTime.contains(this.getYear())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy" + this.getYear() + "MM" + this.getMonth() + "dd" + this.getDay());
                sdf.parse(startTime);
            } else {
                PermInitImportService.parseDateString(startTime);
            }
            check = true;
        }
        catch (ParseException e) {
            check = false;
        }
        return check;
    }

    public void getOtDim(Map<String, Long> dimMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("id,number", null);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dimMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
            }
        }
    }
}

