/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.HRPermTreeService;

public class PermRoleFuncService {
    public Map<String, List<String>> getEntityGroup(Set<String> hrAppIdList) {
        HRPermTreeService hrPermTreeService = new HRPermTreeService();
        DataSet allFuncPermTreeByText = hrPermTreeService.getAllFuncPermTree();
        LinkedHashMap entityGroup = Maps.newLinkedHashMapWithExpectedSize((int)16);
        while (allFuncPermTreeByText.hasNext()) {
            Row next = allFuncPermTreeByText.next();
            String appId = next.getString("burf_appid");
            String entityNum = next.getString("entd_num");
            List entityIdList = entityGroup.getOrDefault(appId, Lists.newArrayListWithExpectedSize((int)128));
            if (!entityIdList.contains(entityNum)) {
                entityIdList.add(entityNum);
            }
            entityGroup.put(appId, entityIdList);
        }
        entityGroup.entrySet().removeIf(entry -> !hrAppIdList.contains(entry.getKey()));
        this.removeForbid(entityGroup);
        return entityGroup;
    }

    public Map<String, DynamicObject> getHRAppMap() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hrcs_hrcloud");
        DynamicObjectCollection cloudResults = cloudHelper.queryOriginalCollection("id,number,index", new QFilter[0], "index");
        List cloudIdList = cloudResults.stream().map(cl -> cl.getString("id")).collect(Collectors.toList());
        List appDynByCloudIds = HRAppServiceHelper.getAPPDynByCloudIds(cloudIdList);
        return appDynByCloudIds.stream().collect(Collectors.toMap(dyn -> dyn.getString("id"), dyn -> dyn));
    }

    public Map<String, List<DynamicObject>> getHRFuncItemGroup(Set<String> entityNumSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_functionperm");
        DynamicObject[] items = serviceHelper.queryOriginalArray("id,permitem.number,permitem.name,entitytype,permitem.id,entitytypeid", new QFilter[]{new QFilter("entitytype", "in", entityNumSet)}, "seq");
        LinkedHashMap itemGroup = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject item : items) {
            String entityNum = item.getString("entitytype");
            List itemList = itemGroup.getOrDefault(entityNum, Lists.newArrayListWithExpectedSize((int)128));
            itemList.add(item);
            itemGroup.put(entityNum, itemList);
        }
        return itemGroup;
    }

    public Map<String, List<String>> getRemoveRelItemMap(Map<String, List<String>> entityGroup) {
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)entityGroup.size());
        entityGroup.forEach((key, value) -> entityNumSet.addAll(value));
        HRBaseServiceHelper cfgServiceHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        DynamicObject[] results = cfgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("isassign", "=", (Object)"1")});
        HashMap diyItemMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject result : results) {
            String appId = result.getString("app.id");
            String entityId = result.getString("entitytype.id");
            String itemNum = result.getString("permitem.number");
            String key2 = appId + "#" + entityId;
            List itemList = diyItemMap.getOrDefault(key2, Lists.newArrayListWithExpectedSize((int)results.length));
            itemList.add(itemNum);
            diyItemMap.put(key2, itemList);
        }
        HRBaseServiceHelper relServiceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] relResults = relServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("entryentity.app", "in", entityGroup.keySet()), new QFilter("entryentity.entitytypeid", "in", (Object)entityNumSet)});
        HashMap removeItemMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject relResult : relResults) {
            DynamicObjectCollection dynamicObjectCollection = relResult.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String[] split;
                String appId = dynamicObject.getString("app.id");
                String entityId = dynamicObject.getString("entitytypeid.id");
                String itemNumStr = dynamicObject.getString("permitemid");
                String key3 = appId + "#" + entityId;
                List itemList = (List)diyItemMap.get(key3);
                if (itemList != null) continue;
                for (String itemNum : split = itemNumStr.split(",")) {
                    List removeItemList = removeItemMap.getOrDefault(key3, Lists.newArrayListWithExpectedSize((int)results.length));
                    removeItemList.add(itemNum);
                    removeItemMap.put(key3, removeItemList);
                }
            }
        }
        return removeItemMap;
    }

    public Map<String, List<String>> getRelItemMap(Map<String, List<String>> entityPermItemGroup) {
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)entityPermItemGroup.size());
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)entityPermItemGroup.size());
        for (Map.Entry<String, List<String>> entry : entityPermItemGroup.entrySet()) {
            String[] split = entry.getKey().split("#");
            appIdSet.add(split[0]);
            entityNumSet.add(split[1]);
        }
        HRBaseServiceHelper cfgServiceHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        DynamicObject[] results = cfgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("isassign", "=", (Object)"1")});
        HashMap diyItemMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject result : results) {
            String appId = result.getString("app.id");
            String entityId = result.getString("entitytype.id");
            String itemNum = result.getString("permitem.number");
            String key = appId + "#" + entityId;
            List itemList = diyItemMap.getOrDefault(key, Lists.newArrayListWithExpectedSize((int)results.length));
            itemList.add(itemNum);
            diyItemMap.put(key, itemList);
        }
        HRBaseServiceHelper relServiceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] relResults = relServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("bizapp", "in", (Object)appIdSet), new QFilter("entitytype.id", "in", (Object)entityNumSet)});
        HashMap removeItemMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject relResult : relResults) {
            String appMainId = relResult.getString("bizapp.id");
            String entityMainId = relResult.getString("entitytype.id");
            String mainPermItem = relResult.getString("mainpermitem");
            List<String> mainPermItemList = entityPermItemGroup.get(appMainId + "#" + entityMainId);
            if (mainPermItemList == null || !mainPermItemList.contains(mainPermItem)) continue;
            DynamicObjectCollection dynamicObjectCollection = relResult.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String[] split;
                String appId = dynamicObject.getString("app.id");
                String entityId = dynamicObject.getString("entitytypeid.id");
                String itemNumStr = dynamicObject.getString("permitemid");
                String key = appId + "#" + entityId;
                List itemList = (List)diyItemMap.get(key);
                if (itemList != null) continue;
                for (String itemNum : split = itemNumStr.split(",")) {
                    List removeItemList = removeItemMap.getOrDefault(key, Lists.newArrayListWithExpectedSize((int)results.length));
                    removeItemList.add(itemNum);
                    removeItemMap.put(key, removeItemList);
                }
            }
        }
        return removeItemMap;
    }

    public Map<String, DynamicObject> getDimMap(Set<String> entityNumSet) {
        HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] dimResults = dimServiceHelper.query("id,entryentity.dimension,entryentity.ismust,entitytype", new QFilter[]{new QFilter("entitytype", "in", entityNumSet)});
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)dimResults.length);
        for (DynamicObject dimResult : dimResults) {
            dimMap.put(dimResult.getString("entitytype.id"), dimResult);
        }
        return dimMap;
    }

    public List<DynamicObject> getDimList(Set<String> dimNumberSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (null != dimNumberSet) {
            qFilter.and(new QFilter("number", "in", dimNumberSet));
        }
        DynamicObject[] results = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList typeListWithSort = Lists.newArrayList((Object[])new String[]{"orgteam", "basedata", "hrbu", "enum"});
        TreeMap dimGroup = Maps.newTreeMap((k1, k2) -> {
            int index1 = typeListWithSort.indexOf(k1);
            int index2 = typeListWithSort.indexOf(k2);
            index1 = index1 == -1 ? 999 : index1;
            index2 = index2 == -1 ? 999 : index2;
            return index1 - index2;
        });
        for (DynamicObject result : results) {
            String type = result.getString("datasource");
            List dimList = dimGroup.getOrDefault(type, Lists.newArrayListWithExpectedSize((int)results.length));
            dimList.add(result);
            dimGroup.put(type, dimList);
        }
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)results.length);
        for (Map.Entry entry : dimGroup.entrySet()) {
            ((List)entry.getValue()).sort((x1, x2) -> {
                boolean x1Sys = x1.getBoolean("issyspreset");
                boolean x2Sys = x2.getBoolean("issyspreset");
                Date createTime1 = x1.getDate("createtime");
                Date createTime2 = x2.getDate("createtime");
                if (x1Sys == x2Sys) {
                    return createTime1.compareTo(createTime2);
                }
                if (x1Sys) {
                    return -1;
                }
                return 1;
            });
            dimList.addAll((Collection)entry.getValue());
        }
        return dimList;
    }

    private void removeForbid(Map<String, List<String>> entityGroup) {
        DynamicObject[] forBidResults;
        HRBaseServiceHelper forBidServiceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        for (DynamicObject forBidResult : forBidResults = forBidServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
            List<String> entityNumList;
            String forbidType = forBidResult.getString("forbidtype");
            String entityNum = forBidResult.getString("entitytypeid.number");
            String appId = forBidResult.getString("app.id");
            if (!"3".equals(forbidType) || (entityNumList = entityGroup.get(appId)) == null) continue;
            entityNumList.removeIf(entityNum2 -> HRStringUtils.equals((String)entityNum, (String)entityNum2));
            if (!entityNumList.isEmpty()) continue;
            entityGroup.remove(appId);
        }
    }

    public void removeFuncItemByForbid(Map<String, List<DynamicObject>> hrFuncItemGroup) {
        DynamicObject[] forBidResults;
        HRBaseServiceHelper forBidServiceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        for (DynamicObject forBidResult : forBidResults = forBidServiceHelper.loadDynamicObjectArray(new QFilter[0])) {
            List<DynamicObject> funcItems;
            String forbidType = forBidResult.getString("forbidtype");
            String entityNum = forBidResult.getString("entitytypeid.number");
            String permItemId = forBidResult.getString("permitem.id");
            if (!"4".equals(forbidType) || (funcItems = hrFuncItemGroup.get(entityNum)) == null) continue;
            funcItems.removeIf(fi -> HRStringUtils.equals((String)permItemId, (String)fi.getString("permitem.id")));
            if (!funcItems.isEmpty()) continue;
            hrFuncItemGroup.remove(entityNum);
        }
    }

    public Map<String, Map<String, List<String>>> getRemoveFuncItemByForbid() {
        HRBaseServiceHelper forBidServiceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        DynamicObject[] forBidResults = forBidServiceHelper.loadDynamicObjectArray(new QFilter[0]);
        HashMap forBidItems = Maps.newHashMapWithExpectedSize((int)forBidResults.length);
        for (DynamicObject forBidResult : forBidResults) {
            String forbidType = forBidResult.getString("forbidtype");
            String entityNum = forBidResult.getString("entitytypeid.number");
            String permItemId = forBidResult.getString("permitem.id");
            String appId = forBidResult.getString("app.id");
            if (!"5".equals(forbidType)) continue;
            boolean entityNotEmpty = HRStringUtils.isNotEmpty((String)entityNum);
            boolean appNotEmpty = HRStringUtils.isNotEmpty((String)appId);
            boolean permNotEmpty = HRStringUtils.isNotEmpty((String)permItemId);
            if (!entityNotEmpty || !appNotEmpty || !permNotEmpty) continue;
            Map entityItemMap = forBidItems.getOrDefault(appId, Maps.newHashMapWithExpectedSize((int)forBidResults.length));
            List items = entityItemMap.getOrDefault(entityNum, Lists.newArrayListWithExpectedSize((int)forBidResults.length));
            items.add(permItemId);
            entityItemMap.put(entityNum, items);
            forBidItems.put(appId, entityItemMap);
        }
        return forBidItems;
    }
}

