/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleFuncService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitValidateService;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DataRangeInitModel;
import kd.hr.hrcs.common.model.perminit.DataRangeInitValidateBO;
import kd.hr.hrcs.common.model.perminit.DimAndDataRangeBaseModel;
import kd.hr.hrcs.common.model.perminit.DimInitCheckedBO;
import kd.hr.hrcs.common.model.perminit.DimInitModel;
import kd.hr.hrcs.common.model.perminit.DimInitValidateBO;
import kd.hr.hrcs.common.model.perminit.FieldPermInitModel;
import kd.hr.hrcs.common.model.perminit.FunctionItemInitModel;
import kd.hr.hrcs.common.model.perminit.PermRoleInitRecord;
import kd.hr.hrcs.common.model.perminit.PermRoleInitValidateBO;
import kd.hr.hrcs.common.model.perminit.RoleInitModel;
import org.apache.commons.lang3.tuple.Pair;

public class PermRoleInitFinishValidateService {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitFinishValidateService.class);
    Map<Integer, String> funcItemRowNumMap;
    Map<String, Integer> roleRowNumMap;
    List<DynamicObject> dimList;
    final PermRoleInitValidateService service = new PermRoleInitValidateService();
    final PermRoleFuncService funcService = new PermRoleFuncService();

    public int[] clickFinishValidate(Long recordId) {
        HRBaseServiceHelper permInitRecordHelper = new HRBaseServiceHelper("hrcs_perminitrecord");
        DynamicObject recordDyna = permInitRecordHelper.loadSingle((Object)recordId);
        PermRoleInitRecord permRoleInitRecord = this.convertToModel(recordDyna);
        PermRoleInitValidateBO validate = this.service.validate(permRoleInitRecord);
        int[] errNum = this.setErrMsg(validate, recordDyna);
        permInitRecordHelper.saveOne(recordDyna);
        return errNum;
    }

    private PermRoleInitRecord convertToModel(DynamicObject recordDyna) {
        List<RoleInitModel> roleInitModelList = this.getRoleInitModelList(recordDyna);
        this.roleRowNumMap = Maps.newHashMapWithExpectedSize((int)roleInitModelList.size());
        for (RoleInitModel roleInitModel : roleInitModelList) {
            this.roleRowNumMap.put(roleInitModel.getRoleNumber(), roleInitModel.getRowNum());
        }
        List<FunctionItemInitModel> functionItemInitModelList = this.getFunctionItemInitModelList(recordDyna, roleInitModelList);
        List<DimInitModel> dimInitModelList = this.getDimInitModelList(recordDyna);
        List<DataRangeInitModel> dataRangeModelList = this.getDataRangeModelList(recordDyna);
        List<FieldPermInitModel> fieldPermInitModelList = this.getFieldPermInitModelList(recordDyna);
        PermRoleInitRecord permRoleInitRecord = new PermRoleInitRecord();
        permRoleInitRecord.setRoleInitModelList(roleInitModelList);
        permRoleInitRecord.setFunctionItemInitModelList(functionItemInitModelList);
        permRoleInitRecord.setDimInitModelList(dimInitModelList);
        permRoleInitRecord.setDataRangeInitModelList(dataRangeModelList);
        permRoleInitRecord.setFieldPermInitModelList(fieldPermInitModelList);
        permRoleInitRecord.setErrorRoleSet((Set)Sets.newHashSet());
        return permRoleInitRecord;
    }

    private int[] setErrMsg(PermRoleInitValidateBO validate, DynamicObject recordDyna) {
        Map roleErrMsgMap = validate.getRoleErrMsgMap();
        DynamicObjectCollection roleBaseEntry = recordDyna.getDynamicObjectCollection("rolebaseentry");
        int rowNum = 0;
        for (DynamicObject role : roleBaseEntry) {
            String errMsg = (String)roleErrMsgMap.get(rowNum);
            role.set("rbase_errormsg", (Object)errMsg);
            ++rowNum;
        }
        Map functionItemErrMsgMap = validate.getFunctionItemErrMsgMap();
        DynamicObjectCollection funcItemRowErrorEntry = recordDyna.getDynamicObjectCollection("rolefuncrowerrorentry");
        DynamicObjectCollection funcItemColErrorEntry = recordDyna.getDynamicObjectCollection("rolefunccolerrorentry");
        funcItemRowErrorEntry.clear();
        funcItemColErrorEntry.clear();
        HashMap roleColNumMap = Maps.newHashMapWithExpectedSize((int)this.roleRowNumMap.size());
        for (Map.Entry<String, Integer> entry : this.roleRowNumMap.entrySet()) {
            roleColNumMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Integer> entry : functionItemErrMsgMap.entrySet()) {
            Integer funcRowNum = (Integer)((Object)entry.getKey());
            Map value = (Map)((Object)entry.getValue());
            for (Map.Entry subEntry : value.entrySet()) {
                if ((Integer)subEntry.getKey() > 0) {
                    DynamicObject colError = funcItemColErrorEntry.addNew();
                    colError.set("rfunccol_rolenumber", roleColNumMap.get((Integer)subEntry.getKey() - 1));
                    colError.set("rfunccol_errormsg", subEntry.getValue());
                    continue;
                }
                String key = this.funcItemRowNumMap.get(funcRowNum);
                String[] split = key.split("#");
                DynamicObject rowError = funcItemRowErrorEntry.addNew();
                rowError.set("rfuncrow_app", (Object)split[0]);
                if (split.length > 1) {
                    rowError.set("rfuncrow_entitytype", (Object)split[1]);
                    rowError.set("rfuncrow_permitem", (Object)split[2]);
                }
                rowError.set("rfuncrow_errormsg", subEntry.getValue());
            }
        }
        this.setDimError(validate, recordDyna);
        this.setDataRangeError(validate, recordDyna);
        this.setFieldError(validate, recordDyna);
        int[] errNum = new int[]{(Integer)validate.getErrorRoleNumList().get(0), (Integer)validate.getErrorRoleNumList().get(1), (Integer)validate.getErrorRoleNumList().get(2), (Integer)validate.getErrorRoleNumList().get(3), (Integer)validate.getErrorRoleNumList().get(4)};
        return errNum;
    }

    private void setDimError(PermRoleInitValidateBO validate, DynamicObject recordDyna) {
        DimInitValidateBO dimErrMsgBO = validate.getDimErrMsgBO();
        Map dimErrMsgMap = dimErrMsgBO.getErrMsgMap();
        Map dimLackMsgMap = dimErrMsgBO.getLackMsgMap();
        DynamicObjectCollection dimCol = recordDyna.getDynamicObjectCollection("roledimentry");
        DynamicObjectCollection dimErrorRowEntry = recordDyna.getDynamicObjectCollection("roledimrowerrorentry");
        HashMap checkedDimMap = Maps.newHashMapWithExpectedSize((int)dimCol.size());
        for (DynamicObject dim : dimCol) {
            String key = dim.getString("rdim_rolenumber") + "#" + dim.getString("rdim_bucafunc.fname");
            List dimList = checkedDimMap.getOrDefault(key, Lists.newArrayListWithExpectedSize((int)200));
            dimList.add(dim);
            checkedDimMap.put(key, dimList);
        }
        int rowNum = 0;
        for (Map.Entry entry : checkedDimMap.entrySet()) {
            String errMsg = (String)dimErrMsgMap.get(rowNum);
            for (DynamicObject dim : (List)entry.getValue()) {
                dim.set("rdim_errormsg", (Object)errMsg);
            }
            ++rowNum;
        }
        dimErrorRowEntry.clear();
        for (Map.Entry dimInitModelEntry : dimLackMsgMap.entrySet()) {
            DimAndDataRangeBaseModel model = (DimAndDataRangeBaseModel)dimInitModelEntry.getKey();
            DynamicObject dimError = dimErrorRowEntry.addNew();
            dimError.set("rdimrow_rolenumber", (Object)model.getRoleNumber());
            dimError.set("rdimrow_bucafunc", (Object)model.getBuCaFuncId());
            dimError.set("rdimrow_errormsg", dimInitModelEntry.getValue());
        }
    }

    private void setDataRangeError(PermRoleInitValidateBO validate, DynamicObject recordDyna) {
        DataRangeInitValidateBO dataRangeInitValidateBO = validate.getDataRangeInitValidateBO();
        Map dataRangeErrMsgMap = dataRangeInitValidateBO.getErrMsgMap();
        Map dataRangeLackMsgMap = dataRangeInitValidateBO.getLackMsgMap();
        DynamicObjectCollection dataRangeEntry = recordDyna.getDynamicObjectCollection("roledataentry");
        DynamicObjectCollection dataRangeErrorRowEntry = recordDyna.getDynamicObjectCollection("roledatarowerrorentry");
        int rowNum = 0;
        for (DynamicObject dim : dataRangeEntry) {
            String errMsg = (String)dataRangeErrMsgMap.get(rowNum);
            dim.set("rdata_errormsg", (Object)errMsg);
            ++rowNum;
        }
        dataRangeErrorRowEntry.clear();
        for (Map.Entry dimInitModelEntry : dataRangeLackMsgMap.entrySet()) {
            DimAndDataRangeBaseModel model = (DimAndDataRangeBaseModel)dimInitModelEntry.getKey();
            DynamicObject dimError = dataRangeErrorRowEntry.addNew();
            dimError.set("rdatarow_rolenumber", (Object)model.getRoleNumber());
            dimError.set("rdatarow_bucafunc", (Object)model.getBuCaFuncId());
            dimError.set("rdatarow_errormsg", dimInitModelEntry.getValue());
        }
    }

    private void setFieldError(PermRoleInitValidateBO validate, DynamicObject recordDyna) {
        Map fieldErrMsgMap = validate.getFieldPermInitValidateBO().getErrMsgMap();
        DynamicObjectCollection fieldCol = recordDyna.getDynamicObjectCollection("rolefieldentry");
        int rowNum = 0;
        for (DynamicObject field : fieldCol) {
            String errMsg = (String)fieldErrMsgMap.get(rowNum);
            field.set("rfield_errormsg", (Object)errMsg);
            ++rowNum;
        }
    }

    private List<RoleInitModel> getRoleInitModelList(DynamicObject recordDyna) {
        DynamicObjectCollection roleBaseEntry = recordDyna.getDynamicObjectCollection("rolebaseentry");
        ArrayList roleInitModelList = Lists.newArrayListWithExpectedSize((int)roleBaseEntry.size());
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrcs_role");
        ComboProp property = (ComboProp)mainEntityType.getProperty("property");
        ComboProp isIntersection = (ComboProp)mainEntityType.getProperty("isintersection");
        ComboProp userScope = (ComboProp)mainEntityType.getProperty("usescope");
        Map<String, String> propertyMap = property.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue()));
        Map<String, String> isIntersectionMap = isIntersection.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue()));
        Map<String, String> userScopeMap = userScope.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue()));
        int rowNum = 0;
        for (DynamicObject role : roleBaseEntry) {
            RoleInitModel roleInitModel = this.getRoleInitModel(role, propertyMap, isIntersectionMap, userScopeMap);
            roleInitModel.setRowNum(Integer.valueOf(rowNum));
            roleInitModelList.add(roleInitModel);
            ++rowNum;
        }
        return roleInitModelList;
    }

    private RoleInitModel getRoleInitModel(DynamicObject role, Map<String, String> propertyMap, Map<String, String> isIntersectionMap, Map<String, String> userScopeMap) {
        RoleInitModel roleInitModel = new RoleInitModel();
        roleInitModel.setRoleNumber(role.getString("rbase_number"));
        roleInitModel.setRoleName(role.getLocaleString("rbase_name"));
        roleInitModel.setRoleGroupNumber(role.getString("rbase_group.number"));
        roleInitModel.setRoleGroupName(role.getString("rbase_group.name"));
        roleInitModel.setRoleProperty(propertyMap.get(role.getString("rbase_property")));
        roleInitModel.setRoleCBisIntersection(isIntersectionMap.get(role.getString("rbase_isintersection")));
        roleInitModel.setCreateAdminGrpNumber(role.getString("rbase_createadmingrp.number"));
        roleInitModel.setCreateAdminGrpName(role.getString("rbase_createadmingrp.name"));
        roleInitModel.setUseScope(userScopeMap.get(role.getString("rbase_usescope")));
        DynamicObjectCollection adminGroupWithView = role.getDynamicObjectCollection("rbase_openscopeview");
        StringBuilder adminGroupWithViewStr = new StringBuilder();
        for (DynamicObject dynamicObject : adminGroupWithView) {
            String number = dynamicObject.getString("fbasedataid.number");
            adminGroupWithViewStr.append(number).append("\uff1b");
        }
        if (adminGroupWithViewStr.length() > 0) {
            roleInitModel.setOpenRangeWithView(adminGroupWithViewStr.substring(0, adminGroupWithViewStr.length() - 1));
        }
        DynamicObjectCollection adminGroupWithEdit = role.getDynamicObjectCollection("rbase_openscopeedit");
        StringBuilder adminGroupWithEditStr = new StringBuilder();
        for (DynamicObject dynamicObject : adminGroupWithEdit) {
            String number = dynamicObject.getString("fbasedataid.number");
            adminGroupWithEditStr.append(number).append("\uff1b");
        }
        if (adminGroupWithEditStr.length() > 0) {
            roleInitModel.setOpenRangeWithEdit(adminGroupWithEditStr.substring(0, adminGroupWithEditStr.length() - 1));
        }
        roleInitModel.setRoleRemark(role.getLocaleString("rbase_remark"));
        return roleInitModel;
    }

    private List<FunctionItemInitModel> getFunctionItemInitModelList(DynamicObject recordDyna, List<RoleInitModel> roleInitModelList) {
        Map roleNumMap;
        DynamicObjectCollection funcCol = recordDyna.getDynamicObjectCollection("rolefuncentry");
        LinkedHashMap appEntityFuncGroup = Maps.newLinkedHashMapWithExpectedSize((int)funcCol.size());
        HashMap roleCheckMap = Maps.newHashMapWithExpectedSize((int)funcCol.size());
        HashMap appIdMap = Maps.newHashMapWithExpectedSize((int)funcCol.size());
        for (Object func : funcCol) {
            String appNum = func.getString("rfunc_app.number");
            appIdMap.put(appNum, func.getString("rfunc_app.id"));
            String entityNum = func.getString("rfunc_entitytype.number");
            String funcItemName = func.getString("rfunc_permitem.name").trim();
            String funcItemId = func.getString("rfunc_permitem.id");
            Map entityFuncMap = appEntityFuncGroup.getOrDefault(appNum, Maps.newHashMapWithExpectedSize((int)funcCol.size()));
            Map funcMap = entityFuncMap.getOrDefault(entityNum, Maps.newHashMapWithExpectedSize((int)funcCol.size()));
            funcMap.put(funcItemId, funcItemName);
            entityFuncMap.put(entityNum, funcMap);
            appEntityFuncGroup.put(appNum, entityFuncMap);
            String key = appNum + entityNum + funcItemName;
            roleNumMap = roleCheckMap.getOrDefault(key, Maps.newHashMapWithExpectedSize((int)16));
            String roleNum = func.getString("rfunc_rolenumber");
            roleNumMap.put(roleNum, Boolean.TRUE);
            roleCheckMap.put(key, roleNumMap);
        }
        if (funcCol.isEmpty()) {
            HashMap roleNumMap2 = Maps.newHashMapWithExpectedSize((int)16);
            for (RoleInitModel roleInitModel : roleInitModelList) {
                roleNumMap2.put(roleInitModel.getRoleNumber(), Boolean.FALSE);
            }
            roleCheckMap.put("", roleNumMap2);
            HashMap funcMap = Maps.newHashMapWithExpectedSize((int)funcCol.size());
            funcMap.put("", "");
            HashMap entityFuncMap = Maps.newHashMapWithExpectedSize((int)funcCol.size());
            entityFuncMap.put("", funcMap);
            appEntityFuncGroup.put("", entityFuncMap);
        }
        int rowNum = 4;
        this.funcItemRowNumMap = Maps.newHashMapWithExpectedSize((int)funcCol.size());
        ArrayList functionItemInitModelList = Lists.newArrayListWithExpectedSize((int)funcCol.size());
        for (Map.Entry appEntry : appEntityFuncGroup.entrySet()) {
            for (Map.Entry entityEntry : ((Map)appEntry.getValue()).entrySet()) {
                for (Map.Entry funcEntry : ((Map)entityEntry.getValue()).entrySet()) {
                    FunctionItemInitModel functionItemInitModel = new FunctionItemInitModel();
                    functionItemInitModel.setAppNum((String)appEntry.getKey());
                    functionItemInitModel.setAppId((String)appIdMap.get(functionItemInitModel.getAppNum()));
                    functionItemInitModel.setEntityNum((String)entityEntry.getKey());
                    functionItemInitModel.setName((String)funcEntry.getValue());
                    functionItemInitModel.setPermItemId((String)funcEntry.getKey());
                    roleNumMap = (Map)roleCheckMap.get((String)appEntry.getKey() + (String)entityEntry.getKey() + (String)funcEntry.getValue());
                    HashMap roleCheckedMap = Maps.newHashMapWithExpectedSize((int)roleNumMap.size());
                    for (Map.Entry<String, Integer> roleNumEntry : this.roleRowNumMap.entrySet()) {
                        String roleNum = roleNumEntry.getKey();
                        Boolean isCheck = roleNumMap.get(roleNum) == null ? Boolean.FALSE : (Boolean)roleNumMap.get(roleNum);
                        roleCheckedMap.put(roleNum, Pair.of((Object)(roleNumEntry.getValue() + 1), (Object)isCheck));
                    }
                    functionItemInitModel.setRoleCheckedMap((Map)roleCheckedMap);
                    functionItemInitModel.setRowNum(Integer.valueOf(rowNum));
                    functionItemInitModelList.add(functionItemInitModel);
                    this.funcItemRowNumMap.put(rowNum, functionItemInitModel.getAppId() + "#" + functionItemInitModel.getEntityNum() + "#" + functionItemInitModel.getPermItemId());
                    ++rowNum;
                }
            }
        }
        return functionItemInitModelList;
    }

    private List<DimInitModel> getDimInitModelList(DynamicObject recordDyna) {
        DynamicObjectCollection dimCol = recordDyna.getDynamicObjectCollection("roledimentry");
        HashSet bosFuncIdSet = Sets.newHashSetWithExpectedSize((int)dimCol.size());
        for (DynamicObject dim : dimCol) {
            bosFuncIdSet.add(dim.getLong("rdim_bucafunc.id"));
        }
        Map<Long, String> hrFuncNameMap = this.getHrFuncNameMap(bosFuncIdSet);
        HashMap checkedDimMap = Maps.newHashMapWithExpectedSize((int)dimCol.size());
        for (DynamicObject dim : dimCol) {
            long buFuncId = dim.getLong("rdim_bucafunc.id");
            String key = dim.getString("rdim_rolenumber") + "#" + hrFuncNameMap.get(buFuncId);
            Set dimNumSet = checkedDimMap.getOrDefault(key, Sets.newHashSetWithExpectedSize((int)200));
            dimNumSet.add(dim.getString("rdim_dimension.number"));
            checkedDimMap.put(key, dimNumSet);
        }
        this.dimList = this.funcService.getDimList(null);
        int rowNum = 0;
        ArrayList dimInitModelList = Lists.newArrayListWithExpectedSize((int)dimCol.size());
        for (Map.Entry entry : checkedDimMap.entrySet()) {
            String[] split = ((String)entry.getKey()).split("#");
            DimInitModel dimInitModel = new DimInitModel();
            dimInitModel.setRoleNumber(split[0]);
            dimInitModel.setBuCaFuncName(split[1]);
            dimInitModel.setRowNum(Integer.valueOf(rowNum));
            LinkedHashMap dimCheckedMap = Maps.newLinkedHashMapWithExpectedSize((int)((Set)entry.getValue()).size());
            for (DynamicObject dim : this.dimList) {
                String dimNum = dim.getString("number");
                String dimName = dim.getString("name");
                DimInitCheckedBO dimInitCheckedBO = new DimInitCheckedBO();
                dimInitCheckedBO.setDimName(dimName);
                dimInitCheckedBO.setDimId(Long.valueOf(dim.getLong("id")));
                dimInitCheckedBO.setCheck(Boolean.valueOf(((Set)entry.getValue()).contains(dimNum)));
                dimCheckedMap.put(dimNum, dimInitCheckedBO);
            }
            dimInitModel.setDimCheckedMap((Map)dimCheckedMap);
            dimInitModelList.add(dimInitModel);
            ++rowNum;
        }
        LOGGER.info("PermRoleInitFinishValidateService_getDimInitModelList:{}", (Object)JSON.toJSONString((Object)dimInitModelList));
        return dimInitModelList;
    }

    public List<DataRangeInitModel> getDataRangeModelList(DynamicObject recordDyna) {
        DynamicObjectCollection dimCol = recordDyna.getDynamicObjectCollection("roledataentry");
        HashMap allDimValMap = Maps.newHashMapWithExpectedSize((int)dimCol.size());
        ArrayList orgTeamIds = Lists.newArrayListWithExpectedSize((int)dimCol.size());
        HashSet bosFuncIdSet = Sets.newHashSetWithExpectedSize((int)dimCol.size());
        for (DynamicObject dimEntry : dimCol) {
            bosFuncIdSet.add(dimEntry.getLong("rdata_bucafunc.id"));
            DynamicObjectCollection dimSubEntry = dimEntry.getDynamicObjectCollection("roledatavalentry");
            for (DynamicObject dimSub : dimSubEntry) {
                long dimId = dimSub.getLong("rdata_dimension.id");
                String dimVal = dimSub.getString("rdata_dimval");
                List dimValList = allDimValMap.getOrDefault(dimId, Lists.newArrayListWithExpectedSize((int)dimSubEntry.size()));
                dimValList.add(dimVal);
                allDimValMap.put(dimId, dimValList);
                long structId = dimSub.getLong("rdata_structproject.id");
                if (structId == 0L) continue;
                orgTeamIds.add(Long.parseLong(dimVal));
            }
        }
        Map<Long, String> hrFuncNameMap = this.getHrFuncNameMap(bosFuncIdSet);
        Map<Long, Map<String, Pair<String, String>>> allDimInfo = PermInitServiceHelper.structDimInfoById(allDimValMap, orgTeamIds);
        ArrayList dataRangeInitModelList = Lists.newArrayListWithExpectedSize((int)dimCol.size());
        int rowNum = 0;
        String prefix = "\u3010";
        String suffix = "\u3011";
        Map<Long, String> allDynaCondMapIdNumber = PermInitServiceHelper.getAllDynaCondMapIdNumber();
        Map<Long, String> allDynaCondNameMap = PermInitServiceHelper.getAllDynaCondNameMap();
        for (DynamicObject dimEntry : dimCol) {
            DataRangeInitModel dataRangeInitModel = new DataRangeInitModel();
            dataRangeInitModel.setRoleNumber(dimEntry.getString("rdata_rolenumber"));
            dataRangeInitModel.setBuCaFuncName(hrFuncNameMap.get(dimEntry.getLong("rdata_bucafunc.id")));
            StringBuilder stringBuilder = new StringBuilder();
            DynamicObjectCollection orgRanges = dimEntry.getDynamicObjectCollection("rdata_orgrange");
            for (DynamicObject orgRange : orgRanges) {
                stringBuilder.append(orgRange.getDynamicObject("fbasedataid").getString("number")).append(prefix).append(orgRange.getDynamicObject("fbasedataid").getString("name")).append(suffix).append(";");
            }
            dataRangeInitModel.setOrgRange(stringBuilder.substring(0, stringBuilder.length() - 1));
            DynamicObjectCollection dimSubEntry = dimEntry.getDynamicObjectCollection("roledatavalentry");
            LinkedHashMap structValueMap = Maps.newLinkedHashMapWithExpectedSize((int)dimSubEntry.size());
            HashSet alreadyAddDimSet = Sets.newHashSetWithExpectedSize((int)dimSubEntry.size());
            for (DynamicObject dimSub : dimSubEntry) {
                String dimValNum;
                String rdata_valtype = dimSub.getString("rdata_valtype");
                long dimId = dimSub.getLong("rdata_dimension.id");
                String dimVal = dimSub.getString("rdata_dimval");
                boolean isAll = dimSub.getBoolean("rdata_isall");
                long structId = dimSub.getLong("rdata_structproject.id");
                String key = structId != 0L ? dimId + "#" + structId : dimId + "";
                if (HRStringUtils.equals((String)"2", (String)rdata_valtype)) {
                    Long rdata_dynacond_id = dimSub.getLong("rdata_dynacond.id");
                    String dimValStr = (String)structValueMap.get(key);
                    dimValNum = allDynaCondMapIdNumber.get(rdata_dynacond_id);
                    dimValNum = dimValNum + prefix + allDynaCondNameMap.get(rdata_dynacond_id) + suffix;
                    dimValStr = HRStringUtils.isEmpty((String)dimValStr) ? dimValNum + ";" : dimValStr + dimValNum + ";";
                    alreadyAddDimSet.add(key);
                    structValueMap.put(key, dimValStr);
                    continue;
                }
                if (isAll) {
                    dimValNum = "all";
                } else {
                    Map<String, Pair<String, String>> dimValMap = allDimInfo.get(dimId);
                    Pair<String, String> dimValNameAndNum = dimValMap.get(dimVal);
                    dimValNum = (String)dimValNameAndNum.getRight() + prefix + (String)dimValNameAndNum.getLeft() + suffix;
                }
                String dimValStr = (String)structValueMap.get(key);
                dimValStr = HRStringUtils.isEmpty((String)dimValStr) ? dimValNum + ";" : dimValStr + dimValNum + ";";
                structValueMap.put(key, dimValStr);
                alreadyAddDimSet.add(key);
            }
            if (this.dimList == null) {
                this.dimList = this.funcService.getDimList(null);
            }
            List typeIdList = this.dimList.stream().map(dyn -> dyn.getLong("teamtype.id")).collect(Collectors.toList());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
            DynamicObject[] struct = serviceHelper.query("id,name,number,otclassify.teamtype", new QFilter[]{new QFilter("otclassify.teamtype.id", "in", typeIdList), new QFilter("enable", "!=", (Object)"10")}, "createtime");
            Map<Long, List<DynamicObject>> structGroup = Arrays.stream(struct).collect(Collectors.groupingBy(dyn -> dyn.getLong("otclassify.teamtype.id")));
            for (DynamicObject dyn2 : this.dimList) {
                long typeId = dyn2.getLong("teamtype.id");
                long dimId = dyn2.getLong("id");
                List<DynamicObject> structList = structGroup.get(typeId);
                String key = dimId + "";
                if (!CollectionUtils.isEmpty(structList)) {
                    for (DynamicObject structDyn : structList) {
                        long structId = structDyn.getLong("id");
                        String key2 = key + "#" + structId;
                        if (alreadyAddDimSet.contains(key2)) continue;
                        structValueMap.put(key2, null);
                    }
                    continue;
                }
                if (alreadyAddDimSet.contains(key)) continue;
                structValueMap.put(key, null);
            }
            dataRangeInitModel.setStructValueMap((Map)structValueMap);
            dataRangeInitModel.setRowNum(Integer.valueOf(rowNum));
            dataRangeInitModelList.add(dataRangeInitModel);
            ++rowNum;
        }
        return dataRangeInitModelList;
    }

    private List<FieldPermInitModel> getFieldPermInitModelList(DynamicObject recordDyna) {
        DynamicObjectCollection fieldCol = recordDyna.getDynamicObjectCollection("rolefieldentry");
        int rowNum = 0;
        ArrayList fieldPermInitModelList = Lists.newArrayListWithExpectedSize((int)fieldCol.size());
        for (DynamicObject field : fieldCol) {
            FieldPermInitModel fieldPermInitModel = new FieldPermInitModel();
            fieldPermInitModel.setRoleNumber(field.getString("rfield_rolenumber"));
            fieldPermInitModel.setAppNum(field.getString("rfield_app.number"));
            fieldPermInitModel.setAppName(field.getString("rfield_app.name"));
            fieldPermInitModel.setEntityNum(field.getString("rfield_entitytype.number"));
            fieldPermInitModel.setEntityName(field.getString("rfield_entitytype.name"));
            fieldPermInitModel.setFieldNumber(field.getString("rfield_propkey"));
            String viewValue = field.getString("rfield_canread");
            String editValue = field.getString("rfield_canwrite");
            String allow = ResManager.loadKDString((String)"\u5141\u8bb8", (String)"RoleTemplateExcelWriter_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String notAllow = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"RoleTemplateExcelWriter_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            fieldPermInitModel.setView("0".equals(viewValue) ? notAllow : allow);
            fieldPermInitModel.setEdit("0".equals(editValue) ? notAllow : allow);
            fieldPermInitModel.setRowNum(Integer.valueOf(rowNum));
            fieldPermInitModelList.add(fieldPermInitModel);
            ++rowNum;
        }
        return fieldPermInitModelList;
    }

    public Map<Long, String> getHrFuncNameMap(Set<Long> bosFuncIdSet) {
        HRBaseServiceHelper hrOrgServiceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject[] hrFunc = hrOrgServiceHelper.queryOriginalArray("id,number,name", new QFilter[]{new QFilter("id", "in", bosFuncIdSet)});
        return Arrays.stream(hrFunc).collect(Collectors.toMap(hf -> hf.getLong("id"), hf -> hf.getString("name")));
    }
}

