/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleFuncService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermRoleInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DataRangeInitModel;
import kd.hr.hrcs.common.model.perminit.DataRangeInitValidateBO;
import kd.hr.hrcs.common.model.perminit.DimAndDataRangeBaseModel;
import kd.hr.hrcs.common.model.perminit.DimInitCheckedBO;
import kd.hr.hrcs.common.model.perminit.DimInitModel;
import kd.hr.hrcs.common.model.perminit.DimInitValidateBO;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.common.model.perminit.FieldPermInitModel;
import kd.hr.hrcs.common.model.perminit.FieldPermInitValidateBO;
import kd.hr.hrcs.common.model.perminit.FunctionItemInitModel;
import kd.hr.hrcs.common.model.perminit.PermInitBaseModel;
import kd.hr.hrcs.common.model.perminit.PermRoleInitRecord;
import kd.hr.hrcs.common.model.perminit.PermRoleInitValidateBO;
import kd.hr.hrcs.common.model.perminit.RoleInitModel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PermRoleInitValidateService {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitValidateService.class);
    private final PermRoleFuncService funcService = new PermRoleFuncService();
    private Map<String, Map<String, DynamicObject>> funcMap;
    Map<String, Map<String, Boolean>> roleFuncMap;
    Map<Long, DynamicObject> dimMapById;
    Map<String, String> appIdMap;

    public PermRoleInitValidateBO validate(PermRoleInitRecord record) {
        Map<Integer, String> roleErrMsgMap = this.checkRoleSheet(record);
        Map<Integer, Map<Integer, String>> funcErrMsgMap = this.checkFunctionItemSheet(record);
        DimInitValidateBO dimInitValidateBO = this.checkDimSheet(record);
        DataRangeInitValidateBO dataRangeInitValidateBO = this.checkDataRangeSheet(record, dimInitValidateBO);
        FieldPermInitValidateBO fieldPermInitValidateBO = this.checkFieldPermSheet(record);
        PermRoleInitValidateBO permRoleInitValidateBO = new PermRoleInitValidateBO(roleErrMsgMap, funcErrMsgMap, dimInitValidateBO, dataRangeInitValidateBO, fieldPermInitValidateBO);
        LOGGER.info("PermRoleInitValidateService_validate:{}", (Object)JSON.toJSONString((Object)permRoleInitValidateBO));
        return permRoleInitValidateBO;
    }

    public Map<Integer, String> checkRoleSheet(PermRoleInitRecord record) {
        List roleInitModelList = record.getRoleInitModelList();
        ArrayList roleNumList = Lists.newArrayListWithExpectedSize((int)roleInitModelList.size());
        ArrayList roleNameList = Lists.newArrayListWithExpectedSize((int)roleInitModelList.size());
        HashSet roleGroupNumSet = Sets.newHashSetWithExpectedSize((int)roleInitModelList.size());
        HashSet createAdminGrpNumSet = Sets.newHashSetWithExpectedSize((int)roleInitModelList.size());
        HashSet adminGroupNumSet = Sets.newHashSetWithExpectedSize((int)roleInitModelList.size());
        for (RoleInitModel roleInitModel : roleInitModelList) {
            String openRangeWithEdit;
            roleNumList.add(roleInitModel.getRoleNumber());
            roleNameList.add(roleInitModel.getRoleName().getLocaleValue());
            roleGroupNumSet.add(roleInitModel.getRoleGroupNumber());
            createAdminGrpNumSet.add(roleInitModel.getCreateAdminGrpNumber());
            String openRangeWithView = roleInitModel.getOpenRangeWithView();
            if (!HRStringUtils.isEmpty((String)openRangeWithView)) {
                String[] split = this.dealValueCode(openRangeWithView).toArray(new String[0]);
                adminGroupNumSet.addAll(Arrays.asList(split));
            }
            if (HRStringUtils.isEmpty((String)(openRangeWithEdit = roleInitModel.getOpenRangeWithEdit()))) continue;
            String[] split = this.dealValueCode(openRangeWithEdit).toArray(new String[0]);
            adminGroupNumSet.addAll(Arrays.asList(split));
        }
        HashMap errorMsgMap = Maps.newHashMapWithExpectedSize((int)roleInitModelList.size());
        this.validateNumberAndName(errorMsgMap, roleInitModelList, roleNumList, roleNameList);
        this.removeErrInfo(errorMsgMap, roleInitModelList);
        this.validateValueError(errorMsgMap, roleInitModelList, roleGroupNumSet, createAdminGrpNumSet);
        this.removeErrInfo(errorMsgMap, roleInitModelList);
        this.validateUserScope(errorMsgMap, roleInitModelList);
        this.removeErrInfo(errorMsgMap, roleInitModelList);
        this.validateAdminGroup(errorMsgMap, roleInitModelList, adminGroupNumSet);
        this.removeErrInfo(errorMsgMap, roleInitModelList);
        return errorMsgMap;
    }

    public Map<Integer, Map<Integer, String>> checkFunctionItemSheet(PermRoleInitRecord record) {
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashMap errMsgMap = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        this.validateFuncItem(errMsgMap, record);
        this.validateFuncWithRole(errMsgMap, record);
        HashSet errRoleCol = Sets.newHashSetWithExpectedSize((int)record.getRoleInitModelList().size());
        errMsgMap.forEach((key, value) -> value.forEach((col, errMsg) -> {
            if (col > 0) {
                errRoleCol.add(col);
            }
        }));
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            roleCheckedMap.entrySet().removeIf(next -> errRoleCol.contains(((Pair)next.getValue()).getKey()));
        }
        return errMsgMap;
    }

    public DimInitValidateBO checkDimSheet(PermRoleInitRecord record) {
        HashMap errorMsgMap = Maps.newHashMapWithExpectedSize((int)record.getDimInitModelList().size());
        HashMap roleRowNumMap = Maps.newHashMapWithExpectedSize((int)record.getDimInitModelList().size());
        for (DimInitModel dimInitModel : record.getDimInitModelList()) {
            roleRowNumMap.put(dimInitModel.getRoleNumber(), dimInitModel.getRowNum());
        }
        HashSet allErrRoleNumSet = Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size());
        this.validateRoleWithDim(errorMsgMap, record);
        ArrayList removeList = Lists.newArrayListWithExpectedSize((int)record.getDimInitModelList().size());
        this.addErrRoleNum(errorMsgMap, record.getDimInitModelList(), allErrRoleNumSet, removeList);
        this.validateFuncWithDim(errorMsgMap, record);
        this.addErrRoleNum(errorMsgMap, record.getDimInitModelList(), allErrRoleNumSet, removeList);
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashMap entityGroup = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            String appId = functionItemInitModel.getAppId();
            String entityNum = functionItemInitModel.getEntityNum();
            List entityNumList = entityGroup.getOrDefault(appId, Lists.newArrayListWithExpectedSize((int)functionItemInitModelList.size()));
            entityNumList.add(entityNum);
            entityGroup.put(appId, entityNumList);
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            roleCheckedMap.forEach((key, value) -> {
                if (Boolean.TRUE.equals(value.getValue())) {
                    entityNumSet.add(entityNum);
                }
            });
        }
        this.funcMap = HRBuCaServiceHelper.getBuCaFuncFromSpec(entityGroup);
        Map<String, DynamicObject> dimMap = this.funcService.getDimMap(entityNumSet);
        this.validateBuWithDim(errorMsgMap, record);
        HashSet errRoleNumSet = Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size());
        errRoleNumSet.addAll(record.getErrorRoleSet());
        this.addErrRoleNum(errorMsgMap, record.getDimInitModelList(), errRoleNumSet, removeList);
        this.validateCheckedDim(errorMsgMap, record, dimMap);
        this.addErrRoleNum(errorMsgMap, record.getDimInitModelList(), errRoleNumSet, removeList);
        DimInitValidateBO dimInitValidateBO = this.validateLack(record, dimMap, removeList, roleRowNumMap);
        for (Map.Entry entry : dimInitValidateBO.getLackMsgMap().entrySet()) {
            errRoleNumSet.add(((DimAndDataRangeBaseModel)entry.getKey()).getRoleNumber());
        }
        dimInitValidateBO.setErrMsgMap((Map)errorMsgMap);
        dimInitValidateBO.setErrorRoleNumSet((Set)errRoleNumSet);
        allErrRoleNumSet.addAll(errRoleNumSet);
        allErrRoleNumSet.removeAll(record.getErrorRoleSet());
        dimInitValidateBO.setAllErrorRoleNumSet((Set)allErrRoleNumSet);
        return dimInitValidateBO;
    }

    public DataRangeInitValidateBO checkDataRangeSheet(PermRoleInitRecord record, DimInitValidateBO dimInitValidateBO) {
        HashMap errorMsgMap = Maps.newHashMapWithExpectedSize((int)record.getDataRangeInitModelList().size());
        HashMap roleRowNumMap = Maps.newHashMapWithExpectedSize((int)record.getDimInitModelList().size());
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            String roleNumber = dataRangeInitModel.getRoleNumber();
            roleRowNumMap.put(roleNumber, dataRangeInitModel.getRowNum());
        }
        HashSet allErrRoleNumSet = Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size());
        this.validateRoleWithDataRange(errorMsgMap, record);
        ArrayList removeList = Lists.newArrayListWithExpectedSize((int)record.getDimInitModelList().size());
        this.addErrRoleNum(errorMsgMap, record.getDataRangeInitModelList(), allErrRoleNumSet, removeList);
        this.validateFuncWithDataRange(errorMsgMap, record);
        this.addErrRoleNum(errorMsgMap, record.getDataRangeInitModelList(), allErrRoleNumSet, removeList);
        this.validateDimWithDataRange(errorMsgMap, record, dimInitValidateBO);
        this.addErrRoleNum(errorMsgMap, record.getDataRangeInitModelList(), allErrRoleNumSet, removeList);
        this.validateBuWithDataRange(errorMsgMap, record);
        this.addErrRoleNum(errorMsgMap, record.getDataRangeInitModelList(), allErrRoleNumSet, removeList);
        this.validateDimCheckWithDataRange(errorMsgMap, record);
        this.addErrRoleNum(errorMsgMap, record.getDataRangeInitModelList(), allErrRoleNumSet, removeList);
        this.validateDimFillWithDataRange(errorMsgMap, record);
        this.validateRangeValWithDataRange(errorMsgMap, record);
        this.validateDiffWithDataRange(errorMsgMap, record);
        this.addErrRoleNum(errorMsgMap, record.getDataRangeInitModelList(), allErrRoleNumSet, removeList);
        Map<DimAndDataRangeBaseModel, String> lackMsgMap = this.validateLackWithDataRange(record, removeList, roleRowNumMap);
        DataRangeInitValidateBO dataRangeInitValidateBO = new DataRangeInitValidateBO();
        dataRangeInitValidateBO.setErrMsgMap((Map)errorMsgMap);
        dataRangeInitValidateBO.setLackMsgMap(lackMsgMap);
        for (Map.Entry<DimAndDataRangeBaseModel, String> entry : lackMsgMap.entrySet()) {
            allErrRoleNumSet.add(entry.getKey().getRoleNumber());
        }
        dataRangeInitValidateBO.setAllErrorRoleNumSet((Set)allErrRoleNumSet);
        return dataRangeInitValidateBO;
    }

    private FieldPermInitValidateBO checkFieldPermSheet(PermRoleInitRecord record) {
        HashMap errorMsgMap = Maps.newHashMapWithExpectedSize((int)record.getDataRangeInitModelList().size());
        this.validateRoleWithField(errorMsgMap, record);
        List<PermInitBaseModel> removeErrInfoList = this.removeErrInfo(errorMsgMap, record.getFieldPermInitModelList());
        this.validateFuncWithField(errorMsgMap, record);
        removeErrInfoList.addAll(this.removeErrInfo(errorMsgMap, record.getFieldPermInitModelList()));
        this.validatePermWithField(errorMsgMap, record);
        removeErrInfoList.addAll(this.removeErrInfo(errorMsgMap, record.getFieldPermInitModelList()));
        this.validateValueWithField(errorMsgMap, record);
        removeErrInfoList.addAll(this.removeErrInfo(errorMsgMap, record.getFieldPermInitModelList()));
        this.validateDuplicateWithField(errorMsgMap, record);
        removeErrInfoList.addAll(this.removeErrInfo(errorMsgMap, record.getFieldPermInitModelList()));
        HashSet allErrRoleNumSet = Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size());
        for (PermInitBaseModel permInitBaseModel : removeErrInfoList) {
            FieldPermInitModel fieldPermInitModel = (FieldPermInitModel)permInitBaseModel;
            if (fieldPermInitModel == null) continue;
            allErrRoleNumSet.add(fieldPermInitModel.getRoleNumber());
        }
        FieldPermInitValidateBO fieldPermInitValidateBO = new FieldPermInitValidateBO();
        fieldPermInitValidateBO.setErrMsgMap((Map)errorMsgMap);
        fieldPermInitValidateBO.setAllErrorRoleNumSet((Set)allErrRoleNumSet);
        return fieldPermInitValidateBO;
    }

    private void validateRoleWithField(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        List fieldPermInitModelList = record.getFieldPermInitModelList();
        List roleInitModelList = record.getRoleInitModelList();
        Set roleNumSet = roleInitModelList.stream().map(RoleInitModel::getRoleNumber).collect(Collectors.toSet());
        for (FieldPermInitModel fieldPermInitModel : fieldPermInitModelList) {
            String roleNumber = fieldPermInitModel.getRoleNumber();
            if (roleNumSet.contains(roleNumber)) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u201d\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u89d2\u8272\uff0c\u6216\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(fieldPermInitModel.getRowNum(), errMsg);
        }
    }

    private void validateFuncWithField(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Set<String> successFuncSet = this.getSuccessFuncSet(record);
        for (FieldPermInitModel fieldPermInitModel : record.getFieldPermInitModelList()) {
            if (successFuncSet.contains(fieldPermInitModel.getRoleNumber())) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(fieldPermInitModel.getRowNum(), errMsg);
        }
    }

    private void validatePermWithField(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Set appEntitySet;
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashMap roleAppEntityMap = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        HashMap entityGroup = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            String appNum = functionItemInitModel.getAppNum();
            String entityNum = functionItemInitModel.getEntityNum();
            for (Map.Entry entry : roleCheckedMap.entrySet()) {
                if (!Boolean.TRUE.equals(((Pair)entry.getValue()).getRight())) continue;
                appEntitySet = roleAppEntityMap.getOrDefault(entry.getKey(), Sets.newHashSetWithExpectedSize((int)functionItemInitModelList.size()));
                appEntitySet.add(appNum + entityNum);
                roleAppEntityMap.put(entry.getKey(), appEntitySet);
                String key = functionItemInitModel.getAppId() + "#" + entityNum;
                List permItemNumList = entityGroup.getOrDefault(key, Lists.newArrayListWithExpectedSize((int)128));
                permItemNumList.add(functionItemInitModel.getPermItemNum());
                entityGroup.put(key, permItemNumList);
            }
        }
        Map<String, List<String>> removeRelItemMap = this.funcService.getRelItemMap(entityGroup);
        List fieldPermInitModelList = record.getFieldPermInitModelList();
        for (FieldPermInitModel fieldPermInitModel : fieldPermInitModelList) {
            String roleNumber = fieldPermInitModel.getRoleNumber();
            String appNum = fieldPermInitModel.getAppNum();
            String entityNum = fieldPermInitModel.getEntityNum();
            appEntitySet = (Set)roleAppEntityMap.get(roleNumber);
            String appId = this.appIdMap.get(appNum);
            if (appEntitySet == null || !appEntitySet.contains(appNum + entityNum)) {
                if (removeRelItemMap != null && removeRelItemMap.containsKey(appId + "#" + entityNum)) {
                    fieldPermInitModel.setAppId(appId);
                    continue;
                }
                String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u9519\u8bef\uff0c\u6216\u8be5\u89d2\u8272\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_39", (String)"hrmp-hrcs-business", (Object[])new Object[0]), fieldPermInitModel.getAppNum(), fieldPermInitModel.getEntityNum());
                errorMsgMap.put(fieldPermInitModel.getRowNum(), errMsg);
                continue;
            }
            fieldPermInitModel.setAppId(appId);
        }
    }

    private void validateValueWithField(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        List fieldPermInitModelList = record.getFieldPermInitModelList();
        HashSet successEntityNumSet = Sets.newHashSetWithExpectedSize((int)fieldPermInitModelList.size());
        for (FieldPermInitModel fieldPermInitModel : fieldPermInitModelList) {
            successEntityNumSet.add(fieldPermInitModel.getEntityNum());
        }
        HashMap entityFieldMap = Maps.newHashMapWithExpectedSize((int)successEntityNumSet.size());
        for (String entityNum : successEntityNumSet) {
            Map<String, String> fieldMap = RoleServiceHelper.getEntityFieldMap(entityNum);
            entityFieldMap.put(entityNum, fieldMap);
        }
        for (FieldPermInitModel fieldPermInitModel : fieldPermInitModelList) {
            String errMsg;
            String entityNum = fieldPermInitModel.getEntityNum();
            String fieldNumber = fieldPermInitModel.getFieldNumber();
            Map fieldMap = (Map)entityFieldMap.get(entityNum);
            StringBuilder stringBuilder = new StringBuilder();
            if (fieldMap == null || !fieldMap.containsKey(fieldNumber)) {
                String errMsg2 = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u65e0\u201c%s\u201d\u5b57\u6bb5\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_40", (String)"hrmp-hrcs-business", (Object[])new Object[]{fieldNumber});
                stringBuilder.append(errMsg2).append("\n");
            }
            String view = fieldPermInitModel.getView();
            String edit = fieldPermInitModel.getEdit();
            String value0 = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"RoleTemplateExcelWriter_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            if (value0.equals(view) && !value0.equals(edit)) {
                String errMsg3 = ResManager.loadKDString((String)"\u5f53\u201c\u67e5\u770b\u201d\u5217\u7684\u503c\u4e3a\u201c\u4e0d\u5141\u8bb8\u201d\u65f6\uff0c\u53ea\u80fd\u5c06\u201c\u7f16\u8f91\u201d\u5217\u7684\u503c\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5141\u8bb8\u201d", (String)"PermRoleInitValidateService_43", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                stringBuilder.append(errMsg3).append("\n");
            }
            String value1 = ResManager.loadKDString((String)"\u5141\u8bb8", (String)"RoleTemplateExcelWriter_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            if (!value0.equals(view) && !value1.equals(view)) {
                errMsg = ResManager.loadKDString((String)"\u67e5\u770b\u5217\u503c\u9519\u8bef", (String)"PermRoleInitValidateService_45", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                stringBuilder.append(errMsg).append("\n");
            } else {
                fieldPermInitModel.setView(HRStringUtils.equals((String)view, (String)value0) ? "0" : "1");
            }
            if (!value0.equals(edit) && !value1.equals(edit)) {
                errMsg = ResManager.loadKDString((String)"\u7f16\u8f91\u5217\u503c\u9519\u8bef", (String)"PermRoleInitValidateService_46", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                stringBuilder.append(errMsg).append("\n");
            } else {
                fieldPermInitModel.setEdit(HRStringUtils.equals((String)edit, (String)value0) ? "0" : "1");
            }
            if (stringBuilder.length() <= 0) continue;
            errorMsgMap.put(fieldPermInitModel.getRowNum(), stringBuilder.toString());
        }
    }

    private void validateDuplicateWithField(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        List fieldPermInitModelList = record.getFieldPermInitModelList();
        ArrayList fieldStrList = Lists.newArrayListWithExpectedSize((int)fieldPermInitModelList.size());
        for (FieldPermInitModel fieldPermInitModel : fieldPermInitModelList) {
            fieldStrList.add(fieldPermInitModel.getRoleNumber() + "#" + fieldPermInitModel.getEntityNum() + "#" + fieldPermInitModel.getFieldNumber());
        }
        for (FieldPermInitModel fieldPermInitModel : fieldPermInitModelList) {
            String fieldStr = fieldPermInitModel.getRoleNumber() + "#" + fieldPermInitModel.getEntityNum() + "#" + fieldPermInitModel.getFieldNumber();
            if (fieldStrList.indexOf(fieldStr) == fieldStrList.lastIndexOf(fieldStr)) continue;
            String errMsg = ResManager.loadKDString((String)"\u89d2\u8272\u5728\u201c%s\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e0b\uff0c\u5b58\u5728\u76f8\u540c\u5b57\u6bb5\u5c5e\u6027\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_44", (String)"hrmp-hrcs-business", (Object[])new Object[]{fieldPermInitModel.getEntityNum()});
            errorMsgMap.put(fieldPermInitModel.getRowNum(), errMsg);
        }
    }

    private void validateRoleWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        List dataRangeInitModelList = record.getDataRangeInitModelList();
        List roleInitModelList = record.getRoleInitModelList();
        Set roleNumSet = roleInitModelList.stream().map(RoleInitModel::getRoleNumber).collect(Collectors.toSet());
        for (DataRangeInitModel dataRangeInitModel : dataRangeInitModelList) {
            String roleNumber = dataRangeInitModel.getRoleNumber();
            if (roleNumSet.contains(roleNumber)) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u201d\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u89d2\u8272\uff0c\u6216\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(dataRangeInitModel.getRowNum(), errMsg);
        }
    }

    private void validateFuncWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Set<String> successFuncSet = this.getSuccessFuncSet(record);
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            if (successFuncSet.contains(dataRangeInitModel.getRoleNumber())) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(dataRangeInitModel.getRowNum(), errMsg);
        }
    }

    private void validateDimWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record, DimInitValidateBO dimInitValidateBO) {
        Set errorRoleNumSet = dimInitValidateBO.getErrorRoleNumSet();
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            if (!errorRoleNumSet.contains(dataRangeInitModel.getRoleNumber())) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u7ef4\u5ea6\u201d\u9875\u7b7e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_30", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(dataRangeInitModel.getRowNum(), errMsg);
        }
    }

    private void validateBuWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Map<String, List<String>> roleAppEntityMap = this.getRoleAppEntityMap(record);
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            this.validateBuUncheck(roleAppEntityMap, errorMsgMap, Lists.newArrayList(), (DimAndDataRangeBaseModel)dataRangeInitModel);
        }
    }

    private void validateDimCheckWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Map dimMap;
        HashMap roleDimCheckedMap = Maps.newHashMapWithExpectedSize((int)record.getDimInitModelList().size());
        for (Object dimInitModel : record.getDimInitModelList()) {
            for (Map.Entry entry : dimInitModel.getDimCheckedMap().entrySet()) {
                DimInitCheckedBO value = (DimInitCheckedBO)entry.getValue();
                if (!Boolean.TRUE.equals(value.getCheck())) continue;
                String string = dimInitModel.getRoleNumber() + dimInitModel.getBuCaFuncName();
                dimMap = roleDimCheckedMap.getOrDefault(string, Maps.newHashMapWithExpectedSize((int)dimInitModel.getDimCheckedMap().size()));
                dimMap.put(value.getDimId(), value.getDimName());
                roleDimCheckedMap.put(string, dimMap);
            }
        }
        HashSet dimIdSet = Sets.newHashSetWithExpectedSize((int)record.getDataRangeInitModelList().size());
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            for (Map.Entry entry : structValueMap.entrySet()) {
                String[] split = ((String)entry.getKey()).split("#");
                dimIdSet.add(Long.parseLong(split[0]));
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dims = serviceHelper.queryOriginalArray("id,name,number,datasource", new QFilter[]{new QFilter("id", "in", (Object)dimIdSet)});
        this.dimMapById = Arrays.stream(dims).collect(Collectors.toMap(rs -> rs.getLong("id"), rs -> rs, (key1, key2) -> key2));
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            String string = dataRangeInitModel.getRoleNumber() + dataRangeInitModel.getBuCaFuncName();
            dimMap = (Map)roleDimCheckedMap.get(string);
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : structValueMap.entrySet()) {
                String[] split = ((String)entry.getKey()).split("#");
                if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                long dimId = Long.parseLong(split[0]);
                String name = this.dimMapById.get(dimId).getString("name");
                if (dimMap == null) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{name}));
                    continue;
                }
                if (dimMap.containsKey(dimId)) continue;
                stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{name}));
            }
            if (stringBuilder.length() <= 0) continue;
            errorMsgMap.put(dataRangeInitModel.getRowNum(), ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u7ef4\u5ea6\u672a\u52fe\u9009%s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_31", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()}));
        }
    }

    private void validateDimFillWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        String key;
        HashMap dimCheckedMap = Maps.newHashMapWithExpectedSize((int)record.getDimInitModelList().size());
        for (DimInitModel dimInitModel : record.getDimInitModelList()) {
            key = dimInitModel.getRoleNumber() + "#" + dimInitModel.getBuCaFuncName();
            for (Map.Entry entry : dimInitModel.getDimCheckedMap().entrySet()) {
                Set checkedDimNumSet = dimCheckedMap.getOrDefault(key, Sets.newHashSetWithExpectedSize((int)dimInitModel.getDimCheckedMap().size()));
                if (Boolean.TRUE.equals(((DimInitCheckedBO)entry.getValue()).getCheck())) {
                    checkedDimNumSet.add(entry.getKey());
                }
                dimCheckedMap.put(key, checkedDimNumSet);
            }
        }
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            key = dataRangeInitModel.getRoleNumber() + "#" + dataRangeInitModel.getBuCaFuncName();
            Set dimNumSet = (Set)dimCheckedMap.get(key);
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            ArrayList<String> errMsgList = new ArrayList<String>(2);
            if (!CollectionUtils.isEmpty((Collection)dimNumSet)) {
                StringBuilder stringBuilder = new StringBuilder();
                HashMap emptyDimMap = Maps.newHashMapWithExpectedSize((int)structValueMap.size());
                HashSet hasValueDimSet = Sets.newHashSetWithExpectedSize((int)structValueMap.size());
                for (Map.Entry entry : structValueMap.entrySet()) {
                    String[] split = ((String)entry.getKey()).split("#");
                    DynamicObject dim = this.dimMapById.get(Long.parseLong(split[0]));
                    String dimNum = dim.getString("number");
                    String dimName = dim.getString("name");
                    if (!dimNumSet.contains(dimNum)) continue;
                    if (split.length == 1) {
                        if (!HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                        stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimName}));
                        continue;
                    }
                    if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) {
                        emptyDimMap.put(dimNum, dimName);
                        continue;
                    }
                    hasValueDimSet.add(dimNum);
                }
                if (stringBuilder.length() > 0) {
                    errMsgList.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u201c%1$s\u201d\u4e0b\u9700\u8bbe\u7f6e%2$s\u8303\u56f4", (String)"PermRoleInitValidateService_32", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dataRangeInitModel.getBuCaFuncName(), stringBuilder));
                }
                for (String dimNum : hasValueDimSet) {
                    emptyDimMap.remove(dimNum);
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                for (Map.Entry entry : emptyDimMap.entrySet()) {
                    stringBuilder2.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{entry.getValue()}));
                }
                if (stringBuilder2.length() > 0) {
                    errMsgList.add(ResManager.loadKDString((String)"\u201c%s\u201d\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u7ec4\u7ec7\u67b6\u6784\u8303\u56f4", (String)"PermRoleInitValidateService_36", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder2.toString()}));
                }
            }
            if (CollectionUtils.isEmpty(errMsgList)) continue;
            errorMsgMap.put(dataRangeInitModel.getRowNum(), String.join((CharSequence)System.lineSeparator(), errMsgList));
        }
    }

    private void validateRangeValWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        List dataRangeInitModelList = record.getDataRangeInitModelList();
        HashSet orgNumSetAll = Sets.newHashSetWithExpectedSize((int)dataRangeInitModelList.size());
        HashMap dimValMap = Maps.newHashMapWithExpectedSize((int)dataRangeInitModelList.size());
        HashMap structNameMap = Maps.newHashMapWithExpectedSize((int)dataRangeInitModelList.size());
        HashMap orgNumSetAllContainsSub = Maps.newHashMapWithExpectedSize((int)16);
        for (DataRangeInitModel dataRangeInitModel : dataRangeInitModelList) {
            String orgRange = dataRangeInitModel.getOrgRange();
            Set<String> orgNumSet = this.dealValueCode(orgRange);
            Map<String, String> orgNumSetContainsSub = PermRoleInitValidateService.dealValueCodeContainsSub(orgRange);
            orgNumSetAllContainsSub.put(orgRange, orgNumSetContainsSub);
            orgNumSetAll.addAll(orgNumSet);
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            for (Map.Entry entry : structValueMap.entrySet()) {
                if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                Set<String> dimValSet = this.dealValueCode((String)entry.getValue());
                String[] split = ((String)entry.getKey()).split("#");
                List dimValList = dimValMap.getOrDefault(entry.getKey(), Lists.newArrayListWithExpectedSize((int)16));
                dimValList.addAll(dimValSet);
                dimValMap.put(entry.getKey(), dimValList);
                if (split.length <= 1) continue;
                structNameMap.put(Long.parseLong(split[1]), null);
            }
        }
        HashMap oTDimValueMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Map<String, String>> resultMap = PermInitServiceHelper.structDimInfoByNumber(dimValMap, oTDimValueMap);
        Map<String, Pair<String, String>> dimInfoMap = PermInitServiceHelper.getDimTypeMap(dimValMap.keySet());
        List<String> allDynaCondNumbers = PermInitServiceHelper.getAllDynaCondNumbers();
        LOGGER.info("validateRangeValWithDataRange allDynaCondNumbers={}", allDynaCondNumbers);
        Map<String, List<String>> dimDynaRangeMap = PermInitServiceHelper.getDimDynaRangeMap(dimValMap.keySet());
        Map<String, Long> allDynaCondMap = PermInitServiceHelper.getAllDynaCondMap();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org");
        DynamicObject[] org = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("number", "in", (Object)orgNumSetAll)});
        Map<String, Long> orgMap = Arrays.stream(org).collect(Collectors.toMap(og -> og.getString("number"), og -> og.getLong("id")));
        HRBaseServiceHelper structServiceHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] struct = structServiceHelper.query("id,number,relyonstructproject", new QFilter[]{new QFilter("id", "in", structNameMap.keySet())});
        for (DynamicObject dyn : struct) {
            String name = dyn.getString("name");
            long relyId = dyn.getLong("relyonstructproject.id");
            structNameMap.put(dyn.getLong("id"), Pair.of((Object)name, (Object)relyId));
        }
        for (DataRangeInitModel dataRangeInitModel : dataRangeInitModelList) {
            String errorTip;
            String orgRange = dataRangeInitModel.getOrgRange();
            Set<String> orgNumSet = this.dealValueCode(orgRange);
            StringBuilder orgNumcontainsSubNotRightErrMsg = new StringBuilder();
            this.setNotRightContainsSubMsg(orgNumSet, orgNumcontainsSubNotRightErrMsg);
            Map orgRangeMap = (Map)orgNumSetAllContainsSub.get(orgRange);
            HashMap orgIdRangeMapContainsSub = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList orgRangeList = Lists.newArrayListWithExpectedSize((int)orgNumSet.size());
            String errMsg = null;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder orgDynaExistErrMsg = new StringBuilder();
            StringBuilder orgDynaRightErrMsg = new StringBuilder();
            StringBuilder orgRangeErrorMsgBu = new StringBuilder();
            for (String orgNum : orgNumSet) {
                LOGGER.info("validateRangeValWithDataRange orgnum 666 dimValNum={}", (Object)orgNum);
                if (orgNum.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                    if (!allDynaCondNumbers.contains(orgNum)) {
                        LOGGER.info("validateRangeValWithDataRange orgnum dimValNum={}", (Object)orgNum);
                        orgDynaExistErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{orgNum}));
                        continue;
                    }
                    orgDynaRightErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{orgNum}));
                    continue;
                }
                Long orgId = orgMap.get(orgNum);
                if (orgId == null || orgId == 0L) {
                    stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{orgNum}));
                    continue;
                }
                orgRangeList.add(orgId);
                orgIdRangeMapContainsSub.put(orgId, orgRangeMap.get(orgNum));
            }
            dataRangeInitModel.setOrgRangeList((List)orgRangeList);
            dataRangeInitModel.setOrgRangeContainsSubMap((Map)orgIdRangeMapContainsSub);
            if (orgNumcontainsSubNotRightErrMsg.length() > 0) {
                errorTip = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u201d\uff1a%s\u7f16\u7801\u503c\u4e0d\u5b58\u5728\u6216\u5305\u542b\u4e0b\u7ea7\u5f55\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_54", (String)"hrmp-hrcs-business", (Object[])new Object[]{orgNumcontainsSubNotRightErrMsg.toString()}) + "\n";
                orgRangeErrorMsgBu.append(errorTip);
            }
            if (stringBuilder.length() > 0) {
                errorTip = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u201d\uff1a%s\u7f16\u7801\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_53", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()}) + "\n";
                orgRangeErrorMsgBu.append(errorTip);
            }
            if (orgDynaExistErrMsg.length() > 0) {
                errorTip = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u201d\uff1a%s\u7f16\u7801\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_53", (String)"hrmp-hrcs-business", (Object[])new Object[]{orgDynaExistErrMsg.toString()}) + "\n";
                orgRangeErrorMsgBu.append(errorTip);
            }
            if (orgDynaRightErrMsg.length() > 0) {
                errorTip = ResManager.loadKDString((String)"\u52a8\u6001\u6570\u636e\u8303\u56f4%s\u4e0d\u9002\u7528\u4e8e\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_81", (String)"hrmp-hrcs-business", (Object[])new Object[]{orgDynaRightErrMsg.toString()}) + "\n";
                orgRangeErrorMsgBu.append(errorTip);
            }
            if (orgRangeErrorMsgBu.length() > 0) {
                errMsg = orgRangeErrorMsgBu.toString();
            }
            Map structValueMap = dataRangeInitModel.getStructValueMap();
            ArrayList dimValues = Lists.newArrayListWithExpectedSize((int)structValueMap.size());
            StringBuilder stringBuilderDimValError = new StringBuilder();
            for (Map.Entry entry : structValueMap.entrySet()) {
                DimValueBean dimValueBean;
                String key;
                if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                StringBuilder stringBuilderDimVal = new StringBuilder();
                StringBuilder dimContainsSubErrMsg = new StringBuilder();
                StringBuilder dimDynaCondExistErrMsg = new StringBuilder();
                StringBuilder dimDynaCondRightErrMsg = new StringBuilder();
                StringBuilder noLimitErrMsg = new StringBuilder();
                StringBuilder containsSubNotRightErrMsg = new StringBuilder();
                String[] split = ((String)entry.getKey()).split("#");
                Long dimId = Long.parseLong(split[0]);
                Set<String> dimValSet = this.dealValueCode((String)entry.getValue());
                this.setNotRightContainsSubMsg(dimValSet, containsSubNotRightErrMsg);
                Map<String, String> dimValSetContainsSub = PermRoleInitValidateService.dealValueCodeContainsSub((String)entry.getValue());
                if (split.length > 1) {
                    long structId = Long.parseLong(split[1]);
                    long relyStructId = (Long)((Pair)structNameMap.get(structId)).getRight();
                    key = this.dimMapById.get(dimId).getString("name") + "_" + (String)((Pair)structNameMap.get(structId)).getLeft();
                    List triples = (List)oTDimValueMap.get(dimId);
                    if (triples == null) {
                        for (String string : dimValSet) {
                            if (string.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                                LOGGER.info("validateRangeValWithDataRange 746 dimValNum={}", (Object)string);
                                dimValueBean = new DimValueBean(dimId, allDynaCondMap.get(string) == null ? "" : allDynaCondMap.get(string).toString());
                                dimValueBean.setContainsSub(false);
                                dimValueBean.setStructProjectId(Long.valueOf(structId));
                                dimValueBean.setDynacondId(allDynaCondMap.get(string));
                                dimValueBean.setValueType("2");
                                dimValues.add(dimValueBean);
                                continue;
                            }
                            stringBuilderDimVal.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{string}));
                        }
                    } else {
                        HashMap otStructMap = Maps.newHashMapWithExpectedSize((int)triples.size());
                        for (Triple triple : triples) {
                            Map tripleMap = otStructMap.getOrDefault(triple.getMiddle(), Maps.newHashMapWithExpectedSize((int)triples.size()));
                            tripleMap.put(triple.getLeft(), triple.getRight());
                            otStructMap.put(triple.getMiddle(), tripleMap);
                        }
                        for (String dimValNum2 : dimValSet) {
                            LOGGER.info("validateRangeValWithDataRange 729 dimValNum={}", (Object)dimValNum2);
                            if (dimValNum2.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                                if (!allDynaCondNumbers.contains(dimValNum2)) {
                                    LOGGER.info("validateRangeValWithDataRange struct dimValNum={}", (Object)dimValNum2);
                                    dimDynaCondExistErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum2}));
                                    continue;
                                }
                                List<String> rightDyanconds = dimDynaRangeMap.get(entry.getKey());
                                if (!rightDyanconds.contains(dimValNum2)) {
                                    dimDynaCondRightErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum2}));
                                    continue;
                                }
                                DimValueBean dimValueBean2 = new DimValueBean(dimId, allDynaCondMap.get(dimValNum2) == null ? "" : allDynaCondMap.get(dimValNum2).toString());
                                dimValueBean2.setContainsSub(HRStringUtils.equals((String)"1", (String)dimValSetContainsSub.get(dimValNum2)));
                                dimValueBean2.setStructProjectId(Long.valueOf(structId));
                                dimValueBean2.setDynacondId(allDynaCondMap.get(dimValNum2));
                                dimValueBean2.setValueType("2");
                                dimValues.add(dimValueBean2);
                                continue;
                            }
                            Map structMap = (Map)otStructMap.get(dimValNum2);
                            if (structMap == null) {
                                stringBuilderDimVal.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum2}));
                                continue;
                            }
                            if (structMap.get(structId) == null && structMap.get(relyStructId) == null) {
                                stringBuilderDimVal.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum2}));
                                continue;
                            }
                            Long dimVal = (Long)structMap.get(structId);
                            if (dimVal == null) {
                                dimVal = (Long)structMap.get(relyStructId);
                            }
                            DimValueBean dimValueBean3 = new DimValueBean(dimId, dimVal.toString());
                            dimValueBean3.setValueType("1");
                            dimValueBean3.setContainsSub(HRStringUtils.equals((String)"1", (String)dimValSetContainsSub.get(dimValNum2)));
                            dimValueBean3.setStructProjectId(Long.valueOf(structId));
                            dimValues.add(dimValueBean3);
                        }
                    }
                } else {
                    key = this.dimMapById.get(dimId).getString("name");
                    Pair<String, String> dimInfoWithType = dimInfoMap.get(dimId.toString());
                    Map<String, String> dimValNumMap = resultMap.get(dimId.toString());
                    if (dimValNumMap != null) {
                        for (String dimValNum : dimValSet) {
                            LOGGER.info("validateRangeValWithDataRange 774 dimValNum={}", (Object)dimValNum);
                            if (dimValNum.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                                if (!allDynaCondNumbers.contains(dimValNum)) {
                                    LOGGER.info("validateRangeValWithDataRange dimValNum={}", (Object)dimValNum);
                                    dimDynaCondExistErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum}));
                                    continue;
                                }
                                List<String> rightDyanconds = dimDynaRangeMap.get(dimId.toString());
                                if (!rightDyanconds.contains(dimValNum)) {
                                    dimDynaCondRightErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum}));
                                    continue;
                                }
                                DimValueBean dimValueBean4 = new DimValueBean(dimId, allDynaCondMap.get(dimValNum) == null ? "" : allDynaCondMap.get(dimValNum).toString());
                                dimValueBean4.setDynacondId(allDynaCondMap.get(dimValNum));
                                dimValueBean4.setValueType("2");
                                dimValues.add(dimValueBean4);
                                continue;
                            }
                            String dimVal = dimValNumMap.get(dimValNum);
                            String containsSub = dimValSetContainsSub.get(dimValNum);
                            if (HRStringUtils.isEmpty((String)dimVal)) {
                                String string = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PermRoleInitValidateService_47", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                                if (HRStringUtils.equals((String)string, (String)dimValNum) || HRStringUtils.equals((String)"all", (String)dimValNum.toLowerCase())) {
                                    if (dimValSet.size() > 1) {
                                        noLimitErrMsg.append(ResManager.loadKDString((String)"\u201c\u4e0d\u9650\u201d\u4e0e\u5177\u4f53\u7684\u7ef4\u5ea6\u503c\u4e0d\u5141\u8bb8\u540c\u65f6\u5f55\u5165\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_55", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                                        break;
                                    }
                                    dimValueBean = new DimValueBean();
                                    dimValueBean.setDimId(dimId);
                                    dimValueBean.setAll(true);
                                    dimValueBean.setValueType("1");
                                    dimValueBean.setContainsSub(HRStringUtils.equals((String)"1", (String)containsSub));
                                    dimValues.add(dimValueBean);
                                    continue;
                                }
                                stringBuilderDimVal.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum}));
                                continue;
                            }
                            if (PermInitServiceHelper.checkBaseDataTreeContainsSub(dimInfoWithType)) {
                                if (HRStringUtils.equals((String)"1", (String)containsSub)) {
                                    dimContainsSubErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimValNum}));
                                    continue;
                                }
                                String string = this.dimMapById.get(dimId).getString("datasource");
                                if ("enum".equals(string)) {
                                    dimVal = dimValNum;
                                }
                                dimValueBean = new DimValueBean(dimId, dimVal);
                                dimValueBean.setValueType("1");
                                dimValueBean.setContainsSub(HRStringUtils.equals((String)"1", (String)containsSub));
                                dimValues.add(dimValueBean);
                                continue;
                            }
                            String string = this.dimMapById.get(dimId).getString("datasource");
                            if ("enum".equals(string)) {
                                dimVal = dimValNum;
                            }
                            dimValueBean = new DimValueBean(dimId, dimVal);
                            dimValueBean.setValueType("1");
                            dimValueBean.setContainsSub(HRStringUtils.equals((String)"1", (String)containsSub));
                            dimValues.add(dimValueBean);
                        }
                    }
                }
                if (noLimitErrMsg.length() > 0) {
                    String notLimitErrorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a%2$s", (String)"PermRoleInitValidateService_51", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key, noLimitErrMsg.toString());
                    stringBuilderDimValError.append(notLimitErrorMsg).append("\n");
                }
                if (containsSubNotRightErrMsg.length() > 0) {
                    String dimValErrorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a%2$s\u7f16\u7801\u503c\u4e0d\u5b58\u5728\u6216\u5305\u542b\u4e0b\u7ea7\u5f55\u5165\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_56", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key, containsSubNotRightErrMsg.toString());
                    stringBuilderDimValError.append(dimValErrorMsg).append("\n");
                }
                if (stringBuilderDimVal.length() > 0) {
                    String dimValErrorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684%2$s\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_34", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key, stringBuilderDimVal.toString());
                    stringBuilderDimValError.append(dimValErrorMsg).append("\n");
                }
                if (dimContainsSubErrMsg.length() > 0) {
                    String dimValErrorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ef4\u5ea6\u4e0d\u652f\u6301\u5305\u542b\u4e0b\u7ea7\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_80", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key);
                    stringBuilderDimValError.append(dimValErrorMsg).append("\n");
                }
                if (dimDynaCondExistErrMsg.length() > 0) {
                    String dimValErrorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u7684\u52a8\u6001\u6570\u636e\u8303\u56f4%2$s\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_83", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key, dimDynaCondExistErrMsg.toString());
                    stringBuilderDimValError.append(dimValErrorMsg).append("\n");
                }
                if (dimDynaCondRightErrMsg.length() <= 0) continue;
                String dimValErrorMsg = String.format(ResManager.loadKDString((String)"\u52a8\u6001\u6570\u636e\u8303\u56f4%1$s\u4e0d\u9002\u7528\u4e8e\u201d%2$s\u201d\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5", (String)"PermInitImportValidateService_82", (String)"hrmp-hrcs-business", (Object[])new Object[0]), dimDynaCondRightErrMsg.toString(), key);
                stringBuilderDimValError.append(dimValErrorMsg).append("\n");
            }
            if (stringBuilderDimValError.length() > 0) {
                String stringBuilderDimValErrorMsg = stringBuilderDimValError.toString();
                errMsg = errMsg == null ? "" : errMsg;
                errMsg = errMsg + stringBuilderDimValErrorMsg;
            }
            if (!HRStringUtils.isEmpty((String)errMsg)) {
                errorMsgMap.put(dataRangeInitModel.getRowNum(), errMsg);
            }
            dataRangeInitModel.setDimValues((List)dimValues);
        }
    }

    private void setNotRightContainsSubMsg(Set<String> orgNumSet, StringBuilder orgNumcontainsSubNotRightErrMsg) {
        Iterator<String> iterator = orgNumSet.iterator();
        HashSet containsSubNotRightSet = Sets.newHashSetWithExpectedSize((int)16);
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!PermInitServiceHelper.isRightContainsSub(next)) continue;
            containsSubNotRightSet.add(next);
            iterator.remove();
        }
        for (String containsSubNotRight : containsSubNotRightSet) {
            orgNumcontainsSubNotRightErrMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{containsSubNotRight}));
        }
    }

    private void validateDiffWithDataRange(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        String key;
        List dataRangeInitModelList = record.getDataRangeInitModelList();
        HashMap roleBuOrgMap = Maps.newHashMapWithExpectedSize((int)dataRangeInitModelList.size());
        HashSet diffSet = Sets.newHashSetWithExpectedSize((int)dataRangeInitModelList.size());
        for (DataRangeInitModel dataRangeInitModel : dataRangeInitModelList) {
            key = dataRangeInitModel.getRoleNumber() + dataRangeInitModel.getBuCaFuncName();
            String orgRange = (String)roleBuOrgMap.get(key);
            if (HRStringUtils.isEmpty((String)orgRange)) {
                roleBuOrgMap.put(key, dataRangeInitModel.getOrgRange());
                continue;
            }
            if (HRStringUtils.equals((String)orgRange, (String)dataRangeInitModel.getOrgRange())) continue;
            diffSet.add(key);
        }
        for (DataRangeInitModel dataRangeInitModel : dataRangeInitModelList) {
            key = dataRangeInitModel.getRoleNumber() + dataRangeInitModel.getBuCaFuncName();
            if (!diffSet.contains(key)) continue;
            errorMsgMap.put(dataRangeInitModel.getRowNum(), ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u804c\u80fd\u4e0b\uff0c\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\u4e0d\u4e00\u81f4", (String)"PermRoleInitValidateService_35", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    private Map<DimAndDataRangeBaseModel, String> validateLackWithDataRange(PermRoleInitRecord record, List<PermInitBaseModel> removeList, Map<String, Integer> roleRowNumMap) {
        HashMap removeMap = Maps.newHashMapWithExpectedSize((int)removeList.size());
        for (PermInitBaseModel permInitBaseModel : removeList) {
            DataRangeInitModel dataRangeInitModel = (DataRangeInitModel)permInitBaseModel;
            if (dataRangeInitModel == null) continue;
            Set funcSet = removeMap.getOrDefault(dataRangeInitModel.getRoleNumber(), Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size()));
            funcSet.add(dataRangeInitModel.getBuCaFuncName());
            removeMap.put(dataRangeInitModel.getRoleNumber(), funcSet);
        }
        HashMap roleNumFuncMap = Maps.newHashMapWithExpectedSize((int)record.getDataRangeInitModelList().size());
        for (DataRangeInitModel dataRangeInitModel : record.getDataRangeInitModelList()) {
            String roleNumber = dataRangeInitModel.getRoleNumber();
            String buCaFuncName = dataRangeInitModel.getBuCaFuncName();
            Set funcErrorSet = (Set)removeMap.get(roleNumber);
            Set funcSet = roleNumFuncMap.getOrDefault(roleNumber, Sets.newHashSetWithExpectedSize((int)record.getDataRangeInitModelList().size()));
            funcSet.add(buCaFuncName);
            if (funcErrorSet != null) {
                funcSet.addAll(funcErrorSet);
            }
            roleNumFuncMap.put(roleNumber, funcSet);
        }
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap roleFuncMap = Maps.newHashMapWithExpectedSize((int)record.getFunctionItemInitModelList().size());
        for (FunctionItemInitModel functionItemInitModel : record.getFunctionItemInitModelList()) {
            String entityNum = functionItemInitModel.getEntityNum();
            Map<String, DynamicObject> entityFuncMap = this.funcMap.get(functionItemInitModel.getAppId());
            DynamicObject func = entityFuncMap.get(entityNum);
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            String buFuncName = func.getString("name");
            long buCaFuncId = func.getLong("id");
            for (Map.Entry entry : roleCheckedMap.entrySet()) {
                if (!Boolean.TRUE.equals(((Pair)entry.getValue()).getValue())) continue;
                Map funcMap = roleFuncMap.getOrDefault(entry.getKey(), Maps.newHashMapWithExpectedSize((int)roleCheckedMap.size()));
                funcMap.put(buFuncName, buCaFuncId);
                roleFuncMap.put(entry.getKey(), funcMap);
            }
        }
        List roleInitModelList = record.getRoleInitModelList();
        for (RoleInitModel roleInitModel : roleInitModelList) {
            Long buCaFuncId;
            String buFuncName;
            Map funcMap;
            String rolePropertyValue = roleInitModel.getRolePropertyValue();
            String roleNumber = roleInitModel.getRoleNumber();
            String roleName = roleInitModel.getRoleName().getLocaleValue();
            if ("0".equals(rolePropertyValue)) {
                Set removeFuncSet = (Set)removeMap.get(roleNumber);
                funcMap = (Map)roleFuncMap.get(roleNumber);
                if (funcMap == null) continue;
                for (Map.Entry entry : funcMap.entrySet()) {
                    String errMsg;
                    buFuncName = (String)entry.getKey();
                    buCaFuncId = (Long)entry.getValue();
                    if (removeFuncSet != null && removeFuncSet.contains(buFuncName)) continue;
                    Set funcSet = (Set)roleNumFuncMap.get(roleNumber);
                    if (funcSet == null) {
                        errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u5728\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u4e2d\u8bbe\u7f6e\u4e86\u201c\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\uff1b", (String)"PermRoleInitValidateService_37", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                        this.addLackMsgByDataRange(roleNumber, roleName, buFuncName, buCaFuncId, null, errMsg, hashMap);
                        continue;
                    }
                    if (funcSet.contains(buFuncName)) continue;
                    errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u7f3a\u5c11\u201c%s\u201d\uff0c\u8bf7\u8865\u5145\u6570\u636e\u8303\u56f4", (String)"PermRoleInitValidateService_38", (String)"hrmp-hrcs-business", (Object[])new Object[]{buFuncName});
                    this.addLackMsgByDataRange(roleNumber, roleName, buFuncName, buCaFuncId, roleRowNumMap.get(roleNumber), errMsg, hashMap);
                }
                continue;
            }
            Set funcSet = (Set)roleNumFuncMap.get(roleNumber);
            funcMap = (Map)roleFuncMap.get(roleNumber);
            if (funcSet == null || funcMap == null) continue;
            for (Map.Entry entry : funcMap.entrySet()) {
                buFuncName = (String)entry.getKey();
                buCaFuncId = (Long)entry.getValue();
                if (funcSet.contains(buFuncName)) continue;
                String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u7f3a\u5c11\u201c%s\u201d\uff0c\u8bf7\u8865\u5145\u6570\u636e\u8303\u56f4", (String)"PermRoleInitValidateService_38", (String)"hrmp-hrcs-business", (Object[])new Object[]{buFuncName});
                this.addLackMsgByDataRange(roleNumber, roleName, buFuncName, buCaFuncId, roleRowNumMap.get(roleNumber), errMsg, hashMap);
            }
        }
        return hashMap;
    }

    private void validateRoleWithDim(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        List dimInitModelList = record.getDimInitModelList();
        List roleInitModelList = record.getRoleInitModelList();
        Set roleNumSet = roleInitModelList.stream().map(RoleInitModel::getRoleNumber).collect(Collectors.toSet());
        for (DimInitModel dimInitModel : dimInitModelList) {
            String roleNumber = dimInitModel.getRoleNumber();
            if (roleNumSet.contains(roleNumber)) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u201d\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u89d2\u8272\uff0c\u6216\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(dimInitModel.getRowNum(), errMsg);
        }
    }

    private void validateFuncWithDim(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Set<String> successFuncSet = this.getSuccessFuncSet(record);
        for (DimInitModel dimInitModel : record.getDimInitModelList()) {
            if (successFuncSet.contains(dimInitModel.getRoleNumber())) continue;
            String errMsg = ResManager.loadKDString((String)"\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errorMsgMap.put(dimInitModel.getRowNum(), errMsg);
        }
    }

    private void validateBuWithDim(Map<Integer, String> errorMsgMap, PermRoleInitRecord record) {
        Map<String, List<String>> roleAppEntityMap = this.getRoleAppEntityMap(record);
        ArrayList roleFuncList = Lists.newArrayListWithExpectedSize((int)record.getDimInitModelList().size());
        for (DimInitModel dimInitModel : record.getDimInitModelList()) {
            this.validateBuUncheck(roleAppEntityMap, errorMsgMap, roleFuncList, (DimAndDataRangeBaseModel)dimInitModel);
        }
        for (DimInitModel dimInitModel : record.getDimInitModelList()) {
            String roleNumber = dimInitModel.getRoleNumber();
            String buCaFuncName = dimInitModel.getBuCaFuncName();
            String key = roleNumber + "#" + buCaFuncName;
            if (roleFuncList.indexOf(key) == roleFuncList.lastIndexOf(key)) continue;
            String errMsg = errorMsgMap.get(dimInitModel.getRowNum());
            String dupErrMsg = ResManager.loadKDString((String)"\u89d2\u8272\u804c\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_24", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            if (!HRStringUtils.isEmpty((String)errMsg)) {
                dupErrMsg = errMsg + "\n" + dupErrMsg;
            }
            errorMsgMap.put(dimInitModel.getRowNum(), dupErrMsg);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateCheckedDim(Map<Integer, String> errorMsgMap, PermRoleInitRecord record, Map<String, DynamicObject> dimMap) {
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        this.roleFuncMap = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            String entityNum = functionItemInitModel.getEntityNum();
            Map<String, DynamicObject> entityFuncMap = this.funcMap.get(functionItemInitModel.getAppId());
            DynamicObject func = entityFuncMap.get(entityNum);
            DynamicObject dim = dimMap.get(entityNum);
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            for (Map.Entry entry : roleCheckedMap.entrySet()) {
                String string = (String)entry.getKey();
                String key = string + "#" + func.getString("name");
                Pair value = (Pair)entry.getValue();
                if (!Boolean.TRUE.equals(value.getValue()) || dim == null) continue;
                DynamicObjectCollection rows = dim.getDynamicObjectCollection("entryentity");
                Map<String, Boolean> dimIsMustMap = this.roleFuncMap.getOrDefault(key, Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size()));
                for (DynamicObject row : rows) {
                    String number = row.getString("dimension.number");
                    Boolean isMust = dimIsMustMap.get(number);
                    if (isMust == null || Boolean.FALSE.equals(isMust)) {
                        dimIsMustMap.put(number, row.getBoolean("ismust"));
                    }
                    this.roleFuncMap.put(key, dimIsMustMap);
                }
            }
        }
        for (DimInitModel dimInitModel : record.getDimInitModelList()) {
            void var13_18;
            String roleNumber = dimInitModel.getRoleNumber();
            String buCaFuncName = dimInitModel.getBuCaFuncName();
            String key = roleNumber + "#" + buCaFuncName;
            Map<String, Boolean> dimIsMustMap = this.roleFuncMap.get(key);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Map.Entry entry : dimInitModel.getDimCheckedMap().entrySet()) {
                Boolean isMust;
                if (Boolean.TRUE.equals(((DimInitCheckedBO)entry.getValue()).getCheck())) {
                    if (dimIsMustMap != null && dimIsMustMap.containsKey(entry.getKey())) continue;
                    stringBuilder2.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{((DimInitCheckedBO)entry.getValue()).getDimName()}));
                    continue;
                }
                if (dimIsMustMap == null || !Boolean.TRUE.equals(isMust = dimIsMustMap.get(entry.getKey()))) continue;
                stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{((DimInitCheckedBO)entry.getValue()).getDimName()}));
            }
            if (stringBuilder.length() > 0) {
                errorMsgMap.put(dimInitModel.getRowNum(), ResManager.loadKDString((String)"\u89d2\u8272\u9700\u52fe\u9009%s", (String)"PermRoleInitValidateService_25", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()}));
            }
            if (stringBuilder2.length() <= 0) continue;
            String string = ResManager.loadKDString((String)"\u6839\u636e\u89d2\u8272\u529f\u80fd\u6743\u9650\u548c\u7cfb\u7edf\u4e1a\u52a1\u5bf9\u8c61\u7ef4\u5ea6\u6620\u5c04\u914d\u7f6e\uff0c\u68c0\u6d4b\u89d2\u8272\u65e0\u9700\u52fe\u9009%s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PermRoleInitValidateService_26", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder2.toString()});
            String string2 = errorMsgMap.get(dimInitModel.getRowNum());
            if (!HRStringUtils.isEmpty((String)string2)) {
                String string3 = string2 + "\n" + string;
            }
            errorMsgMap.put(dimInitModel.getRowNum(), (String)var13_18);
        }
    }

    private DimInitValidateBO validateLack(PermRoleInitRecord record, Map<String, DynamicObject> dimMap, List<PermInitBaseModel> removeList, Map<String, Integer> roleRowNumMap) {
        HashMap dimNameMap = Maps.newHashMapWithExpectedSize((int)dimMap.size());
        dimMap.forEach((key, value) -> {
            DynamicObjectCollection dimEntry = value.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : dimEntry) {
                String name = row.getString("dimension.name");
                String number = row.getString("dimension.number");
                dimNameMap.put(number, name);
            }
        });
        HashMap roleNameMap = Maps.newHashMapWithExpectedSize((int)record.getFunctionItemInitModelList().size());
        List roleInitModelList = record.getRoleInitModelList();
        for (RoleInitModel roleInitModel : roleInitModelList) {
            roleNameMap.put(roleInitModel.getRoleNumber(), roleInitModel.getRoleName().getLocaleValue());
        }
        HashMap lackMsgMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap dmRoleSet = Maps.newHashMapWithExpectedSize((int)record.getDimInitModelList().size());
        for (Object dimInitModel : record.getDimInitModelList()) {
            Set set = dmRoleSet.getOrDefault(dimInitModel.getRoleNumber(), Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size()));
            set.add(dimInitModel.getBuCaFuncName());
            dmRoleSet.put(dimInitModel.getRoleNumber(), set);
        }
        HashMap removeMap = Maps.newHashMapWithExpectedSize((int)removeList.size());
        for (PermInitBaseModel permInitBaseModel : removeList) {
            DimInitModel dimInitModel = (DimInitModel)permInitBaseModel;
            if (dimInitModel == null) continue;
            Set funcSet = removeMap.getOrDefault(dimInitModel.getRoleNumber(), Sets.newHashSetWithExpectedSize((int)record.getDimInitModelList().size()));
            funcSet.add(dimInitModel.getBuCaFuncName());
            removeMap.put(dimInitModel.getRoleNumber(), funcSet);
        }
        for (Map.Entry entry : this.roleFuncMap.entrySet()) {
            String[] split = ((String)entry.getKey()).split("#");
            String roleNum = split[0];
            String funcName = split[1];
            Set funcSet = (Set)dmRoleSet.get(roleNum);
            Set removeFuncSet = (Set)removeMap.get(roleNum);
            if (removeFuncSet != null && removeFuncSet.contains(funcName)) continue;
            if (funcSet == null) {
                Map value2 = (Map)entry.getValue();
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry isMustEntry : value2.entrySet()) {
                    if (!Boolean.TRUE.equals(isMustEntry.getValue())) continue;
                    stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimNameMap.get(isMustEntry.getKey())}));
                }
                if (stringBuilder.length() <= 0) continue;
                DimInitModel dimInitModel = new DimInitModel(roleNum, (String)roleNameMap.get(roleNum), funcName, null);
                String errMsg = ResManager.loadKDString((String)"\u89d2\u8272\u9700\u52fe\u9009%s", (String)"PermRoleInitValidateService_25", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()});
                lackMsgMap.put(dimInitModel, errMsg);
                continue;
            }
            if (funcSet.contains(funcName)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            Map value3 = (Map)entry.getValue();
            for (Map.Entry isMustEntry : value3.entrySet()) {
                if (!Boolean.TRUE.equals(isMustEntry.getValue())) continue;
                stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{dimNameMap.get(isMustEntry.getKey())}));
            }
            if (stringBuilder.length() <= 0) continue;
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u804c\u80fd\u4e0b\u672a\u52fe\u9009%s", (String)"PermRoleInitValidateService_27", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()});
            DimInitModel dimInitModel = new DimInitModel(roleNum, (String)roleNameMap.get(roleNum), funcName, null);
            dimInitModel.setRowNum(roleRowNumMap.get(roleNum));
            lackMsgMap.put(dimInitModel, errMsg);
        }
        DimInitValidateBO dimInitValidateBO = new DimInitValidateBO();
        dimInitValidateBO.setLackMsgMap((Map)lackMsgMap);
        return dimInitValidateBO;
    }

    private void validateFuncItem(Map<Integer, Map<Integer, String>> errMsgMap, PermRoleInitRecord record) {
        List entityNumList;
        String appId;
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashMap appEntityMap = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            String appNum = functionItemInitModel.getAppNum();
            DynamicObject[] entityNum = functionItemInitModel.getEntityNum();
            List entityNumList2 = appEntityMap.getOrDefault(appNum, Lists.newArrayListWithExpectedSize((int)functionItemInitModelList.size()));
            entityNumList2.add(entityNum);
            appEntityMap.put(appNum, entityNumList2);
            entityNumSet.add(entityNum);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_bizobjapp");
        DynamicObject[] appEntityRel = serviceHelper.query("id,bizobj,bizapp", new QFilter[]{new QFilter("bizapp.number", "in", appEntityMap.keySet())});
        HashMap appEntityRelMap = Maps.newHashMapWithExpectedSize((int)appEntityRel.length);
        for (DynamicObject rel : appEntityRel) {
            DynamicObject[] appId2 = rel.getString("bizapp.id");
            String string = rel.getString("bizobj.number");
            List entityNumList3 = appEntityRelMap.getOrDefault(appId2, Lists.newArrayListWithExpectedSize((int)appEntityRel.length));
            entityNumList3.add(string);
            appEntityRelMap.put(appId2, entityNumList3);
        }
        Map<String, DynamicObject> hrAppMap = this.funcService.getHRAppMap();
        HRBaseServiceHelper serviceHelper2 = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] entities = serviceHelper2.queryOriginalArray("id,bizappid", new QFilter[]{new QFilter("number", "in", (Object)entityNumSet)});
        HashMap appEntityDBMap = Maps.newHashMapWithExpectedSize((int)appEntityRel.length);
        for (DynamicObject entity : entities) {
            appId = entity.getString("bizappid");
            DynamicObject app = hrAppMap.get(appId);
            if (app == null) continue;
            String masterId = app.getString("masterid");
            if (!HRStringUtils.isEmpty((String)masterId)) {
                appId = masterId;
            }
            String entityNum = entity.getString("id");
            entityNumList = appEntityDBMap.getOrDefault(appId, Lists.newArrayListWithExpectedSize((int)appEntityRel.length));
            entityNumList.add(entityNum);
            appEntityDBMap.put(appId, entityNumList);
        }
        this.appIdMap = Maps.newHashMapWithExpectedSize((int)hrAppMap.size());
        for (Map.Entry entry : hrAppMap.entrySet()) {
            this.appIdMap.put(((DynamicObject)entry.getValue()).getString("number"), (String)entry.getKey());
        }
        Map<String, List<DynamicObject>> hrFuncItemGroup = this.funcService.getHRFuncItemGroup(entityNumSet);
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            String appNum = functionItemInitModel.getAppNum();
            appId = this.appIdMap.get(appNum);
            String errMsg = null;
            if (HRStringUtils.isEmpty((String)appId)) {
                errMsg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u201c\u5e94\u7528\u7f16\u7801\u201d\u201c\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201d\u201c\u6743\u9650\u9879\u201d", (String)"PermRoleInitValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            } else {
                functionItemInitModel.setAppId(appId);
                String entityNum = functionItemInitModel.getEntityNum();
                List entityNumRelList = (List)appEntityRelMap.get(appId);
                entityNumList = (List)appEntityDBMap.get(appId);
                if (entityNumRelList != null && entityNumRelList.contains(entityNum) || entityNumList != null && entityNumList.contains(entityNum)) {
                    List<DynamicObject> itemList = hrFuncItemGroup.get(entityNum);
                    boolean hasItem = false;
                    if (itemList != null && !HRStringUtils.isEmpty((String)functionItemInitModel.getName())) {
                        for (DynamicObject item : itemList) {
                            String name;
                            String string = name = item.getString("permitem.name") == null ? "" : item.getString("permitem.name").trim();
                            if (!HRStringUtils.equals((String)functionItemInitModel.getName(), (String)name)) continue;
                            hasItem = true;
                            functionItemInitModel.setPermItemId(item.getString("permitem.id"));
                            functionItemInitModel.setPermItemNum(item.getString("permitem.number"));
                            break;
                        }
                    }
                    if (!hasItem) {
                        errMsg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u201c\u5e94\u7528\u7f16\u7801\u201d\u201c\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201d\u201c\u6743\u9650\u9879\u201d", (String)"PermRoleInitValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                    }
                } else {
                    errMsg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u503c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u201c\u5e94\u7528\u7f16\u7801\u201d\u201c\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u201d\u201c\u6743\u9650\u9879\u201d", (String)"PermRoleInitValidateService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                }
            }
            if (errMsg == null) continue;
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            HashMap colErrMsgMap = Maps.newHashMapWithExpectedSize((int)roleCheckedMap.size());
            colErrMsgMap.put(0, errMsg);
            errMsgMap.put(functionItemInitModel.getRowNum(), colErrMsgMap);
            Map<Integer, String> colRoleErrMsgMap = errMsgMap.getOrDefault(((FunctionItemInitModel)functionItemInitModelList.get(0)).getRowNum(), Maps.newHashMapWithExpectedSize((int)roleCheckedMap.size()));
            roleCheckedMap.forEach((key, value) -> {
                if (Boolean.TRUE.equals(value.getValue())) {
                    colRoleErrMsgMap.put((Integer)value.getKey(), ResManager.loadKDString((String)"\u6743\u9650\u9879\u9519\u8bef\uff0c\u89d2\u8272\u5bfc\u5165\u5931\u8d25", (String)"PermRoleInitValidateService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    errMsgMap.put(((FunctionItemInitModel)functionItemInitModelList.get(0)).getRowNum(), colRoleErrMsgMap);
                }
            });
        }
    }

    private void validateFuncWithRole(Map<Integer, Map<Integer, String>> errMsgMap, PermRoleInitRecord record) {
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashMap isRoleCheckedMap = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel itemInitModel : functionItemInitModelList) {
            for (Map.Entry entry : itemInitModel.getRoleCheckedMap().entrySet()) {
                if (!Boolean.TRUE.equals(((Pair)entry.getValue()).getValue())) continue;
                isRoleCheckedMap.put(entry.getKey(), Boolean.TRUE);
            }
        }
        List roleInitModelList = record.getRoleInitModelList();
        Set roleNumSet = roleInitModelList.stream().map(RoleInitModel::getRoleNumber).collect(Collectors.toSet());
        FunctionItemInitModel topFunctionItemInitModel = (FunctionItemInitModel)functionItemInitModelList.get(0);
        Map roleCheckedMap = topFunctionItemInitModel.getRoleCheckedMap();
        roleCheckedMap.forEach((key, value) -> {
            String errMsg;
            Map colErrMsgMap;
            if (!isRoleCheckedMap.containsKey(key)) {
                colErrMsgMap = errMsgMap.getOrDefault(topFunctionItemInitModel.getRowNum(), Maps.newHashMapWithExpectedSize((int)roleCheckedMap.size()));
                errMsg = (String)colErrMsgMap.get(value.getKey());
                errMsg = errMsg == null ? "" : errMsg;
                errMsg = errMsg + "\n" + ResManager.loadKDString((String)"\u89d2\u8272\u672a\u52fe\u9009\u529f\u80fd\u6743\u9650\u9879", (String)"PermRoleInitValidateService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                colErrMsgMap.put(value.getKey(), errMsg);
                errMsgMap.put(topFunctionItemInitModel.getRowNum(), colErrMsgMap);
            }
            if (!roleNumSet.contains(key)) {
                colErrMsgMap = errMsgMap.getOrDefault(topFunctionItemInitModel.getRowNum(), Maps.newHashMapWithExpectedSize((int)roleCheckedMap.size()));
                errMsg = (String)colErrMsgMap.get(value.getKey());
                errMsg = errMsg == null ? "" : errMsg;
                errMsg = errMsg + "\n" + ResManager.loadKDString((String)"\u201c\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u201d\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u89d2\u8272\uff0c\u6216\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                colErrMsgMap.put(value.getKey(), errMsg);
                errMsgMap.put(topFunctionItemInitModel.getRowNum(), colErrMsgMap);
            }
        });
    }

    private void validateNumberAndName(Map<Integer, String> errorMsgMap, List<RoleInitModel> roleInitModelList, List<String> roleNumList, List<String> roleNameList) {
        Set<String> existRoleNum = PermRoleInitServiceHelper.isExistRoleNum(roleNumList);
        Set<String> existRoleName = PermRoleInitServiceHelper.isExistRoleName(roleNameList);
        for (RoleInitModel roleInitModel : roleInitModelList) {
            StringBuilder stringBuilder = new StringBuilder();
            String errMsg = this.validateIsExist(existRoleNum, existRoleName, roleInitModel);
            if (errMsg != null) {
                stringBuilder.append(errMsg).append("\n");
            }
            if ((errMsg = this.validateDuplicate(roleNumList, roleNameList, roleInitModel)) != null) {
                stringBuilder.append(errMsg).append("\n");
            }
            if (stringBuilder.length() <= 0) continue;
            errorMsgMap.put(roleInitModel.getRowNum(), stringBuilder.toString());
        }
    }

    private void validateValueError(Map<Integer, String> errorMsgMap, List<RoleInitModel> roleInitModelList, Set<String> roleGroupNumSet, Set<String> createAdminGrpNumSet) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrcs_role");
        ComboProp property = (ComboProp)mainEntityType.getProperty("property");
        ComboProp isIntersection = (ComboProp)mainEntityType.getProperty("isintersection");
        ComboProp userScope = (ComboProp)mainEntityType.getProperty("usescope");
        Map<String, String> propertyMap = property.getComboItems().stream().collect(Collectors.toMap(item -> item.getName().getLocaleValue(), ValueMapItem::getValue));
        Map<String, String> isIntersectionMap = isIntersection.getComboItems().stream().collect(Collectors.toMap(item -> item.getName().getLocaleValue(), ValueMapItem::getValue));
        Map<String, String> userScopeMap = userScope.getComboItems().stream().collect(Collectors.toMap(item -> item.getName().getLocaleValue(), ValueMapItem::getValue));
        Map<String, String> existRoleGroup = PermRoleInitServiceHelper.isExistRoleGroup(roleGroupNumSet);
        Map<String, Long> existAdminGroup = PermRoleInitServiceHelper.isExistAdminGroup(createAdminGrpNumSet);
        for (RoleInitModel roleInitModel : roleInitModelList) {
            StringBuilder stringBuilder = new StringBuilder();
            String errMsg = this.validateCombo(roleInitModel, propertyMap, isIntersectionMap, userScopeMap);
            if (errMsg != null) {
                stringBuilder.append(errMsg).append("\n");
            }
            if ((errMsg = this.validateBaseData(roleInitModel, existRoleGroup, existAdminGroup)) != null) {
                stringBuilder.append(errMsg).append("\n");
            }
            if (stringBuilder.length() <= 0) continue;
            errorMsgMap.put(roleInitModel.getRowNum(), stringBuilder.toString());
        }
    }

    private void validateUserScope(Map<Integer, String> errorMsgMap, List<RoleInitModel> roleInitModelList) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrcs_role");
        ComboProp userScope = (ComboProp)mainEntityType.getProperty("usescope");
        Map<String, String> userScopeMap = userScope.getComboItems().stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue()));
        for (RoleInitModel roleInitModel : roleInitModelList) {
            String useScope = roleInitModel.getUseScope();
            StringBuilder stringBuilder = new StringBuilder();
            if ((userScopeMap.get("0").equals(useScope) || userScopeMap.get("1").equals(useScope) || !HRStringUtils.isEmpty((String)roleInitModel.getOpenRangeWithView()) || !HRStringUtils.isEmpty((String)roleInitModel.getOpenRangeWithEdit())) && HRStringUtils.isEmpty((String)roleInitModel.getCreateAdminGrpNumber())) {
                stringBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u7f16\u7801", (String)"PermRoleInitValidateService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append("\n");
            }
            if (userScopeMap.get("2").equals(useScope) && !HRStringUtils.isEmpty((String)roleInitModel.getOpenRangeWithView())) {
                stringBuilder.append(ResManager.loadKDString((String)"\u516c\u5f00\u72b6\u6001\u503c\u4e3a\u201c\u516c\u5f00\u201d\u65f6\uff0c\u65e0\u9700\u8bbe\u7f6e\u201c\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u67e5\u770b\uff09\u201d", (String)"PermRoleInitValidateService_12", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append("\n");
            }
            if (!(!userScopeMap.get("0").equals(useScope) || HRStringUtils.isEmpty((String)roleInitModel.getOpenRangeWithView()) && HRStringUtils.isEmpty((String)roleInitModel.getOpenRangeWithEdit()))) {
                stringBuilder.append(ResManager.loadKDString((String)"\u5f53\u516c\u5f00\u72b6\u6001\u503c\u4e3a\u201c\u79c1\u6709\u201d\u65f6\uff0c\u65e0\u9700\u8bbe\u7f6e\u201c\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u67e5\u770b\uff09\u201d\u548c\u201c\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u7f16\u8f91\uff09\u201d", (String)"PermRoleInitValidateService_13", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append("\n");
            }
            if (stringBuilder.length() <= 0) continue;
            errorMsgMap.put(roleInitModel.getRowNum(), stringBuilder.toString());
        }
    }

    private void validateAdminGroup(Map<Integer, String> errorMsgMap, List<RoleInitModel> roleInitModelList, Set<String> adminGroupNumSet) {
        Map<String, Long> existAdminGroup = PermRoleInitServiceHelper.isExistAdminGroup(adminGroupNumSet);
        for (RoleInitModel roleInitModel : roleInitModelList) {
            String openRangeWithEdit;
            StringBuilder stringBuilderAll = new StringBuilder();
            String openRangeWithView = roleInitModel.getOpenRangeWithView();
            if (!HRStringUtils.isEmpty((String)openRangeWithView)) {
                String[] split = this.dealValueCode(openRangeWithView).toArray(new String[0]);
                StringBuilder stringBuilder = this.getAdminGroupNumBuilder(existAdminGroup, split);
                if (stringBuilder.length() > 0) {
                    stringBuilderAll.append(ResManager.loadKDString((String)"\u201c\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u67e5\u770b)\u201d\u7684\u503c\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_15", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()})).append("\n");
                } else {
                    for (String num : split) {
                        Long id = existAdminGroup.get(num);
                        roleInitModel.getOpenRangeWithViewIds().add(id);
                    }
                }
            }
            if (!HRStringUtils.isEmpty((String)(openRangeWithEdit = roleInitModel.getOpenRangeWithEdit()))) {
                String[] split = this.dealValueCode(openRangeWithEdit).toArray(new String[0]);
                StringBuilder stringBuilder = this.getAdminGroupNumBuilder(existAdminGroup, split);
                if (stringBuilder.length() > 0) {
                    stringBuilderAll.append(ResManager.loadKDString((String)"\u201c\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u7f16\u8f91)\u201d\u7684\u503c\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_14", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()})).append("\n");
                } else {
                    for (String num : split) {
                        Long id = existAdminGroup.get(num);
                        roleInitModel.getOpenRangeWithEditIds().add(id);
                    }
                }
            }
            if (stringBuilderAll.length() <= 0) continue;
            errorMsgMap.put(roleInitModel.getRowNum(), stringBuilderAll.toString());
        }
    }

    private StringBuilder getAdminGroupNumBuilder(Map<String, Long> existAdminGroup, String[] adminGroupNums) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String adminGroupNum : adminGroupNums) {
            if (existAdminGroup.containsKey(adminGroupNum)) continue;
            stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{adminGroupNum}));
        }
        return stringBuilder;
    }

    private String validateIsExist(Set<String> existRoleNum, Set<String> existRoleName, RoleInitModel roleInitModel) {
        String param;
        String errMsg = null;
        String roleNumber = roleInitModel.getRoleNumber();
        String roleName = roleInitModel.getRoleName().getLocaleValue();
        if (existRoleNum.contains(roleNumber)) {
            param = ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801", (String)"PermRoleInitValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5b58\u5728\u89d2\u8272\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_0", (String)"hrmp-hrcs-business", (Object[])new Object[]{param});
        }
        if (existRoleName.contains(roleName)) {
            param = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermRoleInitValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            if (errMsg == null) {
                errMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5b58\u5728\u89d2\u8272\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_0", (String)"hrmp-hrcs-business", (Object[])new Object[]{param});
            } else {
                String param2 = ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801", (String)"PermRoleInitValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                errMsg = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5b58\u5728\u89d2\u8272\u201c%1$s\u201d\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), param2, param);
            }
        }
        return errMsg;
    }

    private String validateDuplicate(List<String> roleNumList, List<String> roleNameList, RoleInitModel roleInitModel) {
        String param;
        String errMsg = null;
        String roleNumber = roleInitModel.getRoleNumber();
        String roleName = roleInitModel.getRoleName().getLocaleValue();
        if (roleNumList.indexOf(roleNumber) != roleNumList.lastIndexOf(roleNumber)) {
            param = ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801", (String)"PermRoleInitValidateService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            errMsg = ResManager.loadKDString((String)"\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[]{param});
        }
        if (roleNameList.indexOf(roleName) != roleNameList.lastIndexOf(roleName)) {
            if (errMsg == null) {
                param = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermRoleInitValidateService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                errMsg = ResManager.loadKDString((String)"\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_3", (String)"hrmp-hrcs-business", (Object[])new Object[]{param});
            } else {
                errMsg = ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u3001\u89d2\u8272\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            }
        }
        return errMsg;
    }

    private List<PermInitBaseModel> removeErrInfo(Map<Integer, String> errorMsgMap, List<? extends PermInitBaseModel> modelList) {
        ArrayList removeList = Lists.newArrayListWithExpectedSize((int)modelList.size());
        Map<Integer, PermInitBaseModel> modelMap = modelList.stream().collect(Collectors.toMap(PermInitBaseModel::getRowNum, model -> model));
        errorMsgMap.forEach((key, value) -> removeList.add(modelMap.get(key)));
        modelList.removeAll(removeList);
        return removeList;
    }

    private String validateCombo(RoleInitModel roleInitModel, Map<String, String> propertyMap, Map<String, String> isIntersectionMap, Map<String, String> userScopeMap) {
        String name;
        String roleProperty = roleInitModel.getRoleProperty();
        String roleCBisIntersection = roleInitModel.getRoleCBisIntersection();
        String useScope = roleInitModel.getUseScope();
        StringBuilder stringBuilder = new StringBuilder();
        String errMsg = null;
        if (!propertyMap.containsKey(roleProperty)) {
            name = ResManager.loadKDString((String)"\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027", (String)"PermRoleInitValidateService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{name}));
        } else if ("1".equals(propertyMap.get(roleProperty))) {
            if (HRStringUtils.isEmpty((String)roleCBisIntersection)) {
                errMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u662f\u5426\u53d7\u9650\u4e8e\u89d2\u8272\u8303\u56f4\u201d", (String)"PermRoleInitValidateService_28", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            } else if (!isIntersectionMap.containsKey(roleCBisIntersection)) {
                name = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4\u662f\u5426\u53d7\u9650\u4e8e\u89d2\u8272\u8303\u56f4", (String)"PermRoleInitValidateService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{name}));
            } else {
                roleInitModel.setRolePropertyValue(propertyMap.get(roleProperty));
                roleInitModel.setRoleCBisIntersectionValue(isIntersectionMap.get(roleCBisIntersection));
            }
        } else if ("0".equals(propertyMap.get(roleProperty))) {
            if (!HRStringUtils.isEmpty((String)roleCBisIntersection)) {
                errMsg = ResManager.loadKDString((String)"\u201c\u81ea\u5b9a\u4e49\u8303\u56f4\u662f\u5426\u53d7\u9650\u4e8e\u89d2\u8272\u8303\u56f4\u201d\u65e0\u9700\u8bbe\u503c\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_29", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            } else {
                roleInitModel.setRolePropertyValue(propertyMap.get(roleProperty));
                roleInitModel.setRoleCBisIntersectionValue(isIntersectionMap.get(roleCBisIntersection));
            }
        }
        if (!userScopeMap.containsKey(useScope)) {
            name = ResManager.loadKDString((String)"\u516c\u5f00\u72b6\u6001", (String)"PermRoleInitValidateService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"PermRoleInitValidateService_16", (String)"hrmp-hrcs-business", (Object[])new Object[]{name}));
        } else {
            roleInitModel.setUseScopeValue(userScopeMap.get(useScope));
        }
        if (stringBuilder.length() > 0) {
            errMsg = errMsg == null ? "" : errMsg;
            errMsg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u4fe1\u606f\u503c\u5f55\u5165\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u6279\u6ce8\u540e\u8c03\u6574\uff1a%s", (String)"PermRoleInitValidateService_6", (String)"hrmp-hrcs-business", (Object[])new Object[]{stringBuilder.toString()}) + "\n" + errMsg;
        }
        return errMsg;
    }

    private String validateBaseData(RoleInitModel roleInitModel, Map<String, String> roleGroupNumMap, Map<String, Long> createAdminGrpNumMap) {
        String fieldName;
        String roleGroupNumber = roleInitModel.getRoleGroupNumber();
        String createAdminGrpNumber = roleInitModel.getCreateAdminGrpNumber();
        StringBuilder stringBuilder = new StringBuilder();
        if (!HRStringUtils.isEmpty((String)roleGroupNumber)) {
            if (!roleGroupNumMap.containsKey(roleGroupNumber)) {
                fieldName = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_10", (String)"hrmp-hrcs-business", (Object[])new Object[]{fieldName})).append("\n");
            } else {
                roleInitModel.setRoleGroupId(roleGroupNumMap.get(roleGroupNumber));
            }
        }
        if (!HRStringUtils.isEmpty((String)createAdminGrpNumber)) {
            if (!createAdminGrpNumMap.containsKey(createAdminGrpNumber)) {
                fieldName = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                stringBuilder.append(ResManager.loadKDString((String)"\u201c%s\u201d\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PermRoleInitValidateService_10", (String)"hrmp-hrcs-business", (Object[])new Object[]{fieldName})).append("\n");
            } else {
                roleInitModel.setCreateAdminGrpId(createAdminGrpNumMap.get(createAdminGrpNumber));
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private Set<String> dealValueCode(String orgCodeStr) {
        if (HRStringUtils.isEmpty((String)orgCodeStr)) {
            return Sets.newHashSet();
        }
        String codeStr = orgCodeStr.replaceAll("\\n", "").replaceAll("\u3010", "[");
        String dotStr = codeStr.replaceAll("\uff1b", ";");
        String[] val = dotStr.split(";");
        HashSet codeSet = Sets.newHashSetWithExpectedSize((int)val.length);
        String unlimited = ResManager.loadKDString((String)"\u4e0d\u9650", (String)"PermInitImportValidateService_38", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        for (String dv : val) {
            String code;
            if (HRStringUtils.isEmpty((String)dv)) continue;
            if (dv.startsWith(PermInitServiceHelper.DYNA_CONDE_PREFIX)) {
                String[] dvs = dv.split("\\[");
                code = dvs[0];
                codeSet.add(code);
                continue;
            }
            if (!dv.contains("[")) {
                if (dv.equals("all") || dv.equals(unlimited) || dv.equals("All") || dv.equals("ALL") || dv.equals("aLL") || dv.equals("alL") || dv.equals("AlL") || dv.equals("aLl")) {
                    String[] dvs = dv.split("\\[");
                    code = dvs[0];
                    codeSet.add(code);
                    continue;
                }
                int index = dv.lastIndexOf(PermInitServiceHelper.getContainsSubText());
                if (index > 0) {
                    code = dv.substring(0, index);
                    codeSet.add(code);
                    continue;
                }
                codeSet.add(dv);
                continue;
            }
            String[] dvs = dv.split("\\[");
            code = dvs[0];
            String name = dvs[1];
            if (code.contains(PermInitServiceHelper.getContainsSubText())) {
                code = code.substring(0, code.lastIndexOf(PermInitServiceHelper.getContainsSubText()));
                codeSet.add(code);
                continue;
            }
            if ((name.contains("<") || name.contains(">")) && !name.contains(PermInitServiceHelper.getContainsSubText())) {
                String replaceAll = dv.replaceAll("\u3011", "]");
                if (replaceAll.contains("]")) {
                    String codePre = replaceAll.substring(0, replaceAll.indexOf("["));
                    String codeSuf = replaceAll.substring(replaceAll.indexOf("]") + 1);
                    String orignalCode = codePre + codeSuf;
                    codeSet.add(orignalCode);
                    continue;
                }
                codeSet.add(code);
                continue;
            }
            codeSet.add(code);
        }
        return codeSet;
    }

    public Map<String, String> getAppIdMap(Set<String> appNumSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter enableFilter = new QFilter("deploystatus", "=", (Object)"2");
        QFilter numFilter = new QFilter("number", "in", appNumSet);
        DynamicObject[] results = serviceHelper.queryOriginalArray("id,number", new QFilter[]{enableFilter, numFilter});
        return Arrays.stream(results).collect(Collectors.toMap(rs -> rs.getString("number"), rs -> rs.getString("id")));
    }

    private Set<String> getSuccessFuncSet(PermRoleInitRecord record) {
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashSet successFuncSet = Sets.newHashSetWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            successFuncSet.addAll(roleCheckedMap.keySet());
        }
        return successFuncSet;
    }

    private Map<String, List<String>> getRoleAppEntityMap(PermRoleInitRecord record) {
        List functionItemInitModelList = record.getFunctionItemInitModelList();
        HashMap roleAppEntityMap = Maps.newHashMapWithExpectedSize((int)functionItemInitModelList.size());
        for (FunctionItemInitModel functionItemInitModel : functionItemInitModelList) {
            String appId = functionItemInitModel.getAppId();
            String entityNum = functionItemInitModel.getEntityNum();
            Map roleCheckedMap = functionItemInitModel.getRoleCheckedMap();
            roleCheckedMap.forEach((key, value) -> {
                if (Boolean.TRUE.equals(value.getValue())) {
                    String key2 = appId + "#" + entityNum;
                    List appEntityList = roleAppEntityMap.getOrDefault(key, Lists.newArrayListWithExpectedSize((int)functionItemInitModelList.size()));
                    appEntityList.add(key2);
                    roleAppEntityMap.put(key, appEntityList);
                }
            });
        }
        return roleAppEntityMap;
    }

    private void validateBuUncheck(Map<String, List<String>> roleAppEntityMap, Map<Integer, String> errorMsgMap, List<String> roleFuncList, DimAndDataRangeBaseModel model) {
        String roleNumber = model.getRoleNumber();
        roleFuncList.add(roleNumber + "#" + model.getBuCaFuncName());
        List<String> appEntityList = roleAppEntityMap.get(roleNumber);
        boolean isExist = false;
        for (String appEntity : appEntityList) {
            DynamicObject func;
            String[] split = appEntity.split("#");
            Map<String, DynamicObject> entityFuncMap = this.funcMap.get(split[0]);
            if (CollectionUtils.isEmpty(entityFuncMap) || (func = entityFuncMap.get(split[1])) == null || !HRStringUtils.equals((String)func.getString("name"), (String)model.getBuCaFuncName())) continue;
            isExist = true;
            model.setBuCaFuncId(Long.valueOf(func.getLong("id")));
            break;
        }
        if (!isExist) {
            errorMsgMap.put(model.getRowNum(), ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u662f\u5426\u9057\u6f0f\u52fe\u9009\u6743\u9650\u9879\u3002", (String)"PermRoleInitValidateService_23", (String)"hrmp-hrcs-business", (Object[])new Object[]{model.getBuCaFuncName()}));
        }
    }

    private void addErrRoleNum(Map<Integer, String> errorMsgMap, List<? extends DimAndDataRangeBaseModel> dimInitModelList, Set<String> errRoleNumSet, List<PermInitBaseModel> removeList) {
        List<PermInitBaseModel> removeDimWithBuList = this.removeErrInfo(errorMsgMap, dimInitModelList);
        for (PermInitBaseModel permInitBaseModel : removeDimWithBuList) {
            if (permInitBaseModel == null) continue;
            DimAndDataRangeBaseModel dimAndDataRangeBaseModel = (DimAndDataRangeBaseModel)permInitBaseModel;
            errRoleNumSet.add(dimAndDataRangeBaseModel.getRoleNumber());
        }
        removeList.addAll(removeDimWithBuList);
    }

    private void addLackMsgByDataRange(String roleNumber, String roleName, String buCaFuncName, Long buCAFuncId, Integer rowNum, String errMsg, Map<DimAndDataRangeBaseModel, String> lackMsgMap) {
        DataRangeInitModel dataRangeInitModel = new DataRangeInitModel();
        dataRangeInitModel.setRoleNumber(roleNumber);
        dataRangeInitModel.setRoleName(roleName);
        dataRangeInitModel.setBuCaFuncName(buCaFuncName);
        dataRangeInitModel.setBuCaFuncId(buCAFuncId);
        dataRangeInitModel.setRowNum(rowNum);
        lackMsgMap.put((DimAndDataRangeBaseModel)dataRangeInitModel, errMsg);
    }

    public static Map<String, String> dealValueCodeContainsSub(String dimValueCodeStr) {
        String[] val;
        HashMap dimValueContainsSubMap = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)dimValueCodeStr)) {
            return dimValueContainsSubMap;
        }
        String dotStr = dimValueCodeStr.replaceAll("\uff1b", ";");
        for (String dv : val = dotStr.split(";")) {
            String code;
            String codeStr = dv.replaceAll("\\n", "").replaceAll("\u3010", "[");
            if (HRStringUtils.isEmpty((String)codeStr)) continue;
            if (!codeStr.contains("[")) {
                int index = codeStr.lastIndexOf(PermInitServiceHelper.getContainsSubText());
                if (index > 0) {
                    code = codeStr.substring(0, index);
                    dimValueContainsSubMap.put(code, "1");
                    continue;
                }
                dimValueContainsSubMap.put(codeStr, "0");
                continue;
            }
            String[] dvs = codeStr.split("\\[");
            code = dvs[0];
            if (code.contains(PermInitServiceHelper.getContainsSubText())) {
                code = code.substring(0, code.lastIndexOf(PermInitServiceHelper.getContainsSubText()));
            }
            if (codeStr.contains(PermInitServiceHelper.getContainsSubText())) {
                dimValueContainsSubMap.put(code, "1");
                continue;
            }
            dimValueContainsSubMap.put(code, "0");
        }
        return dimValueContainsSubMap;
    }
}

