/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init.roleinit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.roleinit.PermRoleInitSysService;
import kd.hr.hrcs.bussiness.service.perm.init.roleinit.model.RoleDimensionDetailVo;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.common.model.perminit.RoleInitTccParamBO;
import org.apache.commons.collections.MapUtils;

public class PermRoleInitHrService {
    private static volatile PermRoleInitHrService service = null;
    private static final String splitStr = "####";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermRoleInitHrService getInstance() {
        if (service != null) return service;
        Class<PermRoleInitHrService> clazz = PermRoleInitHrService.class;
        synchronized (PermRoleInitHrService.class) {
            if (service != null) return service;
            service = new PermRoleInitHrService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public boolean saveData(Object paramBO) {
        RoleInitTccParamBO roleInitTccParamBO = (RoleInitTccParamBO)paramBO;
        if (roleInitTccParamBO == null) {
            return false;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        if (roleNumberKeyMap == null || roleNumberKeyMap.isEmpty()) {
            return false;
        }
        if (!this.saveBaseRoleInfo(roleInitTccParamBO)) {
            return false;
        }
        Map<String, Set<Long>> bucafuncIdMap = this.saveHrBu(roleInitTccParamBO);
        this.saveHrBuFunc(bucafuncIdMap, roleInitTccParamBO);
        this.saveRoleDimData(roleInitTccParamBO);
        this.saveDimValueData(roleInitTccParamBO);
        this.saveRoleFieldPerm(roleInitTccParamBO);
        return true;
    }

    private boolean saveBaseRoleInfo(RoleInitTccParamBO roleInitTccParamBO) {
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolebaseentry");
        if (collection == null || collection.size() == 0) {
            return false;
        }
        HRBaseServiceHelper saveServiceHelper = new HRBaseServiceHelper("hrcs_role");
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)10);
        HRBaseServiceHelper openServiceHelper = new HRBaseServiceHelper("hrcs_roleopenscope");
        HRBaseServiceHelper assignServiceHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
        DynamicObjectCollection openServiceDyColl = new DynamicObjectCollection();
        DynamicObjectCollection assignServiceDyColl = new DynamicObjectCollection();
        openServiceHelper.generateEmptyDynamicObject();
        for (DynamicObject entry : collection) {
            DynamicObject assignServiceDy;
            String roleNumber = entry.getString("rbase_number");
            String roleId = (String)roleNumberKeyMap.get(roleNumber);
            DynamicObject permRoleDy = saveServiceHelper.generateEmptyDynamicObject();
            permRoleDy.set("id", (Object)roleId);
            permRoleDy.set("property", entry.get("rbase_property"));
            permRoleDy.set("rolegrp", entry.get("rbase_group"));
            permRoleDy.set("isintersection", entry.get("rbase_isintersection"));
            int useScope = entry.getInt("rbase_usescope");
            permRoleDy.set("usescope", (Object)useScope);
            permRoleDy.set("createadmingrp", entry.get("rbase_createadmingrp"));
            dynamicObjectList.add(permRoleDy);
            Set<Long> setViewIds = this.getOpenScopeViewSet(entry);
            Set<Long> setEditIds = this.getOpenScopeEditSet(entry);
            if (2 == useScope) {
                if (!CollectionUtils.isNotEmpty(setEditIds)) continue;
                for (Long id : setEditIds) {
                    DynamicObject openServiceDy = openServiceHelper.generateEmptyDynamicObject();
                    openServiceDy.set("roleid", (Object)roleId);
                    openServiceDy.set("admingroup", (Object)id);
                    openServiceDyColl.add((Object)openServiceDy);
                }
                continue;
            }
            if (1 != useScope) continue;
            if (CollectionUtils.isNotEmpty(setEditIds)) {
                for (Long id : setEditIds) {
                    assignServiceDy = assignServiceHelper.generateEmptyDynamicObject();
                    assignServiceDy.set("roleid", (Object)roleId);
                    assignServiceDy.set("admingroup", (Object)id);
                    assignServiceDy.set("ismodifiable", (Object)Boolean.TRUE);
                    assignServiceDyColl.add((Object)assignServiceDy);
                }
            }
            if (!CollectionUtils.isNotEmpty(setViewIds)) continue;
            for (Long id : setViewIds) {
                assignServiceDy = assignServiceHelper.generateEmptyDynamicObject();
                assignServiceDy.set("roleid", (Object)roleId);
                assignServiceDy.set("admingroup", (Object)id);
                assignServiceDy.set("ismodifiable", (Object)Boolean.FALSE);
                assignServiceDyColl.add((Object)assignServiceDy);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectList)) {
            saveServiceHelper.save(dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
        }
        if (CollectionUtils.isNotEmpty((Collection)openServiceDyColl)) {
            openServiceHelper.save(openServiceDyColl);
        }
        if (CollectionUtils.isNotEmpty((Collection)assignServiceDyColl)) {
            assignServiceHelper.save(assignServiceDyColl);
        }
        return true;
    }

    private Map<String, Set<Long>> saveHrBu(RoleInitTccParamBO roleInitTccParamBO) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        Boolean includeSub = dynamicObject.getBoolean("includeSub");
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("roledataentry");
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        DynamicObject emptyDy = serviceHelper.generateEmptyDynamicObject();
        DynamicObjectCollection saveDyColl = new DynamicObjectCollection();
        HashMap roleBucafuncIdMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet setResult = Sets.newHashSetWithExpectedSize((int)16);
        HashMap buOrgRangeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject entry : collection) {
            Long bucafuncId;
            DynamicObjectCollection dataOrgRangeDyCol = (DynamicObjectCollection)entry.get("rdata_orgrange");
            String rdata_orgcontainssubstr = entry.getString("rdata_orgcontainssubstr");
            if (CollectionUtils.isEmpty((Collection)dataOrgRangeDyCol)) {
                return null;
            }
            Set setDataOrgRangeDy = dataOrgRangeDyCol.stream().map(dataOrgRangeDy -> dataOrgRangeDy.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(setDataOrgRangeDy)) {
                return null;
            }
            String roleNumber = entry.getString("rdata_rolenumber");
            String roleId = (String)roleNumberKeyMap.get(roleNumber);
            if (StringUtils.isEmpty((String)roleId) || (bucafuncId = Long.valueOf(entry.getLong("rdata_bucafunc_id"))) == null) continue;
            buOrgRangeMap.put(roleId + bucafuncId, SerializationUtils.fromJsonString((String)rdata_orgcontainssubstr, Map.class));
            Set bucafuncIdSet = (Set)roleBucafuncIdMap.get(roleId);
            if (bucafuncIdSet == null) {
                bucafuncIdSet = Sets.newHashSetWithExpectedSize((int)16);
                roleBucafuncIdMap.put(roleId, bucafuncIdSet);
            }
            bucafuncIdSet.add(bucafuncId);
            if (!CollectionUtils.isNotEmpty(setDataOrgRangeDy)) continue;
            for (Long orgId : setDataOrgRangeDy) {
                if (orgId == null) continue;
                String resultKey = roleId + splitStr + bucafuncId + splitStr + orgId;
                setResult.add(resultKey);
            }
        }
        if (CollectionUtils.isEmpty((Collection)setResult)) {
            return roleBucafuncIdMap;
        }
        int idIdx = 0;
        long[] ids = DBServiceHelper.genLongIds((String)"hrcs_rolebu", (int)setResult.size());
        for (String key : setResult) {
            Long bucafuncId;
            Long orgId;
            String[] keys = key.split(splitStr);
            if (keys == null || keys.length != 3) continue;
            String roleId = keys[0];
            String strBucafuncId = keys[1];
            String strOrgId = keys[2];
            try {
                bucafuncId = Long.valueOf(strBucafuncId);
                orgId = Long.valueOf(strOrgId);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            Map orgRangeMap = (Map)buOrgRangeMap.get(roleId + bucafuncId);
            DynamicObject dy = new DynamicObject(emptyDy.getDynamicObjectType());
            dy.set("id", (Object)ids[idIdx]);
            dy.set("role", (Object)roleId);
            dy.set("org", (Object)orgId);
            dy.set("containssub", orgRangeMap.get(orgId.toString()));
            dy.set("hrbuca", (Object)bucafuncId);
            dy.set("hrbucafunc", (Object)bucafuncId);
            saveDyColl.add((Object)dy);
            ++idIdx;
        }
        if (CollectionUtils.isNotEmpty((Collection)saveDyColl)) {
            serviceHelper.save(saveDyColl);
        }
        return roleBucafuncIdMap;
    }

    private void saveHrBuFunc(Map<String, Set<Long>> bucafuncIdMap, RoleInitTccParamBO roleInitTccParamBO) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        HashSet needCalcRoleNumbers = Sets.newHashSetWithExpectedSize((int)16);
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        needCalcRoleNumbers.addAll(roleNumberKeyMap.keySet());
        Map<String, String> roleIdKeyMap = roleNumberKeyMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getKey()));
        if (bucafuncIdMap != null && !bucafuncIdMap.isEmpty()) {
            for (Map.Entry<String, Set<Long>> entry2 : bucafuncIdMap.entrySet()) {
                String roleId = entry2.getKey();
                String roleNumber = roleIdKeyMap.get(roleId);
                if (StringUtils.isNotEmpty((String)roleNumber)) {
                    needCalcRoleNumbers.remove(roleNumber);
                }
                Set<Long> bucafuncIdSet = entry2.getValue();
                if (StringUtils.isEmpty((String)roleId) || CollectionUtils.isEmpty(bucafuncIdSet)) continue;
                for (Long bucafuncId : bucafuncIdSet) {
                    DynamicObject buCaFuncObj = serviceHelper.generateEmptyDynamicObject();
                    buCaFuncObj.set("role", (Object)roleId);
                    buCaFuncObj.set("hrbucafunc", (Object)bucafuncId);
                    dynamicObjectCollection.add((Object)buCaFuncObj);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)needCalcRoleNumbers)) {
            DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
            DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolefuncentry");
            HashMap roleEntityMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject entry3 : collection) {
                String entityNumber;
                String appId;
                List entityList;
                String roleNumber = entry3.getString("rfunc_rolenumber");
                if (StringUtils.isEmpty((String)roleNumber) || !needCalcRoleNumbers.contains(roleNumber)) continue;
                String roleId = (String)roleNumberKeyMap.get(roleNumber);
                Map entityMap = (Map)roleEntityMap.get(roleId);
                if (entityMap == null || entityMap.isEmpty()) {
                    entityMap = Maps.newHashMapWithExpectedSize((int)16);
                    roleEntityMap.put(roleId, entityMap);
                }
                if (CollectionUtils.isEmpty((Collection)(entityList = (List)entityMap.get(appId = entry3.getString("rfunc_app.id"))))) {
                    entityList = Lists.newArrayListWithExpectedSize((int)10);
                    entityMap.put(appId, entityList);
                }
                if (entityList.contains(entityNumber = entry3.getString("rfunc_entitytype.number"))) continue;
                entityList.add(entityNumber);
            }
            this.buildDynamicObjectCollection(roleEntityMap, dynamicObjectCollection, serviceHelper);
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            serviceHelper.save(dynamicObjectCollection);
        }
    }

    private void buildDynamicObjectCollection(Map<String, Map<String, List<String>>> roleEntityMap, DynamicObjectCollection dynamicObjectCollection, HRBaseServiceHelper serviceHelper) {
        if (roleEntityMap == null || roleEntityMap.isEmpty()) {
            return;
        }
        HashMap roleBuResult = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Map<String, List<String>>> entry : roleEntityMap.entrySet()) {
            String roleId = entry.getKey();
            Map<String, List<String>> entityMap = entry.getValue();
            Map<String, Map<String, DynamicObject>> resultMap = HRBuCaServiceHelper.getBuCaFuncFromSpec(entityMap);
            if (resultMap == null || resultMap.isEmpty()) continue;
            for (Map.Entry entry2 : resultMap.entrySet()) {
                DynamicObject[] buCaFuncIdDys;
                Map buCaFuncIdMap = (Map)entry2.getValue();
                if (buCaFuncIdMap == null || buCaFuncIdMap.isEmpty() || (buCaFuncIdDys = buCaFuncIdMap.values().toArray(new DynamicObject[buCaFuncIdMap.size()])) == null || buCaFuncIdDys.length == 0) continue;
                for (DynamicObject dynamicObject : buCaFuncIdDys) {
                    Long id = dynamicObject.getLong("id");
                    if (id == null || id == 0L) continue;
                    Set buSet = (Set)roleBuResult.get(roleId);
                    if (CollectionUtils.isEmpty((Collection)buSet)) {
                        buSet = Sets.newHashSetWithExpectedSize((int)16);
                        roleBuResult.put(roleId, buSet);
                    }
                    buSet.add(id);
                }
            }
        }
        for (Map.Entry<String, Map<String, List<String>>> entry : roleBuResult.entrySet()) {
            String roleId = entry.getKey();
            Set buSet = (Set)((Object)entry.getValue());
            for (Long l : buSet) {
                DynamicObject buCaFuncObj = serviceHelper.generateEmptyDynamicObject();
                buCaFuncObj.set("role", (Object)roleId);
                buCaFuncObj.set("hrbucafunc", (Object)l);
                dynamicObjectCollection.add((Object)buCaFuncObj);
            }
        }
    }

    private void saveRoleDimData(RoleInitTccParamBO roleInitTccParamBO) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("roledimentry");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        Map<String, List<RoleDimensionDetailVo>> roleDimensionDetailVoMap = this.calcRoleDimensionDetail(dynamicObject, roleNumberKeyMap);
        if (roleDimensionDetailVoMap == null || roleDimensionDetailVoMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection roleDimCollection = new DynamicObjectCollection();
        Map<String, List<String>> mapResult = this.buildAppIdMap(roleDimensionDetailVoMap);
        if (MapUtils.isEmpty(mapResult)) {
            return;
        }
        Map<String, Map<String, DynamicObject>> resultMap = HRBuCaServiceHelper.getBuCaFuncFromSpec(mapResult);
        if (MapUtils.isEmpty(resultMap)) {
            return;
        }
        for (DynamicObject entry : collection) {
            DynamicObject roleDimDynamicObject = helper.generateEmptyDynamicObject();
            String roleNumber = entry.getString("rdim_rolenumber");
            String roleId = (String)roleNumberKeyMap.get(roleNumber);
            roleDimDynamicObject.set("role", (Object)roleId);
            String dimensionId = entry.getString("rdim_dimension_id");
            roleDimDynamicObject.set("dimension", (Object)dimensionId);
            String dimBuca = entry.getString("rdim_bucafunc_id");
            roleDimDynamicObject.set("bucafunc", entry.get("rdim_bucafunc"));
            roleDimCollection.add((Object)roleDimDynamicObject);
            List<RoleDimensionDetailVo> roleDimensionDetailVoList = roleDimensionDetailVoMap.get(dimensionId);
            DynamicObjectCollection entryCollection = helper.generateEmptyEntryCollection(roleDimDynamicObject, "entry");
            for (RoleDimensionDetailVo roleDimensionDetailVo : roleDimensionDetailVoList) {
                String entityNumber;
                DynamicObject dyBuCa;
                String buca;
                Map<String, DynamicObject> dynamicObjectMap;
                String appId = roleDimensionDetailVo.getAppId();
                if (StringUtils.isEmpty((String)appId) || MapUtils.isEmpty(dynamicObjectMap = resultMap.get(appId)) || (buca = (dyBuCa = dynamicObjectMap.get(entityNumber = roleDimensionDetailVo.getEntityNumber())).getString("id")) == null || !buca.equals(dimBuca)) continue;
                DynamicObject dimEntry = helper.generateEmptyEntryDynamicObject("entry");
                dimEntry.set("app", (Object)roleDimensionDetailVo.getAppId());
                dimEntry.set("entitytype", (Object)roleDimensionDetailVo.getEntityNumber());
                dimEntry.set("propkey", (Object)roleDimensionDetailVo.getFiledPropKey());
                dimEntry.set("enable", (Object)"1");
                entryCollection.add((Object)dimEntry);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)roleDimCollection)) {
            helper.save(roleDimCollection);
        }
    }

    private Map<String, List<String>> buildAppIdMap(Map<String, List<RoleDimensionDetailVo>> roleDimensionDetailVoMap) {
        LinkedHashMap mapResult = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<RoleDimensionDetailVo>> entry : roleDimensionDetailVoMap.entrySet()) {
            List<RoleDimensionDetailVo> roleDimensionDetailVoList = entry.getValue();
            for (RoleDimensionDetailVo roleDimensionDetailVo : roleDimensionDetailVoList) {
                String appId = roleDimensionDetailVo.getAppId();
                String entityNumber = roleDimensionDetailVo.getEntityNumber();
                List entityNumberList = (List)mapResult.get(appId);
                if (CollectionUtils.isEmpty((Collection)entityNumberList)) {
                    entityNumberList = Lists.newArrayListWithExpectedSize((int)10);
                    mapResult.put(appId, entityNumberList);
                }
                entityNumberList.add(entityNumber);
            }
        }
        return mapResult;
    }

    private Map<String, List<RoleDimensionDetailVo>> calcRoleDimensionDetail(DynamicObject dynamicObject, Map<String, String> roleNumberKeyMap) {
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolefuncentry");
        if (collection == null || collection.size() == 0) {
            return null;
        }
        HashMap entityAppIdMap = Maps.newHashMapWithExpectedSize((int)collection.size());
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)16);
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)collection.size());
        for (DynamicObject entry : collection) {
            String entityNumber = entry.getString("rfunc_entitytype.number");
            String appId = entry.getString("rfunc_app.id");
            String permItemId = entry.getString("rfunc_permitem.id");
            String roleNumber = entry.getString("rfunc_rolenumber");
            String roleId = roleNumberKeyMap.get(roleNumber);
            if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)permItemId) || StringUtils.isEmpty((String)roleNumber) || StringUtils.isEmpty((String)roleId)) continue;
            List dataLists = (List)mapData.get(roleId);
            if (CollectionUtils.isEmpty((Collection)dataLists)) {
                dataLists = Lists.newArrayListWithCapacity((int)10);
                mapData.put(roleId, dataLists);
            }
            HashMap mapNest = Maps.newHashMapWithExpectedSize((int)3);
            mapNest.put("appId", appId);
            appIdSet.add(appId);
            mapNest.put("entityNumber", entityNumber);
            mapNest.put("permItemId", permItemId);
            dataLists.add(mapNest);
            Set appSet = (Set)entityAppIdMap.get(entityNumber);
            if (CollectionUtils.isEmpty((Collection)appSet)) {
                appSet = Sets.newHashSetWithExpectedSize((int)10);
                entityAppIdMap.put(entityNumber, appSet);
            }
            appSet.add(appId);
        }
        PermRoleInitSysService.getInstance().addRelatePerm(mapData, appIdSet);
        this.addRelationAppAndEntity(entityAppIdMap, mapData);
        QFilter[] filters = new QFilter[]{new QFilter("entitytype", "in", entityAppIdMap.keySet())};
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] dims = entityCtrlHelper.query("entitytype,entryentity.propkey,entryentity.dimension,entryentity.ismust", filters);
        HashMap roleDimensionDetailVoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dimObj : dims) {
            DynamicObjectCollection dimensionColl;
            Set appSet;
            String entityNumber = dimObj.getString("entitytype.id");
            if (entityNumber == null || CollectionUtils.isEmpty((Collection)(appSet = (Set)entityAppIdMap.get(entityNumber))) || (dimensionColl = dimObj.getDynamicObjectCollection("entryentity")) == null || dimensionColl.size() == 0) continue;
            for (String appId : appSet) {
                for (DynamicObject dimEntry : dimensionColl) {
                    String filedPropKey = dimEntry.getString("propkey");
                    String dimensionId = dimEntry.getString("dimension.id");
                    List roleDimensionDetailVoList = (List)roleDimensionDetailVoMap.get(dimensionId);
                    if (CollectionUtils.isEmpty((Collection)roleDimensionDetailVoList)) {
                        roleDimensionDetailVoList = Lists.newArrayListWithExpectedSize((int)10);
                        roleDimensionDetailVoMap.put(dimensionId, roleDimensionDetailVoList);
                    }
                    RoleDimensionDetailVo roleDimensionDetailVo = new RoleDimensionDetailVo();
                    roleDimensionDetailVo.setAppId(appId);
                    roleDimensionDetailVo.setEntityNumber(entityNumber);
                    roleDimensionDetailVo.setFiledPropKey(filedPropKey);
                    roleDimensionDetailVoList.add(roleDimensionDetailVo);
                }
            }
        }
        return roleDimensionDetailVoMap;
    }

    private void addRelationAppAndEntity(Map<String, Set<String>> entityAppIdMap, Map<String, List<Map<String, String>>> mapData) {
        if (MapUtils.isEmpty(mapData) || MapUtils.isEmpty(entityAppIdMap)) {
            return;
        }
        for (Map.Entry<String, List<Map<String, String>>> entry : mapData.entrySet()) {
            List<Map<String, String>> dataLists = entry.getValue();
            if (CollectionUtils.isEmpty(dataLists)) continue;
            for (Map<String, String> mapNest : dataLists) {
                String appId = mapNest.get("appId");
                String entityNumber = mapNest.get("entityNumber");
                HashSet appIdSet = entityAppIdMap.get(entityNumber);
                if (appIdSet == null) {
                    appIdSet = Sets.newHashSetWithExpectedSize((int)16);
                    entityAppIdMap.put(entityNumber, appIdSet);
                }
                appIdSet.add(appId);
            }
        }
    }

    private void saveRoleFieldPerm(RoleInitTccParamBO roleInitTccParamBO) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_rolefield");
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolefieldentry");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        DynamicObject roleFieldPerm = helper.generateEmptyDynamicObject();
        DynamicObjectType roleFieldType = roleFieldPerm.getDynamicObjectType();
        DynamicObjectCollection roleFieldPerms = new DynamicObjectCollection();
        Map<String, List<DynamicObject>> mapRoleFieldMainTable = this.groupRoleFiledDy(collection, roleNumberKeyMap);
        if (mapRoleFieldMainTable.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<DynamicObject>> mapEntry : mapRoleFieldMainTable.entrySet()) {
            List<DynamicObject> dynamicObjectList = mapEntry.getValue();
            if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
            DynamicObject dy = dynamicObjectList.get(0);
            String roleNumber = dy.getString("rfield_rolenumber");
            String roleId = (String)roleNumberKeyMap.get(roleNumber);
            String appId = dy.getString("rfield_app_id");
            String entityNumber = dy.getString("rfield_entitytype_id");
            roleFieldPerm = new DynamicObject(roleFieldType);
            roleFieldPerm.set("role", (Object)roleId);
            roleFieldPerm.set("app", (Object)appId);
            roleFieldPerm.set("entitytype", (Object)entityNumber);
            DynamicObjectCollection coll = helper.generateEmptyEntryCollection(roleFieldPerm, "fieldpermentry");
            for (DynamicObject dyFiledEntry : dynamicObjectList) {
                DynamicObject fieldPermEntry = helper.generateEmptyEntryDynamicObject("fieldpermentry");
                fieldPermEntry.set("fieldname", (Object)dyFiledEntry.getString("rfield_propkey"));
                fieldPermEntry.set("isbanread", (Object)(!dyFiledEntry.getBoolean("rfield_canread") ? 1 : 0));
                fieldPermEntry.set("isbanwrite", (Object)(!dyFiledEntry.getBoolean("rfield_canwrite") ? 1 : 0));
                coll.add((Object)fieldPermEntry);
            }
            roleFieldPerm.set("fieldpermentry", (Object)coll);
            roleFieldPerms.add((Object)roleFieldPerm);
        }
        if (CollectionUtils.isNotEmpty((Collection)roleFieldPerms)) {
            helper.save(roleFieldPerms);
        }
    }

    private void saveDimValueData(RoleInitTccParamBO roleInitTccParamBO) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimgrp");
        DynamicObject dynamicObject = roleInitTccParamBO.getDynamicObject();
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        Boolean includeSub = dynamicObject.getBoolean("includeSub");
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("roledataentry");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        DynamicObjectCollection dimGrpCollection = new DynamicObjectCollection();
        int index = 0;
        for (DynamicObject entry : collection) {
            String roleNumber = entry.getString("rdata_rolenumber");
            String roleId = (String)roleNumberKeyMap.get(roleNumber);
            DynamicObject dimGrpDynamicObject = helper.generateEmptyDynamicObject();
            dimGrpCollection.add((Object)dimGrpDynamicObject);
            dimGrpDynamicObject.set("role", (Object)roleId);
            dimGrpDynamicObject.set("bucafunc", entry.get("rdata_bucafunc"));
            dimGrpDynamicObject.set("index", (Object)index);
            ++index;
            DynamicObjectCollection dimValueCollection = (DynamicObjectCollection)entry.get("roledatavalentry");
            if (CollectionUtils.isEmpty((Collection)dimValueCollection)) continue;
            DynamicObjectCollection dimValueEntryColl = helper.generateEmptyEntryCollection(dimGrpDynamicObject, "entry");
            for (DynamicObject dimValueDy : dimValueCollection) {
                DynamicObject dataRuleEntry = helper.generateEmptyEntryDynamicObject("entry");
                DynamicObject dimension = (DynamicObject)dimValueDy.get("rdata_dimension");
                String dataSource = dimension.getString("datasource");
                String showType = dimension.getString("showtype");
                dataRuleEntry.set("dimension", dimValueDy.get("rdata_dimension"));
                dataRuleEntry.set("isall", dimValueDy.get("rdata_isall"));
                if (HRStringUtils.equals((String)"orgteam", (String)dataSource) || HRStringUtils.equals((String)"hrbu", (String)dataSource) && HRStringUtils.equals((String)"tree", (String)showType) || HRStringUtils.equals((String)"basedata", (String)dataSource) && HRStringUtils.equals((String)"tree", (String)showType)) {
                    dataRuleEntry.set("containssub", dimValueDy.get("rdata_containssub"));
                    dataRuleEntry.set("admincontainssub", dimValueDy.get("rdata_containssub"));
                } else {
                    dataRuleEntry.set("containssub", (Object)false);
                    dataRuleEntry.set("admincontainssub", (Object)false);
                }
                dataRuleEntry.set("dimval", dimValueDy.get("rdata_dimval"));
                dataRuleEntry.set("structproject", dimValueDy.get("rdata_structproject"));
                String rdata_valtype = dimValueDy.getString("rdata_valtype");
                Long rdata_dynacond_id = dimValueDy.getLong("rdata_dynacond.id");
                if (HRStringUtils.equals((String)"2", (String)rdata_valtype)) {
                    dataRuleEntry.set("valtype", (Object)"2");
                    dataRuleEntry.set("dynacond", (Object)rdata_dynacond_id);
                    dataRuleEntry.set("dimval", (Object)rdata_dynacond_id);
                } else {
                    dataRuleEntry.set("valtype", (Object)"1");
                }
                dimValueEntryColl.add((Object)dataRuleEntry);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dimGrpCollection)) {
            helper.save(dimGrpCollection);
        }
    }

    private Map<String, List<DynamicObject>> groupRoleFiledDy(DynamicObjectCollection collection, Map<String, String> roleNumberKeyMap) {
        HashMap mapRoleFieldMainTable = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject entry : collection) {
            String roleNumber = entry.getString("rfield_rolenumber");
            String roleId = roleNumberKeyMap.get(roleNumber);
            String appId = entry.getString("rfield_app_id");
            String entityNumber = entry.getString("rfield_entitytype_id");
            if (StringUtils.isEmpty((String)roleId) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNumber)) continue;
            String key = roleId + splitStr + appId + splitStr + entityNumber;
            List dynamicObjectList = (List)mapRoleFieldMainTable.get(key);
            if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
                dynamicObjectList = Lists.newArrayListWithExpectedSize((int)10);
                mapRoleFieldMainTable.put(key, dynamicObjectList);
            }
            dynamicObjectList.add(entry);
        }
        return mapRoleFieldMainTable;
    }

    private Set<Long> getOpenScopeViewSet(DynamicObject dynamicObject) {
        Set<Long> setEditIds = this.getOpenScopeEditSet(dynamicObject);
        DynamicObjectCollection openScopeViewColl = dynamicObject.getDynamicObjectCollection("rbase_openscopeview");
        if (CollectionUtils.isEmpty((Collection)openScopeViewColl)) {
            return null;
        }
        Set<Long> setViewIds = openScopeViewColl.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(setViewIds)) {
            return null;
        }
        if (CollectionUtils.isEmpty(setEditIds)) {
            return setViewIds;
        }
        setViewIds.removeAll(setEditIds);
        return setViewIds;
    }

    private Set<Long> getOpenScopeEditSet(DynamicObject dynamicObject) {
        DynamicObjectCollection openScopeViewColl = dynamicObject.getDynamicObjectCollection("rbase_openscopeEdit");
        if (CollectionUtils.isEmpty((Collection)openScopeViewColl)) {
            return null;
        }
        return openScopeViewColl.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
    }

    public void deleteData(Object paramBO) {
        RoleInitTccParamBO roleInitTccParamBO = (RoleInitTccParamBO)paramBO;
        if (roleInitTccParamBO == null) {
            return;
        }
        Map roleNumberKeyMap = roleInitTccParamBO.getRoleNumberKeyMap();
        if (roleNumberKeyMap == null || roleNumberKeyMap.isEmpty()) {
            return;
        }
        Set roleIdSet = roleNumberKeyMap.keySet();
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return;
        }
        String[] roleIds = roleIdSet.toArray(new String[roleIdSet.size()]);
        this.deleteBaseRoleInfo(roleIds);
        this.deleteHrBu(roleIds);
        this.deleteHrBucaFunc(roleIds);
        this.deleteRoleDimData(roleIds);
        this.deleteDimValueData(roleIds);
        this.deleteRoleFieldPerm(roleIds);
    }

    private void deleteBaseRoleInfo(String[] roleIds) {
        HRBaseServiceHelper saveServiceHelper = new HRBaseServiceHelper("hrcs_role");
        HRBaseServiceHelper openServiceHelper = new HRBaseServiceHelper("hrcs_roleopenscope");
        HRBaseServiceHelper assignServiceHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
        QFilter roleQFilter = new QFilter("id", "in", (Object)roleIds);
        saveServiceHelper.deleteByFilter(new QFilter[]{roleQFilter});
        QFilter qFilter = new QFilter("roleid", "in", (Object)roleIds);
        openServiceHelper.deleteByFilter(new QFilter[]{qFilter});
        assignServiceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    private void deleteHrBu(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_rolebu");
        QFilter qFilter = new QFilter("role", "in", (Object)roleIds);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    private void deleteHrBucaFunc(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        QFilter qFilter = new QFilter("role", "in", (Object)roleIds);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    private void deleteRoleDimData(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        QFilter qFilter = new QFilter("role", "in", (Object)roleIds);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    private void deleteDimValueData(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimgrp");
        QFilter qFilter = new QFilter("role", "in", (Object)roleIds);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
    }

    private void deleteRoleFieldPerm(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_rolefield");
        QFilter qFilter = new QFilter("role", "in", (Object)roleIds);
        serviceHelper.deleteByFilter(new QFilter[]{qFilter});
    }
}

