/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.init.roleinit;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.tcc.TCCSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.common.model.perminit.RoleInitTccParamBO;

public class PermRoleInitService {
    private static final Log LOGGER = LogFactory.getLog(PermRoleInitService.class);
    private static final HRBaseServiceHelper PERM_INIT_RECORD_HELPER = new HRBaseServiceHelper("hrcs_perminitrecord");
    private static volatile PermRoleInitService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermRoleInitService getInstance() {
        if (service != null) return service;
        Class<PermRoleInitService> clazz = PermRoleInitService.class;
        synchronized (PermRoleInitService.class) {
            if (service != null) return service;
            service = new PermRoleInitService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public boolean initRole(Long recordId) {
        DynamicObject dynamicObject = PERM_INIT_RECORD_HELPER.loadDynamicObject(new QFilter("id", "=", (Object)recordId));
        if (dynamicObject == null) {
            return false;
        }
        RoleInitTccParamBO roleInitTccParamBO = new RoleInitTccParamBO();
        roleInitTccParamBO.setDynamicObject(dynamicObject);
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("rolebaseentry");
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.initRoleIds(roleInitTccParamBO, collection);
        TCCSession session = DtxFactory.createTCC((String)"hrcs_permroleinit");
        try {
            String cloudId = "hrmp";
            String appId = "hrcs";
            session.Try(cloudId, appId, "PermRoleInitSysTccService", (Param)roleInitTccParamBO, "initToSys");
            session.Try(cloudId, appId, "PermRoleInitHmpTccService", (Param)roleInitTccParamBO, "initToHmp");
        }
        catch (Exception ex) {
            session.rollback();
            LOGGER.error("role init error.", (Throwable)ex);
            return false;
        }
        session.commit();
        LOGGER.info("role init end,recordId:{}", (Object)recordId);
        return true;
    }

    private void initRoleIds(RoleInitTccParamBO roleInitTccParamBO, DynamicObjectCollection collection) {
        int size = collection.size();
        String[] entryIds = ORM.create().genStringIds("perm_role", size);
        HashMap roleIdMap = Maps.newHashMapWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            roleIdMap.put(dynamicObject.getString("rbase_number"), entryIds[i]);
        }
        roleInitTccParamBO.setRoleNumberKeyMap((Map)roleIdMap);
    }
}

