/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.log.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.log.PermLogHandler;
import kd.hr.hrcs.bussiness.service.perm.log.handler.RoleLogBaseService;
import kd.hr.hrcs.common.constants.perm.log.FieldModel;
import kd.hr.hrcs.common.constants.perm.log.FunctionItemLogModel;
import kd.hr.hrcs.common.constants.perm.log.MulValue;
import kd.hr.hrcs.common.constants.perm.log.RoleDimLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleUserFileModel;
import kd.hr.hrcs.common.constants.perm.log.ScopeModel;

@ExcludeFromJacocoGeneratedReport
public class RoleModifyLogHandler
extends PermLogHandler {
    private static final Log LOGGER = LogFactory.getLog(RoleModifyLogHandler.class);

    @Override
    public void doHandler(DynamicObject dyn) {
        try {
            String beforeOpData = dyn.getString("beforeopdata");
            String afterOpData = dyn.getString("afteropdata");
            RoleInfoLogModel beforeRoleInfo = (RoleInfoLogModel)SerializationUtils.fromJsonString((String)beforeOpData, RoleInfoLogModel.class);
            RoleInfoLogModel afterRoleInfo = (RoleInfoLogModel)SerializationUtils.fromJsonString((String)afterOpData, RoleInfoLogModel.class);
            boolean isModifyBase = this.handleBaseInfo(dyn, beforeRoleInfo, afterRoleInfo);
            boolean isModifyFunc = this.handleFunctionPerm(dyn, beforeRoleInfo, afterRoleInfo);
            boolean isModifyDim = this.handleRoleDim(dyn, beforeRoleInfo, afterRoleInfo);
            boolean isModifyDimRule = this.handleDimRule(dyn, beforeRoleInfo, afterRoleInfo);
            boolean isModifyFieldPerm = this.handleFieldPerm(dyn, beforeRoleInfo, afterRoleInfo);
            boolean isModifyScope = this.handleScopeEntry(dyn, beforeRoleInfo, afterRoleInfo);
            this.handleUserFile(dyn, beforeRoleInfo, afterRoleInfo);
            DynamicObjectCollection inUserEntry = dyn.getDynamicObjectCollection("influuserentry");
            dyn.set("influusernumber", (Object)inUserEntry.size());
            dyn.set("hashandle", (Object)true);
            dyn.set("rolenumber", (Object)beforeRoleInfo.getRoleNumber());
            dyn.set("rolename", (Object)beforeRoleInfo.getRoleName());
            String format = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u201c%1$s %2$s\u201d%3$s%4$s%5$s%6$s%7$s%8$s\u3002", (String)"RoleModifyLogHandler_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), afterRoleInfo.getRoleNumber(), afterRoleInfo.getRoleName(), isModifyBase ? ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u3001", (String)"RoleModifyLogHandler_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : "", isModifyFunc ? ResManager.loadKDString((String)"\u529f\u80fd\u6743\u9650\u3001", (String)"RoleModifyLogHandler_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : "", isModifyDim ? ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6\u3001", (String)"RoleModifyLogHandler_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : "", isModifyDimRule ? ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u3001", (String)"RoleModifyLogHandler_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : "", isModifyFieldPerm ? ResManager.loadKDString((String)"\u5b57\u6bb5\u6743\u9650\u3001", (String)"RoleModifyLogHandler_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : "", isModifyScope ? ResManager.loadKDString((String)"\u516c\u5f00\u8303\u56f4\u3001", (String)"RoleModifyLogHandler_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : "");
            StringBuilder sb = new StringBuilder(format);
            if (sb.length() > 2) {
                sb.deleteCharAt(sb.length() - 2);
                dyn.set("description", (Object)sb.toString());
            }
            if (isModifyBase || isModifyFunc || isModifyDim || isModifyDimRule || isModifyFieldPerm || isModifyScope) {
                PERM_LOG_HELPER.saveOne(dyn);
            } else {
                PERM_LOG_HELPER.deleteOne((Object)dyn.getLong("id"));
            }
        }
        catch (Exception ex) {
            LOGGER.error("kd.hr.hrcs.bussiness.service.perm.log.handler.RoleModifyLogHandler", (Throwable)ex);
        }
    }

    private void handleUserFile(DynamicObject dyn, RoleInfoLogModel roleInfo, RoleInfoLogModel beforeRoleInfo) {
        boolean all = false;
        DynamicObjectCollection inUserEntry = dyn.getDynamicObjectCollection("influuserentry");
        DynamicObjectCollection roleFuncEntry = dyn.getDynamicObjectCollection("rolefuncentry");
        DynamicObjectCollection roleDimEntry = dyn.getDynamicObjectCollection("roledimentry");
        if (!HRStringUtils.equals((String)roleInfo.getRoleProperty(), (String)beforeRoleInfo.getRoleProperty()) || !HRStringUtils.equals((String)roleInfo.getRoleCBisIntersection(), (String)beforeRoleInfo.getRoleCBisIntersection()) || roleFuncEntry.size() > 0 || roleDimEntry.size() > 0) {
            all = true;
        } else {
            boolean isDataRangeModify;
            DynamicObjectCollection fieldPermEntry = dyn.getDynamicObjectCollection("rangefieldentry");
            DynamicObjectCollection rangeDataEntry = dyn.getDynamicObjectCollection("rangebizentry");
            DynamicObjectCollection rangeOrgEntry = dyn.getDynamicObjectCollection("rangeorgentry");
            DynamicObjectCollection rangeBdEntry = dyn.getDynamicObjectCollection("rangebddrentry");
            DynamicObjectCollection rangeDrEntry = dyn.getDynamicObjectCollection("rangedrentry");
            boolean bl = isDataRangeModify = rangeOrgEntry.size() > 0 || rangeDataEntry.size() > 0 || rangeBdEntry.size() > 0 || rangeDrEntry.size() > 0;
            if (HRStringUtils.equals((String)roleInfo.getRoleProperty(), (String)"0")) {
                if (isDataRangeModify || fieldPermEntry.size() > 0) {
                    all = true;
                }
            } else if (HRStringUtils.equals((String)roleInfo.getRoleCBisIntersection(), (String)"0")) {
                if (isDataRangeModify || fieldPermEntry.size() > 0) {
                    this.addEntry(beforeRoleInfo, inUserEntry, false);
                }
            } else if (HRStringUtils.equals((String)roleInfo.getRoleCBisIntersection(), (String)"1")) {
                if (isDataRangeModify || fieldPermEntry.size() > 0) {
                    all = true;
                }
            } else if (HRStringUtils.equals((String)roleInfo.getRoleCBisIntersection(), (String)"2")) {
                if (isDataRangeModify) {
                    all = true;
                }
                if (fieldPermEntry.size() > 0) {
                    this.addEntry(beforeRoleInfo, inUserEntry, all);
                }
            } else if (HRStringUtils.equals((String)roleInfo.getRoleCBisIntersection(), (String)"3")) {
                if (fieldPermEntry.size() > 0) {
                    all = true;
                }
                if (isDataRangeModify) {
                    this.addEntry(beforeRoleInfo, inUserEntry, all);
                }
            }
        }
        if (all) {
            List roleUserFileModelList = beforeRoleInfo.getRoleUserFileModelList();
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
            List permFileIds = roleUserFileModelList.stream().map(RoleUserFileModel::getPermFileId).collect(Collectors.toList());
            DynamicObject[] permFileDys = helper.loadDynamicObjectArray(permFileIds.toArray());
            Map<Long, DynamicObject> dynamicObjectMap = Arrays.stream(permFileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
            for (RoleUserFileModel roleUserFileModel : roleUserFileModelList) {
                DynamicObject entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("influuserentry");
                RoleLogBaseService.getInstance().getBaseInfoUserFiles(dynamicObjectMap, beforeRoleInfo, roleUserFileModel, entry);
                inUserEntry.add((Object)entry);
            }
        }
    }

    private void addEntry(RoleInfoLogModel beforeRoleInfo, DynamicObjectCollection inUserEntry, boolean all) {
        if (all) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        List permFileIds = beforeRoleInfo.getRoleUserFileModelList().stream().map(RoleUserFileModel::getPermFileId).collect(Collectors.toList());
        DynamicObject[] permFileDys = helper.loadDynamicObjectArray(permFileIds.toArray());
        Map<Long, DynamicObject> dynamicObjectMap = Arrays.stream(permFileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        for (RoleUserFileModel roleUserFileModel : beforeRoleInfo.getRoleUserFileModelList()) {
            if (!HRStringUtils.equals((String)roleUserFileModel.getDataProperty(), (String)"0")) continue;
            DynamicObject entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("influuserentry");
            RoleLogBaseService.getInstance().getBaseInfoUserFiles(dynamicObjectMap, beforeRoleInfo, roleUserFileModel, entry);
            inUserEntry.add((Object)entry);
        }
    }

    private boolean handleBaseInfo(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        List beforeFieldModelList = beforeRoleInfo.getFieldModelList();
        List fieldModelList = afterRoleInfo.getFieldModelList();
        DynamicObjectCollection baseInfoEntry = dyn.getDynamicObjectCollection("baseinfoentry");
        for (FieldModel fieldModel : fieldModelList) {
            DynamicObject emptyEntryDynamicObject = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("baseinfoentry");
            emptyEntryDynamicObject.set("baseinfo_changefield", (Object)fieldModel.getPropName());
            emptyEntryDynamicObject.set("baseinfo_description", (Object)RoleLogBaseService.getInstance().getModifyStr());
            if (HRStringUtils.equals((String)fieldModel.getPropNum(), (String)"rolename") || HRStringUtils.equals((String)fieldModel.getPropNum(), (String)"roleremark")) {
                Object beforeMulValueList = Lists.newArrayListWithExpectedSize((int)beforeFieldModelList.size());
                boolean isModify = false;
                for (FieldModel model : beforeFieldModelList) {
                    if (!HRStringUtils.equals((String)fieldModel.getPropName(), (String)model.getPropName())) continue;
                    beforeMulValueList = model.getMulValueList();
                    break;
                }
                for (MulValue mulValue : fieldModel.getMulValueList()) {
                    Iterator iterator = beforeMulValueList.iterator();
                    while (iterator.hasNext()) {
                        MulValue value = (MulValue)iterator.next();
                        if (!HRStringUtils.equals((String)mulValue.getLocaleId(), (String)value.getLocaleId()) || HRStringUtils.equals((String)mulValue.getValue(), (String)value.getValue())) continue;
                        mulValue.setModify(true);
                        value.setModify(true);
                        isModify = true;
                    }
                }
                emptyEntryDynamicObject.set("baseinfo_beforedata", (Object)RoleModifyLogHandler.getLocaleName((List<MulValue>)beforeMulValueList));
                emptyEntryDynamicObject.set("baseinfo_afterdata", (Object)RoleModifyLogHandler.getLocaleName(fieldModel.getMulValueList()));
                if (!isModify) continue;
                baseInfoEntry.add((Object)emptyEntryDynamicObject);
                continue;
            }
            for (FieldModel model : beforeFieldModelList) {
                if (!HRStringUtils.equals((String)fieldModel.getPropName(), (String)model.getPropName())) continue;
                emptyEntryDynamicObject.set("baseinfo_beforedata", (Object)model.getVal());
                break;
            }
            emptyEntryDynamicObject.set("baseinfo_afterdata", (Object)fieldModel.getVal());
            String beforeData = emptyEntryDynamicObject.getString("baseinfo_beforedata");
            if (HRStringUtils.equals((String)beforeData, (String)fieldModel.getVal())) continue;
            baseInfoEntry.add((Object)emptyEntryDynamicObject);
        }
        return baseInfoEntry.size() > 0;
    }

    private static String getLocaleName(List<MulValue> mulValues) {
        if (mulValues == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (MulValue mulValue : mulValues) {
            if (!mulValue.getModify()) continue;
            sb.append("\u3010").append(mulValue.getName()).append("\u3011").append(":");
            sb.append(mulValue.getValue()).append("\n");
        }
        return sb.toString();
    }

    private boolean handleScopeEntry(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        DynamicObject entry;
        DynamicObjectCollection roleOpenEntry = dyn.getDynamicObjectCollection("roleopenentry");
        List beforeScopeModelList = beforeRoleInfo.getScopeModelList();
        List scopeModelList = afterRoleInfo.getScopeModelList();
        Map<Long, ScopeModel> beforeScopeModelMap = beforeScopeModelList.stream().collect(Collectors.toMap(ScopeModel::getAdminGroupId, model -> model, (v1, v2) -> v2));
        Map<Long, ScopeModel> scopeModelMap = scopeModelList.stream().collect(Collectors.toMap(ScopeModel::getAdminGroupId, model -> model, (v1, v2) -> v2));
        ArrayList newScopeModelList = Lists.newArrayListWithExpectedSize((int)scopeModelList.size());
        ArrayList modifyScopeModelList = Lists.newArrayListWithExpectedSize((int)scopeModelList.size());
        for (ScopeModel model2 : scopeModelList) {
            if (!beforeScopeModelMap.containsKey(model2.getAdminGroupId())) {
                newScopeModelList.add(model2);
                continue;
            }
            ScopeModel beforeModel = beforeScopeModelMap.get(model2.getAdminGroupId());
            if (Boolean.compare(beforeModel.getModifiable(), model2.getModifiable()) == 0) continue;
            modifyScopeModelList.add(model2);
        }
        for (ScopeModel scopeModel : newScopeModelList) {
            entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roleopenentry");
            entry.set("roleopen_admingroup", (Object)scopeModel.getAdminGroupId());
            entry.set("roleopen_admingroupnumber", (Object)scopeModel.getAdminGroupNumber());
            entry.set("roleopen_admingroupname", (Object)scopeModel.getAdminGroupName());
            RoleLogBaseService.getInstance().getUserDynamicObjects(scopeModel, entry);
            entry.set("roleopen_beforedata", (Object)"");
            entry.set("roleopen_afterdata", (Object)RoleLogBaseService.getInstance().getScopeStr(scopeModel));
            entry.set("roleopen_description", (Object)RoleLogBaseService.getInstance().getAddStr());
            roleOpenEntry.add((Object)entry);
        }
        for (ScopeModel scopeModel : modifyScopeModelList) {
            entry = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roleopenentry");
            entry.set("roleopen_admingroup", (Object)scopeModel.getAdminGroupId());
            entry.set("roleopen_admingroupnumber", (Object)scopeModel.getAdminGroupNumber());
            entry.set("roleopen_admingroupname", (Object)scopeModel.getAdminGroupName());
            RoleLogBaseService.getInstance().getUserDynamicObjects(scopeModel, entry);
            entry.set("roleopen_beforedata", (Object)RoleLogBaseService.getInstance().getBeforeScopeStr(scopeModel));
            entry.set("roleopen_afterdata", (Object)RoleLogBaseService.getInstance().getScopeStr(scopeModel));
            entry.set("roleopen_description", (Object)RoleLogBaseService.getInstance().getModifyStr());
            roleOpenEntry.add((Object)entry);
        }
        ArrayList deleteScopeModelList = Lists.newArrayListWithExpectedSize((int)beforeScopeModelList.size());
        for (ScopeModel model3 : beforeScopeModelList) {
            if (scopeModelMap.containsKey(model3.getAdminGroupId())) continue;
            deleteScopeModelList.add(model3);
        }
        for (ScopeModel scopeModel : deleteScopeModelList) {
            DynamicObject entry2 = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roleopenentry");
            entry2.set("roleopen_admingroup", (Object)scopeModel.getAdminGroupId());
            entry2.set("roleopen_admingroupnumber", (Object)scopeModel.getAdminGroupNumber());
            entry2.set("roleopen_admingroupname", (Object)scopeModel.getAdminGroupName());
            RoleLogBaseService.getInstance().getUserDynamicObjects(scopeModel, entry2);
            entry2.set("roleopen_beforedata", (Object)RoleLogBaseService.getInstance().getScopeStr(scopeModel));
            entry2.set("roleopen_afterdata", (Object)"");
            entry2.set("roleopen_description", (Object)RoleLogBaseService.getInstance().getDelStr());
            roleOpenEntry.add((Object)entry2);
        }
        return roleOpenEntry.size() > 0;
    }

    private boolean handleFieldPerm(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        List fieldPermLogModelList;
        List beforeFieldPermLogModelList = beforeRoleInfo.getFieldPermLogModelList();
        DynamicObjectCollection rangeFieldEntry = this.setRangeFieldEntry(dyn, beforeFieldPermLogModelList, fieldPermLogModelList = afterRoleInfo.getFieldPermLogModelList());
        return rangeFieldEntry.size() > 0;
    }

    private boolean handleDimRule(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        boolean isModifyRange = this.handleDataRange(dyn, beforeRoleInfo, afterRoleInfo);
        boolean isModifyBd = this.handleBdDataRule(dyn, beforeRoleInfo, afterRoleInfo);
        boolean isModifyDr = this.handleDataRule(dyn, beforeRoleInfo, afterRoleInfo);
        return isModifyRange || isModifyBd || isModifyDr;
    }

    private boolean handleDataRange(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        List beforeDataRangeLogModelList = beforeRoleInfo.getDataRangeLogModelList();
        List dataRangeLogModelList = afterRoleInfo.getDataRangeLogModelList();
        boolean isModifyOrg = this.handleOrgRange(dyn, beforeDataRangeLogModelList, dataRangeLogModelList);
        DynamicObjectCollection rangeDataEntry = dyn.getDynamicObjectCollection("rangebizentry");
        boolean isModifyRangeData = this.setRangeDataEntry(rangeDataEntry, beforeDataRangeLogModelList, dataRangeLogModelList);
        return isModifyOrg || isModifyRangeData;
    }

    private boolean handleDataRule(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        DynamicObjectCollection rangeDrEntry = dyn.getDynamicObjectCollection("rangedrentry");
        List beforeDataRuleModelList = beforeRoleInfo.getDataRuleModelList();
        List dataRuleModelList = afterRoleInfo.getDataRuleModelList();
        this.setRangeDrEntry(rangeDrEntry, beforeDataRuleModelList, dataRuleModelList);
        return rangeDrEntry.size() > 0;
    }

    private boolean handleBdDataRule(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        DynamicObjectCollection rangeBdEntry = dyn.getDynamicObjectCollection("rangebddrentry");
        List beforeBdDataRuleModelList = beforeRoleInfo.getBdDataRuleModelList();
        List bdDataRuleModelList = afterRoleInfo.getBdDataRuleModelList();
        this.setRangeBdEntry(rangeBdEntry, beforeBdDataRuleModelList, bdDataRuleModelList);
        return rangeBdEntry.size() > 0;
    }

    private boolean handleFunctionPerm(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        DynamicObjectCollection roleFuncEntry = dyn.getDynamicObjectCollection("rolefuncentry");
        List beforeItemLogModelList = beforeRoleInfo.getFunctionItemLogModelList();
        List functionItemLogModelList = afterRoleInfo.getFunctionItemLogModelList();
        Map<String, FunctionItemLogModel> beforeFunctionMap = beforeItemLogModelList.stream().collect(Collectors.toMap(this::getKeyFunction, model -> model, (v1, v2) -> v2));
        Map<String, FunctionItemLogModel> functionMap = functionItemLogModelList.stream().collect(Collectors.toMap(this::getKeyFunction, model -> model, (v1, v2) -> v2));
        ArrayList newFunctionList = Lists.newArrayListWithExpectedSize((int)functionItemLogModelList.size());
        for (FunctionItemLogModel model2 : functionItemLogModelList) {
            if (beforeFunctionMap.containsKey(this.getKeyFunction(model2))) continue;
            newFunctionList.add(model2);
        }
        for (FunctionItemLogModel functionItemLogModel : newFunctionList) {
            DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rolefuncentry");
            RoleLogBaseService.getInstance().setBaseInfoFuncEntry(functionItemLogModel, entryDyna);
            entryDyna.set("rolefunc_description", (Object)RoleLogBaseService.getInstance().getAddStr());
            roleFuncEntry.add((Object)entryDyna);
        }
        ArrayList deleteFunctionList = Lists.newArrayListWithExpectedSize((int)beforeItemLogModelList.size());
        for (FunctionItemLogModel model3 : beforeItemLogModelList) {
            if (functionMap.containsKey(this.getKeyFunction(model3))) continue;
            deleteFunctionList.add(model3);
        }
        for (FunctionItemLogModel functionItemLogModel : deleteFunctionList) {
            DynamicObject entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("rolefuncentry");
            RoleLogBaseService.getInstance().setBaseInfoFuncEntry(functionItemLogModel, entryDyna);
            entryDyna.set("rolefunc_description", (Object)RoleLogBaseService.getInstance().getDelStr());
            roleFuncEntry.add((Object)entryDyna);
        }
        return roleFuncEntry.size() > 0;
    }

    private String getKeyFunction(FunctionItemLogModel model) {
        return model.getAppId() + "#" + model.getEntityNum() + "#" + model.getPermItemId();
    }

    private boolean handleRoleDim(DynamicObject dyn, RoleInfoLogModel beforeRoleInfo, RoleInfoLogModel afterRoleInfo) {
        DynamicObject entryDyna;
        List beforeRoleDimLogModelList = beforeRoleInfo.getRoleDimLogModelList();
        List roleDimLogModelList = afterRoleInfo.getRoleDimLogModelList();
        Map<String, RoleDimLogModel> beforeRoleDimLogMap = beforeRoleDimLogModelList.stream().collect(Collectors.toMap(this::getKeyByRoleDim, model -> model, (v1, v2) -> v2));
        Map<String, RoleDimLogModel> roleDimLogMap = roleDimLogModelList.stream().collect(Collectors.toMap(this::getKeyByRoleDim, model -> model, (v1, v2) -> v2));
        DynamicObjectCollection roleDimEntry = dyn.getDynamicObjectCollection("roledimentry");
        ArrayList newRoleDimLogModelList = Lists.newArrayListWithExpectedSize((int)roleDimLogModelList.size());
        ArrayList modifyRoleDimLogModelList = Lists.newArrayListWithExpectedSize((int)roleDimLogModelList.size());
        for (RoleDimLogModel model2 : roleDimLogModelList) {
            if (!beforeRoleDimLogMap.containsKey(this.getKeyByRoleDim(model2))) {
                newRoleDimLogModelList.add(model2);
                continue;
            }
            RoleDimLogModel beforeModel = beforeRoleDimLogMap.get(this.getKeyByRoleDim(model2));
            if (Boolean.compare(beforeModel.getCheck(), model2.getCheck()) == 0) continue;
            modifyRoleDimLogModelList.add(model2);
        }
        for (RoleDimLogModel roleDimLogModel : newRoleDimLogModelList) {
            entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roledimentry");
            RoleLogBaseService.getInstance().setBaseInfoRoleDimEntry(roleDimLogModel, entryDyna);
            entryDyna.set("roledim_beforedata", (Object)"");
            entryDyna.set("roledim_afterdata", (Object)RoleLogBaseService.getInstance().getCheckDimStr(roleDimLogModel.getCheck()));
            entryDyna.set("roledim_description", (Object)RoleLogBaseService.getInstance().getAddStr());
            roleDimEntry.add((Object)entryDyna);
        }
        for (RoleDimLogModel roleDimLogModel : modifyRoleDimLogModelList) {
            entryDyna = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roledimentry");
            RoleLogBaseService.getInstance().setBaseInfoRoleDimEntry(roleDimLogModel, entryDyna);
            entryDyna.set("roledim_beforedata", (Object)RoleLogBaseService.getInstance().getCheckDimStr(!roleDimLogModel.getCheck()));
            entryDyna.set("roledim_afterdata", (Object)RoleLogBaseService.getInstance().getCheckDimStr(roleDimLogModel.getCheck()));
            entryDyna.set("roledim_description", (Object)RoleLogBaseService.getInstance().getModifyStr());
            roleDimEntry.add((Object)entryDyna);
        }
        ArrayList deleteRoleDimLogModelList = Lists.newArrayListWithExpectedSize((int)beforeRoleDimLogModelList.size());
        for (RoleDimLogModel model3 : beforeRoleDimLogModelList) {
            if (roleDimLogMap.containsKey(this.getKeyByRoleDim(model3))) continue;
            deleteRoleDimLogModelList.add(model3);
        }
        for (RoleDimLogModel roleDimLogModel : deleteRoleDimLogModelList) {
            DynamicObject entryDyna2 = PERM_LOG_HELPER.generateEmptyEntryDynamicObject("roledimentry");
            RoleLogBaseService.getInstance().setBaseInfoRoleDimEntry(roleDimLogModel, entryDyna2);
            entryDyna2.set("roledim_beforedata", (Object)RoleLogBaseService.getInstance().getCheckDimStr(roleDimLogModel.getCheck()));
            entryDyna2.set("roledim_afterdata", (Object)"");
            entryDyna2.set("roledim_description", (Object)RoleLogBaseService.getInstance().getDelStr());
            roleDimEntry.add((Object)entryDyna2);
        }
        return roleDimEntry.size() > 0;
    }

    private String getKeyByRoleDim(RoleDimLogModel model) {
        return model.getBuCaFuncId() + "#" + model.getDimId() + "#" + model.getEntityNum() + "#" + model.getPropKey();
    }
}

